/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryClosingBalance;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.base.BaseInventoryClosingBalance;
import com.floreantpos.model.dao.BaseInventoryClosingBalanceDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.NumberUtil;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.hibernate.type.DoubleType;
import org.hibernate.type.Type;

public class InventoryClosingBalanceDAO
extends BaseInventoryClosingBalanceDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    public void closeStock(Date date, Date date2) throws Exception {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            List<InventoryClosingBalance> list = this.closeInventoryStock(session, DateUtil.endOfMonth(date), date2, true);
            if (list == null || list.isEmpty()) {
                throw new PosException("No data found");
            }
            date2 = DateUtil.startOfDay(date2);
            for (InventoryClosingBalance inventoryClosingBalance : list) {
                inventoryClosingBalance.setClosingDate(date2);
                session.saveOrUpdate((Object)inventoryClosingBalance);
            }
            transaction.commit();
        }
    }

    public List<InventoryClosingBalance> closeInventoryStock(Session session, Date date, Date date2, boolean bl) {
        Object object;
        Iterator iterator;
        ArrayList<InventoryClosingBalance> arrayList;
        Object object2;
        Criteria criteria = null;
        Map<String, InventoryClosingBalance> map = this.getInventoryItems(session);
        HashMap<String, InventoryClosingBalance> hashMap = new HashMap<String, InventoryClosingBalance>();
        Date date3 = this.getExistingClosingDate(date, date2);
        if (date3 != null) {
            criteria = session.createCriteria(InventoryClosingBalance.class);
            if (date3 != null) {
                date3 = DateUtil.startOfDay(date3);
                criteria.add((Criterion)Restrictions.ge((String)InventoryClosingBalance.PROP_CLOSING_DATE, (Object)date3));
                criteria.add((Criterion)Restrictions.lt((String)InventoryClosingBalance.PROP_CLOSING_DATE, (Object)DateUtil.endOfDay(date3)));
            }
            if ((object2 = criteria.list()) != null && object2.size() > 0) {
                arrayList = object2.iterator();
                while (arrayList.hasNext()) {
                    iterator = (InventoryClosingBalance)arrayList.next();
                    ((BaseInventoryClosingBalance)((Object)iterator)).setBalance(0.0);
                    ((BaseInventoryClosingBalance)((Object)iterator)).setUnitCost(0.0);
                    ((BaseInventoryClosingBalance)((Object)iterator)).setTotal(0.0);
                    hashMap.put(this.generateKey((InventoryClosingBalance)((Object)iterator)), (InventoryClosingBalance)((Object)iterator));
                }
            }
        }
        if ((object2 = this.getLastClosingDate(date)) != null) {
            object2 = DateUtil.startOfDay((Date)object2);
            criteria = session.createCriteria(InventoryClosingBalance.class);
            if (object2 != null) {
                criteria.add((Criterion)Restrictions.ge((String)InventoryClosingBalance.PROP_CLOSING_DATE, (Object)object2));
                criteria.add((Criterion)Restrictions.lt((String)InventoryClosingBalance.PROP_CLOSING_DATE, (Object)DateUtil.endOfDay((Date)object2)));
            }
            if ((arrayList = criteria.list()) != null && arrayList.size() > 0) {
                for (InventoryClosingBalance inventoryClosingBalance : arrayList) {
                    object = this.generateKey(inventoryClosingBalance);
                    InventoryClosingBalance inventoryClosingBalance2 = (InventoryClosingBalance)hashMap.get(object);
                    if (inventoryClosingBalance2 != null) {
                        inventoryClosingBalance2.setBalance(inventoryClosingBalance2.getBalance() + inventoryClosingBalance.getBalance());
                        continue;
                    }
                    InventoryClosingBalance inventoryClosingBalance3 = new InventoryClosingBalance();
                    inventoryClosingBalance3.setMenuItemId(inventoryClosingBalance.getMenuItemId());
                    inventoryClosingBalance3.setLocationId(inventoryClosingBalance.getLocationId());
                    inventoryClosingBalance3.setUnit(inventoryClosingBalance.getUnit());
                    inventoryClosingBalance3.setBalance(inventoryClosingBalance.getBalance());
                    inventoryClosingBalance3.setUnitCost(inventoryClosingBalance.getUnitCost());
                    hashMap.put((String)object, inventoryClosingBalance3);
                }
            }
        }
        this.populateInventoryTransactions(session, hashMap, date2, (Date)object2);
        arrayList = new ArrayList<InventoryClosingBalance>(hashMap.values());
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            InventoryClosingBalance inventoryClosingBalance;
            inventoryClosingBalance = (InventoryClosingBalance)iterator.next();
            if (inventoryClosingBalance.getBalance() <= 0.0) {
                inventoryClosingBalance.setUnitCost(0.0);
                inventoryClosingBalance.setTotal(0.0);
            } else {
                inventoryClosingBalance.setTotal(inventoryClosingBalance.getUnitCost() * inventoryClosingBalance.getBalance());
            }
            if (!bl && inventoryClosingBalance.getBalance() == 0.0) {
                iterator.remove();
            }
            if ((object = map.get(inventoryClosingBalance.getMenuItemId())) == null || !bl || object == null) continue;
            map.remove(inventoryClosingBalance.getMenuItemId());
        }
        if (bl && map.values().size() > 0) {
            arrayList.addAll(map.values());
        }
        return arrayList;
    }

    private String generateKey(InventoryClosingBalance inventoryClosingBalance) {
        return inventoryClosingBalance.getMenuItemId() + inventoryClosingBalance.getUnit() + inventoryClosingBalance.getLocationId();
    }

    private void populateInventoryTransactions(Session session, Map<String, InventoryClosingBalance> map, Date date, Date date2) {
        Criteria criteria = session.createCriteria(InventoryLocation.class);
        criteria.setProjection((Projection)Projections.property((String)InventoryLocation.PROP_ID));
        List list = criteria.list();
        if (list != null) {
            for (String string : list) {
                criteria = session.createCriteria(InventoryTransaction.class);
                criteria.createAlias(InventoryTransaction.PROP_MENU_ITEM, "item");
                ProjectionList projectionList = Projections.projectionList();
                projectionList.add((Projection)Projections.property((String)"item.id"), InventoryClosingBalance.PROP_MENU_ITEM_ID);
                projectionList.add((Projection)Projections.property((String)InventoryTransaction.PROP_UNIT), InventoryClosingBalance.PROP_UNIT);
                projectionList.add(Projections.sqlProjection((String)("sum(quantity*tran_type) AS " + InventoryClosingBalance.PROP_BALANCE), (String[])new String[]{InventoryClosingBalance.PROP_BALANCE}, (Type[])new Type[]{new DoubleType()}));
                projectionList.add((Projection)Projections.groupProperty((String)InventoryTransaction.PROP_UNIT));
                projectionList.add((Projection)Projections.groupProperty((String)"item.id"));
                criteria.setProjection((Projection)projectionList);
                if (date2 != null) {
                    criteria.add((Criterion)Restrictions.gt((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date2));
                }
                criteria.add((Criterion)Restrictions.lt((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)date));
                if (string != null) {
                    criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_FROM_LOCATION_ID, (Object)string), (Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TO_LOCATION_ID, (Object)string)));
                }
                criteria.setResultTransformer(Transformers.aliasToBean(InventoryClosingBalance.class));
                List list2 = criteria.list();
                projectionList = Projections.projectionList();
                projectionList.add((Projection)Projections.property((String)"item.id"), InventoryClosingBalance.PROP_MENU_ITEM_ID);
                projectionList.add((Projection)Projections.property((String)InventoryTransaction.PROP_UNIT), InventoryClosingBalance.PROP_UNIT);
                projectionList.add((Projection)Projections.groupProperty((String)InventoryTransaction.PROP_UNIT));
                projectionList.add((Projection)Projections.groupProperty((String)"item.id"));
                projectionList.add(Projections.sqlProjection((String)("sum(total)/sum(quantity) AS " + InventoryClosingBalance.PROP_UNIT_COST), (String[])new String[]{InventoryClosingBalance.PROP_UNIT_COST}, (Type[])new Type[]{new DoubleType()}));
                criteria.add((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_TYPE, (Object)InventoryTransactionType.IN.getType()));
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"NEW STOCK"), (Criterion)Restrictions.eq((String)InventoryTransaction.PROP_REASON, (Object)"PURCHASE")));
                criteria.setProjection((Projection)projectionList);
                criteria.setResultTransformer(Transformers.aliasToBean(InventoryClosingBalance.class));
                List list3 = criteria.list();
                ArrayList arrayList = new ArrayList();
                if (list2 != null && list2.size() > 0) {
                    arrayList.addAll(list2);
                }
                if (list3 != null && list3.size() > 0) {
                    arrayList.addAll(list3);
                }
                if (arrayList == null || arrayList.size() <= 0) continue;
                for (InventoryClosingBalance inventoryClosingBalance : arrayList) {
                    inventoryClosingBalance.setLocationId(string);
                    String string2 = this.generateKey(inventoryClosingBalance);
                    InventoryClosingBalance inventoryClosingBalance2 = map.get(string2);
                    if (inventoryClosingBalance2 != null) {
                        inventoryClosingBalance2.setBalance(inventoryClosingBalance2.getBalance() + inventoryClosingBalance.getBalance());
                        inventoryClosingBalance2.setUnitCost(NumberUtil.getCurrencyFormatWithoutSymbol(inventoryClosingBalance2.getUnitCost() + inventoryClosingBalance.getUnitCost()));
                        continue;
                    }
                    map.put(string2, inventoryClosingBalance);
                }
            }
        }
    }

    private Map<String, InventoryClosingBalance> getInventoryItems(Session session) {
        Criteria criteria = session.createCriteria(MenuItem.class);
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.property((String)MenuItem.PROP_ID), InventoryClosingBalance.PROP_MENU_ITEM_ID);
        projectionList.add((Projection)Projections.property((String)MenuItem.PROP_UNIT_NAME), InventoryClosingBalance.PROP_UNIT);
        criteria.setProjection((Projection)projectionList);
        criteria.add(Restrictions.eqOrIsNull((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
        criteria.setResultTransformer(Transformers.aliasToBean(InventoryClosingBalance.class));
        List list = criteria.list();
        HashMap<String, InventoryClosingBalance> hashMap = new HashMap<String, InventoryClosingBalance>();
        if (list != null && list.size() > 0) {
            for (InventoryClosingBalance inventoryClosingBalance : list) {
                hashMap.put(inventoryClosingBalance.getMenuItemId(), inventoryClosingBalance);
            }
        }
        return hashMap;
    }

    public Date getExistingClosingDate(Date date, Date date2) {
        Criteria criteria = this.getSession().createCriteria(this.getReferenceClass());
        Date date3 = DateUtil.startOfDay(date);
        Date date4 = DateUtil.endOfDay(date2);
        criteria.setProjection((Projection)Projections.property((String)InventoryClosingBalance.PROP_CLOSING_DATE));
        criteria.add((Criterion)Restrictions.gt((String)InventoryClosingBalance.PROP_CLOSING_DATE, (Object)date3));
        criteria.add((Criterion)Restrictions.le((String)InventoryClosingBalance.PROP_CLOSING_DATE, (Object)date4));
        criteria.setMaxResults(1);
        return (Date)criteria.uniqueResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getLastClosingDate(Date date) {
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.distinct((Projection)Projections.max((String)InventoryClosingBalance.PROP_CLOSING_DATE)));
            criteria.add((Criterion)Restrictions.lt((String)InventoryClosingBalance.PROP_CLOSING_DATE, (Object)date));
            Date date2 = (Date)criteria.uniqueResult();
            return date2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getFirstInventoryTransactionDate() {
        try (Session session = null;){
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(InventoryTransaction.class);
            criteria.setProjection(Projections.distinct((Projection)Projections.min((String)InventoryTransaction.PROP_TRANSACTION_DATE)));
            Date date = (Date)criteria.uniqueResult();
            return date;
        }
    }

    public void saveOrUpdateInventoryClosingBalances(List<InventoryClosingBalance> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (InventoryClosingBalance inventoryClosingBalance : list) {
                InventoryClosingBalance inventoryClosingBalance2 = this.get(inventoryClosingBalance.getId());
                if (inventoryClosingBalance2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(inventoryClosingBalance.getLastUpdateTime(), inventoryClosingBalance2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), inventoryClosingBalance.getId() + " already updated");
                        continue;
                    }
                    long l = inventoryClosingBalance2.getVersion();
                    PropertyUtils.copyProperties((Object)inventoryClosingBalance2, (Object)inventoryClosingBalance);
                    inventoryClosingBalance2.setVersion(l);
                    inventoryClosingBalance2.setUpdateLastUpdateTime(bl);
                    inventoryClosingBalance2.setUpdateSyncTime(bl2);
                    this.update(inventoryClosingBalance2, session);
                    continue;
                }
                inventoryClosingBalance.setUpdateLastUpdateTime(bl);
                inventoryClosingBalance.setUpdateSyncTime(bl2);
                this.save(inventoryClosingBalance, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<InventoryClosingBalance> getClosingBalances(List<String> list, Date date) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.in((String)InventoryClosingBalance.PROP_MENU_ITEM_ID, list));
            criteria.add((Criterion)Restrictions.ge((String)InventoryClosingBalance.PROP_CLOSING_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)InventoryClosingBalance.PROP_CLOSING_DATE, (Object)DateUtil.endOfDay(date)));
            List list2 = criteria.list();
            return list2;
        }
    }
}

