/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.Discount;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryStock;
import com.floreantpos.model.InventoryStockUnit;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemInventoryStatus;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.PriceTableItem;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseMenuItem;
import com.floreantpos.model.base.BaseMenuItemInventoryStatus;
import com.floreantpos.model.dao.BaseMenuItemDAO;
import com.floreantpos.model.dao.ComboItemDAO;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuItemInventoryStatusDAO;
import com.floreantpos.model.dao.MenuPageItemDAO;
import com.floreantpos.model.dao.PriceTableItemDAO;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.util.NumberUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.criterion.Subqueries;
import org.hibernate.transform.Transformers;

public class MenuItemDAO
extends BaseMenuItemDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        Serializable serializable = super.save(object, session);
        this.updateDependentModels((MenuItem)object, session);
        return serializable;
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
        this.updateDependentModels((MenuItem)object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
        this.updateDependentModels((MenuItem)object, session);
    }

    @Override
    public void delete(Object object, Session session) throws HibernateException {
        List<TimedModel> list;
        MenuItem menuItem = (MenuItem)object;
        if (menuItem == null) {
            throw new PosException(Messages.getString("MenuItemDAO.0"));
        }
        session.refresh((Object)menuItem);
        this.checkIfItemCanbeDeleted(session, menuItem);
        if (menuItem.isComboItem().booleanValue()) {
            Object object2;
            list = menuItem.getComboGroups();
            if (list != null && !list.isEmpty()) {
                list.clear();
            }
            if ((object2 = menuItem.getComboItems()) != null && !object2.isEmpty()) {
                Iterator<ComboItem> object3 = object2.iterator();
                while (object3.hasNext()) {
                    ComboItem comboItem = object3.next();
                    comboItem.setDeleted(true);
                    ComboItemDAO.getInstance().update(comboItem, session);
                }
            }
        }
        menuItem.setDeleted(true);
        this.removeFromDependentModels(menuItem, session);
        this.updateTime(menuItem);
        session.update((Object)menuItem);
        if (menuItem.isHasVariant().booleanValue() && (list = menuItem.getVariants()) != null && !list.isEmpty()) {
            for (MenuItem menuItem2 : list) {
                menuItem2.setDeleted(true);
                this.update(menuItem2, session);
            }
        }
        this.removeFromDiscounts(menuItem, session);
    }

    private void removeFromDiscounts(MenuItem menuItem, Session session) {
        DiscountDAO discountDAO = DiscountDAO.getInstance();
        List<Discount> list = discountDAO.getDiscountsByMenuItem(menuItem, session);
        if (list != null && !list.isEmpty()) {
            for (Discount discount : list) {
                List<MenuItem> list2 = discount.getMenuItems();
                list2.remove(menuItem);
                discountDAO.saveOrUpdate(discount, session);
            }
        }
    }

    private void checkIfItemCanbeDeleted(Session session, MenuItem menuItem) {
        List<MenuItem> list;
        String string = "";
        List<String> list2 = RecepieDAO.getInstance().getForeignDataListNames(menuItem, session);
        if (list2 != null && !list2.isEmpty()) {
            string = Messages.getString("MenuItemDAO.3") + (list2.size() > 1 ? Messages.getString("MenuItemDAO.4") : ":");
            int n = 1;
            for (String iterator : list2) {
                string = string + "\n" + n + ". " + iterator;
                ++n;
            }
        }
        if ((list = this.getMenuItemsByComboItemId(menuItem.getId(), session)) != null && !list.isEmpty()) {
            if (StringUtils.isNotBlank((String)string)) {
                string = string + "\n";
            }
            string = string + Messages.getString("MenuItemDAO.5");
            int n = 1;
            for (MenuItem menuItem2 : list) {
                string = string + "\n" + n + ". " + menuItem2.getName();
                ++n;
            }
        }
        if ((list = this.getMenuItemsByComboGroupsByComboGroupItemId(menuItem.getId(), session)) != null && !list.isEmpty()) {
            if (StringUtils.isNotBlank((String)string)) {
                string = string + "\n";
            }
            string = string + Messages.getString("MenuItemDAO.8");
            int n = 1;
            for (MenuItem menuItem2 : list) {
                string = string + "\n" + n + ". " + menuItem2.getName();
                ++n;
            }
        }
        if (StringUtils.isNotBlank((String)string)) {
            throw new PosException(Messages.getString("MenuItemDAO.2"), string);
        }
    }

    private List<MenuItem> getMenuItemsByComboItemId(String string, Session session) {
        if (StringUtils.isBlank((String)string) || session == null) {
            return null;
        }
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        this.addDeletedFilter(criteria);
        criteria.createAlias("comboItems", "i");
        criteria.add(Restrictions.isNotNull((String)("i." + ComboItem.PROP_MENU_ITEM_ID)));
        criteria.add((Criterion)Restrictions.eq((String)("i." + ComboItem.PROP_ITEM_ID), (Object)string));
        criteria.setProjection(Projections.alias((Projection)Projections.distinct((Projection)Projections.property((String)MenuItem.PROP_NAME)), (String)MenuItem.PROP_NAME));
        return criteria.setResultTransformer(Transformers.aliasToBean((Class)this.getReferenceClass())).list();
    }

    private List<MenuItem> getMenuItemsByComboGroupsByComboGroupItemId(String string, Session session) {
        if (StringUtils.isBlank((String)string) || session == null) {
            return null;
        }
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        this.addDeletedFilter(criteria);
        criteria.createAlias("comboGroups", "g");
        criteria.createAlias("g.items", "i");
        criteria.add(Restrictions.in((String)("i." + MenuItem.PROP_ID), Arrays.asList(string)));
        criteria.setProjection(Projections.alias((Projection)Projections.distinct((Projection)Projections.property((String)MenuItem.PROP_NAME)), (String)MenuItem.PROP_NAME));
        return criteria.setResultTransformer(Transformers.aliasToBean((Class)this.getReferenceClass())).list();
    }

    private void removeFromDependentModels(MenuItem menuItem, Session session) {
        String string = menuItem.getId();
        PriceTableItem priceTableItem = PriceTableItemDAO.getInstance().getPriceTableItemByMenuItemId(string);
        if (priceTableItem != null) {
            PriceTableItemDAO.getInstance().delete(priceTableItem, session);
        }
        String string2 = "delete MenuPageItem where %s=:menuItemId";
        string2 = String.format(string2, MenuPageItem.PROP_MENU_ITEM_ID);
        Query query = session.createQuery(string2);
        query.setParameter("menuItemId", (Object)string);
        query.executeUpdate();
    }

    private void updateDependentModels(MenuItem menuItem, Session session) {
        this.saveInventoryStockStatus(menuItem, session);
        MenuPageItemDAO menuPageItemDAO = MenuPageItemDAO.getInstance();
        List<MenuPageItem> list = menuPageItemDAO.getPageItemFor(menuItem, session);
        if (list != null) {
            for (MenuPageItem object2 : list) {
                object2.setMenuItem(menuItem);
                menuPageItemDAO.saveOrUpdate(object2, session);
            }
        }
        List<ComboItem> list2 = ComboItemDAO.getInstance().getByMenuItem(menuItem.getId(), session);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            ComboItem comboItem = (ComboItem)iterator.next();
            comboItem.setMenuItem(menuItem);
            ComboItemDAO.getInstance().update(comboItem, session);
        }
        this.updateDependentStockModel(menuItem, session);
    }

    private void updateDependentStockModel(MenuItem menuItem, Session session) throws HibernateException {
        String string = "update InventoryStock set %s=:itemName, %s=:sku, %s=:barCode where %s=:menuItemId";
        string = String.format(string, InventoryStock.PROP_ITEM_NAME, InventoryStock.PROP_SKU, InventoryStock.PROP_BARCODE, InventoryStock.PROP_MENU_ITEM_ID);
        Query query = session.createQuery(string);
        query.setParameter("itemName", (Object)menuItem.getName());
        query.setParameter("sku", (Object)menuItem.getSku());
        query.setParameter("barCode", (Object)menuItem.getBarcode());
        query.setParameter("menuItemId", (Object)menuItem.getId());
        query.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll(List<MenuItem> list) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (MenuItem menuItem : list) {
                menuItem.setLastUpdateTime(StoreDAO.getServerTimestamp());
                session.merge((Object)menuItem);
            }
            transaction.commit();
        }
    }

    private void saveInventoryStockStatus(MenuItem menuItem, Session session) {
        if (!menuItem.isInventoryItem().booleanValue()) {
            return;
        }
        MenuItemInventoryStatus menuItemInventoryStatus = menuItem.getStockStatus();
        if (menuItemInventoryStatus == null) {
            menuItemInventoryStatus = new MenuItemInventoryStatus();
            menuItem.setStockStatus(menuItemInventoryStatus);
        }
        if (menuItemInventoryStatus.getId() == null) {
            menuItemInventoryStatus.setId(menuItem.getId());
            MenuItemInventoryStatusDAO.getInstance().save(menuItemInventoryStatus, session);
        }
    }

    @Override
    public void saveOrUpdate(MenuItem menuItem2) throws HibernateException {
        Transaction transaction = null;
        try (Session session = null;){
            Object object;
            session = this.createNewSession();
            transaction = session.beginTransaction();
            menuItem2.setLastUpdateTime(StoreDAO.getServerTimestamp());
            if (menuItem2.getId() == null) {
                this.save(menuItem2, session);
            } else {
                this.update(menuItem2, session);
                object = menuItem2.getVariants();
                if (object != null) {
                    List list = object.stream().filter(menuItem -> menuItem.isDeleted()).collect(Collectors.toList());
                    for (MenuItem menuItem3 : list) {
                        this.removeFromDependentModels(menuItem3, session);
                    }
                }
            }
            if (!menuItem2.isInventoryItem().booleanValue()) {
                transaction.commit();
                return;
            }
            object = menuItem2.getStockStatus();
            if (object == null) {
                object = new MenuItemInventoryStatus();
                ((BaseMenuItemInventoryStatus)object).setId(menuItem2.getId());
                menuItem2.setStockStatus((MenuItemInventoryStatus)object);
                MenuItemInventoryStatusDAO.getInstance().save((MenuItemInventoryStatus)object, session);
            }
            transaction.commit();
        }
    }

    public void initializeUnits(MenuItem menuItem) {
        try (Session session = null;){
            session = this.createNewSession();
            session.refresh((Object)menuItem);
            if (!Hibernate.isInitialized(menuItem.getStockUnits())) {
                Hibernate.initialize(menuItem.getStockUnits());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(String string) {
        Criteria criteria = null;
        try (Session session = null;){
            Number number;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string, (MatchMode)MatchMode.START));
            }
            if ((number = (Number)criteria.uniqueResult()) != null) {
                int n = number.intValue();
                return n;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInventoryItems(String string, BeanTableModel<MenuItem> beanTableModel) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string, (MatchMode)MatchMode.START));
            }
            criteria.setFirstResult(beanTableModel.getCurrentRowIndex());
            criteria.setMaxResults(beanTableModel.getPageSize());
            beanTableModel.setRows(criteria.list());
        }
    }

    public int rowCount(Boolean bl, MenuGroup menuGroup, String string, Object object, boolean bl2) {
        return this.rowCount(bl, menuGroup, string, object, bl2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(Boolean bl, MenuGroup menuGroup, String string, Object object, boolean bl2, Boolean bl3) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.setProjection(Projections.rowCount());
            if (!bl.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            }
            if (bl3 != null && bl3.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)bl3));
            }
            if (!bl2) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            this.addOrderTypeFilter(object, session, criteria);
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(Boolean bl, MenuGroup menuGroup, String string) {
        Criteria criteria = null;
        try (Session session = null;){
            Number number;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.setProjection(Projections.rowCount());
            if (!bl.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if ((number = (Number)criteria.uniqueResult()) != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rowCount(MenuGroup menuGroup, String string, boolean bl, Boolean bl2) {
        Criteria criteria = null;
        try (Session session = null;){
            Number number;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (bl2 != null && bl2.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)bl2));
            }
            if (!bl) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if ((number = (Number)criteria.uniqueResult()) != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
    }

    public MenuItem loadInitialized(String string) throws HibernateException {
        MenuItem menuItem = super.get(string);
        this.initialize(menuItem);
        return menuItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem getInitialized(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        try (Session session = null;){
            session = this.createNewSession();
            MenuItem menuItem = this.get(string, session);
            this.initialize(menuItem, session);
            MenuItem menuItem2 = menuItem;
            return menuItem2;
        }
    }

    public void initialize(MenuItem menuItem) {
        if (menuItem == null || StringUtils.isBlank((String)menuItem.getId())) {
            return;
        }
        try (Session session = null;){
            session = this.createNewSession();
            session.refresh((Object)menuItem);
            this.initialize(menuItem, session);
        }
    }

    public void deleteVariants(MenuItem menuItem, Session session) {
        if (menuItem == null) {
            return;
        }
        this.deleteVariants(menuItem.getVariants(), session);
    }

    public void deleteVariants(List<MenuItem> list, Session session) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (MenuItem menuItem : list) {
            this.delete(menuItem, session);
        }
    }

    public void initializeVariants(MenuItem menuItem) {
        if (menuItem == null || menuItem.getId() == null) {
            return;
        }
        try (Session session = null;){
            session = this.createNewSession();
            session.update((Object)menuItem);
            Hibernate.initialize(menuItem.getVariants());
            Hibernate.initialize(menuItem.getAttributes());
        }
    }

    public void initialize(MenuItem menuItem, Session session) {
        Object object;
        Object object2;
        if (menuItem == null) {
            return;
        }
        Hibernate.initialize(menuItem.getStockUnits());
        Hibernate.initialize(menuItem.getMenuItemModiferSpecs());
        Hibernate.initialize(menuItem.getPizzaPriceList());
        Hibernate.initialize(menuItem.getDiscounts());
        Hibernate.initialize(menuItem.getComboGroups());
        Hibernate.initialize(menuItem.getComboItems());
        Hibernate.initialize(menuItem.getVariants());
        Hibernate.initialize(menuItem.getAttributes());
        List<MenuItem> list = menuItem.getVariants();
        if (list != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (MenuItem)object2.next();
                Hibernate.initialize(((BaseMenuItem)object).getAttributes());
            }
        }
        if ((object2 = menuItem.getMenuItemModiferSpecs()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                MenuItemModifierSpec menuItemModifierSpec = (MenuItemModifierSpec)object.next();
                Set<MenuItemModifierPage> set = menuItemModifierSpec.getModifierPages();
                for (MenuItemModifierPage menuItemModifierPage : set) {
                    menuItemModifierPage.setModifierSpec(menuItemModifierSpec);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> findByParent(Terminal terminal, MenuGroup menuGroup, boolean bl) throws PosException {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            if (!bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            List list = criteria.list();
            return list;
        }
    }

    public List<MenuItem> getVariants(MenuItem menuItem, Session session) throws PosException {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
        if (menuItem != null) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PARENT_MENU_ITEM_ID, (Object)menuItem.getId()));
        }
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
        criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
        criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
        return criteria.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getVariants(MenuItem menuItem) throws PosException {
        try (Session session = null;){
            session = this.createNewSession();
            List<MenuItem> list = this.getVariants(menuItem, session);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(Terminal terminal, MenuGroup menuGroup, Object object) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            this.addOrderTypeFilter(object, session, criteria);
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadItems(Terminal terminal, MenuGroup menuGroup, Object object, boolean bl, PaginatedListModel paginatedListModel, boolean bl2) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            if (!bl2) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (!bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            this.addOrderTypeFilter(object, session, criteria);
            criteria.setFirstResult(paginatedListModel.getCurrentRowIndex());
            criteria.setMaxResults(paginatedListModel.getPageSize());
            paginatedListModel.setData(criteria.list());
        }
    }

    public List<MenuItemModifierSpec> findModifierGroups(MenuItem menuItem) throws PosException {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_ID, (Object)menuItem.getId()));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            MenuItem menuItem2 = (MenuItem)criteria.uniqueResult();
            Hibernate.initialize(menuItem2.getMenuItemModiferSpecs());
            List<MenuItemModifierSpec> list = menuItem2.getMenuItemModiferSpecs();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItems(String string, MenuGroup menuGroup, Object object, String string2) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.getSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (string2.equals("InventoryItem")) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            }
            this.addOrderTypeFilter(object, session, criteria);
            List list = criteria.list();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getPizzaItems(String string, MenuGroup menuGroup, Object object) {
        Criteria criteria = null;
        try (Session session = null;){
            Object object2;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)true));
            if (StringUtils.isNotBlank((String)string)) {
                string = string.trim();
                object2 = Restrictions.disjunction();
                object2.add((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)string));
                object2.add((Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)string));
                object2.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE));
                criteria.add((Criterion)object2);
            }
            this.addOrderTypeFilter(object, session, criteria);
            object2 = criteria.list();
            return object2;
        }
    }

    public void releaseParent(List<MenuItem> list) {
    }

    public void releaseParentAndDelete(MenuItem menuItem) {
        if (menuItem == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            String string = "delete from MENUITEM_DISCOUNT where MENUITEM_ID='%s'";
            string = String.format(string, menuItem.getId());
            SQLQuery sQLQuery = session.createSQLQuery(string);
            sQLQuery.executeUpdate();
            String string2 = "delete from MENU_PAGE_ITEM where MENU_ITEM_ID='%s'";
            string2 = String.format(string2, menuItem.getId());
            SQLQuery sQLQuery2 = session.createSQLQuery(string2);
            sQLQuery2.executeUpdate();
            String string3 = "delete from RECIPE_TABLE where MENU_ITEM_ID='%s'";
            string3 = String.format(string3, menuItem.getId());
            SQLQuery sQLQuery3 = session.createSQLQuery(string3);
            sQLQuery3.executeUpdate();
            session.delete((Object)menuItem);
            transaction.commit();
        }
    }

    public MenuItem getMenuItemByBarcodeOrSKU(String string) {
        MenuItem menuItem = this.getMenuItemByBarcode(string);
        if (menuItem == null) {
            menuItem = this.getMenuItemBySKU(string);
        }
        return menuItem;
    }

    public MenuItem getMenuItemByBarcodeOrSKU(OrderType orderType, String string) {
        List<String> list = MenuCategoryDAO.getInstance().findActiveCategoryIds(orderType);
        try (Session session = MenuItemDAO.getInstance().createNewSession();){
            MenuItem menuItem = this.getMenuItemByBarcode(orderType, string, list, session);
            if (menuItem == null) {
                menuItem = this.getMenuItemBySKU(orderType, string, list, session);
            }
            MenuItem menuItem2 = menuItem;
            return menuItem2;
        }
    }

    public MenuItem getMenuItemByBarcode(String string) {
        return this.getMenuItemByBarcode(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem getMenuItemByBarcode(String string, boolean bl) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)bl));
            }
            criteria.add((Criterion)Restrictions.like((String)MenuItem.PROP_BARCODE, (Object)string));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                MenuItem menuItem = null;
                return menuItem;
            }
            MenuItem menuItem = (MenuItem)list.get(0);
            return menuItem;
        }
    }

    public MenuItem getMenuItemByBarcode(OrderType orderType, String string, List<String> list, Session session) {
        Criteria criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)true));
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)string));
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
        LogicalExpression logicalExpression = Restrictions.or((Criterion)Restrictions.in((String)MenuItem.PROP_MENU_CATEGORY_ID, list), (Criterion)Restrictions.isNull((String)MenuItem.PROP_MENU_CATEGORY_ID));
        if (list == null || list.isEmpty()) {
            logicalExpression = Restrictions.isNull((String)MenuItem.PROP_MENU_CATEGORY_ID);
        }
        criteria.add((Criterion)logicalExpression);
        List list2 = criteria.list();
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        return (MenuItem)list2.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem getMenuItemBySKU(String string) {
        try (Session session = null;){
            session = this.createNewSession();
            MenuItem menuItem = this.getMenuItemBySKU(string, session, false, true);
            return menuItem;
        }
    }

    public MenuItem getMenuItemBySKU(String string, Session session, boolean bl) {
        return this.getMenuItemBySKU(string, session, bl, false);
    }

    public MenuItem getMenuItemBySKU(String string, Session session, boolean bl, boolean bl2) {
        List list;
        Criteria criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
        if (!bl) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
        }
        criteria.add((Criterion)Restrictions.like((String)MenuItem.PROP_SKU, (Object)string));
        if (bl2) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
        }
        if ((list = criteria.list()) == null || list.isEmpty()) {
            return null;
        }
        return (MenuItem)list.get(0);
    }

    public MenuItem getMenuItemBySKU(OrderType orderType, String string, List<String> list, Session session) {
        Criteria criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)string));
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
        LogicalExpression logicalExpression = Restrictions.or((Criterion)Restrictions.in((String)MenuItem.PROP_MENU_CATEGORY_ID, list), (Criterion)Restrictions.isNull((String)MenuItem.PROP_MENU_CATEGORY_ID));
        if (list == null || list.isEmpty()) {
            logicalExpression = Restrictions.isNull((String)MenuItem.PROP_MENU_CATEGORY_ID);
        }
        criteria.add((Criterion)logicalExpression);
        List list2 = criteria.list();
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        return (MenuItem)list2.get(0);
    }

    public List<MenuItem> getMenuItemByName(String string) {
        return this.getMenuItemByName(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItemByName(String string, boolean bl) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)bl));
            }
            criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                List<MenuItem> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
    }

    public List<MenuItem> getMenuItemsByNameOrBarcode(MenuGroup menuGroup, String string) {
        return this.getMenuItemsByNameOrBarcode(menuGroup, string, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItemsByNameOrBarcode(MenuGroup menuGroup, String string, boolean bl, boolean bl2) {
        Criteria criteria = null;
        try (Session session = null;){
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            if (!bl2) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
            }
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)string), (Criterion)Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE)));
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if ((list = criteria.list()) == null || list.isEmpty()) {
                List<MenuItem> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItemsByNameOrBarcode(MenuCategory menuCategory, String string, boolean bl, boolean bl2) {
        Criteria criteria = null;
        try (Session session = null;){
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)string), (Criterion)Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE)));
            if (!bl2) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
            }
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            if ((list = criteria.list()) == null || list.isEmpty()) {
                List<MenuItem> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
    }

    public List<MenuItem> getMenuItemsByNameOrBarcode(OrderType orderType, MenuCategory menuCategory, MenuGroup menuGroup, String string, boolean bl) {
        return this.getMenuItemsByNameOrBarcode(orderType, menuCategory, menuGroup, string, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItemsByNameOrBarcode(OrderType orderType, MenuCategory menuCategory, MenuGroup menuGroup, String string, boolean bl, boolean bl2) {
        if (menuGroup != null) {
            return this.getMenuItemsByNameOrBarcode(menuGroup, string, bl, bl2);
        }
        if (menuCategory != null) {
            return this.getMenuItemsByNameOrBarcode(menuCategory, string, bl, bl2);
        }
        List<String> list = MenuCategoryDAO.getInstance().findActiveCategoryIds(orderType);
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (bl) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            }
            if (!bl2) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
            }
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)string), (Criterion)Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE)));
            LogicalExpression logicalExpression = Restrictions.or((Criterion)Restrictions.in((String)MenuItem.PROP_MENU_CATEGORY_ID, list), (Criterion)Restrictions.isNull((String)MenuItem.PROP_MENU_CATEGORY_ID));
            if (list == null || list.isEmpty()) {
                logicalExpression = Restrictions.isNull((String)MenuItem.PROP_MENU_CATEGORY_ID);
            }
            criteria.add((Criterion)logicalExpression);
            List list2 = criteria.list();
            if (list2 == null || list2.isEmpty()) {
                List<MenuItem> list3 = null;
                return list3;
            }
            List list4 = list2;
            return list4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItems(String string, String string2, String string3, ReportGroup reportGroup) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (StringUtils.isNotEmpty((String)string3)) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)string3));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)string));
            }
            if (StringUtils.isNotEmpty((String)string2)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string2, (MatchMode)MatchMode.START));
            }
            if (reportGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_REPORT_GROUP_ID, (Object)reportGroup.getId()));
            }
            List list = criteria.list();
            return list;
        }
    }

    public List<MenuItem> findMenuItemsForStockCount(String string, MenuGroup menuGroup, InventoryVendor inventoryVendor, InventoryLocation inventoryLocation) {
        try (Session session = this.createNewSession();){
            Criteria criteria = null;
            List list = null;
            if (inventoryVendor != null) {
                criteria = session.createCriteria(InventoryVendorItems.class);
                criteria.add((Criterion)Restrictions.eq((String)InventoryVendorItems.PROP_VENDOR, (Object)inventoryVendor));
                criteria.createAlias(InventoryVendorItems.PROP_ITEM, "item");
                criteria.setProjection((Projection)Projections.property((String)"item.id"));
                list = criteria.list();
            }
            if (inventoryLocation != null) {
                criteria = session.createCriteria(InventoryStock.class);
                criteria.add((Criterion)Restrictions.eq((String)InventoryStock.PROP_LOCATION_ID, (Object)inventoryLocation.getId()));
                criteria.setProjection((Projection)Projections.property((String)InventoryStock.PROP_MENU_ITEM_ID));
                if (list == null) {
                    list = criteria.list();
                } else {
                    list.retainAll(criteria.list());
                }
            }
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE));
            criteria.add(Restrictions.isNotNull((String)MenuItem.PROP_UNIT_ID));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)string), (Criterion)Restrictions.or((Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)string), (Criterion)Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string, (MatchMode)MatchMode.START))));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (list != null && !list.isEmpty()) {
                criteria.add(Restrictions.in((String)MenuItem.PROP_ID, (Collection)list));
            }
            criteria.setMaxResults(10);
            List list2 = criteria.list();
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getPizzaItems() {
        Criteria criteria = null;
        try (Session session = null;){
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)true));
            List list2 = list = criteria.list();
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItems() {
        Criteria criteria = null;
        try (Session session = null;){
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)false), (Criterion)Restrictions.isNull((String)MenuItem.PROP_PIZZA_TYPE)));
            List list2 = list = criteria.list();
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getInventortItems() {
        Criteria criteria = null;
        try (Session session = null;){
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            List list2 = list = criteria.list();
            return list2;
        }
    }

    public MenuItem getReplenishedMenuItem(Integer n, Session session) {
        Criteria criteria = null;
        criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_ID, (Object)n));
        MenuItem menuItem = (MenuItem)criteria.uniqueResult();
        Double d = 0.0;
        if (menuItem != null) {
            d = menuItem.getReorderLevel();
        }
        if (d == 0.0) {
            return null;
        }
        criteria = session.createCriteria(MenuItemInventoryStatus.class);
        criteria.add((Criterion)Restrictions.eq((String)MenuItemInventoryStatus.PROP_ID, (Object)n));
        criteria.add((Criterion)Restrictions.lt((String)MenuItemInventoryStatus.PROP_AVAILABLE_UNIT, (Object)d));
        MenuItemInventoryStatus menuItemInventoryStatus = (MenuItemInventoryStatus)criteria.uniqueResult();
        if (menuItemInventoryStatus == null) {
            return null;
        }
        menuItem.setStockStatus(menuItemInventoryStatus);
        return menuItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getReOrderedMenuItems() {
        Criteria criteria = null;
        try (Session session = null;){
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass(), "item");
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_ID));
            criteria.add(Subqueries.exists((DetachedCriteria)this.getDetachedCriteriaForStockStatus("item.id")));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            List list2 = list = criteria.list();
            return list2;
        }
    }

    private DetachedCriteria getDetachedCriteriaForStockStatus(String string) {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(MenuItemInventoryStatus.class, (String)"status").setProjection((Projection)Projections.property((String)MenuItemInventoryStatus.PROP_ID)).add((Criterion)Restrictions.eqProperty((String)MenuItemInventoryStatus.PROP_ID, (String)string)).add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)("status." + MenuItemInventoryStatus.PROP_UNIT_ON_HAND)), (Criterion)Restrictions.leProperty((String)("status." + MenuItemInventoryStatus.PROP_UNIT_ON_HAND), (String)("item." + MenuItem.PROP_REORDER_LEVEL))));
        return detachedCriteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int rowReOrderedItemCount(MenuGroup menuGroup, String string, boolean bl, Boolean bl2) {
        Criteria criteria = null;
        try (Session session = null;){
            Object object;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class, "item");
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.setProjection(Projections.rowCount());
            criteria.add(Subqueries.exists((DetachedCriteria)this.getDetachedCriteriaForStockStatus("item.id")));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            if (bl2 != null && bl2.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)bl2));
            }
            if (!bl) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                object = Restrictions.disjunction();
                object.add((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)string));
                object.add((Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)string));
                object.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
                criteria.add((Criterion)object);
            }
            if ((object = (Number)criteria.uniqueResult()) != null) {
                int n = ((Number)object).intValue();
                return n;
            }
            int n = 0;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadReorderedMenuItems(PaginationSupport paginationSupport, MenuGroup menuGroup, String string, boolean bl, Boolean bl2) {
        Criteria criteria = null;
        try (Session session = null;){
            Object object;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class, "item");
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add(Subqueries.exists((DetachedCriteria)this.getDetachedCriteriaForStockStatus("item.id")));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            if (bl2 != null && bl2.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)bl2));
            }
            if (!bl) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                object = Restrictions.disjunction();
                object.add((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)string));
                object.add((Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)string));
                object.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
                criteria.add((Criterion)object);
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            paginationSupport.setNumRows(super.rowCount(criteria));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_ID));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            object = criteria.list();
            paginationSupport.setRows((List)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> getMenuItems(String string, String string2, String string3, MenuGroup menuGroup, Pagination pagination, Boolean bl) {
        Criteria criteria = null;
        try (Session session = null;){
            Object object;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            this.updateCriteria(criteria, string, string2, string3, menuGroup, pagination, bl);
            List list = criteria.list();
            if (pagination != null) {
                criteria = session.createCriteria(this.getReferenceClass());
                criteria.setProjection(Projections.rowCount());
                this.updateCriteria(criteria, string, string2, string3, menuGroup, null, bl);
                object = (Number)criteria.uniqueResult();
                pagination.setNumRows(((Number)object).intValue());
            }
            object = list;
            return object;
        }
    }

    public List<MenuItem> getMenuItems(String string, String string2, String string3, MenuGroup menuGroup, Pagination pagination) {
        return this.getMenuItems(string, string2, string3, menuGroup, pagination, null);
    }

    private void updateCriteria(Criteria criteria, String string, String string2, String string3, MenuGroup menuGroup, Pagination pagination, Boolean bl) {
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_DELETED), (Criterion)Restrictions.eq((String)MenuItem.PROP_DELETED, (Object)Boolean.FALSE)));
        if (StringUtils.isNotEmpty((String)string3)) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)string3));
        }
        if (StringUtils.isNotEmpty((String)string)) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)string));
        }
        if (StringUtils.isNotEmpty((String)string2)) {
            criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string2, (MatchMode)MatchMode.ANYWHERE));
        }
        if (menuGroup != null) {
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
        }
        if (pagination != null) {
            criteria.setFirstResult(pagination.getCurrentRowIndex());
            criteria.setMaxResults(pagination.getPageSize());
        }
        if (bl != null && bl.booleanValue()) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)Boolean.FALSE), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE)));
        }
    }

    public void loadMenuItems(PaginationSupport paginationSupport, Boolean bl) {
        this.loadMenuItems(paginationSupport, bl, null, null, null, false);
    }

    public void loadMenuItems(PaginationSupport paginationSupport, Boolean bl, MenuGroup menuGroup, String string, MenuCategory menuCategory, boolean bl2) {
        this.loadMenuItems(paginationSupport, bl, menuGroup, string, menuCategory, bl2, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> loadInventoryMenuItem() {
        Criteria criteria = null;
        try (Session session = null;){
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_ID));
            List list2 = list = criteria.list();
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> loadInventoryMenuItem(String string, MenuGroup menuGroup, MenuCategory menuCategory) {
        Criteria criteria = null;
        try (Session session = null;){
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_MENU_GROUP_ID));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)string)));
            }
            List list2 = list = criteria.list();
            return list2;
        }
    }

    public void loadMenuItems(PaginationSupport paginationSupport, Boolean bl, MenuGroup menuGroup, String string, MenuCategory menuCategory, boolean bl2, Boolean bl3) {
        this.loadMenuItems(paginationSupport, bl, menuGroup, string, menuCategory, bl2, bl3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuItems(PaginationSupport paginationSupport, Boolean bl, MenuGroup menuGroup, String string, MenuCategory menuCategory, boolean bl2, Boolean bl3, Boolean bl4) {
        Criteria criteria = null;
        try (Session session = null;){
            Object object;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (!bl.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            }
            if (bl3 != null && bl3.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)bl3));
            }
            if (!bl2) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
                criteria.add(Restrictions.isNotNull((String)MenuItem.PROP_PARENT_MENU_ITEM_ID));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                object = Restrictions.disjunction();
                object.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
                object.add(Restrictions.ilike((String)MenuItem.PROP_BARCODE, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
                object.add(Restrictions.ilike((String)MenuItem.PROP_SKU, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
                criteria.add((Criterion)object);
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            if (bl4 != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)bl4));
            }
            criteria.setProjection(Projections.rowCount());
            object = (Number)criteria.uniqueResult();
            paginationSupport.setNumRows(((Number)object).intValue());
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            List list = criteria.list();
            paginationSupport.setRows(list);
        }
    }

    private void addOrderTypeFilter(Object object, Session session, Criteria criteria) {
        if (object instanceof OrderType) {
            OrderType orderType = (OrderType)object;
            Criteria criteria2 = session.createCriteria(MenuCategory.class);
            criteria2.createAlias("orderTypes", "ot");
            criteria2.add(Restrictions.in((String)("ot." + OrderType.PROP_ID), Arrays.asList(orderType.getId())));
            List list = criteria2.list();
            if (list != null && !list.isEmpty()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (MenuCategory menuCategory : list) {
                    arrayList.add(menuCategory.getId());
                }
                criteria.add(Restrictions.in((String)MenuItem.PROP_MENU_CATEGORY_ID, arrayList));
            }
        }
    }

    public void findByBarcodeOrName(PaginationSupport paginationSupport, Boolean bl, MenuGroup menuGroup, String string, Boolean bl2, Boolean bl3, Boolean bl4) {
        this.findByBarcodeOrName(paginationSupport, bl, menuGroup, string, bl2, bl3, bl4, true, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findByBarcodeOrName(PaginationSupport paginationSupport, Boolean bl, MenuGroup menuGroup, String string, Boolean bl2, Boolean bl3, Boolean bl4, boolean bl5, boolean bl6, String ... stringArray) {
        Criteria criteria = null;
        try (Session session = null;){
            Criterion criterion;
            Object object;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (StringUtils.isNotEmpty((String)string)) {
                object = Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE);
                criterion = Restrictions.ilike((String)MenuItem.PROP_BARCODE, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE);
                String[] stringArray2 = Restrictions.ilike((String)MenuItem.PROP_SKU, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE);
                Disjunction disjunction = Restrictions.or((Criterion[])new Criterion[]{object, criterion, stringArray2});
                criteria.add((Criterion)disjunction);
            }
            if (bl.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            }
            if (bl3 != null && bl3.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)bl3));
            }
            if (!bl2.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)bl2));
            }
            if (!bl5) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)bl5));
            }
            if (!bl6) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_COMBO_ITEM, (Object)bl6));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (bl4.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)bl4));
            }
            criteria.setProjection(Projections.rowCount());
            object = (Number)criteria.uniqueResult();
            if (object != null) {
                paginationSupport.setNumRows(((Number)object).intValue());
            }
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            if (stringArray != null && stringArray.length > 0) {
                criterion = Projections.projectionList();
                for (String string2 : stringArray) {
                    criterion.add((Projection)Projections.property((String)string2), string2);
                }
                criteria.setProjection((Projection)criterion);
                criteria.setResultTransformer(Transformers.aliasToBean(MenuItem.class));
                paginationSupport.setRows(criteria.list());
            } else {
                paginationSupport.setRows(criteria.list());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findPriceTableItemByBarcodeOrName(PaginationSupport paginationSupport, MenuGroup menuGroup, String string, Boolean bl, Boolean bl2, Boolean bl3, boolean bl4, boolean bl5, String ... stringArray) {
        Criteria criteria = null;
        try (Session session = null;){
            Object object;
            Object object2;
            Object object3;
            Object object4;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (StringUtils.isNotEmpty((String)string)) {
                object4 = Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE);
                object3 = Restrictions.ilike((String)MenuItem.PROP_BARCODE, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE);
                object2 = Restrictions.ilike((String)MenuItem.PROP_SKU, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE);
                object = Restrictions.or((Criterion[])new Criterion[]{object4, object3, object2});
                criteria.add((Criterion)object);
            }
            if (bl2 != null && bl2.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)bl2));
            }
            if (!bl.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)bl));
            }
            if (!bl4) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)bl4));
            }
            if (!bl5) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_COMBO_ITEM, (Object)bl5));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            if (bl3.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VISIBLE, (Object)bl3));
            }
            criteria.setProjection(Projections.rowCount());
            object4 = (Number)criteria.uniqueResult();
            if (object4 != null) {
                paginationSupport.setNumRows(((Number)object4).intValue());
            }
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            if (stringArray != null && stringArray.length > 0) {
                object2 = Projections.projectionList();
                for (String object5 : stringArray) {
                    object2.add((Projection)Projections.property((String)object5), object5);
                }
                criteria.setProjection((Projection)object2);
                criteria.setResultTransformer(Transformers.aliasToBean(MenuItem.class));
                object3 = criteria.list();
            } else {
                object3 = criteria.list();
            }
            object2 = new ArrayList();
            object = object3.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                MenuItem menuItem = (MenuItem)e;
                PriceTableItem priceTableItem = new PriceTableItem();
                priceTableItem.setMenuItem(menuItem);
                priceTableItem.setMenuItemId(menuItem.getId());
                priceTableItem.setItemName(menuItem.getDisplayName());
                priceTableItem.setItemBarcode(menuItem.getBarcode());
                priceTableItem.setRegularPrice(menuItem.getPrice());
                priceTableItem.setPrice(menuItem.getPrice());
                object2.add(priceTableItem);
            }
            paginationSupport.setRows((List)object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem findByName(String string) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_NAME, (Object)string));
            List list = criteria.list();
            if (list.size() == 0) {
                MenuItem menuItem = null;
                return menuItem;
            }
            MenuItem menuItem = (MenuItem)list.get(0);
            return menuItem;
        }
    }

    public MenuItem findByBarcode(String string, Session session) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        Criteria criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)string.trim()));
        List list = criteria.list();
        if (list.size() > 0) {
            return (MenuItem)list.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuItems(BeanTableModel beanTableModel, Boolean bl, MenuGroup menuGroup, String string) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (!bl.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)Boolean.TRUE));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            beanTableModel.setNumRows(number.intValue());
            criteria.setProjection(null);
            String string2 = beanTableModel.getSortBy();
            if (StringUtils.isNotEmpty((String)string2)) {
                criteria.addOrder(beanTableModel.isAscOrder() ? Order.asc((String)string2) : Order.desc((String)string2));
            } else {
                criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
                criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            }
            criteria.setFirstResult(beanTableModel.getCurrentRowIndex());
            criteria.setMaxResults(beanTableModel.getPageSize());
            List list = criteria.list();
            beanTableModel.setRows(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuItems(PaginationSupport paginationSupport, MenuGroup menuGroup, String string, boolean bl, Boolean bl2) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (bl2 != null && bl2.booleanValue()) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PIZZA_TYPE, (Object)bl2));
            }
            if (!bl) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuItem.PROP_VARIANT), (Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.FALSE)));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_VARIANT, (Object)Boolean.TRUE));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            criteria.addOrder(Order.asc((String)MenuItem.PROP_ID));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            List list = criteria.list();
            paginationSupport.setRows(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInventoryItems(PaginationSupport paginationSupport, MenuGroup menuGroup, String string) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.or((Criterion[])new Criterion[]{Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE), Restrictions.ilike((String)MenuItem.PROP_SKU, (String)string.trim(), (MatchMode)MatchMode.START), Restrictions.ilike((String)MenuItem.PROP_BARCODE, (String)string.trim(), (MatchMode)MatchMode.START)}));
            }
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            paginationSupport.setNumRows(number.intValue());
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuItem.PROP_ID));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            List list = criteria.list();
            paginationSupport.setRows(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> findAllInventoryItems() {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_INVENTORY_ITEM, (Object)true));
            List list = criteria.list();
            return list;
        }
    }

    public void updateStockQuantity(String string, double d, boolean bl, boolean bl2, Session session) {
        MenuItemInventoryStatus menuItemInventoryStatus = MenuItemInventoryStatusDAO.getInstance().get(string, session);
        if (menuItemInventoryStatus == null) {
            menuItemInventoryStatus = new MenuItemInventoryStatus();
            menuItemInventoryStatus.setId(string);
        }
        if (bl) {
            menuItemInventoryStatus.setAvailableUnit(menuItemInventoryStatus.getAvailableUnit() + d);
        }
        if (bl2) {
            menuItemInventoryStatus.setUnitOnHand(menuItemInventoryStatus.getUnitOnHand() + d);
        }
        MenuItemInventoryStatusDAO.getInstance().saveOrUpdate(menuItemInventoryStatus, session);
    }

    public void updateStockQuantity(String string, double d, double d2, boolean bl, boolean bl2, Session session) {
        String string2 = null;
        string2 = bl && bl2 ? String.format("update MenuItem set availableUnit = (availableUnit + %s),unitOnHand = (unitOnHand + %s),cost = %s where id = '%s'", d, d, d2, string) : (bl2 ? String.format("update MenuItem set unitOnHand = (unitOnHand + %s),cost = %s where id = '%s'", d, d2, string) : String.format("update MenuItem set availableUnit = (availableUnit + %s),cost = %s where id = '%s'", d, d2, string));
        session.createQuery(string2).executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsMenuItem(MenuGroup menuGroup) {
        Criteria criteria = null;
        try (Session session = null;){
            Number number;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.setProjection(Projections.rowCount());
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            boolean bl = (number = (Number)criteria.uniqueResult()) != null && number.intValue() > 0;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsMenuItem(MenuCategory menuCategory) {
        Criteria criteria = null;
        try (Session session = null;){
            Number number;
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.setProjection(Projections.rowCount());
            if (menuCategory != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_MENU_CATEGORY_ID, (Object)menuCategory.getId()));
            }
            boolean bl = (number = (Number)criteria.uniqueResult()) != null && number.intValue() > 0;
            return bl;
        }
    }

    public void updateLastPurchaseCost(String string, double d, boolean bl, Session session) {
        String string2 = null;
        double d2 = InventoryTransactionDAO.getInstance().findItemAvgCost(string, session);
        double d3 = bl ? d : d2;
        d3 = NumberUtil.roundToTwoDigit(d3);
        string2 = String.format("update MenuItem set lastPurchasedCost = %s,avgCost=%s, cost = %s where id = '%s'", d, d2, d3, string);
        session.createQuery(string2).executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastPurchaseCost(PurchaseOrder purchaseOrder, boolean bl) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            List<PurchaseOrderItem> list = purchaseOrder.getOrderItems();
            for (PurchaseOrderItem purchaseOrderItem : list) {
                MenuItem menuItem = purchaseOrderItem.getMenuItem();
                double d = menuItem.getBaseUnitQuantity(purchaseOrderItem.getItemUnitName());
                double d2 = NumberUtil.roundToTwoDigit(purchaseOrderItem.getUnitPrice() / d);
                this.updateLastPurchaseCost(menuItem.getId(), d2, bl, session);
            }
            session.saveOrUpdate((Object)purchaseOrder);
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem getMenuItemWithFields(String string, String ... stringArray) throws Exception {
        try (Session session = null;){
            session = this.createNewSession();
            MenuItem menuItem = this.getMenuItemWithFields(session, string, stringArray);
            return menuItem;
        }
    }

    public MenuItem getMenuItemWithFields(Session session, String string, String ... stringArray) throws Exception {
        Criteria criteria = null;
        criteria = session.createCriteria(MenuItem.class);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_ID, (Object)string));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.property((String)MenuItem.PROP_ID), MenuItem.PROP_ID);
        for (String string2 : stringArray) {
            projectionList.add((Projection)Projections.property((String)string2), string2);
        }
        criteria.setProjection((Projection)projectionList);
        criteria.setResultTransformer(Transformers.aliasToBean(MenuItem.class));
        MenuItem menuItem = (MenuItem)criteria.uniqueResult();
        if (menuItem != null) {
            Hibernate.initialize(menuItem.getStockUnits());
        }
        return menuItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMenuItems(PaginationSupport paginationSupport, String string) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuItem.PROP_NAME, (String)string.trim(), (MatchMode)MatchMode.ANYWHERE));
            }
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_HAS_VARIANT, (Object)false));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            paginationSupport.setNumRows(number.intValue());
            criteria.setProjection(null);
            criteria.addOrder(Order.asc((String)MenuItem.PROP_SORT_ORDER));
            criteria.addOrder(Order.asc((String)MenuItem.PROP_NAME));
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            List list = criteria.list();
            paginationSupport.setRows(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> findAllUnSyncMenuItems() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            SimpleExpression simpleExpression = Restrictions.eq((String)MenuItem.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE);
            Criterion criterion = Restrictions.isNull((String)MenuItem.PROP_CLOUD_SYNCED);
            criteria.add((Criterion)Restrictions.or((Criterion)simpleExpression, (Criterion)criterion));
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null && session != null) {
                session.close();
            }
        }
    }

    public void updateMenuItemSync(List<String> list, Boolean bl) {
        String string;
        if (list == null || list.isEmpty()) {
            return;
        }
        String string2 = "(";
        Transaction transaction = list.iterator();
        while (transaction.hasNext()) {
            string = transaction.next();
            string2 = string2 + "'" + string + "'";
            if (!transaction.hasNext()) continue;
            string2 = string2 + ",";
        }
        string2 = string2 + ")";
        transaction = null;
        string = null;
        try {
            string = this.getSession();
            transaction = string.beginTransaction();
            String string3 = "update MenuItem set %s=:synced where %s in" + string2;
            string3 = String.format(string3, MenuItem.PROP_CLOUD_SYNCED, MenuItem.PROP_ID);
            Query query = string.createQuery(string3);
            query.setParameter("synced", (Object)bl);
            query.executeUpdate();
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            if (string != null) {
                string.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasByBarcodeOrSKU(String string, String string2) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            Disjunction disjunction = Restrictions.disjunction();
            if (StringUtils.isNotEmpty((String)string)) {
                disjunction.add((Criterion)Restrictions.eq((String)MenuItem.PROP_BARCODE, (Object)string));
            }
            if (StringUtils.isNotEmpty((String)string2)) {
                disjunction.add((Criterion)Restrictions.eq((String)MenuItem.PROP_SKU, (Object)string2));
            }
            criteria.add((Criterion)disjunction);
            List list = criteria.list();
            if (list.size() == 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem getMenuItemByBarcodeAndSKU(String string, String string2) {
        Criteria criteria = null;
        try (Session session = null;){
            session = this.createNewSession();
            criteria = session.createCriteria(MenuItem.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.like((String)MenuItem.PROP_BARCODE, (Object)string));
            criteria.add((Criterion)Restrictions.like((String)MenuItem.PROP_SKU, (Object)string2));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                MenuItem menuItem = null;
                return menuItem;
            }
            MenuItem menuItem = (MenuItem)list.get(0);
            return menuItem;
        }
    }

    public boolean isNameExist(String string, String string2) {
        if (StringUtils.isBlank((String)string2)) {
            return false;
        }
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(MenuItem.class);
            if (StringUtils.isNotBlank((String)string)) {
                criteria.add((Criterion)Restrictions.ne((String)MenuItem.PROP_ID, (Object)string));
            }
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_NAME, (Object)string2));
            List list = criteria.list();
            boolean bl = list != null && !list.isEmpty();
            return bl;
        }
    }

    public void removePizzaPrices(List<String> list, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.createAlias("pizzaPriceList", "priceList");
        criteria.add(Restrictions.in((String)"priceList.id", list));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        List list2 = criteria.list();
        if (list2 != null && !list2.isEmpty()) {
            for (MenuItem menuItem : list2) {
                List<PizzaPrice> list3 = menuItem.getPizzaPriceList();
                Iterator<PizzaPrice> iterator = list3.iterator();
                while (iterator.hasNext()) {
                    PizzaPrice pizzaPrice = iterator.next();
                    if (!list.contains(pizzaPrice.getId())) continue;
                    iterator.remove();
                }
                session.update((Object)menuItem);
            }
        }
    }

    public List<MenuItem> getMenuItemsByPackagingUnit(PackagingUnit packagingUnit, Session session) {
        Criteria criteria = session.createCriteria(InventoryStockUnit.class);
        criteria.add((Criterion)Restrictions.eq((String)InventoryStockUnit.PROP_PACKAGING_UNIT, (Object)packagingUnit));
        criteria.setProjection(Projections.distinct((Projection)Projections.property((String)InventoryStockUnit.PROP_MENU_ITEM_ID)));
        List list = criteria.list();
        if (list != null && !list.isEmpty()) {
            criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add(Restrictions.in((String)MenuItem.PROP_ID, (Collection)list));
            criteria.setProjection(Projections.alias((Projection)Projections.property((String)MenuItem.PROP_NAME), (String)MenuItem.PROP_NAME));
            List list2 = criteria.setResultTransformer(Transformers.aliasToBean((Class)this.getReferenceClass())).list();
            return list2;
        }
        return null;
    }

    public List<MenuItem> getMenuItemsByPrinterGroup(PrinterGroup printerGroup, Session session) {
        if (printerGroup == null) {
            return null;
        }
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        this.addDeletedFilter(criteria);
        criteria.add((Criterion)Restrictions.eq((String)MenuItem.PROP_PRINTER_GROUP_ID, (Object)printerGroup.getId()));
        criteria.setProjection(Projections.alias((Projection)Projections.property((String)MenuItem.PROP_NAME), (String)MenuItem.PROP_NAME));
        return criteria.setResultTransformer(Transformers.aliasToBean((Class)this.getReferenceClass())).list();
    }

    public void doCopyModifiersToOtherItems(MenuItem menuItem, List<MenuItem> list) throws Exception {
        List<MenuItemModifierSpec> list2 = menuItem.getMenuItemModiferSpecs();
        if (list2 == null || list2.isEmpty()) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (MenuItem menuItem2 : list) {
                session.refresh((Object)menuItem2);
                for (MenuItemModifierSpec menuItemModifierSpec : list2) {
                    if (menuItemModifierSpec != null && menuItemModifierSpec.getId() != null) {
                        session.refresh((Object)menuItemModifierSpec);
                    }
                    List<MenuItemModifierSpec> list3 = menuItem2.getMenuItemModiferSpecs();
                    Iterator<MenuItemModifierSpec> iterator = list3.iterator();
                    while (iterator.hasNext()) {
                        MenuItemModifierSpec menuItemModifierSpec2 = iterator.next();
                        if (!menuItemModifierSpec2.getModifierGroupId().equals(menuItemModifierSpec.getModifierGroupId())) continue;
                        iterator.remove();
                    }
                    menuItem2.addTomenuItemModiferSpecs(menuItemModifierSpec.deepClone());
                }
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
    }

    public void saveOrUpdateMenuItems(List<MenuItem> list) throws Exception {
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (MenuItem menuItem : list) {
                this.saveOrUpdate(menuItem, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
    }
}

