/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.StockCount;
import com.floreantpos.model.StockCountItem;
import com.floreantpos.model.dao.BaseStockCountDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.StockCountItemDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class StockCountDAO
extends BaseStockCountDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdate(StockCount stockCount, boolean bl) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.saveOrUpdate(stockCount, bl, session);
            transaction.commit();
        }
    }

    public void saveOrUpdate(StockCount stockCount, boolean bl, Session session) {
        if (stockCount.getId() == null) {
            stockCount.setCreatedDate(new Date());
        }
        stockCount.setLastModifiedDate(new Date());
        if (bl) {
            this.adjustInventoryItems(session, stockCount);
        }
        session.saveOrUpdate((Object)stockCount);
    }

    private void adjustInventoryItems(Session session, StockCount stockCount) {
        List<StockCountItem> list = stockCount.getCountItems();
        if (list == null) {
            return;
        }
        for (StockCountItem stockCountItem : list) {
            if (stockCountItem.isAdjusted().booleanValue()) continue;
            stockCountItem.setAdjusted(Boolean.TRUE);
            Double d = stockCountItem.getActualUnit() - stockCountItem.getUnitOnHand();
            if (d == 0.0) continue;
            InventoryTransaction inventoryTransaction = new InventoryTransaction();
            MenuItem menuItem = MenuItemDAO.getInstance().get(stockCountItem.getItemId(), session);
            if (menuItem == null && (menuItem = MenuItemDAO.getInstance().getMenuItemBySKU(stockCountItem.getSku(), session, true)) != null) {
                stockCountItem.setItemId(menuItem.getId());
            }
            Hibernate.initialize(menuItem.getStockUnits());
            inventoryTransaction.setMenuItem(menuItem);
            inventoryTransaction.setQuantity(Math.abs(d));
            inventoryTransaction.setUnit(stockCountItem.getUnit());
            double d2 = menuItem.getBaseUnitQuantity(stockCountItem.getUnit());
            inventoryTransaction.setUnitCost(d2 * menuItem.getCost());
            inventoryTransaction.setTotal(d2 * inventoryTransaction.getQuantity() * menuItem.getCost());
            inventoryTransaction.setTransactionDate(new Date());
            String string = stockCountItem.getReason();
            if (StringUtils.isEmpty((CharSequence)string)) {
                String string2 = d > 0.0 ? "ADJUST_IN" : "ADJUST_OUT";
                inventoryTransaction.setReason(string2);
            } else {
                inventoryTransaction.setReason(string);
            }
            if (d > 0.0) {
                inventoryTransaction.setType(InventoryTransactionType.IN.getType());
                inventoryTransaction.setToInventoryLocation(stockCountItem.getInventoryLocation());
            } else {
                inventoryTransaction.setType(InventoryTransactionType.OUT.getType());
                inventoryTransaction.setFromInventoryLocation(stockCountItem.getInventoryLocation());
            }
            InventoryTransactionDAO.getInstance().adjustInventoryStock(inventoryTransaction, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextStockCountSequenceNumber() {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.max((String)StockCount.PROP_REF_NUMBER));
            Object object = criteria.uniqueResult();
            if (object == null) {
                String string = "10001";
                return string;
            }
            String string = String.valueOf(Integer.parseInt((String)object) + 1);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findBy(String string, Date date, Date date2, Boolean bl) {
        try (Session session = null;){
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotEmpty((CharSequence)string)) {
                criteria.add(Restrictions.ilike((String)StockCount.PROP_REF_NUMBER, (Object)string));
            }
            if (date != null && date2 != null) {
                criteria.add((Criterion)Restrictions.ge((String)StockCount.PROP_CREATED_DATE, (Object)date));
                criteria.add((Criterion)Restrictions.le((String)StockCount.PROP_CREATED_DATE, (Object)date2));
            }
            if (!bl.booleanValue()) {
                criteria.add(Restrictions.isNull((String)StockCount.PROP_VERIFIED_BY));
            }
            List list = criteria.list();
            return list;
        }
    }

    public void saveOrUpdateStockCounts(List<StockCount> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (StockCount stockCount : list) {
                List<StockCountItem> list2 = stockCount.getCountItems();
                stockCount.setCountItems(null);
                stockCount.setUpdateLastUpdateTime(bl);
                stockCount.setUpdateSyncTime(bl2);
                StockCountDAO stockCountDAO = StockCountDAO.getInstance();
                StockCount stockCount2 = stockCountDAO.get(stockCount.getId());
                if (stockCount2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(stockCount.getLastUpdateTime(), stockCount2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), stockCount.getId() + " already updated");
                        continue;
                    }
                    long l = stockCount2.getVersion();
                    stockCount.setVersion(l);
                } else {
                    this.save(stockCount, session);
                }
                List<StockCountItem> list3 = null;
                if (stockCount2 != null && stockCount2.getCountItems() != null) {
                    list3 = stockCount2.getCountItems();
                }
                if (list3 == null) {
                    list3 = new ArrayList<StockCountItem>();
                }
                if (list2 != null && list2.size() > 0) {
                    for (StockCountItem stockCountItem : list2) {
                        stockCountItem.setStockCount(stockCount);
                        int n = list3.indexOf(stockCountItem);
                        StockCountItem stockCountItem2 = null;
                        if (n != -1) {
                            stockCountItem2 = list3.get(n);
                            if (stockCountItem2 == null) {
                                stockCountItem.setVersion(0L);
                                StockCountItemDAO.getInstance().save(stockCountItem, session);
                                continue;
                            }
                            stockCountItem.setVersion(stockCountItem2.getVersion());
                            continue;
                        }
                        stockCountItem.setVersion(0L);
                        StockCountItemDAO.getInstance().save(stockCountItem, session);
                    }
                }
                stockCount.setCountItems(list2);
                this.saveOrUpdate(stockCount, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }
}

