/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.report.AbstractReportDataSource;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class KitchenStickerModel
extends AbstractReportDataSource {
    public KitchenStickerModel(List<KitchenSticker> list) {
        super(new String[]{"itemCount", "item", "itemModifier", "cookingInstruction", "time", "other", "token", "customerName"});
        this.setRows(list);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        KitchenSticker kitchenSticker = (KitchenSticker)this.rows.get(n);
        switch (n2) {
            case 0: {
                return kitchenSticker.getItemCount();
            }
            case 1: {
                return kitchenSticker.getItemName();
            }
            case 2: {
                return this.getModifiers(kitchenSticker);
            }
            case 3: {
                return this.getCookingInsgtruction(kitchenSticker);
            }
            case 4: {
                return kitchenSticker.getTime();
            }
            case 5: {
                return kitchenSticker.getOrderType();
            }
            case 6: {
                return kitchenSticker.getToken();
            }
            case 7: {
                String string = kitchenSticker.getCustomerName();
                if (!StringUtils.isNotEmpty((String)string)) break;
                return string;
            }
        }
        return null;
    }

    public String getModifiers(KitchenSticker kitchenSticker) {
        List<KitchenTicketItem> list = kitchenSticker.getModifiers();
        String string = "<html><body>";
        if (list == null) {
            return string + "</body></html>";
        }
        for (KitchenTicketItem kitchenTicketItem : list) {
            string = string + kitchenTicketItem.getMenuItemName() + "<br>";
        }
        return string + "</body></html>";
    }

    public String getCookingInsgtruction(KitchenSticker kitchenSticker) {
        List<KitchenTicketItem> list = kitchenSticker.getCookingInstructions();
        String string = "<html><body>";
        if (list == null) {
            return string + "</body></html>";
        }
        for (KitchenTicketItem kitchenTicketItem : list) {
            string = string + kitchenTicketItem.getMenuItemName() + "<br>";
        }
        return string;
    }

    public static class KitchenSticker {
        private String a;
        private List<KitchenTicketItem> b;
        private List<KitchenTicketItem> c;
        private String d;
        private String e;
        private String f;
        private Integer g;
        private String h;

        public String getItemName() {
            return this.a;
        }

        public void setItemName(String string) {
            this.a = string;
        }

        public String getTime() {
            return this.d;
        }

        public void setTime(String string) {
            this.d = string;
        }

        public String getOrderType() {
            return this.e;
        }

        public void setOrderType(String string) {
            this.e = string;
        }

        public String getItemCount() {
            return this.f;
        }

        public void setItemCount(String string) {
            this.f = string;
        }

        public List<KitchenTicketItem> getCookingInstructions() {
            return this.b;
        }

        public void setCookingInstructions(List<KitchenTicketItem> list) {
            this.b = list;
        }

        public List<KitchenTicketItem> getModifiers() {
            return this.c;
        }

        public void setModifiers(List<KitchenTicketItem> list) {
            this.c = list;
        }

        public Integer getToken() {
            return this.g;
        }

        public void setToken(Integer n) {
            this.g = n;
        }

        public String getCustomerName() {
            return this.h;
        }

        public void setCustomerName(String string) {
            this.h = string;
        }
    }
}

