/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.TaxExemptReport;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class TaxExemptReportView
extends JPanel {
    private JXDatePicker a = UiUtil.getCurrentMonthStart();
    private JXDatePicker b = UiUtil.getCurrentMonthEnd();
    private JButton c = new JButton(POSConstants.GO);
    private JPanel d;

    public TaxExemptReportView() {
        super(new BorderLayout());
        this.a();
    }

    private void a() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        this.d = new JPanel(new BorderLayout());
        this.c.addActionListener(actionEvent -> this.b());
        jPanel.add((Component)new JLabel(POSConstants.FROM + ":"), "grow");
        jPanel.add((Component)this.a);
        jPanel.add((Component)new JLabel(POSConstants.TO + ":"), "grow");
        jPanel.add((Component)this.b);
        jPanel.add((Component)this.c, "skip 1, al right");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        jPanel2.add(this.d);
        this.add(jPanel2);
    }

    private void b() {
        try {
            Date date = this.a.getDate();
            Date date2 = this.b.getDate();
            DateUtil.validateDate(date, date2);
            date = DateUtil.startOfDay(date);
            date2 = DateUtil.endOfDay(date2);
            ReportService reportService = new ReportService();
            TaxExemptReport taxExemptReport = reportService.getTaxExemptReport(date, date2);
            HashMap hashMap = new HashMap();
            ReportUtil.populateRestaurantProperties(hashMap, true);
            ReportUtil.populateReportHeader(hashMap, null, date, date2, null);
            ReportUtil.populateReportFooter(hashMap);
            this.a(hashMap);
            JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("tax_exempt_report"));
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)taxExemptReport.getTaxExemptTableModel()));
            JRViewer jRViewer = new JRViewer(jasperPrint);
            this.d.removeAll();
            this.d.add((Component)jRViewer);
            this.d.revalidate();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (JRException jRException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), jRException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    private void a(HashMap hashMap) {
        hashMap.put("reportTitle", POSConstants.TAX_EXEMPT_REPORT);
        hashMap.put("colTicketId", POSConstants.TICKET_ID);
        hashMap.put("colCustomerName", POSConstants.CUSTOMER);
        hashMap.put("colTotalAmount", POSConstants.TOTAL_AMOUNT);
        hashMap.put("colCreateDate", POSConstants.CREATED);
        hashMap.put("colTaxAmount", POSConstants.TAX_EXEMPT);
    }
}

