/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services.report;

import com.floreantpos.POSConstants;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.Discount;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PayoutReason;
import com.floreantpos.model.PayoutRecepient;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseCashDrawer;
import com.floreantpos.model.base.BasePayoutReason;
import com.floreantpos.model.base.BasePayoutRecepient;
import com.floreantpos.model.base.BaseTerminal;
import com.floreantpos.model.base.BaseUser;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.PayoutReasonDAO;
import com.floreantpos.model.dao.PayoutRecepientDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.CardTypeEnum;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.DiscountData;
import com.floreantpos.report.DiscountReportDataModel;
import com.floreantpos.report.JournalReportModel;
import com.floreantpos.report.MenuUsageReport;
import com.floreantpos.report.ReportItem;
import com.floreantpos.report.SalesBalanceReport;
import com.floreantpos.report.SalesDetailedReport;
import com.floreantpos.report.SalesExceptionReport;
import com.floreantpos.report.SalesReportModel;
import com.floreantpos.report.ServerProductivityReport;
import com.floreantpos.report.TaxExemptReport;
import com.floreantpos.report.payout.PayoutReportData;
import com.floreantpos.report.payout.PayoutReportDataModel;
import com.floreantpos.services.report.CashDrawerReportService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class ReportService {
    private static SimpleDateFormat a = new SimpleDateFormat("MMM dd yyyy, hh:mm a");
    private static SimpleDateFormat b = new SimpleDateFormat("MMM dd yyyy ");

    public static String formatFullDate(Date date) {
        return a.format(date);
    }

    public static String formatShortDate(Date date) {
        return b.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuUsageReport getMenuUsageReport(Date date, Date date2) {
        GenericDAO genericDAO = new GenericDAO();
        MenuUsageReport menuUsageReport = new MenuUsageReport();
        try (Session session = null;){
            session = genericDAO.getSession();
            Criteria criteria = session.createCriteria(MenuCategory.class);
            List list = criteria.list();
            MenuCategory menuCategory = new MenuCategory();
            menuCategory.setName(POSConstants.MISC_BUTTON_TEXT);
            list.add(menuCategory);
            for (MenuCategory menuCategory2 : list) {
                criteria = session.createCriteria(TicketItem.class, "item");
                criteria.createCriteria("ticket", "t");
                ProjectionList projectionList = Projections.projectionList();
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_QUANTITY));
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_SUBTOTAL_AMOUNT));
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_DISCOUNT_AMOUNT));
                criteria.setProjection((Projection)projectionList);
                criteria.add((Criterion)Restrictions.eq((String)("item." + TicketItem.PROP_CATEGORY_ID), (Object)menuCategory2.getId()));
                criteria.add((Criterion)Restrictions.ge((String)("t." + Ticket.PROP_CREATE_DATE), (Object)date));
                criteria.add((Criterion)Restrictions.lt((String)("t." + Ticket.PROP_CREATE_DATE), (Object)date2));
                criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_PAID), (Object)Boolean.TRUE));
                List list2 = criteria.list();
                if (list2.size() <= 0) continue;
                Object[] objectArray = (Object[])list2.get(0);
                MenuUsageReport.MenuUsageReportData menuUsageReportData = new MenuUsageReport.MenuUsageReportData();
                menuUsageReportData.setCategoryName(menuCategory2.getName());
                if (objectArray.length > 0 && objectArray[0] != null) {
                    menuUsageReportData.setCount(((Number)objectArray[0]).intValue());
                }
                if (objectArray.length > 1 && objectArray[1] != null) {
                    menuUsageReportData.setGrossSales(((Number)objectArray[1]).doubleValue());
                }
                if (objectArray.length > 2 && objectArray[2] != null) {
                    menuUsageReportData.setDiscount(((Number)objectArray[2]).doubleValue());
                }
                menuUsageReportData.calculate();
                menuUsageReport.addReportData(menuUsageReportData);
            }
            MenuUsageReport menuUsageReport2 = menuUsageReport;
            return menuUsageReport2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerProductivityReport getServerProductivityReport(Date date, Date date2, List<User> list) {
        GenericDAO genericDAO = new GenericDAO();
        ServerProductivityReport serverProductivityReport = new ServerProductivityReport();
        try (Session session = null;){
            session = genericDAO.getSession();
            Criteria criteria = session.createCriteria(MenuCategory.class);
            List list2 = criteria.list();
            MenuCategory menuCategory = new MenuCategory();
            menuCategory.setName(POSConstants.MISC_BUTTON_TEXT);
            list2.add(menuCategory);
            for (User user : list) {
                ServerProductivityReport.ServerProductivityReportData serverProductivityReportData = new ServerProductivityReport.ServerProductivityReportData();
                serverProductivityReportData.setServerName(user.toString());
                criteria = session.createCriteria(Ticket.class);
                criteria.add(Restrictions.in((String)Ticket.PROP_OWNER_ID, user.getRoleIds()));
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.TRUE));
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
                criteria.add((Criterion)Restrictions.lt((String)Ticket.PROP_CREATE_DATE, (Object)date2));
                ProjectionList projectionList = Projections.projectionList();
                projectionList.add(Projections.rowCount());
                projectionList.add((Projection)Projections.sum((String)Ticket.PROP_NUMBER_OF_GUESTS));
                projectionList.add((Projection)Projections.sum((String)Ticket.PROP_SUBTOTAL_AMOUNT));
                projectionList.add((Projection)Projections.sum((String)Ticket.PROP_DISCOUNT_AMOUNT));
                criteria.setProjection((Projection)projectionList);
                Object[] objectArray = (Object[])criteria.uniqueResult();
                int n = 0;
                double d = 0.0;
                if (objectArray != null) {
                    int n2;
                    if (objectArray.length > 0 && objectArray[0] != null) {
                        n = n2 = ((Number)objectArray[0]).intValue();
                        serverProductivityReportData.setTotalCheckCount(n);
                    }
                    if (objectArray.length > 1 && objectArray[1] != null) {
                        n2 = ((Number)objectArray[1]).intValue();
                        serverProductivityReportData.setTotalGuestCount(n2);
                    }
                    if (objectArray.length > 3) {
                        d = objectArray[2] != null ? ((Number)objectArray[2]).doubleValue() : 0.0;
                        double d2 = objectArray[3] != null ? ((Number)objectArray[3]).doubleValue() : 0.0;
                        serverProductivityReportData.setTotalSales(d - d2);
                    }
                }
                serverProductivityReportData.calculate();
                serverProductivityReport.addReportData(serverProductivityReportData);
                criteria = session.createCriteria(TicketItem.class, "item");
                criteria.createCriteria(TicketItem.PROP_TICKET, "t");
                projectionList = Projections.projectionList();
                criteria.setProjection((Projection)projectionList);
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_QUANTITY), "itemCount");
                projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_SUBTOTAL_AMOUNT), "grossSales");
                projectionList.add((Projection)Projections.sum((String)("t." + Ticket.PROP_DISCOUNT_AMOUNT)), "salesDiscount");
                projectionList.add((Projection)Projections.property((String)TicketItem.PROP_CATEGORY_NAME), "categoryName");
                criteria.add((Criterion)Restrictions.eq((String)("item." + TicketItem.PROP_VOIDED), (Object)Boolean.FALSE));
                criteria.add((Criterion)Restrictions.ge((String)("t." + Ticket.PROP_CREATE_DATE), (Object)date));
                criteria.add((Criterion)Restrictions.lt((String)("t." + Ticket.PROP_CREATE_DATE), (Object)date2));
                criteria.add(Restrictions.in((String)("t." + Ticket.PROP_OWNER_ID), user.getRoleIds()));
                criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_PAID), (Object)Boolean.TRUE));
                criteria.addOrder(Order.asc((String)TicketItem.PROP_CATEGORY_NAME));
                projectionList.add((Projection)Projections.groupProperty((String)("item." + TicketItem.PROP_CATEGORY_NAME)));
                criteria.setResultTransformer(Transformers.aliasToBean(ServerProductivityReport.ServerProductivityReportData.class));
                List list3 = criteria.list();
                for (ServerProductivityReport.ServerProductivityReportData serverProductivityReportData2 : list3) {
                    serverProductivityReportData2.setServerName(user.toString());
                    serverProductivityReportData2.setTotalCheckCount(n);
                    if (serverProductivityReportData2.getCategoryName() == null) {
                        serverProductivityReportData2.setCategoryName(POSConstants.OTHERS);
                    }
                    serverProductivityReportData2.calculate();
                    serverProductivityReport.addReportData(serverProductivityReportData2);
                }
            }
            ServerProductivityReport serverProductivityReport2 = serverProductivityReport;
            return serverProductivityReport2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JournalReportModel getJournalReport(Date date, Date date2) {
        GenericDAO genericDAO = new GenericDAO();
        JournalReportModel journalReportModel = new JournalReportModel();
        Session session = null;
        journalReportModel.setFromDate(date);
        journalReportModel.setToDate(date2);
        journalReportModel.setReportTime(new Date());
        try {
            session = genericDAO.getSession();
            Criteria criteria = session.createCriteria(ActionHistory.class);
            criteria.add((Criterion)Restrictions.ge((String)ActionHistory.PROP_ACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)ActionHistory.PROP_ACTION_TIME, (Object)date2));
            criteria.addOrder(Order.desc((String)ActionHistory.PROP_ACTION_TIME));
            List list = criteria.list();
            for (ActionHistory actionHistory : list) {
                User user = actionHistory.getPerformer();
                String string = "";
                if (user != null) {
                    string = user.getId();
                }
                JournalReportModel.JournalReportData journalReportData = new JournalReportModel.JournalReportData();
                journalReportData.setAction(actionHistory.getActionName());
                journalReportData.setUserInfo(string);
                journalReportData.setTime(actionHistory.getActionTime());
                journalReportData.setComments(actionHistory.getDescription());
                journalReportModel.addReportData(journalReportData);
            }
            JournalReportModel journalReportModel2 = journalReportModel;
            return journalReportModel2;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesBalanceReport getSalesBalanceReport(Date date, Date date2, User user) {
        GenericDAO genericDAO = new GenericDAO();
        SalesBalanceReport salesBalanceReport = new SalesBalanceReport();
        Session session = null;
        salesBalanceReport.setFromDate(date);
        salesBalanceReport.setToDate(date2);
        salesBalanceReport.setReportTime(new Date());
        try {
            session = genericDAO.getSession();
            salesBalanceReport.setNetSalesAmount(this.i(session, date, date2, user));
            salesBalanceReport.setNetTaxableSalesAmount(this.a(session, date, date2, user, true));
            salesBalanceReport.setNetNonTaxableSalesAmount(this.a(session, date, date2, user, false));
            salesBalanceReport.setDiscountAmount(this.g(session, date, date2, user));
            salesBalanceReport.setSalesTaxAmount(this.h(session, date, date2, user));
            salesBalanceReport.setCashTipsAmount(this.e(session, date, date2, user));
            salesBalanceReport.setChargedTipsAmount(this.f(session, date, date2, user));
            salesBalanceReport.setCashReceiptsAmount(this.d(session, date, date2, user));
            salesBalanceReport.setCreditCardReceiptsAmount(this.a(session, CreditCardTransaction.class, date, date2, user));
            salesBalanceReport.setDebitCardReceiptsAmount(this.d(session, DebitCardTransaction.class, date, date2, user));
            salesBalanceReport.setMemberPaymentAmount(this.f(session, CustomerAccountTransaction.class, date, date2, user));
            salesBalanceReport.setCustomPaymentAmount(this.e(session, CustomPaymentTransaction.class, date, date2, user));
            salesBalanceReport.setGiftCertReceipts(this.calculateGiftCertReceipts(session, date, date2, user));
            salesBalanceReport.setCashBackAmount(this.b(session, RefundTransaction.class, date, date2, user));
            salesBalanceReport.setCashRefundAmount(this.c(session, RefundTransaction.class, date, date2, user));
            salesBalanceReport.setToleranceAmount(this.j(session, date, date2, user));
            salesBalanceReport.setServiceChargeAmnt(this.c(session, date, date2, user));
            salesBalanceReport.setGrossTipsPaidAmount(this.b(session, date, date2, user));
            salesBalanceReport.setCashPayoutAmount(this.a(session, date, date2, user));
            this.a(session, salesBalanceReport, date, date2, user);
            salesBalanceReport.setVisaCreditCardAmount(this.g(session, CreditCardTransaction.class, date, date2, user));
            salesBalanceReport.setMasterCardAmount(this.h(session, CreditCardTransaction.class, date, date2, user));
            salesBalanceReport.setAmexAmount(this.i(session, CreditCardTransaction.class, date, date2, user));
            salesBalanceReport.setDiscoveryAmount(this.j(session, CreditCardTransaction.class, date, date2, user));
            salesBalanceReport.setVisaDebitCardAmount(this.k(session, DebitCardTransaction.class, date, date2, user));
            salesBalanceReport.setMasterDebitCardAmount(this.l(session, DebitCardTransaction.class, date, date2, user));
            salesBalanceReport.calculate();
            SalesBalanceReport salesBalanceReport2 = salesBalanceReport;
            return salesBalanceReport2;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private void a(Session session, SalesBalanceReport salesBalanceReport, Date date, Date date2, User user) {
        double d;
        Criteria criteria = session.createCriteria(CashDrawer.class);
        criteria.add((Criterion)Restrictions.ge((String)CashDrawer.PROP_REPORT_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)CashDrawer.PROP_REPORT_TIME, (Object)date2));
        ReportService.addMultiUserFilter(user, criteria, CashDrawer.PROP_ASSIGNED_USER_ID);
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.sum((String)CashDrawer.PROP_DRAWER_ACCOUNTABLE));
        projectionList.add((Projection)Projections.sum((String)CashDrawer.PROP_BEGIN_CASH));
        criteria.setProjection((Projection)projectionList);
        Object[] objectArray = (Object[])criteria.uniqueResult();
        if (objectArray.length > 0 && objectArray[0] instanceof Number) {
            d = ((Number)objectArray[0]).doubleValue();
            salesBalanceReport.setDrawerPullsAmount(d);
        }
        if (objectArray.length > 1 && objectArray[1] instanceof Number) {
            d = ((Number)objectArray[1]).doubleValue();
            salesBalanceReport.setDrawerPullsAmount(salesBalanceReport.getDrawerPullsAmount() - d);
        }
    }

    private double a(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(PayOutTransaction.class);
        criteria.add((Criterion)Restrictions.ge((String)PayOutTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)PayOutTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        ReportService.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)PayOutTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double b(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.createAlias(Ticket.PROP_GRATUITY, "gratuity");
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)Ticket.PROP_CREATE_DATE, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)("gratuity." + Gratuity.PROP_PAID), (Object)Boolean.TRUE));
        ReportService.addMultiUserFilter(user, criteria, Ticket.PROP_OWNER_ID);
        criteria.setProjection((Projection)Projections.sum((String)("gratuity." + Gratuity.PROP_AMOUNT)));
        return this.a(criteria.uniqueResult());
    }

    private double a(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        ReportService.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CreditCardTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double b(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        ReportService.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double c(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        ReportService.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double c(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)Ticket.PROP_CREATE_DATE, (Object)date2));
        ReportService.addMultiUserFilter(user, criteria, Ticket.PROP_OWNER_ID);
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)Ticket.PROP_SERVICE_CHARGE));
        return this.a(criteria.uniqueResult());
    }

    private double d(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        ReportService.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double e(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        ReportService.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CustomPaymentTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double d(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(CashTransaction.class);
        criteria.add((Criterion)Restrictions.ge((String)CashTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)CashTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        ReportService.addMultiUserFilter(user, criteria, CashTransaction.PROP_USER_ID);
        criteria.add((Criterion)Restrictions.eq((String)CashTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    public double calculateGiftCertReceipts(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(GiftCertificateTransaction.class);
        criteria.add((Criterion)Restrictions.ge((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        ReportService.addMultiUserFilter(user, criteria, GiftCertificateTransaction.PROP_USER_ID);
        criteria.add((Criterion)Restrictions.eq((String)GiftCertificateTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double e(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(PosTransaction.class);
        criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double f(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.MEMBER_ACCOUNT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double f(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(PosTransaction.class);
        criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
        criteria.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double g(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)Ticket.PROP_CREATE_DATE, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
        ReportService.addMultiUserFilter(user, criteria, Ticket.PROP_OWNER_ID);
        criteria.setProjection((Projection)Projections.sum((String)Ticket.PROP_DISCOUNT_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double a(Object object) {
        if (object != null && object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return 0.0;
    }

    private double h(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)Ticket.PROP_CREATE_DATE, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
        ReportService.addMultiUserFilter(user, criteria, Ticket.PROP_OWNER_ID);
        criteria.setProjection((Projection)Projections.sum((String)Ticket.PROP_TAX_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double i(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)Ticket.PROP_CREATE_DATE, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
        ReportService.addMultiUserFilter(user, criteria, Ticket.PROP_OWNER_ID);
        criteria.setProjection((Projection)Projections.sum((String)Ticket.PROP_SUBTOTAL_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double j(Session session, Date date, Date date2, User user) {
        Criteria criteria = this.a(session, CashTransaction.class);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        ReportService.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TOLERANCE_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private Criteria a(Session session, Class clazz) {
        Criteria criteria = session.createCriteria(clazz);
        if (clazz.equals(RefundTransaction.class) || clazz.equals(PayOutTransaction.class)) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
        } else {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        }
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        return criteria;
    }

    private double a(Session session, Date date, Date date2, User user, boolean bl) {
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)Ticket.PROP_CREATE_DATE, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
        ReportService.addMultiUserFilter(user, criteria, Ticket.PROP_OWNER_ID);
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TAX_EXEMPT, (Object)(!bl ? 1 : 0)));
        criteria.setProjection((Projection)Projections.sum((String)Ticket.PROP_SUBTOTAL_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesExceptionReport getSalesExceptionReport(Date date, Date date2) {
        GenericDAO genericDAO = new GenericDAO();
        SalesExceptionReport salesExceptionReport = new SalesExceptionReport();
        Session session = null;
        salesExceptionReport.setFromDate(date);
        salesExceptionReport.setToDate(date2);
        salesExceptionReport.setReportTime(new Date());
        try {
            Object object;
            Object object22;
            Object object32;
            session = genericDAO.getSession();
            Criteria criteria = session.createCriteria(RefundTransaction.class);
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
            List list = criteria.list();
            for (Object object32 : list) {
                salesExceptionReport.addRefundToRefundData((RefundTransaction)object32);
            }
            Criteria criteria2 = session.createCriteria(Ticket.class);
            criteria2.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            criteria2.add((Criterion)Restrictions.lt((String)Ticket.PROP_CLOSING_DATE, (Object)date2));
            criteria2.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)true));
            list = criteria2.list();
            for (Object object22 : list) {
                salesExceptionReport.addVoidToVoidData((Ticket)object22);
            }
            criteria2 = session.createCriteria(Ticket.class);
            criteria2.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            criteria2.add((Criterion)Restrictions.lt((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            criteria2.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
            list = criteria2.list();
            for (Object object22 : list) {
                salesExceptionReport.addDiscountOnTicket((Ticket)object22);
                object = ((Ticket)object22).getTicketItems();
                Iterator<TicketItem> iterator = object.iterator();
                while (iterator.hasNext()) {
                    TicketItem ticketItem = iterator.next();
                    salesExceptionReport.addDiscountOnTicketItem(ticketItem);
                }
            }
            object32 = new DiscountDAO();
            object22 = ((DiscountDAO)object32).getValidCoupons();
            salesExceptionReport.addEmptyDiscounts((List<Discount>)object22);
            object = salesExceptionReport;
            return object;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public SalesDetailedReport getSalesDetailedReport(Date date, Date date2) {
        GenericDAO genericDAO = new GenericDAO();
        SalesDetailedReport salesDetailedReport = new SalesDetailedReport();
        salesDetailedReport.setFromDate(date);
        salesDetailedReport.setToDate(date2);
        salesDetailedReport.setReportTime(new Date());
        try (Session session = genericDAO.createNewSession();){
            Criteria criteria = session.createCriteria(CashDrawer.class);
            criteria.add(Restrictions.between((String)CashDrawer.PROP_START_TIME, (Object)date, (Object)date2));
            List list = criteria.list();
            for (Comparable comparable : list) {
                Object object;
                if (((BaseCashDrawer)comparable).getReportTime() == null) {
                    object = new CashDrawerReportService((CashDrawer)comparable);
                    ((CashDrawerReportService)object).populateReport(session);
                }
                object = new SalesDetailedReport.DrawerPullData();
                ((SalesDetailedReport.DrawerPullData)object).setDrawerPullId(((BaseCashDrawer)comparable).getId());
                ((SalesDetailedReport.DrawerPullData)object).setTicketCount(((BaseCashDrawer)comparable).getTicketCount());
                ((SalesDetailedReport.DrawerPullData)object).setIdealAmount(((BaseCashDrawer)comparable).getDrawerAccountable());
                ((SalesDetailedReport.DrawerPullData)object).setActualAmount(((BaseCashDrawer)comparable).getCashToDeposit());
                ((SalesDetailedReport.DrawerPullData)object).setVarinceAmount(((BaseCashDrawer)comparable).getDrawerAccountable() - ((BaseCashDrawer)comparable).getCashToDeposit());
                salesDetailedReport.addDrawerPullData((SalesDetailedReport.DrawerPullData)object);
            }
            criteria = session.createCriteria(PosTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)CustomPaymentTransaction.PROP_TRANSACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)CustomPaymentTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            list = criteria.list();
            for (Comparable comparable : list) {
                salesDetailedReport.addPaymentData((PosTransaction)comparable);
            }
            SalesDetailedReport salesDetailedReport2 = salesDetailedReport;
            return salesDetailedReport2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SalesDetailedReport getCloudSalesDetailedReport(Date date, Date date2) {
        GenericDAO genericDAO = new GenericDAO();
        SalesDetailedReport salesDetailedReport = new SalesDetailedReport();
        Session session = null;
        salesDetailedReport.setFromDate(date);
        salesDetailedReport.setToDate(date2);
        salesDetailedReport.setReportTime(new Date());
        try {
            Object object;
            Comparable comparable2;
            session = genericDAO.getSession();
            Criteria criteria = session.createCriteria(CashDrawer.class);
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)CashDrawer.PROP_REPORT_TIME), (Criterion)Restrictions.ge((String)CashDrawer.PROP_REPORT_TIME, (Object)date)));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)CashDrawer.PROP_REPORT_TIME), (Criterion)Restrictions.lt((String)CashDrawer.PROP_REPORT_TIME, (Object)date2)));
            List list = criteria.list();
            for (Comparable comparable2 : list) {
                object = new SalesDetailedReport.DrawerPullData();
                ((SalesDetailedReport.DrawerPullData)object).setDrawerPullId(((BaseCashDrawer)comparable2).getId());
                ((SalesDetailedReport.DrawerPullData)object).setTicketCount(((BaseCashDrawer)comparable2).getTicketCount());
                ((SalesDetailedReport.DrawerPullData)object).setIdealAmount(((BaseCashDrawer)comparable2).getDrawerAccountable());
                ((SalesDetailedReport.DrawerPullData)object).setActualAmount(((BaseCashDrawer)comparable2).getCashToDeposit());
                ((SalesDetailedReport.DrawerPullData)object).setVarinceAmount(((BaseCashDrawer)comparable2).getDrawerAccountable() - ((BaseCashDrawer)comparable2).getCashToDeposit());
                salesDetailedReport.addDrawerPullData((SalesDetailedReport.DrawerPullData)object);
            }
            criteria = session.createCriteria(CreditCardTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)CreditCardTransaction.PROP_TRANSACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)CreditCardTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            list = criteria.list();
            for (Comparable comparable2 : list) {
                salesDetailedReport.addCreditCardData((CreditCardTransaction)comparable2);
            }
            criteria = session.createCriteria(DebitCardTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)DebitCardTransaction.PROP_TRANSACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)DebitCardTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            list = criteria.list();
            for (Comparable comparable2 : list) {
                salesDetailedReport.addCreditCardData((DebitCardTransaction)comparable2);
            }
            criteria = session.createCriteria(GiftCertificateTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add(Projections.rowCount());
            projectionList.add((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_AMOUNT));
            criteria.setProjection((Projection)projectionList);
            comparable2 = (Object[])criteria.uniqueResult();
            if (comparable2 != null && ((Comparable)comparable2).length > 0 && comparable2[0] instanceof Number) {
                salesDetailedReport.setGiftCertReturnCount(((Number)((Object)comparable2[0])).intValue());
            }
            if (comparable2 != null && ((Comparable)comparable2).length > 1 && comparable2[1] instanceof Number) {
                salesDetailedReport.setGiftCertReturnAmount(((Number)((Object)comparable2[1])).doubleValue());
            }
            criteria = session.createCriteria(GiftCertificateTransaction.class);
            criteria.add((Criterion)Restrictions.ge((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)GiftCertificateTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            criteria.add((Criterion)Restrictions.gt((String)GiftCertificateTransaction.PROP_GIFT_CERT_CASH_BACK_AMOUNT, (Object)0.0));
            projectionList = Projections.projectionList();
            projectionList.add(Projections.rowCount());
            projectionList.add((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_GIFT_CERT_CASH_BACK_AMOUNT));
            criteria.setProjection((Projection)projectionList);
            comparable2 = (Object[])criteria.uniqueResult();
            if (comparable2 != null && ((Comparable)comparable2).length > 0 && comparable2[0] instanceof Number) {
                salesDetailedReport.setGiftCertChangeCount(((Number)((Object)comparable2[0])).intValue());
            }
            if (comparable2 != null && ((Comparable)comparable2).length > 1 && comparable2[1] instanceof Number) {
                salesDetailedReport.setGiftCertChangeAmount(((Number)((Object)comparable2[1])).doubleValue());
            }
            object = salesDetailedReport;
            return object;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private double g(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.VISA.name()).ignoreCase());
        ReportService.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double h(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)PosTransactionDAO.createMasterCardSearchCriteria());
        ReportService.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double i(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)PosTransactionDAO.createAmexOrAmericanExpCardSearchCriteria());
        ReportService.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double j(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.DISCOVER.name()).ignoreCase());
        ReportService.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double k(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.VISA.name()).ignoreCase());
        ReportService.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    private double l(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(clazz);
        criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)PosTransactionDAO.createMasterCardSearchCriteria());
        ReportService.addMultiUserFilter(user, criteria, PosTransaction.PROP_USER_ID);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return this.a(criteria.uniqueResult());
    }

    public static void addMultiUserFilter(User user, Criteria criteria, String string) {
        if (user != null) {
            Disjunction disjunction = Restrictions.disjunction();
            disjunction.add((Criterion)Restrictions.eq((String)string, (Object)user.getId()));
            List<User> list = user.getLinkedUser();
            if (list != null) {
                for (User user2 : list) {
                    if (user2.getId().equals(user.getId())) continue;
                    disjunction.add((Criterion)Restrictions.eq((String)string, (Object)user2.getId()));
                }
            }
            criteria.add((Criterion)disjunction);
        }
    }

    public static SalesReportModel prepareItemSalesReportModel(List<TicketItem> list) {
        SalesReportModel salesReportModel = new SalesReportModel();
        if (list != null && list.size() > 0) {
            LinkedHashMap<String, ReportItem> linkedHashMap = new LinkedHashMap<String, ReportItem>();
            String string = null;
            for (TicketItem ticketItem : list) {
                String string2 = ticketItem.getMenuItemId();
                string = (string2 == null ? ticketItem.getName() : string2) + "-" + ticketItem.getUnitPrice() + "-" + ticketItem.getUnitName();
                ReportItem reportItem = (ReportItem)((HashMap)linkedHashMap).get(string);
                if (reportItem == null) {
                    reportItem = new ReportItem();
                    reportItem.setId(string);
                    reportItem.setPrice(ticketItem.getUnitPrice());
                    reportItem.setUnit(ticketItem.getUnitName());
                    reportItem.setCost(ticketItem.getUnitCost());
                    reportItem.setName(ticketItem.getName());
                    reportItem.setTaxRate(ticketItem.getTotalTaxRate());
                    reportItem.setGroupName(ticketItem.getGroupName());
                    reportItem.setBarcode(string2);
                    reportItem.setAdjustedPrice(ticketItem.getAdjustedUnitPrice());
                    linkedHashMap.put(string, reportItem);
                }
                reportItem.setQuantity(reportItem.getQuantity() + ticketItem.getQuantity());
                reportItem.setGrossTotal(reportItem.getGrossTotal() + ticketItem.getAdjustedTotalWithoutModifiers());
                reportItem.setDiscount(reportItem.getDiscount() + ticketItem.getAdjustedDiscountWithoutModifiers());
                reportItem.setTaxTotal(reportItem.getTaxTotal() + ticketItem.getAdjustedTaxWithoutModifiers());
                reportItem.setServiceCharge(reportItem.getServiceCharge() + ticketItem.getServiceCharge());
                double d = ticketItem.isTaxIncluded() != false ? ticketItem.getAdjustedTotalWithoutModifiers() - ticketItem.getAdjustedTaxWithoutModifiers() : ticketItem.getAdjustedSubtotalWithoutModifiers();
                reportItem.setNetTotal(reportItem.getNetTotal() + d);
            }
            salesReportModel.setItems(new ArrayList<ReportItem>(((HashMap)linkedHashMap).values()));
        }
        return salesReportModel;
    }

    public static Map<String, Integer> prepareTicketForDashBoard(List<Date> list) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (list != null && list.size() > 0) {
            int n = 0;
            for (Date date : list) {
                String string = DateUtil.formatAsDefaultMonthDate(date);
                if (hashMap.get(string) == null) {
                    n = 1;
                }
                if (hashMap.containsKey(string)) {
                    ++n;
                }
                hashMap.put(string, n);
            }
        }
        return hashMap;
    }

    public TaxExemptReport getTaxExemptReport(Date date, Date date2) throws Exception {
        TaxExemptReport taxExemptReport = new TaxExemptReport();
        try (Session session = TicketDAO.getInstance().createNewSession();){
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)Ticket.PROP_CLOSING_DATE, (Object)date2));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TAX_EXEMPT, (Object)true));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)false));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.property((String)Ticket.PROP_ID), Ticket.PROP_ID);
            projectionList.add((Projection)Projections.property((String)Ticket.PROP_CREATE_DATE), Ticket.PROP_CREATE_DATE);
            projectionList.add((Projection)Projections.property((String)Ticket.PROP_TOTAL_AMOUNT), Ticket.PROP_TOTAL_AMOUNT);
            projectionList.add((Projection)Projections.property((String)Ticket.PROP_EXTRA_PROPERTIES), Ticket.PROP_EXTRA_PROPERTIES);
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(Ticket.class));
            List list = criteria.list();
            for (Ticket ticket : list) {
                taxExemptReport.addTaxExemptTicket(ticket);
            }
            TaxExemptReport taxExemptReport2 = taxExemptReport;
            return taxExemptReport2;
        }
    }

    public DiscountReportDataModel createTicketDiscountDataList(Date date, Date date2) {
        DiscountReportDataModel discountReportDataModel = new DiscountReportDataModel();
        try (Session session = TicketItemDAO.getInstance().createNewSession();){
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.gt((String)Ticket.PROP_DISCOUNT_AMOUNT, (Object)0.0));
            criteria.addOrder(Order.asc((String)Ticket.PROP_CREATE_DATE));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.property((String)Ticket.PROP_ID), "ticketId");
            projectionList.add((Projection)Projections.property((String)Ticket.PROP_CREATE_DATE), "date");
            projectionList.add((Projection)Projections.property((String)Ticket.PROP_TOTAL_AMOUNT), "totalWithDiscount");
            projectionList.add((Projection)Projections.property((String)Ticket.PROP_DISCOUNTS_PROPERTY), "properties");
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(DiscountData.class));
            List list = criteria.list();
            Object object = list.iterator();
            while (object.hasNext()) {
                DiscountData discountData = (DiscountData)object.next();
                String string = discountData.getProperties();
                if (string.equals("[]")) {
                    object.remove();
                }
                discountData.setTicketDiscount(Boolean.TRUE);
            }
            discountReportDataModel.addDiscountDataList(list);
            object = discountReportDataModel;
            return object;
        }
    }

    public DiscountReportDataModel createItemDiscountDataList(Date date, Date date2) {
        DiscountReportDataModel discountReportDataModel = new DiscountReportDataModel();
        try (Session session = TicketItemDAO.getInstance().createNewSession();){
            Criteria criteria = session.createCriteria(TicketItem.class);
            criteria.createAlias("ticket", "t");
            criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_VOIDED), (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.ge((String)TicketItem.PROP_CREATE_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)TicketItem.PROP_CREATE_DATE, (Object)date2));
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.gt((String)TicketItem.PROP_DISCOUNT_AMOUNT, (Object)0.0));
            criteria.addOrder(Order.asc((String)TicketItem.PROP_CREATE_DATE));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.property((String)TicketItem.PROP_NAME), "itemName");
            projectionList.add((Projection)Projections.property((String)("t." + Ticket.PROP_ID)), "ticketId");
            projectionList.add((Projection)Projections.property((String)TicketItem.PROP_CREATE_DATE), "date");
            projectionList.add((Projection)Projections.property((String)TicketItem.PROP_TOTAL_AMOUNT), "totalWithDiscount");
            projectionList.add((Projection)Projections.property((String)TicketItem.PROP_DISCOUNTS_PROPERTY), "properties");
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(DiscountData.class));
            List list = criteria.list();
            discountReportDataModel.addDiscountDataList(list);
            DiscountReportDataModel discountReportDataModel2 = discountReportDataModel;
            return discountReportDataModel2;
        }
    }

    public PayoutReportDataModel findPayoutTransactions(String string, Date date, Date date2) {
        PayoutReportDataModel payoutReportDataModel = new PayoutReportDataModel();
        try (Session session = PosTransactionDAO.getInstance().createNewSession();){
            Criteria criteria = session.createCriteria(PayOutTransaction.class);
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)string));
            }
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_TRANSACTION_TIME), "date");
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_USER_ID), PosTransaction.PROP_USER_ID);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_RECEPIENT_ID), "recipientId");
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_REASON_ID), PosTransaction.PROP_REASON_ID);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_NOTE), PosTransaction.PROP_NOTE);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_CASH_DRAWER_ID), PosTransaction.PROP_CASH_DRAWER_ID);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_AMOUNT), PosTransaction.PROP_AMOUNT);
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(PayoutReportData.class));
            List list = criteria.list();
            HashMap<String, Comparable> hashMap = new HashMap<String, Comparable>();
            HashMap<String, Comparable> hashMap2 = new HashMap<String, Comparable>();
            HashMap<String, Comparable> hashMap3 = new HashMap<String, Comparable>();
            HashMap<Integer, Comparable> hashMap4 = new HashMap<Integer, Comparable>();
            if (list.size() > 0) {
                for (PayoutReportData payoutReportData : list) {
                    Comparable comparable;
                    if (payoutReportData.getReasonId() != null) {
                        comparable = (PayoutReason)hashMap.get(payoutReportData.getReasonId());
                        if (comparable == null) {
                            comparable = PayoutReasonDAO.getInstance().get(payoutReportData.getReasonId());
                            hashMap.put(((BasePayoutReason)comparable).getId(), comparable);
                        }
                        payoutReportData.setReason(((BasePayoutReason)comparable).getReason());
                    }
                    if (payoutReportData.getUserId() != null) {
                        comparable = (User)hashMap2.get(payoutReportData.getUserId());
                        if (comparable == null) {
                            comparable = UserDAO.getInstance().get(payoutReportData.getUserId());
                            hashMap2.put(((BaseUser)comparable).getId(), comparable);
                        }
                        payoutReportData.setUserName(((User)comparable).getFullName());
                    }
                    if (payoutReportData.getRecipientId() != null) {
                        comparable = (PayoutRecepient)hashMap3.get(payoutReportData.getRecipientId());
                        if (comparable == null) {
                            comparable = PayoutRecepientDAO.getInstance().get(payoutReportData.getRecipientId());
                            hashMap3.put(((BasePayoutRecepient)comparable).getId(), comparable);
                        }
                        payoutReportData.setRecipientName(((BasePayoutRecepient)comparable).getName());
                    }
                    if (payoutReportData.getTerminalId() == null) continue;
                    comparable = (Terminal)hashMap4.get(payoutReportData.getTerminalId());
                    if (comparable == null) {
                        comparable = TerminalDAO.getInstance().get(payoutReportData.getTerminalId());
                        hashMap4.put(((BaseTerminal)comparable).getId(), comparable);
                    }
                    payoutReportData.setTerminalName(((BaseTerminal)comparable).getName());
                }
            }
            payoutReportDataModel.addPayoutDataList(list);
            PayoutReportDataModel payoutReportDataModel2 = payoutReportDataModel;
            return payoutReportDataModel2;
        }
    }
}

