/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.model.OrderType;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.views.LoginView;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;

public class OrderTypeLoginButton
extends PosButton
implements ActionListener {
    private OrderType a;

    public OrderTypeLoginButton() {
        super("");
    }

    public OrderTypeLoginButton(OrderType orderType) {
        this.a = orderType;
        if (orderType != null) {
            ImageIcon imageIcon = orderType.getImage();
            Color color = orderType.getButtonColor();
            Color color2 = orderType.getTextColor();
            if (imageIcon != null) {
                if (orderType.isShowImageOnly().booleanValue()) {
                    this.setIcon(POSUtil.scaleImage(imageIcon, 60));
                } else {
                    this.setHorizontalTextPosition(0);
                    this.setVerticalTextPosition(3);
                    this.setIcon(POSUtil.scaleImage(imageIcon, 60));
                    if (color != null) {
                        this.setBackground(color);
                    }
                    if (color2 != null) {
                        this.setForeground(color2);
                    }
                    this.setText(orderType.name());
                }
            } else {
                this.setText(orderType.name());
                if (color != null) {
                    this.setBackground(color);
                }
                if (color2 != null) {
                    this.setForeground(color2);
                }
            }
        } else {
            this.setText(POSConstants.TAKE_OUT_BUTTON_TEXT);
        }
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TerminalConfig.setDefaultView(this.a.getId());
        LoginView.getInstance().doLogin();
    }
}

