/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.floorplan;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.Command;
import com.floreantpos.bo.ui.ModelBrowser;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.floorplan.ShopTableForm;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableModel;

public class ShopTableModelBrowser<E>
extends ModelBrowser {
    private BeanEditor a;
    private JButton b = new JButton(Messages.getString("ShopTableModelBrowser.0"));
    private JButton c = new JButton(Messages.getString("ShopTableModelBrowser.1"));

    public ShopTableModelBrowser(BeanEditor<E> beanEditor) {
        super(beanEditor, "[30%][70%,fill,grow]", "grow", "grow,span");
        this.a = beanEditor;
    }

    @Override
    public void init(TableModel tableModel) {
        super.init(tableModel);
        this.buttonPanel.add(this.b);
        this.b.addActionListener(this);
        this.b.setEnabled(false);
        this.buttonPanel.add(this.c);
        this.c.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Command command = Command.fromString(actionEvent.getActionCommand());
        int n = this.browserTable.getSelectedRow();
        try {
            switch (command) {
                case NEW: {
                    this.a.createNew();
                    this.a.setFieldsEnable(true);
                    this.btnNew.setEnabled(false);
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(true);
                    this.btnDelete.setEnabled(false);
                    this.btnCancel.setEnabled(true);
                    this.browserTable.clearSelection();
                    this.b.setEnabled(false);
                    break;
                }
                case EDIT: {
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ShopTableModelBrowser.2"));
                        break;
                    }
                    this.a.edit();
                    this.a.setFieldsEnable(true);
                    this.btnNew.setEnabled(false);
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(true);
                    this.btnDelete.setEnabled(false);
                    this.btnCancel.setEnabled(true);
                    this.b.setEnabled(false);
                    break;
                }
                case CANCEL: {
                    this.doCancelEditing();
                    break;
                }
                case SAVE: {
                    if (!this.a.save()) break;
                    this.a.setFieldsEnable(false);
                    this.btnNew.setEnabled(true);
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(false);
                    this.btnDelete.setEnabled(false);
                    this.btnCancel.setEnabled(false);
                    this.refreshTable();
                    this.a();
                    break;
                }
                case DELETE: {
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ShopTableModelBrowser.2"));
                        break;
                    }
                    if (!this.a.delete()) break;
                    this.a.setBean(null);
                    this.a.setFieldsEnable(false);
                    this.btnNew.setEnabled(true);
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(false);
                    this.btnDelete.setEnabled(false);
                    this.btnCancel.setEnabled(false);
                    this.refreshTable();
                    this.b.setEnabled(false);
                    break;
                }
            }
            this.handleAdditionaButtonActionIfApplicable(actionEvent);
            ShopTableForm shopTableForm = (ShopTableForm)this.a;
            if (actionEvent.getSource() == this.b) {
                if (n < 0) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ShopTableModelBrowser.2"));
                    return;
                }
                shopTableForm.setDuplicate(true);
                shopTableForm.createNew();
                shopTableForm.save();
                this.refreshTable();
                this.a();
                this.btnSave.setEnabled(false);
                this.btnCancel.setEnabled(false);
            } else if (actionEvent.getSource() == this.c) {
                int n2 = this.browserTable.getRowCount();
                if (n2 < 1) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ShopTableModelBrowser.3"));
                    return;
                }
                if (!shopTableForm.deleteAllTables()) {
                    return;
                }
                this.refreshTable();
                this.btnNew.setEnabled(true);
                this.btnEdit.setEnabled(false);
                this.btnSave.setEnabled(false);
                this.btnDelete.setEnabled(false);
                this.btnCancel.setEnabled(false);
                this.b.setEnabled(false);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("POSMessageDialog.0"), exception);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        this.b.setEnabled(true);
        this.c.setEnabled(true);
    }

    @Override
    public void doCancelEditing() {
        super.doCancelEditing();
        if (this.browserTable.getSelectedRow() != -1) {
            this.b.setEnabled(true);
        }
    }

    private void a() {
        ShopTableForm shopTableForm = (ShopTableForm)this.a;
        int n = this.a(this.browserTable.getModel(), shopTableForm.getNewTable());
        this.browserTable.setRowSelectionInterval(n, n);
    }

    private int a(TableModel tableModel, Object object) {
        for (int i = 0; i <= tableModel.getRowCount(); ++i) {
            if (!tableModel.getValueAt(i, 0).equals(object)) continue;
            return i;
        }
        return -1;
    }
}

