/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class MultiplierForm
extends BeanEditor<Multiplier> {
    private FixedLengthTextField a;
    private FixedLengthTextField b;
    private DoubleTextField c;
    private IntegerTextField d;
    private JButton e;
    private JButton f;

    public MultiplierForm() {
        this(new Multiplier());
    }

    public MultiplierForm(Multiplier multiplier) {
        this.a();
        this.setBean(multiplier);
    }

    private void a() {
        this.a = new FixedLengthTextField();
        this.a.setLength(20);
        this.c = new DoubleTextField();
        this.b = new FixedLengthTextField();
        this.b.setLength(20);
        this.c.setHorizontalAlignment(4);
        this.d = new IntegerTextField();
        JLabel jLabel = new JLabel(Messages.getString("MenuModifierForm.1"));
        JLabel jLabel2 = new JLabel(Messages.getString("MenuModifierForm.27"));
        this.e = new JButton("");
        this.e.setPreferredSize(new Dimension(140, 40));
        this.f = new JButton(Messages.getString("MenuModifierForm.29"));
        this.f.setPreferredSize(new Dimension(140, 40));
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuModifierForm.39"), MultiplierForm.this.e.getBackground());
                MultiplierForm.this.e.setBackground(color);
                MultiplierForm.this.f.setBackground(color);
            }
        });
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuModifierForm.40"), MultiplierForm.this.f.getForeground());
                MultiplierForm.this.f.setForeground(color);
            }
        });
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        jPanel.add(new JLabel(Messages.getString("NAME")));
        jPanel.add((Component)this.a, "grow,wrap");
        jPanel.add(new JLabel(Messages.getString("MultiplierForm.3")));
        jPanel.add((Component)this.b, "grow,wrap");
        jPanel.add(new JLabel(Messages.getString("MultiplierForm.5")));
        jPanel.add((Component)this.c, "grow,wrap");
        jPanel.add(new JLabel(Messages.getString("MultiplierForm.7")));
        jPanel.add((Component)this.d, "grow,wrap");
        jPanel.add(jLabel);
        jPanel.add((Component)this.e, "wrap");
        jPanel.add(jLabel2);
        jPanel.add((Component)this.f, "wrap");
        this.add(jPanel);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            MultiplierDAO multiplierDAO = new MultiplierDAO();
            Multiplier multiplier = (Multiplier)this.getBean();
            if (multiplierDAO.get(multiplier.getId()) == null) {
                multiplierDAO.save(multiplier);
            } else {
                multiplierDAO.update(multiplier);
            }
            return true;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage(), posException);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
        return false;
    }

    @Override
    protected void updateView() {
        Color color;
        Multiplier multiplier = (Multiplier)this.getBean();
        this.a.setText(multiplier.getId());
        this.b.setText(multiplier.getTicketPrefix());
        this.c.setText(NumberUtil.formatNumber(multiplier.getRate()));
        this.d.setText(String.valueOf(multiplier.getSortOrder()));
        this.a.setEnabled(multiplier.getId() == null);
        if (multiplier.getButtonColor() != null) {
            color = new Color(multiplier.getButtonColor());
            this.e.setBackground(color);
            this.f.setBackground(color);
        }
        if (multiplier.getTextColor() != null) {
            color = new Color(multiplier.getTextColor());
            this.f.setForeground(color);
        }
    }

    @Override
    protected boolean updateModel() {
        String string = this.a.getText();
        double d = this.c.getDoubleOrZero();
        Multiplier multiplier = (Multiplier)this.getBean();
        if (POSUtil.isBlankOrNull(string)) {
            MessageDialog.showError(POSConstants.NAME_REQUIRED);
            return false;
        }
        if (d < 0.0) {
            POSMessageDialog.showError(POSConstants.NEGATIVE_AMOUNT_NOT_ALLOWED);
            return false;
        }
        string = string.trim();
        GenericDAO.getInstance().checkDifferentObjectExists(multiplier.getId(), string, Multiplier.class, Multiplier.PROP_ID);
        multiplier.setId(string);
        multiplier.setDeleted(Boolean.FALSE);
        multiplier.setRate(d);
        multiplier.setTicketPrefix(this.b.getText());
        multiplier.setSortOrder(this.d.getInteger());
        multiplier.setButtonColor(this.e.getBackground().getRGB());
        multiplier.setTextColor(this.f.getForeground().getRGB());
        return true;
    }

    @Override
    public String getDisplayText() {
        Multiplier multiplier = (Multiplier)this.getBean();
        if (multiplier.getId() == null) {
            return Messages.getString("MultiplierForm.12");
        }
        return Messages.getString("MultiplierForm.13");
    }
}

