/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.SeatSelectionAction;
import com.floreantpos.actions.SendToKitchenAction;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.actions.TableSelectionAction;
import com.floreantpos.actions.VoidTicketAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.base.BaseSalesArea;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.UpdatableView;
import com.floreantpos.ui.dialog.MiscTicketItemDialog;
import com.floreantpos.ui.dialog.NotesDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.ReorderDialog;
import com.floreantpos.ui.dialog.SalesAreaSelectionDialog;
import com.floreantpos.ui.order.CourseOrganizeDialog;
import com.floreantpos.ui.views.order.CategoryView;
import com.floreantpos.ui.views.order.GroupView;
import com.floreantpos.ui.views.order.MenuItemView;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.TicketSummaryView;
import com.floreantpos.ui.views.order.TicketView;
import com.floreantpos.ui.views.order.ViewPanel;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.order.actions.OrderListener;
import com.floreantpos.ui.views.order.actions.TicketEditListener;
import com.floreantpos.ui.views.payment.PaymentListener;
import com.floreantpos.ui.views.payment.PaymentView;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class OrderView
extends ViewPanel
implements RefreshableView,
UpdatableView,
DataChangeListener,
OrderListener,
TicketEditListener,
PaymentListener {
    private HashMap<String, JComponent> a = new HashMap();
    public static final String VIEW_NAME = "ORDER_VIEW";
    private static OrderView b;
    private Ticket c;
    private CategoryView d = new CategoryView();
    private GroupView e = new GroupView();
    private MenuItemView f = new MenuItemView();
    private TicketView g = new TicketView();
    private TransparentPanel h = new TransparentPanel(new BorderLayout(5, 5));
    private JPanel i = new JPanel(new BorderLayout());
    private TicketSummaryView j;
    private OrderController k = new OrderController(this);
    private JPanel l = new JPanel((LayoutManager)new MigLayout("fill, ins 2, hidemode 3", "fill", "fill"));
    private PosButton m = new PosButton(POSConstants.HOLD_BUTTON_TEXT);
    private PosButton n = new PosButton(POSConstants.SAVE_BUTTON_TEXT);
    private PosButton o = new PosButton(POSConstants.SEND_TO_KITCHEN);
    private PosButton p = new PosButton(POSConstants.CANCEL_BUTTON_TEXT);
    private PosButton q = new PosButton(POSConstants.GUEST_NO_BUTTON_TEXT);
    private PosButton r = new PosButton(Messages.getString("OrderView.7"));
    private PosButton s = new PosButton(POSConstants.MISC_BUTTON_TEXT);
    private PosButton t = new PosButton(POSConstants.TABLE_NO_BUTTON_TEXT);
    private PosButton u = new PosButton(POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT);
    private PosButton v = new PosButton(Messages.getString("OrderView.1"));
    private PosButton w = new PosButton("<html><center>" + POSConstants.ORGANIZE_COURSE + "</center></html>");
    private PosButton x = new PosButton(Messages.getString("OrderView.25"));
    private PosButton y = new PosButton(Messages.getString("OrderView.11"));
    private PosButton z = new PosButton(Messages.getString("OrderView.2"));
    private PosButton A = new PosButton(Messages.getString("OrderView.5"));
    private SeatSelectionAction B = new SeatSelectionAction();
    private boolean C;
    private boolean D;
    private PaymentView E;

    private OrderView() {
        this.a();
        this.g.addOrderListener(this);
        this.g.getTicketViewerTable().addTicketUpdateListener(this);
        this.k.addTicketUpdateListener(this);
    }

    public void addView(String string, JComponent jComponent) {
        JComponent jComponent2 = this.a.get(string);
        if (jComponent2 != null) {
            return;
        }
        this.h.add((Component)jComponent, string);
    }

    private void a() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout(2, 1));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.g);
        this.i.add(jPanel);
        this.h.setOpaque(false);
        this.h.setBorder(null);
        this.h.add((Component)this.e, "North");
        this.h.add(this.f);
        this.b();
        this.showView("VIEW_EMPTY");
    }

    private void b() {
        this.A.addActionListener(actionEvent -> this.doAddSalesArea());
        this.n.addActionListener(actionEvent -> this.l());
        this.p.addActionListener(actionEvent -> this.n());
        this.o.addActionListener(actionEvent -> this.k());
        this.v.addActionListener(actionEvent -> this.j());
        this.w.addActionListener(actionEvent -> this.d());
        this.u.addActionListener(actionEvent -> this.doAddEditCustomer());
        this.x.addActionListener(actionEvent -> this.c());
        this.s.addActionListener(actionEvent -> this.doInsertMisc(actionEvent));
        this.q.addActionListener(actionEvent -> this.btnCustomerNumberActionPerformed());
        this.y.addActionListener(actionEvent -> this.doTokenNumberInputActionPerformed());
        this.B.setSource(this.r);
        this.r.setAction(this.B);
        this.t.addActionListener(new TableSelectionAction(this));
        this.m.addActionListener(actionEvent -> this.doHoldOrder());
        this.z.addActionListener(actionEvent -> this.doShowDeliveryDialog());
        this.l.add(this.u);
        this.l.add(this.x);
        this.l.add(this.z);
        this.l.add(this.t);
        this.l.add(this.y);
        this.l.add(this.q);
        this.l.add(this.r);
        this.l.add(this.A);
        this.l.add(this.w);
        this.l.add(this.s);
        this.l.add(this.m);
        this.l.add(this.o);
        this.l.add(this.v);
        this.l.add(this.p);
        this.l.add(this.n);
        this.z.setVisible(false);
    }

    private void c() {
        String string = this.c.getNote();
        NotesDialog notesDialog = new NotesDialog();
        notesDialog.setTitle(VersionInfo.getAppName());
        notesDialog.setCaption(Messages.getString("OrderView.104"));
        notesDialog.setNote(string);
        notesDialog.setSize(PosUIManager.getSize(900, 500));
        notesDialog.open();
        if (notesDialog.isCanceled()) {
            return;
        }
        string = notesDialog.getNote();
        if (notesDialog.getNote() != null) {
            this.c.setNote(string);
        }
    }

    private void d() {
        try {
            if (DataProvider.get().getCourses().isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("OrderView.15"));
                return;
            }
            if (this.c.getId() != null) {
                OrderController.saveOrder(this.c);
            }
            CourseOrganizeDialog courseOrganizeDialog = new CourseOrganizeDialog(this.c);
            courseOrganizeDialog.openFullScreen();
            if (courseOrganizeDialog.isCanceled()) {
                this.refresh();
                return;
            }
            OrderView.getInstance().setCurrentTicket(courseOrganizeDialog.getTicket());
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    protected void doShowDeliveryDialog() {
        try {
            Customer customer = CustomerDAO.getInstance().findById(this.c.getCustomerId());
            OrderServiceFactory.getOrderService().showDeliveryInfo(this.c, this.c.getOrderType(), customer);
            if (this.g != null) {
                this.g.updateView();
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    protected void doAddSalesArea() {
        try {
            SalesAreaSelectionDialog salesAreaSelectionDialog = new SalesAreaSelectionDialog();
            salesAreaSelectionDialog.open();
            if (salesAreaSelectionDialog.isCanceled()) {
                return;
            }
            SalesArea salesArea = salesAreaSelectionDialog.getSelectedSalesArea();
            this.setFocusable(true);
            this.c.setSalesArea(salesArea);
            this.c.setSalesAreaId(salesArea.getId());
            this.A.setText("<html><center>" + POSConstants.SALES_AREA + "<br/>" + salesArea.getName() + "</center></html>");
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    protected void btnCustomerNumberActionPerformed() {
        try {
            Ticket ticket = this.c;
            int n = ticket.getNumberOfGuests();
            NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2(5);
            numberSelectionDialog2.setCaption(POSConstants.NUMBER_OF_GUESTS);
            numberSelectionDialog2.setValue(n);
            numberSelectionDialog2.pack();
            numberSelectionDialog2.open();
            if (numberSelectionDialog2.isCanceled()) {
                return;
            }
            n = (int)numberSelectionDialog2.getValue();
            if (n == 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.GUEST_NUMBER_CANNOT_BE_0);
                return;
            }
            ticket.setNumberOfGuests(n);
            this.updateView();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    protected void doTokenNumberInputActionPerformed() {
        try {
            Ticket ticket = this.c;
            int n = ticket.getTokenNo();
            NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2(5);
            numberSelectionDialog2.setCaption(Messages.getString("EnterTokenNo"));
            numberSelectionDialog2.setControlButtonsVisible(false);
            numberSelectionDialog2.setValue(n);
            numberSelectionDialog2.pack();
            numberSelectionDialog2.open();
            if (numberSelectionDialog2.isCanceled()) {
                return;
            }
            n = (int)numberSelectionDialog2.getValue();
            ticket.setTokenNo(n);
            this.updateView();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    protected void doInsertMisc(ActionEvent actionEvent) {
        try {
            MiscTicketItemDialog miscTicketItemDialog = new MiscTicketItemDialog();
            miscTicketItemDialog.setOrderType(this.c.getOrderType());
            miscTicketItemDialog.pack();
            miscTicketItemDialog.open();
            if (!miscTicketItemDialog.isCanceled()) {
                TicketItem ticketItem = miscTicketItemDialog.getTicketItem();
                ticketItem.setTicket(this.c);
                ticketItem.calculatePrice();
                this.g.addTicketItem(ticketItem);
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAddEditCustomer() {
        try {
            DataProvider.get().setTicketToBeCreated(this.getCurrentTicket());
            CustomerSelectorDialog customerSelectorDialog = CustomerSelectorFactory.createCustomerSelectorDialog(this.c.getOrderType());
            customerSelectorDialog.setCreateNewTicket(false);
            if (this.c != null) {
                customerSelectorDialog.setTicket(this.c);
            }
            customerSelectorDialog.openUndecoratedFullScreen();
            if (!customerSelectorDialog.isCanceled()) {
                Customer customer = customerSelectorDialog.getSelectedCustomer();
                this.c.setCustomer(customer);
                if (customer != null) {
                    String string = "<html><center>" + POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT + "<br>" + customer.getName() + "</center></html>";
                    this.u.setText(string);
                }
                this.g.updateView();
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
        finally {
            DataProvider.get().setTicketToBeCreated(null);
        }
    }

    protected void addDiscount() {
        try {
            ITicketItem iTicketItem = this.g.getTicketViewerTable().getSelected();
            if (!(iTicketItem instanceof TicketItem)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TicketView.20"));
                return;
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    @Override
    public void updateView() {
        Terminal terminal = Application.getInstance().getTerminal();
        this.s.setVisible(!DataProvider.get().getStore().getBooleanProperty("hide_misc_button.in_order", false));
        if (this.c != null) {
            Object object;
            Object object2;
            OrderType orderType = this.c.getOrderType();
            this.a(orderType);
            if (orderType.isPrepaid().booleanValue()) {
                this.n.setVisible(false);
            } else {
                this.n.setVisible(true);
            }
            if (!orderType.isShouldPrintToKitchen().booleanValue()) {
                this.o.setEnabled(false);
            } else {
                this.o.setEnabled(true);
            }
            if (!orderType.isAllowSeatBasedOrder().booleanValue()) {
                this.r.setVisible(false);
            } else {
                this.r.setVisible(true);
                object2 = null;
                object = this.B.getLastSeat(this.c);
                if (object instanceof Integer) {
                    object2 = (Integer)object;
                    this.r.putClientProperty("SEAT_NO", object2);
                } else if (object instanceof TicketItemSeat) {
                    TicketItemSeat ticketItemSeat = (TicketItemSeat)this.B.getLastSeat(this.c);
                    this.r.putClientProperty("SEAT_NO", ticketItemSeat);
                }
            }
            if (!orderType.isShowGuestSelection().booleanValue()) {
                this.q.setVisible(false);
            } else {
                this.q.setVisible(true);
                this.q.setText(Messages.getString("OrderView.27") + ": " + String.valueOf(this.c.getNumberOfGuests()));
            }
            if (!orderType.isShowTableSelection().booleanValue()) {
                this.t.setVisible(false);
            } else {
                this.t.setVisible(true);
                this.t.setText("<html><center>" + Messages.getString("OrderView.23") + ": " + this.c.getTableNameOrNumberDisplay() + "</center><html/>");
            }
            if (orderType.isEnableReorder().booleanValue()) {
                this.v.setVisible(true);
            } else {
                this.v.setVisible(false);
            }
            this.w.setVisible(orderType.isEnableCourse());
            object2 = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
            if (object2 != null && orderType.isDelivery().booleanValue() && orderType.isRequiredCustomerData().booleanValue()) {
                this.z.setVisible(true);
            }
            if (orderType.isRetailOrder().booleanValue()) {
                this.g.setTicket(this.c);
                this.j.setTicket(this.c);
                if (this.E != null) {
                    this.E.setTicket(this.c);
                }
                this.e();
            }
            if (this.c.getSalesArea() != null) {
                object = this.c.getSalesArea().getName();
                this.A.setText("<html><center>" + Messages.getString("OrderView.38") + "<br>" + (String)object + "</center><html/>");
            } else if (this.c.getId() != null) {
                this.A.setText(Messages.getString("OrderView.41"));
            } else {
                object = terminal.getSalesArea();
                if (object != null) {
                    this.A.setText("<html><center>" + Messages.getString("OrderView.42") + "<br>" + ((BaseSalesArea)object).getName() + "</center><html/>");
                } else {
                    this.A.setText(Messages.getString("OrderView.41"));
                }
                if (terminal.isFixedSalesArea().booleanValue()) {
                    this.A.setEnabled(false);
                } else {
                    this.A.setEnabled(true);
                }
            }
            if (this.c.getCustomer() != null) {
                this.u.setText("<html><center>" + POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT + "<br>" + this.c.getCustomer().getName());
            } else {
                this.u.setText(POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT);
            }
        }
    }

    private void a(OrderType orderType) {
        boolean bl = POSUtil.getBoolean(orderType.getProperty("TokenManualInput"));
        this.y.setVisible(bl);
        if (bl) {
            this.y.setText("Token: " + String.valueOf(this.c.getTokenNo()));
        }
        this.y.setEnabled(this.c.getId() == null);
    }

    public void showView(String string) {
    }

    public CategoryView getCategoryView() {
        return this.d;
    }

    public void setCategoryView(CategoryView categoryView) {
        this.d = categoryView;
    }

    public GroupView getGroupView() {
        return this.e;
    }

    public void setGroupView(GroupView groupView) {
        this.e = groupView;
    }

    public MenuItemView getItemView() {
        return this.f;
    }

    public void setItemView(MenuItemView menuItemView) {
        this.f = menuItemView;
    }

    public TicketView getTicketView() {
        return this.g;
    }

    public void setTicketView(TicketView ticketView) {
        this.g = ticketView;
    }

    public OrderController getOrderController() {
        return this.k;
    }

    public Ticket getCurrentTicket() {
        return this.c;
    }

    private void b(OrderType orderType) {
        if (orderType.isRetailOrder().booleanValue()) {
            this.g();
        } else {
            this.h();
        }
        this.revalidate();
        this.repaint();
    }

    private void e() {
        this.n.setVisible(false);
        this.p.setVisible(false);
        this.z.setVisible(false);
        this.q.setVisible(false);
        this.v.setVisible(false);
        this.A.setVisible(false);
        this.r.setVisible(false);
        this.t.setVisible(false);
        this.o.setVisible(false);
        this.m.setVisible(false);
    }

    private void f() {
        this.n.setVisible(true);
        this.p.setVisible(true);
        this.q.setVisible(true);
        this.m.setVisible(true);
        this.s.setVisible(true);
        this.A.setVisible(true);
        this.r.setVisible(true);
        this.o.setVisible(true);
        this.t.setVisible(true);
    }

    private void g() {
        this.removeAll();
        if (this.j == null) {
            this.j = new TicketSummaryView(this);
            this.g.getParent().add((Component)this.j, "South");
        }
        if (this.E == null) {
            SettleTicketProcessor settleTicketProcessor = new SettleTicketProcessor(null, this);
            settleTicketProcessor.addPaymentListener(this);
            this.E = new PaymentView(settleTicketProcessor, this);
        }
        this.g.showSettleButton(false);
        this.j.setVisible(true);
        this.j.setTicket(this.g.getTicket());
        this.j.setPaymentView(this.E);
        this.i.add((Component)this.l, "South");
        this.add((Component)this.i, "Center");
        this.add((Component)this.E, "East");
    }

    private void h() {
        this.removeAll();
        this.f();
        if (this.j != null) {
            this.j.setVisible(false);
        }
        this.g.showSettleButton(true);
        boolean bl = DataProvider.get().getStore().getBooleanProperty("order_view.ticket_on_right", false);
        if (!bl) {
            this.add((Component)this.d, "East");
            this.add((Component)this.i, "West");
        } else {
            this.add((Component)this.d, "West");
            this.add((Component)this.i, "East");
        }
        this.add((Component)this.h, "Center");
        this.add((Component)this.l, "South");
    }

    public void setCurrentTicket(Ticket ticket) {
        if (this.c != null && ticket != null) {
            OrderType orderType = this.c.getOrderType();
            OrderType orderType2 = ticket.getOrderType();
            if (orderType2 == null) {
                throw new PosException(Messages.getString("OrderView.55"));
            }
            if (orderType != null && !orderType.equals(orderType2)) {
                this.c = ticket;
                this.b(orderType2);
            }
        } else if (this.c == null && ticket != null) {
            OrderType orderType = ticket.getOrderType();
            if (orderType == null) {
                throw new PosException(Messages.getString("OrderView.55"));
            }
            this.b(orderType);
        }
        this.c = ticket;
        this.g.setTicket(ticket);
        if (this.E != null) {
            this.E.setTicket(ticket);
        }
        this.updateView();
        this.k.fireTicketEditingStart(ticket);
    }

    public static synchronized OrderView getInstance() {
        if (b == null) {
            b = new OrderView();
        }
        return b;
    }

    public void resetView() {
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.i();
            this.g.setVisible(true);
        } else {
            this.g.setVisible(false);
            if (TerminalConfig.isActiveCustomerDisplay()) {
                DrawerUtil.setCustomerDisplayMessage(TerminalConfig.getCustomerDisplayPort(), Messages.getString("OrderView.48"));
            }
        }
        this.setReturnMode(false);
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    private void i() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    OrderView.this.d.initialize();
                }
                catch (Throwable throwable) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
    }

    public void doHoldOrder() {
        try {
            this.doHoldOrder(true);
            ActionHistoryDAO.getInstance().performActionHistorySaveOperation(this.c, false);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void doHoldOrder(boolean bl) {
        this.c.validateTicketBeforeSave();
        this.g.doHoldOrder(bl);
        this.g.setAllowToLogOut(true);
        this.k.fireTicketEditingFinish(this.c);
    }

    private void j() {
        try {
            List<TicketItem> list;
            Ticket ticket = this.g.getTicket();
            Ticket ticket2 = Ticket.clone(ticket);
            List<TicketItem> list2 = ticket2.getTicketItems();
            if (list2 == null || list2.size() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("OrderView.49"));
                return;
            }
            Object object = list2.iterator();
            while (object.hasNext()) {
                list = object.next();
                if (((BaseTicketItem)((Object)list)).isPrintedToKitchen().booleanValue()) continue;
                object.remove();
            }
            if (ticket2.getTicketItems().size() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("OrderView.49"));
                return;
            }
            object = new ReorderDialog(ticket2);
            ((Dialog)object).setTitle(Messages.getString("OrderView.51"));
            ((JDialog)object).setDefaultCloseOperation(2);
            ((Dialog)object).setResizable(false);
            ((POSDialog)object).openFullScreen();
            if (!((POSDialog)object).isCanceled()) {
                list = ((ReorderDialog)object).getTicketItems();
                if (list == null) {
                    return;
                }
                for (TicketItem ticketItem : list) {
                    this.g.addTicketItem(ticketItem);
                }
                OrderController.saveOrder(this.g.getTicket());
                this.g.sendTicketToKitchen();
                this.g.getTicketViewerTable().repaint();
                POSMessageDialog.showMessage(Messages.getString("OrderView.8"));
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void k() {
        try {
            Ticket ticket = this.getCurrentTicket();
            boolean bl = ticket.isKitchenPrintable();
            if (!bl) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TicketView.333"));
                return;
            }
            ticket.validateTicketBeforeSave();
            OrderController.saveOrder(ticket);
            new SendToKitchenAction(this).actionPerformed(null);
            this.g.updateTicketTitle();
            this.g.getTicketViewerTable().updateView();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public Object getSelectedSeatNumber() {
        Ticket ticket = this.getCurrentTicket();
        if (ticket.getOrderType() != null && ticket.getOrderType().isAllowSeatBasedOrder().booleanValue()) {
            return this.B.getSelectedSeatNumber();
        }
        return null;
    }

    public boolean updateSeat(TicketItem ticketItem) {
        return this.B.updateSeatNumber(ticketItem);
    }

    public boolean is_86Mode() {
        return this.C;
    }

    public void set_86Mode(boolean bl) {
        this.C = bl;
    }

    @Override
    public void paymentDone() {
        try {
            this.g.doFinishOrder();
            this.updateView();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), OrderView.getInstance());
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    @Override
    public void paymentCanceled() {
        if (this.c == null) {
            return;
        }
        if (StringUtils.isNotEmpty((String)this.c.getId()) && this.c.getDueAmount() > 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("OrderView.53"));
            return;
        }
        this.c.getTicketItems().clear();
        this.g.doCancelOrder();
        this.updateView();
    }

    @Override
    public void paymentDataChanged() {
        this.updateView();
    }

    public PaymentView getPaymentView() {
        return this.E;
    }

    @Override
    public void itemAdded(Ticket ticket, ITicketItem iTicketItem) {
        if (ticket.getOrderType().isRetailOrder().booleanValue()) {
            this.updateView();
            this.E.updateView();
        }
    }

    @Override
    public void itemRemoved(ITicketItem iTicketItem) {
        if (this.c.getOrderType().isRetailOrder().booleanValue()) {
            this.updateView();
            this.E.updateView();
        }
    }

    public boolean isReturnMode() {
        return this.D;
    }

    public void setReturnMode(boolean bl) {
        this.D = bl;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void dataAdded(Object object) {
    }

    @Override
    public void dataChanged(Object object) {
    }

    @Override
    public void dataRemoved(Object object) {
    }

    @Override
    public Object getSelectedData() {
        return this.getCurrentTicket();
    }

    @Override
    public void dataSetUpdated() {
    }

    @Override
    public void dataChangeCanceled(Object object) {
    }

    private void l() {
        try {
            this.c.validateTicketBeforeSave();
            this.c.setShouldUpdateStock(true);
            this.g.doFinishOrder();
            this.k.fireTicketEditingFinish(this.c);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), OrderView.getInstance());
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
        finally {
            this.c.setShouldUpdateStock(false);
        }
    }

    @Override
    public void payOrderSelected(Ticket ticket) {
        this.m();
    }

    private void m() {
        try {
            this.c.validateTicketBeforeSave();
            Ticket ticket = Ticket.clone(this.c);
            SettleTicketAction settleTicketAction = new SettleTicketAction(ticket);
            if (settleTicketAction.performSettle()) {
                RootView.getInstance().showDefaultView();
            } else {
                Ticket ticket2 = settleTicketAction.getTicket();
                if (ticket2.getId() != null) {
                    Ticket ticket3 = TicketDAO.getInstance().loadFullTicket(ticket2.getId());
                    if (ticket3.getVersion() != this.c.getVersion()) {
                        this.setCurrentTicket(ticket3);
                    } else {
                        this.setCurrentTicket(this.c);
                    }
                } else {
                    this.setCurrentTicket(this.c);
                }
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void n() {
        if (this.g.isCancelable()) {
            this.g.doCancelOrder();
            this.k.fireTicketEditingFinish(this.c);
            return;
        }
        int n = POSMessageDialog.showYesNoQuestionDialog(null, Messages.getString("OrderView.4"), Messages.getString("CONFIRM"));
        if (n != 0) {
            return;
        }
        VoidTicketAction voidTicketAction = new VoidTicketAction(this.c);
        voidTicketAction.execute();
        if (this.c.isVoided().booleanValue()) {
            this.g.doCancelOrder();
            this.g.setAllowToLogOut(true);
        }
        this.k.fireTicketEditingFinish(this.c);
    }
}

