/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.actions.SplitTicketAction;
import com.floreantpos.actions.VoidTicketAction;
import com.floreantpos.config.CardConfig;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.extension.ExternalPaymentGatewayPlugin;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.extension.InginicoPlugin;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.services.PostPaymentProcessor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.MultiCurrencyTenderDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.dialog.RefundDialog;
import com.floreantpos.ui.dialog.TicketDiscountSelectionDialog;
import com.floreantpos.ui.dialog.TicketItemDiscountSelectionDialog;
import com.floreantpos.ui.dialog.TransactionCompletionDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.payment.AuthorizationCodeDialog;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.ui.views.payment.CreditCardInputListener;
import com.floreantpos.ui.views.payment.CustomPaymentSelectionDialog;
import com.floreantpos.ui.views.payment.GiftCardInputListener;
import com.floreantpos.ui.views.payment.GratuityInputDialog;
import com.floreantpos.ui.views.payment.ManualCardEntryDialog;
import com.floreantpos.ui.views.payment.PaymentListener;
import com.floreantpos.ui.views.payment.PaymentReferenceEntryDialog;
import com.floreantpos.ui.views.payment.SwipeCardDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.HeadlessException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingWorker;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class SettleTicketProcessor {
    private Vector<PaymentListener> a = new Vector(3);
    private Ticket b;
    private double c;
    private PaymentType d;
    private User e;
    private RefreshableView f;

    public SettleTicketProcessor(User user, RefreshableView refreshableView) {
        this.e = user;
        this.f = refreshableView;
    }

    public Ticket getTicket() {
        return this.b;
    }

    public void setTicket(Ticket ticket) {
        this.b = ticket;
    }

    public double getTenderAmount() {
        return this.c;
    }

    public void setTenderAmount(double d) {
        this.c = d;
    }

    public void addPaymentListener(PaymentListener paymentListener) {
        this.a.add(paymentListener);
    }

    public void removePaymentListener(PaymentListener paymentListener) {
        this.a.remove(paymentListener);
    }

    public void doSettle(PaymentType paymentType, double d) throws Exception {
        this.doSettle(paymentType, d, null);
    }

    public void doSettle(PaymentType paymentType, double d, List<MultiCurrencyTenderDialog.PaymentByCurrency> list) throws Exception {
        this.c = d;
        if (this.b == null) {
            return;
        }
        if (!POSUtil.checkDrawerAssignment()) {
            return;
        }
        if (!this.a()) {
            return;
        }
        this.d = paymentType;
        switch (paymentType) {
            case CASH: {
                DrawerUtil.kickDrawer();
                this.a(paymentType, list);
                break;
            }
            case CUSTOM_PAYMENT: {
                CustomPaymentSelectionDialog customPaymentSelectionDialog = new CustomPaymentSelectionDialog();
                customPaymentSelectionDialog.setTitle(Messages.getString("SettleTicketDialog.8"));
                customPaymentSelectionDialog.pack();
                customPaymentSelectionDialog.open();
                if (customPaymentSelectionDialog.isCanceled()) {
                    return;
                }
                PosTransaction posTransaction = paymentType.createTransaction();
                CustomPaymentTransaction customPaymentTransaction = (CustomPaymentTransaction)posTransaction;
                customPaymentTransaction.setCustomPaymentFieldName(customPaymentSelectionDialog.getPaymentFieldName());
                customPaymentTransaction.setCustomPaymentName(customPaymentSelectionDialog.getPaymentName());
                customPaymentTransaction.setCustomPaymentRef(customPaymentSelectionDialog.getPaymentRef());
                this.doPayByCustomPayment(customPaymentTransaction);
                break;
            }
            case CREDIT_CARD: 
            case DEBIT_CARD: {
                this.b(d);
                break;
            }
            case GIFT_CERTIFICATE: {
                this.a(d);
                break;
            }
            case MEMBER_ACCOUNT: {
                CustomerAccountTransaction customerAccountTransaction = (CustomerAccountTransaction)paymentType.createTransaction();
                customerAccountTransaction.setTicket(this.b);
                customerAccountTransaction.setCaptured(true);
                this.setTransactionAmounts(customerAccountTransaction);
                customerAccountTransaction.setCustomerId(this.b.getCustomerId());
                this.settleTicket(customerAccountTransaction);
                break;
            }
        }
    }

    private void a(final PaymentType paymentType, final List<MultiCurrencyTenderDialog.PaymentByCurrency> list) {
        final BusyDialog busyDialog = new BusyDialog();
        busyDialog.setCaption(Messages.getString("SettleTicketProcessor.24"));
        SwingWorker<Double, Void> swingWorker = new SwingWorker<Double, Void>(){
            private PosTransaction e;

            @Override
            protected Double doInBackground() throws Exception {
                Double d = SettleTicketProcessor.this.b.getDueAmount();
                this.e = paymentType.createTransaction();
                this.e.setTicket(SettleTicketProcessor.this.b);
                SettleTicketProcessor.this.setTransactionAmounts(this.e, list);
                SettleTicketProcessor.this.settleTicket(this.e, null, true, false, list);
                return d;
            }

            @Override
            protected void done() {
                try {
                    Double d = (Double)this.get();
                    busyDialog.dispose();
                    SettleTicketProcessor.this.doAfterSettleTask(this.e, d, true);
                }
                catch (Exception exception) {
                    busyDialog.dispose();
                    Throwable throwable = exception.getCause();
                    if (throwable instanceof PosException) {
                        POSMessageDialog.showError(throwable.getMessage());
                    } else if (throwable instanceof StaleStateException) {
                        POSMessageDialog.showError(Messages.getString("SplitedTicketSelectionDialog.0"));
                        SettleTicketProcessor.this.f.refresh();
                    } else {
                        POSMessageDialog.showError(throwable.getMessage(), throwable);
                    }
                }
                finally {
                    busyDialog.dispose();
                }
            }
        };
        swingWorker.execute();
        busyDialog.setVisible(true);
    }

    private void a(final PaymentGatewayPlugin paymentGatewayPlugin) {
        final BusyDialog busyDialog = new BusyDialog();
        busyDialog.setCaption(Messages.getString("SettleTicketProcessor.25"));
        SwingWorker<Double, Void> swingWorker = new SwingWorker<Double, Void>(){
            private PosTransaction d;

            @Override
            protected Double doInBackground() throws Exception {
                Double d = SettleTicketProcessor.this.b.getDueAmount();
                this.d = SettleTicketProcessor.this.d.createTransaction();
                this.d.setTicket(SettleTicketProcessor.this.b);
                this.d.setCaptured(false);
                this.d.setCardMerchantGateway(paymentGatewayPlugin.getProductName());
                SettleTicketProcessor.this.setTransactionAmounts(this.d);
                if (SettleTicketProcessor.this.b.getOrderType().isPreAuthCreditCard().booleanValue()) {
                    paymentGatewayPlugin.getProcessor().preAuth(this.d);
                } else {
                    paymentGatewayPlugin.getProcessor().chargeAmount(this.d);
                }
                SettleTicketProcessor.this.settleTicket(this.d, null, true, false);
                return d;
            }

            @Override
            protected void done() {
                try {
                    Double d = (Double)this.get();
                    busyDialog.dispose();
                    SettleTicketProcessor.this.doAfterSettleTask(this.d, d, true);
                }
                catch (Exception exception) {
                    busyDialog.dispose();
                    Throwable throwable = exception.getCause();
                    if (throwable instanceof PosException) {
                        POSMessageDialog.showError(throwable.getMessage());
                    } else if (throwable instanceof StaleStateException) {
                        POSMessageDialog.showError(Messages.getString("SplitedTicketSelectionDialog.0"));
                        SettleTicketProcessor.this.f.refresh();
                    } else {
                        POSMessageDialog.showError(throwable.getMessage(), throwable);
                    }
                }
                finally {
                    busyDialog.dispose();
                }
            }
        };
        swingWorker.execute();
        busyDialog.setVisible(true);
    }

    public void payByCustomPayment(CustomPayment customPayment, double d) {
        this.c = d;
        CustomPaymentTransaction customPaymentTransaction = new CustomPaymentTransaction();
        customPaymentTransaction.setCustomPaymentFieldName(customPayment.getRefNumberFieldName());
        customPaymentTransaction.setCustomPaymentName(customPayment.getName());
        if (customPayment.isRequiredRefNumber().booleanValue() && StringUtils.isEmpty((String)customPaymentTransaction.getCustomPaymentRef())) {
            PaymentReferenceEntryDialog paymentReferenceEntryDialog = new PaymentReferenceEntryDialog(customPayment);
            paymentReferenceEntryDialog.pack();
            paymentReferenceEntryDialog.open();
            if (paymentReferenceEntryDialog.isCanceled()) {
                return;
            }
            customPaymentTransaction.setCustomPaymentRef(paymentReferenceEntryDialog.getPaymentRef());
        }
        this.doPayByCustomPayment(customPaymentTransaction);
    }

    public void doPayByCustomPayment(CustomPaymentTransaction customPaymentTransaction) {
        customPaymentTransaction.setPaymentType(PaymentType.CUSTOM_PAYMENT);
        customPaymentTransaction.setTicket(this.b);
        customPaymentTransaction.setCaptured(true);
        this.setTransactionAmounts(customPaymentTransaction);
        this.settleTicket(customPaymentTransaction);
    }

    private void a(double d) throws Exception {
        try {
            GiftCardPaymentPlugin giftCardPaymentPlugin = GiftCardConfig.getPaymentGateway();
            if (giftCardPaymentPlugin == null) {
                throw new PosException(Messages.getString("SettleTicketProcessor.0"));
            }
            GiftCardInputListener giftCardInputListener = new GiftCardInputListener(this);
            SwipeCardDialog swipeCardDialog = new SwipeCardDialog(giftCardInputListener, this.d);
            swipeCardDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private boolean a() {
        if (!DataProvider.get().getCurrentTerminal().isConfirmTicketSettlement().booleanValue()) {
            return true;
        }
        String string = String.format(Messages.getString("SettleTicketProcessor.17"), CurrencyUtil.getCurrencySymbol(), NumberUtil.trimDecilamIfNotNeeded(this.c));
        int n = POSMessageDialog.showYesNoQuestionDialog(string);
        return n == 0;
    }

    public void doSettleBarTabTicket(Ticket ticket, User user) {
        try {
            String string = "Do you want to settle ticket?";
            int n = POSMessageDialog.showYesNoQuestionDialog(null, string, Messages.getString("NewBarTabAction.4"));
            if (n != 0) {
                return;
            }
            for (PosTransaction posTransaction : ticket.getTransactions()) {
                posTransaction.setAmount(ticket.getDueAmount());
                posTransaction.setTenderAmount(ticket.getDueAmount());
                posTransaction.setAuthorizable(true);
                this.settleTicket(posTransaction);
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.f);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public void settleTicket(PosTransaction posTransaction) {
        try {
            this.settleTicket(posTransaction, null, true, true);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.f);
        }
        catch (UnknownHostException unknownHostException) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SettleTicketDialog.12"));
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public void settleTicket(PosTransaction posTransaction, PostPaymentProcessor postPaymentProcessor) {
        try {
            this.settleTicket(posTransaction, postPaymentProcessor, true, true);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.f);
        }
        catch (UnknownHostException unknownHostException) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SettleTicketDialog.12"));
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public void settleTicket(PosTransaction posTransaction, PostPaymentProcessor postPaymentProcessor, boolean bl, boolean bl2) throws Exception {
        this.settleTicket(posTransaction, postPaymentProcessor, bl, bl2, null);
    }

    public void settleTicket(PosTransaction posTransaction, PostPaymentProcessor postPaymentProcessor, boolean bl, boolean bl2, List<MultiCurrencyTenderDialog.PaymentByCurrency> list) throws Exception {
        double d = this.b.getDueAmount();
        PosTransactionService posTransactionService = PosTransactionService.getInstance();
        if (postPaymentProcessor == null) {
            posTransactionService.settleTicket(this.b, posTransaction, this.getCurrentUser(), null, list);
        } else {
            posTransactionService.settleTicket(this.b, posTransaction, this.getCurrentUser(), postPaymentProcessor, list);
        }
        if (bl) {
            this.a(this.b, posTransaction);
        }
        if (bl2) {
            this.doAfterSettleTask(posTransaction, d, true);
        }
    }

    public void doAfterSettleTask(PosTransaction posTransaction, double d, boolean bl) throws HeadlessException {
        int n;
        double d2;
        SettleTicketProcessor.showTransactionCompleteMsg(d, posTransaction.getTenderAmount(), this.b, posTransaction);
        if (this.b.isCoreAmountPaid() && (d2 = this.b.getRemainingGratuity()) > 0.0 && (n = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("SettleTicketProcessor.13"), POSConstants.CONFIRM)) != 0) {
            this.c(d2);
        }
        if (NumberUtil.isZero(this.b.getDueAmount())) {
            this.c();
        } else {
            this.setTicket(this.b);
            this.doInformListenerPaymentUpdate();
        }
    }

    private void b(double d) throws Exception {
        try {
            PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
            CreditCardInputListener creditCardInputListener = new CreditCardInputListener(this);
            if (paymentGatewayPlugin instanceof ExternalPaymentGatewayPlugin) {
                AuthorizationCodeDialog authorizationCodeDialog = new AuthorizationCodeDialog(creditCardInputListener, this.d);
                authorizationCodeDialog.pack();
                authorizationCodeDialog.open();
                return;
            }
            if (paymentGatewayPlugin instanceof InginicoPlugin) {
                BusyDialog busyDialog = new BusyDialog();
                busyDialog.setVisible(true);
                if (!busyDialog.isCanceled()) {
                    this.c();
                }
                return;
            }
            if (!paymentGatewayPlugin.shouldShowCardInputProcessor()) {
                this.a(paymentGatewayPlugin);
                return;
            }
            CardReader cardReader = CardConfig.getCardReader();
            switch (cardReader) {
                case MANUAL: {
                    ManualCardEntryDialog manualCardEntryDialog = new ManualCardEntryDialog(creditCardInputListener, this.d);
                    manualCardEntryDialog.pack();
                    manualCardEntryDialog.open();
                    break;
                }
                default: {
                    SwipeCardDialog swipeCardDialog = new SwipeCardDialog(creditCardInputListener, this.d);
                    swipeCardDialog.open();
                    break;
                }
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.f);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void b() {
        if (this.b == null) {
            return;
        }
        this.b.calculatePrice();
    }

    public void doApplyCoupon(int n) {
        try {
            Serializable serializable;
            if (this.b == null) {
                return;
            }
            if (!this.b.isDiscountable()) {
                String string = POSConstants.TICKET_IS_EMPTY_;
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string);
                return;
            }
            if (!this.getCurrentUser().hasPermission(UserPermission.ADD_DISCOUNT)) {
                serializable = PasswordEntryDialog.getUser(Application.getPosWindow(), Messages.getString("LoginView.1"), Messages.getString("EnterSecretKey"));
                if (serializable == null) {
                    return;
                }
                if (((User)serializable).getUserRoleWithPermission(UserPermission.ADD_DISCOUNT) == null) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SettleTicketDialog.7"));
                    return;
                }
            }
            if (n == 1) {
                serializable = new TicketDiscountSelectionDialog(this.b);
                ((POSDialog)serializable).openFullScreen();
            } else {
                serializable = new TicketItemDiscountSelectionDialog(this.b);
                ((POSDialog)serializable).openFullScreen();
            }
            this.b();
            this.doInformListenerPaymentUpdate();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void doAddLoyaltyDiscount() {
        boolean bl;
        if (this.b == null) {
            return;
        }
        if (!this.b.isDiscountable()) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.TICKET_IS_EMPTY_);
            return;
        }
        Store store = DataProvider.get().getStore();
        String string = store.getProperty("loyalty.enabled");
        boolean bl2 = bl = StringUtils.isNotEmpty((String)string) && Boolean.valueOf(string) != false;
        if (!bl) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketProcessor.9"));
            return;
        }
        Customer customer = this.b.getCustomer();
        if (customer == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketProcessor.10"));
            return;
        }
        CustomerDAO.getInstance().refresh(customer);
        Integer n = customer.getLoyaltyPoint();
        List<TicketDiscount> list = this.b.getDiscounts();
        for (TicketDiscount ticketDiscount : list) {
            if (ticketDiscount.getType() != 3 || ticketDiscount.isSaved()) continue;
            n = n - ticketDiscount.getLoyaltyPoint();
        }
        double d = NumberUtil.parseDouble(store.getProperty("loyalty.exchangeRate", "0"));
        int n2 = (int)Math.ceil(this.b.getDueAmount() / d);
        Integer n3 = Integer.parseInt(store.getProperty("loyalty.minRedeemablePoint"));
        if (n < n3) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketProcessor.11"));
            return;
        }
        String string2 = Messages.getString("SettleTicketProcessor.12");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(String.format(Messages.getString("SettleTicketProcessor.16"), n));
        stringBuilder.append("<br>");
        stringBuilder.append(String.format(Messages.getString("SettleTicketProcessor.19"), CurrencyUtil.getCurrencySymbol(), NumberUtil.getCurrencyFormatWithoutCurrencySymbol((double)n.intValue() * d)));
        stringBuilder.append("</html>");
        long l = NumberSelectionDialog2.takeIntInput(string2, stringBuilder.toString(), n2);
        if (l <= 0L) {
            return;
        }
        if (l > (long)n.intValue()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketProcessor.11"));
            return;
        }
        double d2 = d * (double)l;
        if (d2 > this.b.getDueAmount()) {
            if (d2 - this.b.getDueAmount() < 1.0) {
                d2 -= d2 - this.b.getDueAmount();
            } else {
                String string3 = String.format(Messages.getString("SettleTicketProcessor.20"), n2);
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string3);
                return;
            }
        }
        TicketDiscount ticketDiscount = Ticket.buildLoyaltyDiscount(this.b);
        ticketDiscount.setLoyaltyPoint((int)l);
        this.b.addTodiscounts(ticketDiscount);
        ticketDiscount.setValue(d2);
        this.b.calculatePrice();
        this.doInformListenerPaymentUpdate();
    }

    public void doSetGratuity() {
        if (this.b == null) {
            return;
        }
        GratuityInputDialog gratuityInputDialog = new GratuityInputDialog();
        gratuityInputDialog.setGratuity(this.b.getGratuityAmount());
        gratuityInputDialog.pack();
        gratuityInputDialog.setResizable(false);
        gratuityInputDialog.open();
        if (gratuityInputDialog.isCanceled()) {
            return;
        }
        double d = gratuityInputDialog.getGratuityAmount();
        if (d < 0.0) {
            POSMessageDialog.showError(Messages.getString("SettleTicketProcessor.21"));
            return;
        }
        this.b.setGratuityAmount(gratuityInputDialog.getGratuityAmount());
        this.b.calculatePrice();
        this.doInformListenerPaymentUpdate();
        ActionHistoryDAO.addSetGratuityActionHistory(this.b, this.b.getGratuity());
    }

    public void doInformListenerPaymentUpdate() {
        for (PaymentListener paymentListener : this.a) {
            paymentListener.paymentDataChanged();
        }
    }

    public void setTransactionAmounts(PosTransaction posTransaction) {
        posTransaction.setTenderAmount(this.c);
        if (this.c >= this.b.getDueAmount()) {
            posTransaction.setAmount(this.b.getDueAmount());
        } else {
            posTransaction.setAmount(this.c);
        }
    }

    public void setTransactionAmounts(PosTransaction posTransaction, List<MultiCurrencyTenderDialog.PaymentByCurrency> list) {
        double d = 0.0;
        if (list != null && list.size() > 0) {
            for (MultiCurrencyTenderDialog.PaymentByCurrency paymentByCurrency : list) {
                d += paymentByCurrency.cashBackAmount / paymentByCurrency.currency.getExchangeRate();
            }
        }
        if (d > this.c) {
            throw new PosException(Messages.getString("SettleTicketProcessor.26"));
        }
        posTransaction.setTenderAmount(this.c);
        if (this.c - d >= this.b.getDueAmount()) {
            posTransaction.setAmount(this.b.getDueAmount());
        } else {
            posTransaction.setAmount(this.c - d);
        }
    }

    public void doHoldTicket() {
        try {
            if (this.b.isReOpened().booleanValue() && this.b.getDueAmount() == 0.0) {
                this.b.setClosed(true);
            }
            if (this.b.getTicketItems() == null || this.b.getTicketItems().size() == 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.TICKET_IS_EMPTY_);
                return;
            }
            TicketDAO.getInstance().saveOrUpdate(this.b);
            ActionHistoryDAO.getInstance().performActionHistorySaveOperation(this.b);
            for (PaymentListener paymentListener : this.a) {
                paymentListener.paymentDone();
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.f);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    public void printTicket(Ticket ticket) {
        this.printTicket(ticket, true);
    }

    public void printTicket(Ticket ticket, boolean bl) {
        ReceiptPrintService.printTicket(ticket, bl);
        for (PaymentListener paymentListener : this.a) {
            paymentListener.paymentDataChanged();
        }
    }

    public void doSplitTicket() {
        DataChangeListener dataChangeListener = new DataChangeListener(){

            @Override
            public Object getSelectedData() {
                return SettleTicketProcessor.this.b;
            }

            @Override
            public void dataSetUpdated() {
            }

            @Override
            public void dataRemoved(Object object) {
            }

            @Override
            public void dataChanged(Object object) {
                if (object == null) {
                    return;
                }
                Ticket ticket = (Ticket)object;
                String string = ticket.getId();
                if (StringUtils.isNotEmpty((String)string)) {
                    OrderType orderType = ticket.getOrderType();
                    if (orderType != null && orderType.isRetailOrder().booleanValue()) {
                        SettleTicketProcessor.this.d();
                    } else {
                        SettleTicketProcessor.this.c();
                    }
                } else {
                    SettleTicketProcessor.this.doInformListenerPaymentUpdate();
                }
            }

            @Override
            public void dataChangeCanceled(Object object) {
            }

            @Override
            public void dataAdded(Object object) {
            }
        };
        SplitTicketAction splitTicketAction = new SplitTicketAction();
        splitTicketAction.setRefreshableView(this.f);
        splitTicketAction.setDataChangedListener(dataChangeListener);
        splitTicketAction.execute();
    }

    public void cancelPayment() {
        for (PaymentListener paymentListener : this.a) {
            paymentListener.paymentCanceled();
        }
    }

    public static void showTransactionCompleteMsg(double d, double d2, Ticket ticket, PosTransaction posTransaction) {
        TransactionCompletionDialog transactionCompletionDialog = new TransactionCompletionDialog(posTransaction);
        transactionCompletionDialog.setCompletedTransaction(posTransaction);
        transactionCompletionDialog.setTenderedAmount(d2);
        transactionCompletionDialog.setTotalAmount(d);
        transactionCompletionDialog.setPaidAmount(posTransaction.getAmount());
        transactionCompletionDialog.setDueAmount(ticket.getDueAmount());
        transactionCompletionDialog.setGratuityAmount(posTransaction.getTipsAmount());
        transactionCompletionDialog.setChangeAmount(posTransaction.getChangeAmount());
        transactionCompletionDialog.updateView();
        transactionCompletionDialog.pack();
        transactionCompletionDialog.open();
    }

    private void a(Ticket ticket, PosTransaction posTransaction) {
        String string = "";
        if (ticket.getOrderType().isShouldPrintToKitchen().booleanValue() && ticket.needsKitchenPrint()) {
            try {
                ReceiptPrintService.printToKitchen(ticket);
            }
            catch (Exception exception) {
                string = Messages.getString("SettleTicketProcessor.22");
            }
        }
        if (DataProvider.get().getCurrentTerminal().isAutoPrintReceipt() && NumberUtil.isZero(ticket.getDueAmount())) {
            try {
                ReceiptPrintService.printTransaction(posTransaction);
            }
            catch (Exception exception) {
                string = string + Messages.getString("SettleTicketProcessor.23");
            }
        }
        if (StringUtils.isNotBlank((String)string)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), string);
        }
    }

    public void doRefund() {
        new RefundAction().actionPerformed(null);
    }

    public void doVoidTicket() {
        if (this.b == null) {
            return;
        }
        if (!this.b.isVoidable()) {
            String string = POSConstants.TICKET_IS_EMPTY_;
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), string);
            return;
        }
        int n = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("WantedToVoid"), POSConstants.CONFIRM);
        if (n != 0) {
            return;
        }
        if (this.b.getId() == null) {
            this.c();
            return;
        }
        this.b.calculatePrice();
        if (this.b.getPaidAmount() > 0.0) {
            POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("SettleTicketProcessor.7"));
            return;
        }
        VoidTicketAction voidTicketAction = new VoidTicketAction(this.b);
        voidTicketAction.actionPerformed(null);
        if (this.b.isVoided().booleanValue()) {
            this.c();
        }
    }

    private void c(double d) {
        if (!this.b.hasGratuity()) {
            return;
        }
        Gratuity gratuity = this.b.getGratuity();
        gratuity.setAutoCalculated(false);
        gratuity.setAmount(gratuity.getAmount() - d);
        this.b.calculatePrice();
        PosTransactionService.closeTicketIfApplicable(this.b, StoreDAO.getServerTimestamp());
        TicketDAO.getInstance().saveOrUpdate(this.b);
    }

    private void c() {
        for (PaymentListener paymentListener : this.a) {
            paymentListener.paymentDone();
        }
    }

    private void d() {
        for (PaymentListener paymentListener : this.a) {
            paymentListener.paymentCanceled();
        }
    }

    public User getCurrentUser() {
        return this.e != null ? this.e : Application.getCurrentUser();
    }

    public void setCurrentUser(User user) {
        this.e = user;
    }

    public RefreshableView getRefreshableView() {
        return this.f;
    }

    private class RefundAction
    extends PosAction {
        public RefundAction() {
            this.setRequiredPermission(UserPermission.PERFORM_MANAGER_TASK);
            this.setMandatoryPermission(true);
        }

        @Override
        public void execute() {
            try {
                double d;
                if (SettleTicketProcessor.this.b.getTransactions() == null) {
                    SettleTicketProcessor.this.b.setTransactions(new HashSet<PosTransaction>());
                }
                if ((d = SettleTicketProcessor.this.b.getDueAmount().doubleValue()) >= 0.0) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketProcessor.8"));
                    return;
                }
                RefundDialog refundDialog = new RefundDialog(POSUtil.getFocusedWindow(), SettleTicketProcessor.this.b, SettleTicketProcessor.this);
                refundDialog.setSize(810, 600);
                refundDialog.open();
                SettleTicketProcessor.this.b.calculatePrice();
                if (NumberUtil.isZero(SettleTicketProcessor.this.b.getDueAmount())) {
                    SettleTicketProcessor.this.c();
                } else {
                    SettleTicketProcessor.this.doInformListenerPaymentUpdate();
                }
            }
            catch (PosException posException) {
                POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
            }
            catch (Exception exception) {
                POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
            }
        }
    }
}

