/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.Address;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CookingInstruction;
import com.floreantpos.model.Course;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.Currency;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.DeletedData;
import com.floreantpos.model.DeliveryAddress;
import com.floreantpos.model.DeliveryCharge;
import com.floreantpos.model.DeliveryInstruction;
import com.floreantpos.model.Department;
import com.floreantpos.model.Discount;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.InventoryClosingBalance;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopFloorTemplate;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.SlideShowImage;
import com.floreantpos.model.StockCount;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.VoidReason;
import com.floreantpos.model.base.BaseAddress;
import com.floreantpos.model.base.BaseTax;
import com.floreantpos.model.dao.AddressDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TerminalTypeDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.util.AsyncAction;
import com.floreantpos.util.XMLTransientUtil;
import com.floreantpos.webservice.PosWebService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.core.GenericEntity;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;

public class CloudDataUploader {
    private static Logger a = Logger.getLogger(CloudDataUploader.class);
    private ProgressObserver b;
    private PosWebService c;
    private boolean d;
    private int e;
    private Date f;
    private Integer g = 1;
    private Integer h = 0;
    private boolean i;

    public CloudDataUploader(ProgressObserver progressObserver) {
        this.b = progressObserver;
        this.c = PosWebService.get();
    }

    public void uploadLocalSettings(Date date) throws Exception {
        this.i = true;
        this.d = true;
        this.f = date;
        this.h = 0;
        this.a(Messages.getString("SyncService.76"));
        this.uploadAddress();
        this.uploadStore();
        this.uploadCurrency();
        this.uploadTaxes();
    }

    public Integer uploadAllData(boolean bl, Date date, Integer n) throws Exception {
        this.d = bl;
        this.f = date;
        this.h = n;
        this.e = 0;
        this.g = 1;
        return this.a();
    }

    private Integer a() throws Exception {
        List<Department> list = null;
        List<OrderType> list2 = null;
        List<TerminalType> list3 = null;
        PosLog.info(this.getClass(), "  =======================Starting Upload=======================");
        this.P();
        this.T();
        this.g();
        if (!this.i) {
            this.uploadCurrency();
        }
        this.uploadShift();
        this.x();
        this.b();
        this.y();
        list3 = this.v();
        this.w();
        if (!this.i) {
            this.uploadTaxes();
        }
        list2 = this.R();
        list = this.S();
        this.ai();
        this.aj();
        this.Q();
        this.f();
        this.A();
        this.e();
        this.d();
        this.M();
        this.L();
        this.O();
        this.N();
        this.u();
        this.t();
        this.E();
        this.F();
        this.B();
        this.z();
        this.G();
        this.H();
        this.C();
        this.D();
        this.I();
        this.J();
        this.K();
        this.uploadBookingInfos();
        this.uploadTickets();
        if (!this.i) {
            this.uploadAddress();
        }
        this.ak();
        this.r();
        this.q();
        this.p();
        this.o();
        this.n();
        this.m();
        this.l();
        this.k();
        this.i();
        this.j();
        this.V();
        this.U();
        this.W();
        this.X();
        this.Y();
        this.Z();
        this.aa();
        this.ab();
        this.ac();
        this.ad();
        this.ae();
        this.af();
        this.c();
        this.ag();
        this.h();
        this.ah();
        this.s();
        if (list != null && list.size() > 0) {
            this.e(list);
        }
        if (list2 != null && list2.size() > 0) {
            this.c(list2);
        }
        if (list3 != null && list3.size() > 0) {
            this.d(list3);
        }
        if (this.e == 0) {
            this.b("Nothing to upload. Everything is up to date.");
        } else {
            PosLog.info(this.getClass(), "=======================Upload Finished=======================");
        }
        return this.h;
    }

    public boolean uploadStore() throws Exception {
        this.a(this.h, Messages.getString("CloudDataUploader.55"));
        PosLog.info(this.getClass(), "");
        GenericDAO genericDAO = GenericDAO.getInstance();
        List list = genericDAO.findAllUnSyncItem(Store.class, this.d, this.f);
        this.b(list, " store.");
        if (list != null && !list.isEmpty()) {
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<Store>>(list){}, "store");
            }
            catch (Exception exception) {
                if (exception.getMessage().contains("Connection refused")) {
                    throw new PosException("Connection failed.");
                }
                this.a(exception);
                return false;
            }
        }
        return true;
    }

    private void b() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(StoreSessionControl.class, this.d, this.f);
        this.a(list, " store session control.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.57"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (StoreSessionControl storeSessionControl : list) {
                arrayList.add(storeSessionControl.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<StoreSessionControl>>(list){}, "storesessioncontrol");
                this.b(this.f, arrayList, StoreSessionControl.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void c() {
        ArrayList<String> arrayList = new ArrayList<String>();
        GenericDAO genericDAO = GenericDAO.getInstance();
        List list = genericDAO.findAllUnSyncItem(MenuPage.class, this.d, this.f);
        this.a(list, " menu page.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.53"));
            for (MenuPage menuPage : list) {
                arrayList.add(menuPage.getId());
                XMLTransientUtil.makeXMLTransient(menuPage);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<MenuPage>>(list){}, "menuPage");
                this.b(this.f, arrayList, MenuPage.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void d() {
        ArrayList<String> arrayList = new ArrayList<String>();
        GenericDAO genericDAO = GenericDAO.getInstance();
        List list = genericDAO.findAllUnSyncItem(PizzaPrice.class, this.d, this.f);
        this.a(list, " pizza price.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.52"));
            for (PizzaPrice pizzaPrice : list) {
                arrayList.add(pizzaPrice.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<PizzaPrice>>(list){}, "pizzaPrice");
                this.b(this.f, arrayList, PizzaPrice.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void e() {
        ArrayList<String> arrayList = new ArrayList<String>();
        GenericDAO genericDAO = GenericDAO.getInstance();
        List list = genericDAO.findAllUnSyncItem(PizzaCrust.class, this.d, this.f);
        this.a(list, Messages.getString("CloudDataUploader.66"));
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.51"));
            for (PizzaCrust pizzaCrust : list) {
                arrayList.add(pizzaCrust.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<PizzaCrust>>(list){}, "pizzaCrust");
                this.b(this.f, arrayList, PizzaCrust.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void f() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Multiplier.class, this.d, this.f);
        this.a(list, Messages.getString("CloudDataUploader.78"));
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.78"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Multiplier multiplier : list) {
                arrayList.add(multiplier.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<Multiplier>>(list){}, "multiplier");
                this.b(this.f, arrayList, Multiplier.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void g() {
        ArrayList<String> arrayList = new ArrayList<String>();
        GenericDAO genericDAO = GenericDAO.getInstance();
        List list = genericDAO.findAllUnSyncItem(ImageResource.class, this.d, this.f);
        this.a(list, " image resources.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.56"));
            for (ImageResource imageResource : list) {
                arrayList.add(imageResource.getId());
                imageResource.setImageData(null);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<ImageResource>>(list){}, "imageResources");
                this.b(this.f, arrayList, ImageResource.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void h() {
        ArrayList<String> arrayList = new ArrayList<String>();
        GenericDAO genericDAO = GenericDAO.getInstance();
        List list = genericDAO.findAllUnSyncItem(GratuityPaymentHistory.class, this.d, this.f);
        this.a(list, " gratuity payment history.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.46"));
            for (GratuityPaymentHistory gratuityPaymentHistory : list) {
                arrayList.add(gratuityPaymentHistory.getId());
                XMLTransientUtil.makeXMLTransient(gratuityPaymentHistory);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<GratuityPaymentHistory>>(list){}, "gratuityPaymentHistory");
                this.b(this.f, arrayList, GratuityPaymentHistory.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void i() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = GenericDAO.getInstance().findAllUnSyncItem(GiftCard.class, this.d, this.f);
        this.a(list, " gift card.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.45"));
            for (GiftCard giftCard : list) {
                arrayList.add(giftCard.getCardNumber());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<GiftCard>>(list){}, "giftCard");
                GiftCardDAO.getInstance().updateItemsLastSyncTime(arrayList, GiftCard.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void j() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(DeliveryInstruction.class, this.d, this.f);
        this.a(list, " delivery instruction.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.47"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DeliveryInstruction deliveryInstruction : list) {
                arrayList.add(deliveryInstruction.getId());
                XMLTransientUtil.makeXMLTransient(deliveryInstruction.getCustomer());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<DeliveryInstruction>>(list){}, "deliveryInstruction");
                this.b(this.f, arrayList, DeliveryInstruction.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void k() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Discount.class, this.d, this.f);
        this.a(list, " discount.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.44"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Discount discount : list) {
                arrayList.add(discount.getId());
                XMLTransientUtil.makeLazy(discount);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<Discount>>(list){}, "discount");
                this.b(this.f, arrayList, Discount.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void l() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(DeliveryCharge.class, this.d, this.f);
        this.a(list, " delivery charge.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.43"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DeliveryCharge deliveryCharge : list) {
                arrayList.add(deliveryCharge.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<DeliveryCharge>>(list){}, "deliveryCharge");
                this.b(this.f, arrayList, DeliveryCharge.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void m() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(DeliveryAddress.class, this.d, this.f);
        this.a(list, " delivery address.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.42"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DeliveryAddress deliveryAddress : list) {
                arrayList.add(deliveryAddress.getId());
                String string = deliveryAddress.getCustomerId();
                deliveryAddress.setCustomer(null);
                deliveryAddress.setCustomerId(string);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<DeliveryAddress>>(list){}, "deliveryAddress");
                this.b(this.f, arrayList, DeliveryAddress.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void n() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(DeclaredTips.class, this.d, this.f);
        this.a(list, " declared tips.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.41"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DeclaredTips declaredTips : list) {
                arrayList.add(declaredTips.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<DeclaredTips>>(list){}, "declaredTips");
                this.b(this.f, arrayList, DeclaredTips.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void o() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(CustomPayment.class, this.d, this.f);
        this.a(list, " custom payment.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.40"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (CustomPayment customPayment : list) {
                arrayList.add(customPayment.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<CustomPayment>>(list){}, "customPayment");
                this.b(this.f, arrayList, CustomPayment.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void p() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(CustomerGroup.class, this.d, this.f);
        this.a(list, " customer group.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.39"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (CustomerGroup customerGroup : list) {
                arrayList.add(customerGroup.getId());
                CustomerGroupDAO.getInstance().initialize(customerGroup);
                this.a(customerGroup.getCustomers());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<CustomerGroup>>(list){}, "customerGroup");
                this.b(this.f, arrayList, CustomerGroup.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void a(List<Customer> list) {
        if (list == null) {
            return;
        }
        for (Customer customer : list) {
            XMLTransientUtil.makeXMLTransient(customer);
        }
    }

    private void q() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Course.class, this.d, this.f);
        this.a(list, " course.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.38"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Course course : list) {
                arrayList.add(course.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<Course>>(list){}, "course");
                this.b(this.f, arrayList, Course.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void r() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(CookingInstruction.class, this.d, this.f);
        this.a(list, " cooking instructions.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.37"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (CookingInstruction cookingInstruction : list) {
                arrayList.add(cookingInstruction.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<CookingInstruction>>(list){}, "cookingInstruction");
                this.b(this.f, arrayList, CookingInstruction.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void s() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(DeletedData.class, this.d, this.f);
        this.a(list, " deleted data.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading deleted data...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DeletedData deletedData : list) {
                arrayList.add(deletedData.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<DeletedData>>(list){}, "deletedData");
                this.b(this.f, arrayList, DeletedData.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void t() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Attribute.class, this.d, this.f);
        this.a(list, " attribute.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.17"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Attribute attribute : list) {
                arrayList.add(attribute.getId());
                XMLTransientUtil.makeXMLTransient(attribute.getGroup());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<Attribute>>(list){}, "attribute");
                this.b(this.f, arrayList, Attribute.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void u() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(AttributeGroup.class, this.d, this.f);
        this.a(list, " attribute group.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.16"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (AttributeGroup attributeGroup : list) {
                arrayList.add(attributeGroup.getId());
                attributeGroup.setAttributes(null);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<AttributeGroup>>(list){}, "attributeGroup");
                this.b(this.f, arrayList, AttributeGroup.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private List<TerminalType> v() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(TerminalType.class, this.d, this.f);
        this.a(list, " terminal type.");
        ArrayList<TerminalType> arrayList = new ArrayList<TerminalType>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.4"));
            for (TerminalType terminalType : list) {
                TerminalTypeDAO.getInstance().initialize(terminalType);
                TerminalType terminalType2 = XMLTransientUtil.getLazyData(terminalType);
                if (terminalType2 != null) {
                    arrayList.add(terminalType2);
                }
                arrayList2.add(terminalType.getId());
                XMLTransientUtil.makeXMLTransient(terminalType);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<TerminalType>>(list){}, "terminalType");
                this.b(this.f, arrayList2, TerminalType.REF);
                this.a(arrayList2.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
        return arrayList;
    }

    private void w() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Terminal.class, this.d, this.f);
        this.a(list, " terminal.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.4"));
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (Terminal terminal : list) {
                terminal.setProperties(null);
                arrayList.add(terminal.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<Terminal>>(list){}, "terminal");
                this.a(this.f, arrayList, Terminal.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void x() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(StoreSession.class, this.d, this.f);
        this.a(list, " store session.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.2"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (StoreSession storeSession : list) {
                if (StringUtils.isEmpty((String)storeSession.getOutletId())) {
                    storeSession.setOutletId(DataProvider.get().getStore().getDefaultOutletId());
                }
                XMLTransientUtil.makeXMLTransient(storeSession.getClosedBy());
                XMLTransientUtil.makeXMLTransient(storeSession.getOpenedBy());
                arrayList.add(storeSession.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<StoreSession>>(list){}, "storesession");
                this.b(this.f, arrayList, StoreSession.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    public void uploadTickets() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Ticket.class, this.d, this.f);
        this.a(list, " ticket.");
        String string = DataProvider.get().getStore().getDefaultOutletId();
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.33"));
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            for (Ticket ticket : list) {
                TicketDAO.getInstance().loadFullTicket(ticket);
                XMLTransientUtil.makeXMLTransient(ticket);
                ticket.setOutletId(string);
                arrayList.add(ticket);
            }
            this.doSendTicketToCloud(arrayList);
        }
    }

    public void uploadToCloudIfOnlineOrder(final Ticket ticket) {
        if (ticket == null || ticket.getType().intValue() != TicketType.ONLINE.getTypeNo()) {
            return;
        }
        if (!this.c.isCloudConfigured()) {
            return;
        }
        AsyncAction.execute(new Runnable(){

            @Override
            public void run() {
                CloudDataUploader.this.uploadToCloud(ticket);
            }
        });
    }

    public void uploadToCloud(Ticket ticket) {
        try {
            Ticket ticket2 = TicketDAO.getInstance().loadFullTicket(ticket.getId());
            XMLTransientUtil.makeXMLTransient(ticket2);
            ticket2.setOutletId(DataProvider.get().getStore().getDefaultOutletId());
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            arrayList.add(ticket2);
            GenericEntity<List<Ticket>> genericEntity = new GenericEntity<List<Ticket>>(arrayList){};
            this.c.uploadData((GenericEntity)genericEntity, "tickets");
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), "Failed to upload ticket : " + ticket.getId() + " " + exception.getMessage());
        }
    }

    public void doSendTicketToCloud(List<Ticket> list) throws Exception {
        try {
            GenericEntity<List<Ticket>> genericEntity = new GenericEntity<List<Ticket>>(list){};
            this.c.uploadData((GenericEntity)genericEntity, "tickets");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Ticket ticket : list) {
                arrayList.add(ticket.getId());
            }
            GenericDAO.getInstance().updateItemsLastSyncTime(this.f, arrayList, Ticket.REF);
            this.a(arrayList.size());
        }
        catch (Exception exception) {
            this.a(exception);
        }
    }

    private void y() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(CashDrawer.class, this.d, this.f);
        this.a(list, " cash drawer.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.3"));
            this.b(list);
        }
    }

    private void b(List<CashDrawer> list) {
        try {
            this.c.uploadData((GenericEntity)new GenericEntity<List<CashDrawer>>(list){}, "cashdrawers");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (CashDrawer cashDrawer : list) {
                arrayList.add(cashDrawer.getId());
            }
            GenericDAO.getInstance().updateItemsLastSyncTime(this.f, arrayList, CashDrawer.REF);
            this.a(arrayList.size());
        }
        catch (Exception exception) {
            this.a(exception);
        }
    }

    private void z() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(MenuItem.class, this.d, this.f);
        this.a(list, " menu item.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.18"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MenuItem menuItem : list) {
                menuItem.setAttributes(null);
                arrayList.add(menuItem.getId());
                XMLTransientUtil.makeXMLTransientMenuItem(menuItem);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<MenuItem>>(list){}, "menuitem");
                this.b(this.f, arrayList, MenuItem.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void A() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(MenuItemSize.class, this.d, this.f);
        this.a(list, " menu item size.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.19"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MenuItemSize menuItemSize : list) {
                arrayList.add(menuItemSize.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<MenuItemSize>>(list){}, "menuitemsizes");
                this.b(this.f, arrayList, MenuItemSize.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void B() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(PackagingUnit.class, this.d, this.f);
        this.a(list, " packaging unit.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.24"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (PackagingUnit packagingUnit : list) {
                arrayList.add(packagingUnit.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<PackagingUnit>>(list){}, "packagingunits");
                this.b(this.f, arrayList, PackagingUnit.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void C() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(InventoryLocation.class, this.d, this.f);
        this.a(list, " inventory location.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.26"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (InventoryLocation inventoryLocation : list) {
                arrayList.add(inventoryLocation.getId());
                XMLTransientUtil.makeXMLTransient(inventoryLocation);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<InventoryLocation>>(list){}, "inventorylocation");
                this.b(this.f, arrayList, InventoryLocation.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void D() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(InventoryTransaction.class, this.d, this.f);
        this.a(list, " inventory transaction.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.27"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (InventoryTransaction inventoryTransaction : list) {
                arrayList.add(inventoryTransaction.getId());
                XMLTransientUtil.makeXMLTransient(inventoryTransaction);
            }
            this.doSendInventoryTransactions(arrayList, list);
        }
    }

    public void doSendInventoryTransactions(List<String> list, List<InventoryTransaction> list2) {
        try {
            this.c.uploadData((GenericEntity)new GenericEntity<List<InventoryTransaction>>(list2){}, "inventorytransactions");
            GenericDAO.getInstance().updateItemsLastSyncTime(this.f, list, InventoryTransaction.REF);
            this.a(list.size());
        }
        catch (Exception exception) {
            this.a(exception);
        }
    }

    private void E() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(InventoryUnitGroup.class, this.d, this.f);
        this.a(list, " inventory unit group.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.22"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (InventoryUnitGroup inventoryUnitGroup : list) {
                inventoryUnitGroup.setUnits(null);
                arrayList.add(inventoryUnitGroup.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<InventoryUnitGroup>>(list){}, "inventoryunitgroups");
                this.b(this.f, arrayList, InventoryUnitGroup.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void F() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(InventoryUnit.class, this.d, this.f);
        this.a(list, " inventory unit.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.23"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (InventoryUnit inventoryUnit : list) {
                arrayList.add(inventoryUnit.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<InventoryUnit>>(list){}, "inventoryunits");
                this.b(this.f, arrayList, InventoryUnit.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void G() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(InventoryVendor.class, this.d, this.f);
        this.a(list, " inventory vendor.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.20"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (InventoryVendor inventoryVendor : list) {
                arrayList.add(inventoryVendor.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<InventoryVendor>>(list){}, "inventoryvendors");
                this.b(this.f, arrayList, InventoryVendor.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void H() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(InventoryVendorItems.class, this.d, this.f);
        this.a(list, " inventory vendor item.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.21"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (InventoryVendorItems inventoryVendorItems : list) {
                arrayList.add(inventoryVendorItems.getId());
                XMLTransientUtil.makeXMLTransient(inventoryVendorItems);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<InventoryVendorItems>>(list){}, "inventoryvendoritems");
                this.b(this.f, arrayList, InventoryVendorItems.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void I() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(InventoryClosingBalance.class, this.d, this.f);
        this.a(list, " inventory closing balance.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.29"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (InventoryClosingBalance inventoryClosingBalance : list) {
                arrayList.add(inventoryClosingBalance.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<InventoryClosingBalance>>(list){}, "inventoryclosingbalances");
                this.b(this.f, arrayList, InventoryClosingBalance.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void J() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(ShopFloor.class, this.d, this.f);
        this.a(list, " shop floor.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.30"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ShopFloor shopFloor : list) {
                arrayList.add(shopFloor.getId());
                XMLTransientUtil.makeXMLTransient(shopFloor);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<ShopFloor>>(list){}, "shopfloors");
                this.b(this.f, arrayList, ShopFloor.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void K() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(ShopTable.class, this.d, this.f);
        this.a(list, " shop table.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.31"));
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (ShopTable shopTable : list) {
                arrayList.add(shopTable.getId());
                XMLTransientUtil.makeXMLTransient(shopTable);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<ShopTable>>(list){}, "shoptables");
                this.a(this.f, arrayList, ShopTable.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    public void uploadBookingInfos() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(BookingInfo.class, this.d, this.f);
        this.a(list, " booking info.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.32"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (BookingInfo bookingInfo : list) {
                arrayList.add(bookingInfo.getId());
                XMLTransientUtil.makeXMLTransient(bookingInfo);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<BookingInfo>>(list){}, "bookinginfos");
                this.b(this.f, arrayList, BookingInfo.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    public void uploadCurrency() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Currency.class, this.d, this.f);
        this.a(list, " currency.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.1"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Currency currency : list) {
                arrayList.add(currency.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<Currency>>(list){}, "currencies");
                this.b(this.f, arrayList, Currency.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    public void uploadCashBreakDown() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(CashBreakdown.class, this.d, this.f);
        this.a(list, " cash breakdown.");
        if (list != null && !list.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (CashBreakdown cashBreakdown : list) {
                arrayList.add(cashBreakdown.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<CashBreakdown>>(list){}, "cashbreakdowns");
                this.b(this.f, arrayList, CashBreakdown.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    public void uploadShift() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Shift.class, this.d, this.f);
        this.a(list, " shift.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.34"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Shift shift : list) {
                arrayList.add(shift.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<Shift>>(list){}, "shifts");
                this.b(this.f, arrayList, Shift.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    public void uploadShopTablesStatus() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(ShopTableStatus.class, this.d, this.f);
        this.a(list, " shop table status.");
        if (list != null && !list.isEmpty()) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (ShopTableStatus shopTableStatus : list) {
                arrayList.add(shopTableStatus.getId());
            }
            this.doSendShopTableStatusToCloud(arrayList, list);
        }
    }

    public void doSendShopTableStatusToCloud(List<Integer> list, List<ShopTableStatus> list2) {
        try {
            this.c.uploadData((GenericEntity)new GenericEntity<List<ShopTableStatus>>(list2){}, "shoptablesstatus");
            this.a(this.f, list, ShopTableStatus.REF);
        }
        catch (Exception exception) {
            String string = Messages.getString("CloudDataUploader.226");
            PosLog.error(CloudDataUploader.class, string);
        }
    }

    private void L() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(ModifierGroup.class, this.d, this.f);
        this.a(list, " modifier group.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.13"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ModifierGroup modifierGroup : list) {
                arrayList.add(modifierGroup.getId());
                XMLTransientUtil.makeXMLTransient(modifierGroup);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<ModifierGroup>>(list){}, "modifiergroup");
                this.b(this.f, arrayList, ModifierGroup.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void M() throws Exception {
        List list = GenericDAO.getInstance().findAllUnSyncItem(MenuModifier.class, this.d, this.f);
        this.a(list, " menu modifier.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.12"));
            HashSet<String> hashSet = new HashSet<String>();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MenuModifier menuModifier : list) {
                arrayList.add(menuModifier.getId());
                MenuModifierDAO.getInstance().initialize(menuModifier);
                List<ModifierGroup> list2 = menuModifier.getModifierGroups();
                if (list2 == null) {
                    return;
                }
                for (ModifierGroup modifierGroup : list2) {
                    hashSet.add(modifierGroup.getId());
                    modifierGroup.setModifiers(null);
                }
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<MenuModifier>>(list){}, "modifier");
                this.b(this.f, arrayList, MenuModifier.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void N() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(MenuGroup.class, this.d, this.f);
        this.a(list, " menu group.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.15"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MenuGroup menuGroup : list) {
                arrayList.add(menuGroup.getId());
                XMLTransientUtil.makeXMLTransient(menuGroup);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<MenuGroup>>(list){}, "menugroup");
                this.b(this.f, arrayList, MenuGroup.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void O() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(MenuCategory.class, this.d, this.f);
        this.a(list, " menu category.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.14"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MenuCategory menuCategory : list) {
                arrayList.add(menuCategory.getId());
                XMLTransientUtil.makeXMLTransientCollection(menuCategory);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<MenuCategory>>(list){}, "menucategory");
                this.b(this.f, arrayList, MenuCategory.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void P() {
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Outlet> arrayList2 = new ArrayList<Outlet>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        Store store = StoreDAO.getRestaurant();
        OutletDAO outletDAO = OutletDAO.getInstance();
        Outlet outlet = outletDAO.get(store.getDefaultOutletId());
        boolean bl = outletDAO.isOutletSyncable(store.getDefaultOutletId());
        if (outlet == null) {
            outlet = new Outlet();
            outlet.setId(store.getDefaultOutletId());
            outlet.setName(store.getOutletName());
            outletDAO.save(outlet);
            object2 = TerminalDAO.getInstance().findAll();
            if (object2 != null) {
                object = object2.iterator();
                while (object.hasNext()) {
                    Terminal terminal = (Terminal)object.next();
                    terminal.setOutlet(outlet);
                    TerminalDAO.getInstance().saveOrUpdate(terminal);
                }
            }
        } else {
            if (!bl) {
                return;
            }
            outletDAO.initialize(outlet);
            outlet.setId(store.getDefaultOutletId());
            outlet.setName(store.getOutletName());
        }
        object2 = store.getAddress();
        if (object2 != null && (object = AddressDAO.getInstance().findAddressById(((BaseAddress)object2).getId())) != null) {
            arrayList3.add(object);
            if (arrayList3 != null && !arrayList3.isEmpty()) {
                try {
                    this.c.uploadData((GenericEntity)new GenericEntity<List<Address>>(arrayList3){}, "address");
                }
                catch (Exception exception) {
                    this.a(exception);
                }
            }
            outlet.setAddressId(((BaseAddress)object).getId());
        }
        outlet.setDepartments(null);
        arrayList.add(outlet.getId());
        arrayList2.add(outlet);
        if (arrayList2 != null && !arrayList2.isEmpty()) {
            try {
                this.c(Messages.getString("CloudDataUploader.0"));
                this.c.uploadData((GenericEntity)new GenericEntity<List<Outlet>>(arrayList2){}, "outlet");
                this.b(this.f, arrayList, Outlet.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void a(String string) {
        if (this.b == null) {
            return;
        }
        this.b.printInfo("\n" + string);
    }

    public void uploadTaxes() {
        ArrayList<String> arrayList;
        List list = GenericDAO.getInstance().findAllUnSyncItem(Tax.class, this.d, this.f);
        this.a(list, " tax.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.10"));
            arrayList = new ArrayList();
            for (Object object : list) {
                arrayList.add(((BaseTax)object).getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<Tax>>(list){}, "tax");
                this.b(this.f, arrayList, Tax.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
        arrayList = new ArrayList<String>();
        List list2 = GenericDAO.getInstance().findAllUnSyncItem(TaxGroup.class, this.d, this.f);
        this.a(list2, " tax group.");
        if (list2 != null && !list2.isEmpty()) {
            Object object;
            object = list2.iterator();
            while (object.hasNext()) {
                TaxGroup taxGroup = (TaxGroup)object.next();
                arrayList.add(taxGroup.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<TaxGroup>>(list2){}, "taxgroup");
                this.b(this.f, arrayList, TaxGroup.REF);
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void Q() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Customer.class, this.d, this.f);
        this.a(list, " customer.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.11"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Customer customer : list) {
                CustomerDAO.getInstance().initialize(customer);
                arrayList.add(customer.getId());
                XMLTransientUtil.makeXMLTransient(customer);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<Customer>>(list){}, "customer");
                this.b(this.f, arrayList, Customer.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private List<OrderType> R() {
        ArrayList<OrderType> arrayList = new ArrayList<OrderType>();
        List list = GenericDAO.getInstance().findAllUnSyncItem(OrderType.class, this.d, this.f);
        this.a(list, " order type.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.6"));
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (OrderType orderType : list) {
                OrderTypeDAO.getInstance().initialize(orderType);
                OrderType orderType2 = XMLTransientUtil.getLazyData(orderType);
                if (orderType2 != null) {
                    arrayList.add(orderType2);
                }
                arrayList2.add(orderType.getId());
                XMLTransientUtil.makeXMLTransient(orderType);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<OrderType>>(list){}, "ordertype");
                this.b(this.f, arrayList2, OrderType.REF);
                this.a(arrayList2.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
        return arrayList;
    }

    private void c(List<OrderType> list) {
        this.a(list, " order type -> terminal types and menu categories and departments");
        if (list != null && !list.isEmpty()) {
            this.c(" order type -> terminal types and menu categories and departments");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (OrderType orderType : list) {
                arrayList.add(orderType.getId());
                XMLTransientUtil.makeLazy(orderType);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<OrderType>>(list){}, "ordertype/categories");
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void d(List<TerminalType> list) {
        this.a(list, " terminal type -> outlets and menu categories");
        if (list != null && !list.isEmpty()) {
            this.c(" terminal type -> outlets and menu categories");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (TerminalType terminalType : list) {
                arrayList.add(terminalType.getId());
                XMLTransientUtil.makeLazy(terminalType);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<TerminalType>>(list){}, "terminalType/categories");
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private List<Department> S() {
        ArrayList<Department> arrayList = new ArrayList<Department>();
        List list = GenericDAO.getInstance().findAllUnSyncItem(Department.class, this.d, this.f);
        this.a(list, " department.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading department");
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (Department department : list) {
                try (Object object = DepartmentDAO.getInstance().createNewSession();){
                    object.refresh((Object)department);
                    Hibernate.initialize(department.getOutlets());
                    Hibernate.initialize(department.getOrderTypes());
                }
                object = XMLTransientUtil.getLazyData(department);
                if (object != null) {
                    arrayList.add((Department)object);
                }
                arrayList2.add(department.getId());
                XMLTransientUtil.makeXMLTransient(department);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<Department>>(list){}, "departments");
                this.b(this.f, arrayList2, Department.REF);
                this.a(arrayList2.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
        return arrayList;
    }

    private void e(List<Department> list) {
        this.a(list, " department -> outlets and order types");
        if (list != null && !list.isEmpty()) {
            this.c(" department -> outlets and order types");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Department department : list) {
                arrayList.add(department.getId());
                XMLTransientUtil.makeLazy(department);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<Department>>(list){}, "departments/orderTypesAndOutlets");
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void T() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(SalesArea.class, this.d, this.f);
        this.a(list, " sales area.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading sales areas...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (SalesArea salesArea : list) {
                arrayList.add(salesArea.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<SalesArea>>(list){}, "salesAreas");
                this.b(this.f, arrayList, SalesArea.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void U() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(ReportGroup.class, this.d, this.f);
        this.a(list, " report group.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading report group...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ReportGroup reportGroup : list) {
                arrayList.add(reportGroup.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<ReportGroup>>(list){}, "reportGroups");
                this.b(this.f, arrayList, ReportGroup.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void V() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(PrinterGroup.class, this.d, this.f);
        this.a(list, " printer group.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading printer group...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (PrinterGroup printerGroup : list) {
                arrayList.add(printerGroup.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<PrinterGroup>>(list){}, "printerGroups");
                this.b(this.f, arrayList, PrinterGroup.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void W() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(VoidReason.class, this.d, this.f);
        this.a(list, " void reason.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading void reason...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (VoidReason voidReason : list) {
                arrayList.add(voidReason.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<VoidReason>>(list){}, "voidReasons");
                this.b(this.f, arrayList, VoidReason.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void X() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(VirtualPrinter.class, this.d, this.f);
        this.a(list, " virtual printer.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading printers...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (VirtualPrinter virtualPrinter : list) {
                arrayList.add(virtualPrinter.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<VirtualPrinter>>(list){}, "printers");
                this.b(this.f, arrayList, VirtualPrinter.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void Y() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(ShopTableType.class, this.d, this.f);
        this.a(list, " shop table type.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading table types...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ShopTableType shopTableType : list) {
                arrayList.add(shopTableType.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<ShopTableType>>(list){}, "shopTableTypes");
                this.b(this.f, arrayList, ShopTableType.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void Z() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(ActionHistory.class, this.d, this.f);
        this.a(list, " action history.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading action histories...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ActionHistory actionHistory : list) {
                XMLTransientUtil.makeXMLTransient(actionHistory.getPerformer());
                arrayList.add(actionHistory.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<ActionHistory>>(list){}, "actionHistories");
                this.b(this.f, arrayList, ActionHistory.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void a(int n) {
        if (this.b == null) {
            return;
        }
        this.b.printInfo(" (" + n + ") : success");
    }

    private void aa() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(VoidItem.class, this.d, this.f);
        this.a(list, " void item.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading void items...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (VoidItem voidItem : list) {
                arrayList.add(voidItem.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<VoidItem>>(list){}, "voidItems");
                this.b(this.f, arrayList, VoidItem.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void ab() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Recepie.class, this.d, this.f);
        this.a(list, " recipe.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading recipes...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Recepie recepie : list) {
                XMLTransientUtil.makeLazy(recepie);
                arrayList.add(recepie.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<Recepie>>(list){}, "recipes");
                this.b(this.f, arrayList, Recepie.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void ac() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(PurchaseOrder.class, this.d, this.f);
        this.a(list, " purchase order.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading purchase orders...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (PurchaseOrder purchaseOrder : list) {
                XMLTransientUtil.makeLazy(purchaseOrder);
                arrayList.add(purchaseOrder.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<PurchaseOrder>>(list){}, "purchaseOrders");
                this.b(this.f, arrayList, PurchaseOrder.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void ad() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(StockCount.class, this.d, this.f);
        this.a(list, " stock count.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading stock counts...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (StockCount stockCount : list) {
                XMLTransientUtil.makeLazy(stockCount);
                arrayList.add(stockCount.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<StockCount>>(list){}, "stockCounts");
                this.b(this.f, arrayList, StockCount.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void ae() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(ShopFloorTemplate.class, this.d, this.f);
        this.a(list, " shop floor template.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading shop floor templates...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ShopFloorTemplate shopFloorTemplate : list) {
                XMLTransientUtil.makeXMLTransient(shopFloorTemplate);
                arrayList.add(shopFloorTemplate.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<ShopFloorTemplate>>(list){}, "shopFloorTemplates");
                this.b(this.f, arrayList, ShopFloorTemplate.REF);
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void af() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(CronJob.class, this.d, this.f);
        this.a(list, " cron job.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading cron jobs...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (CronJob cronJob : list) {
                arrayList.add(cronJob.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<CronJob>>(list){}, "cronJobs");
                this.b(this.f, arrayList, CronJob.REF);
                this.a(list.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void ag() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Gratuity.class, this.d, this.f);
        this.a(list, " gratuity.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading gratuities...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Gratuity gratuity : list) {
                arrayList.add(gratuity.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<Gratuity>>(list){}, "gratuity");
                this.b(this.f, arrayList, Gratuity.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void ah() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(SlideShowImage.class, this.d, this.f);
        this.a(list, " slide images.");
        if (list != null && !list.isEmpty()) {
            this.c("Uploading slide images...");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (SlideShowImage slideShowImage : list) {
                arrayList.add(slideShowImage.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<SlideShowImage>>(list){}, "slideShowImages");
                this.b(this.f, arrayList, SlideShowImage.REF);
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void ai() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(UserType.class, this.d, this.f);
        this.a(list, " user type.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.8"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (UserType userType : list) {
                arrayList.add(userType.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<UserType>>(list){}, "usertypes");
                this.b(this.f, arrayList, UserType.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void aj() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(User.class, this.d, this.f);
        this.a(list, " user.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.9"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (User user : list) {
                arrayList.add(user.getId());
                XMLTransientUtil.makeXMLTransient(user);
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<User>>(list){}, "users");
                this.b(this.f, arrayList, User.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    public static CloudDataUploader get() {
        return CloudDataUploader.get(null);
    }

    public static CloudDataUploader get(ProgressObserver progressObserver) {
        return new CloudDataUploader(progressObserver);
    }

    public void uploadOnSaveBookingInfo(BookingInfo bookingInfo) {
        try {
            if (!Application.getInstance().isCloudConnected()) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<BookingInfo> arrayList2 = new ArrayList<BookingInfo>();
            XMLTransientUtil.makeXMLTransient(bookingInfo);
            arrayList2.add(bookingInfo);
            arrayList.add(bookingInfo.getId());
            if (this.c == null) {
                this.c = PosWebService.get();
            }
            this.c.uploadData((GenericEntity)new GenericEntity<List<BookingInfo>>(arrayList2){}, "bookinginfos");
            this.b(this.f, arrayList, BookingInfo.REF);
        }
        catch (Exception exception) {
            this.a(exception);
        }
    }

    public void sendTicketWithTransactions(String string) {
        if (!Application.getInstance().isCloudConnected()) {
            return;
        }
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        AsyncAction.execute(() -> {
            try {
                Ticket ticket = TicketDAO.getInstance().loadFullTicket(string);
                if (ticket == null) {
                    return;
                }
                this.c.doUploadTicketToCloud(ticket);
            }
            catch (Exception exception) {
                PosLog.error(PosWebService.class, "Uploading ticket/transaction/InvTransaction failed...", exception);
            }
        });
    }

    public void uploadAddress() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(Address.class, this.d, this.f);
        this.a(list, " address.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.35"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Address address : list) {
                arrayList.add(address.getId());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<Address>>(list){}, "address");
                this.b(this.f, arrayList, Address.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void ak() {
        List list = GenericDAO.getInstance().findAllUnSyncItem(AttendenceHistory.class, this.d, this.f);
        this.a(list, " attendence history.");
        if (list != null && !list.isEmpty()) {
            this.c(Messages.getString("CloudDataUploader.36"));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (AttendenceHistory attendenceHistory : list) {
                arrayList.add(attendenceHistory.getId());
                Integer n = attendenceHistory.getTerminalId();
                attendenceHistory.setTerminal(null);
                attendenceHistory.setTerminalId(n);
                XMLTransientUtil.makeXMLTransient(attendenceHistory.getUser());
            }
            try {
                this.c.uploadData((GenericEntity)new GenericEntity<List<AttendenceHistory>>(list){}, "attendenceHistory");
                this.b(this.f, arrayList, AttendenceHistory.REF);
                this.a(arrayList.size());
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    private void a(Date date, List<Integer> list, String string) {
        GenericDAO genericDAO = GenericDAO.getInstance();
        genericDAO.updateItemsLastSyncTimeByInt(date, list, string);
    }

    private void b(Date date, List<String> list, String string) {
        GenericDAO genericDAO = GenericDAO.getInstance();
        genericDAO.updateItemsLastSyncTime(date, list, string);
    }

    private void a(Exception exception) {
        if (this.b != null) {
            this.b.printError("failed");
        }
        PosLog.error(this.getClass(), exception);
    }

    private void a(List<?> list, String string) {
        this.b(list, string);
    }

    private void b(List<?> list, String string) {
        if (list == null || list.size() == 0) {
            return;
        }
        a.info((Object)("  Uploading " + list.size() + string));
        this.e += list.size();
    }

    private void b(String string) {
        PosLog.info(this.getClass(), string);
        if (this.b == null) {
            return;
        }
        this.b.printInfo("\n" + string);
    }

    private void c(String string) {
        try {
            this.h = this.h + this.g;
            if (this.b == null) {
                return;
            }
            this.b.progress(this.h, string);
            this.b.printInfo("\n" + string);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void a(Integer n, String string) throws Exception {
        this.h = n;
        if (this.b == null) {
            return;
        }
        this.b.progress(n, string);
    }
}

