/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.ITicketList;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.config.CardConfig;
import com.floreantpos.extension.ExternalPaymentGatewayPlugin;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.GlobalInputDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.ui.views.payment.CardInputListener;
import com.floreantpos.ui.views.payment.CardInputProcessor;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.ui.views.payment.ManualCardEntryDialog;
import com.floreantpos.ui.views.payment.SwipeCardDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.SwingWorker;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class NewBarTabAction
extends AbstractAction
implements CardInputListener {
    public static final String BARTAB_TRANSACTION_ID = "bartab.transaction.id";
    private Component a;
    private OrderType b;
    private Ticket c;
    private double d;

    public NewBarTabAction(OrderType orderType, List<ShopTable> list, Component component) {
        this.b = orderType;
        this.a = component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.c = this.a();
        if (this.c == null) {
            return;
        }
        PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
        if (paymentGatewayPlugin == null || paymentGatewayPlugin instanceof ExternalPaymentGatewayPlugin) {
            this.a(this.c);
            return;
        }
        try {
            Object object;
            if (paymentGatewayPlugin.supportsPreAuth()) {
                object = Messages.getString("NewBarTabAction.11");
                int n = POSMessageDialog.showYesNoQuestionDialog(this.a, (String)object, Messages.getString("NewBarTabAction.4"));
                if (n != 0) {
                    return;
                }
                this.d = NumberSelectionDialog2.takeDoubleInput("Enter pre auth amount", false, false, 25.0);
                if (this.d < 0.0) {
                    return;
                }
            }
            if (!paymentGatewayPlugin.shouldShowCardInputProcessor()) {
                this.a(paymentGatewayPlugin);
                return;
            }
            object = CardConfig.getCardReader();
            switch (2.a[((Enum)object).ordinal()]) {
                case 1: {
                    ManualCardEntryDialog manualCardEntryDialog = new ManualCardEntryDialog(this, PaymentType.CREDIT_CARD);
                    manualCardEntryDialog.pack();
                    manualCardEntryDialog.open();
                    return;
                }
                default: {
                    SwipeCardDialog swipeCardDialog = new SwipeCardDialog(this, PaymentType.CREDIT_CARD);
                    swipeCardDialog.open();
                    return;
                }
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
            return;
        }
        finally {
            this.a(this.c);
        }
    }

    private Ticket a() {
        GlobalInputDialog globalInputDialog = new GlobalInputDialog();
        globalInputDialog.setCaption(Messages.getString("NewBarTabAction.12"));
        globalInputDialog.open();
        if (globalInputDialog.isCanceled()) {
            return null;
        }
        String string = globalInputDialog.getInput();
        if (StringUtils.isBlank((String)string)) {
            POSMessageDialog.showError(Messages.getString("POSUtil.1"));
            return null;
        }
        Ticket ticket = new Ticket(true);
        ticket.setOrderType(this.b);
        ticket.addProperty("CUSTOMER_NAME", string);
        ticket.addProperty("BARTAB_NAME", string);
        TicketDAO.getInstance().saveOrUpdate(ticket);
        return ticket;
    }

    private void a(final PaymentGatewayPlugin paymentGatewayPlugin) {
        final BusyDialog busyDialog = new BusyDialog();
        busyDialog.setCaption(Messages.getString("SettleTicketProcessor.25"));
        SwingWorker<PosTransaction, Void> swingWorker = new SwingWorker<PosTransaction, Void>(){

            @Override
            protected PosTransaction doInBackground() throws Exception {
                PosTransaction posTransaction = PaymentType.CREDIT_CARD.createTransaction();
                if (NewBarTabAction.this.c == null) {
                    return null;
                }
                NewBarTabAction.this.a(posTransaction, paymentGatewayPlugin);
                paymentGatewayPlugin.getProcessor().preAuth(posTransaction);
                return posTransaction;
            }

            @Override
            protected void done() {
                try {
                    PosTransaction posTransaction = (PosTransaction)this.get();
                    busyDialog.dispose();
                    if (posTransaction != null) {
                        NewBarTabAction.this.a(posTransaction);
                    }
                }
                catch (Exception exception) {
                    busyDialog.dispose();
                    Throwable throwable = exception.getCause();
                    if (throwable instanceof PosException) {
                        POSMessageDialog.showError(throwable.getMessage());
                    } else if (throwable instanceof StaleStateException) {
                        POSMessageDialog.showError(Messages.getString("SplitedTicketSelectionDialog.0"));
                    } else {
                        POSMessageDialog.showError(throwable.getMessage(), throwable);
                    }
                }
                finally {
                    busyDialog.dispose();
                    NewBarTabAction.this.a(NewBarTabAction.this.c);
                }
            }
        };
        swingWorker.execute();
        busyDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cardInputted(CardInputProcessor cardInputProcessor, PaymentType paymentType, String string) {
        BusyDialog busyDialog = new BusyDialog(Application.getPosWindow());
        try {
            busyDialog.setVisible(true);
            PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
            PosTransaction posTransaction = paymentType.createTransaction();
            this.a(posTransaction, paymentGatewayPlugin);
            if (this.c == null) {
                return;
            }
            CardProcessor cardProcessor = paymentGatewayPlugin.getProcessor();
            if (cardInputProcessor instanceof SwipeCardDialog) {
                SwipeCardDialog swipeCardDialog = (SwipeCardDialog)cardInputProcessor;
                String string2 = swipeCardDialog.getCardString();
                if (StringUtils.isEmpty((String)string2) || string2.length() < 16) {
                    throw new PosException(Messages.getString("SettleTicketDialog.16"));
                }
                posTransaction.setCardType(paymentType.getDisplayString());
                posTransaction.setCardTrack(string2);
                posTransaction.setCardMerchantGateway(paymentGatewayPlugin.getProductName());
                posTransaction.setCardReader(CardReader.SWIPE.name());
                cardProcessor.preAuth(posTransaction);
                this.a(posTransaction);
            } else if (cardInputProcessor instanceof ManualCardEntryDialog) {
                ManualCardEntryDialog manualCardEntryDialog = (ManualCardEntryDialog)cardInputProcessor;
                posTransaction.setCardMerchantGateway(paymentGatewayPlugin.getProductName());
                posTransaction.setCardReader(CardReader.MANUAL.name());
                posTransaction.setCardNumber(manualCardEntryDialog.getCardNo());
                posTransaction.setCardExpMonth(manualCardEntryDialog.getExpMonth());
                posTransaction.setCardExpYear(manualCardEntryDialog.getExpYear());
                cardProcessor.preAuth(posTransaction);
                this.a(posTransaction);
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
        finally {
            busyDialog.setVisible(false);
        }
    }

    private void a(PosTransaction posTransaction, PaymentGatewayPlugin paymentGatewayPlugin) {
        posTransaction.setCardMerchantGateway(paymentGatewayPlugin.getProductName());
        posTransaction.setTerminal(DataProvider.get().getCurrentTerminal());
        User user = Application.getCurrentUser();
        posTransaction.setUser(user);
        posTransaction.setServer(user);
        posTransaction.setTransactionTime(StoreDAO.getServerTimestamp());
        posTransaction.setCashDrawer(user.getActiveDrawerPullReport());
        posTransaction.setTicket(this.c);
        posTransaction.setAuthorizable(true);
        posTransaction.setCaptured(false);
        posTransaction.setTenderAmount(this.d);
        posTransaction.setAmount(this.d);
    }

    private void a(PosTransaction posTransaction) {
        PosTransactionDAO.getInstance().saveOrUpdate(posTransaction);
        Ticket ticket = posTransaction.getTicket();
        ticket.addProperty(BARTAB_TRANSACTION_ID, String.valueOf(posTransaction.getId()));
        ticket.addTotransactions(posTransaction);
        TicketDAO.getInstance().saveOrUpdate(ticket);
        if (this.a instanceof ITicketList) {
            ((ITicketList)((Object)this.a)).updateTicketList();
        }
        this.a(ticket);
    }

    private void a(Ticket ticket) {
        if (ticket == null) {
            return;
        }
        if (ticket.getId() != null) {
            ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        }
        OrderView.getInstance().setCurrentTicket(ticket);
        RootView.getInstance().showView("ORDER_VIEW");
    }
}

