/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.TransferTicketDialog;
import com.floreantpos.ui.views.order.StyledTicketSelectionDialog;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;
import java.util.List;

public class TransferTicketItemsAction
extends PosAction {
    public TransferTicketItemsAction() {
        super(Messages.getString("TransferTicketItemsAction.0"));
    }

    @Override
    public void execute() {
        try {
            List<Ticket> list = TicketDAO.getInstance().findMergableTickets(this.authorizedUser, true);
            StyledTicketSelectionDialog styledTicketSelectionDialog = new StyledTicketSelectionDialog(list);
            styledTicketSelectionDialog.setCaption(Messages.getString("TransferTicketItemsAction.1"));
            styledTicketSelectionDialog.setRequiredNumber(2);
            styledTicketSelectionDialog.openFullScreen();
            if (styledTicketSelectionDialog.isCanceled()) {
                return;
            }
            List<Ticket> list2 = styledTicketSelectionDialog.getSelectedTickets();
            if (list2.size() <= 0) {
                return;
            }
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            for (Ticket ticket : list2) {
                arrayList.add(TicketDAO.getInstance().loadFullTicket(ticket.getId()));
            }
            TransferTicketDialog transferTicketDialog = new TransferTicketDialog(arrayList);
            transferTicketDialog.setTitle(Messages.getString("TransferTicketItemsAction.2"));
            transferTicketDialog.openFullScreen();
            if (transferTicketDialog.isCanceled()) {
                return;
            }
            this.a(list2);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TransferTicketItemsAction.4"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(List<Ticket> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Items transfered among: ");
        Object object = list.iterator();
        while (object.hasNext()) {
            Ticket ticket = object.next();
            stringBuilder.append(ticket.getId());
            if (!object.hasNext()) continue;
            stringBuilder.append(", ");
        }
        object = stringBuilder.toString();
        if (((String)object).length() > 255) {
            object = ((String)object).substring(0, 255);
        }
        ActionHistoryDAO.saveHistory("Transfer items", (String)object);
    }
}

