/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.ModifierGroupExplorer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class ModifierGroupExplorerAction
extends AbstractAction {
    public ModifierGroupExplorerAction() {
        super(POSConstants.MENU_MODIFIER_GROUPS);
    }

    public ModifierGroupExplorerAction(String string) {
        super(string);
    }

    public ModifierGroupExplorerAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            ModifierGroupExplorer modifierGroupExplorer;
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            int n = jTabbedPane.indexOfTab(POSConstants.MODIFIER_GROUP_EXPLORER);
            if (n == -1) {
                modifierGroupExplorer = new ModifierGroupExplorer();
                jTabbedPane.addTab(POSConstants.MODIFIER_GROUP_EXPLORER, modifierGroupExplorer);
            } else {
                modifierGroupExplorer = (ModifierGroupExplorer)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(modifierGroupExplorer);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

