/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.Command;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.main.Application;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.SearchPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXTable;

public class ModelBrowser<E>
extends JPanel
implements ActionListener,
ListSelectionListener {
    protected JXTable browserTable;
    protected BeanEditor<E> beanEditor;
    protected SearchPanel<E> searchPanel;
    protected JPanel buttonPanel;
    protected JPanel browserPanel = new JPanel(new BorderLayout());
    protected JPanel beanPanel = new JPanel(new BorderLayout());
    protected JButton btnNew = new JButton(Messages.getString("NEW"));
    protected JButton btnEdit = new JButton(Messages.getString("EDIT"));
    protected JButton btnSave = new JButton(Messages.getString("ModelBrowser.2"));
    protected JButton btnDelete = new JButton(Messages.getString("DELETE"));
    protected JButton btnCancel = new JButton(Messages.getString("CANCEL"));
    private String a;
    private String b;
    private String c;

    public ModelBrowser() {
        this((BeanEditor<E>)null);
    }

    public ModelBrowser(BeanEditor<E> beanEditor) {
        this(beanEditor, "", "", "");
    }

    public ModelBrowser(BeanEditor<E> beanEditor, String string, String string2, String string3) {
        this.beanEditor = beanEditor;
        this.a = string;
        this.b = string2;
        this.c = string3;
    }

    public ModelBrowser(BeanEditor<E> beanEditor, SearchPanel<E> searchPanel) {
        this.beanEditor = beanEditor;
        this.searchPanel = searchPanel;
    }

    public void init(TableModel tableModel) {
        this.browserTable = new JXTable();
        this.browserTable.setRowHeight(PosUIManager.getSize(30));
        this.browserTable.getSelectionModel().setSelectionMode(0);
        this.browserTable.getSelectionModel().addListSelectionListener(this);
        this.browserTable.setDefaultRenderer(Date.class, (TableCellRenderer)new CustomCellRenderer());
        if (tableModel != null) {
            this.browserTable.setModel(tableModel);
        }
        if (this.searchPanel != null) {
            this.searchPanel.setModelBrowser(this);
            this.browserPanel.add(this.searchPanel, "North");
        }
        this.browserPanel.add(new JScrollPane((Component)this.browserTable));
        this.beanPanel.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel = new JPanel();
        if (StringUtils.isNotEmpty((String)this.a)) {
            jPanel.setLayout((LayoutManager)new MigLayout("fill,hidemode 3"));
            jPanel.add(this.beanEditor, "grow,span");
            this.setLayout((LayoutManager)new MigLayout("fill,hidemode 3", this.a));
            this.add((Component)this.browserPanel, this.b);
            this.add((Component)this.beanPanel, this.c);
        } else {
            jPanel.setLayout((LayoutManager)new MigLayout());
            jPanel.add(this.beanEditor);
            this.setLayout(new BorderLayout(10, 10));
            this.beanPanel.setPreferredSize(PosUIManager.getSize(700, 400));
            this.add(this.browserPanel);
            this.add((Component)this.beanPanel, "East");
        }
        this.beanPanel.add(jPanel);
        this.buttonPanel = new JPanel();
        JButton jButton = this.getAdditionalButton();
        if (jButton != null) {
            this.buttonPanel.add(jButton);
            jButton.addActionListener(this);
        }
        this.buttonPanel.add(this.btnNew);
        this.buttonPanel.add(this.btnEdit);
        this.buttonPanel.add(this.btnSave);
        this.buttonPanel.add(this.btnDelete);
        this.buttonPanel.add(this.btnCancel);
        this.beanPanel.add((Component)this.buttonPanel, "South");
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.btnNew.addActionListener(this);
        this.btnEdit.addActionListener(this);
        this.btnDelete.addActionListener(this);
        this.btnSave.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.btnNew.setEnabled(true);
        this.btnEdit.setEnabled(false);
        this.btnSave.setEnabled(false);
        this.btnDelete.setEnabled(false);
        this.btnCancel.setEnabled(false);
        this.beanEditor.clearFields();
        this.beanEditor.setFieldsEnable(false);
        this.refreshTable();
    }

    public void refreshTable() {
    }

    protected JButton getAdditionalButton() {
        return null;
    }

    protected void handleAdditionaButtonActionIfApplicable(ActionEvent actionEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Command command = Command.fromString(actionEvent.getActionCommand());
        try {
            switch (command) {
                case NEW: {
                    this.beanEditor.createNew();
                    this.beanEditor.setFieldsEnable(true);
                    this.btnNew.setEnabled(false);
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(true);
                    this.btnDelete.setEnabled(false);
                    this.btnCancel.setEnabled(true);
                    this.browserTable.clearSelection();
                    break;
                }
                case EDIT: {
                    this.beanEditor.edit();
                    this.beanEditor.setEnabledFalse();
                    this.beanEditor.setFieldsEnable(true);
                    this.btnNew.setEnabled(false);
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(true);
                    this.btnDelete.setEnabled(false);
                    this.btnCancel.setEnabled(true);
                    break;
                }
                case CANCEL: {
                    this.doCancelEditing();
                    break;
                }
                case SAVE: {
                    if (!this.beanEditor.save()) break;
                    OroMqttClient.getInstance().notifyDataUpdated(this.beanEditor.getBean().getClass());
                    this.beanEditor.setFieldsEnable(false);
                    this.btnNew.setEnabled(true);
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(false);
                    this.btnDelete.setEnabled(false);
                    this.btnCancel.setEnabled(false);
                    this.refreshTable();
                    break;
                }
                case DELETE: {
                    if (!this.beanEditor.delete()) break;
                    OroMqttClient.getInstance().notifyDataUpdated(this.beanEditor.getBean().getClass());
                    this.beanEditor.setBean(null);
                    this.beanEditor.setFieldsEnable(false);
                    this.btnNew.setEnabled(true);
                    this.btnEdit.setEnabled(false);
                    this.btnSave.setEnabled(false);
                    this.btnDelete.setEnabled(false);
                    this.btnCancel.setEnabled(false);
                    this.refreshTable();
                    break;
                }
            }
            this.handleAdditionaButtonActionIfApplicable(actionEvent);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public void doCancelEditing() {
        if (this.browserTable.getSelectedRow() != -1) {
            this.beanEditor.setFieldsEnable(false);
            this.btnNew.setEnabled(true);
            this.btnEdit.setEnabled(true);
            this.btnSave.setEnabled(false);
            this.btnDelete.setEnabled(true);
            this.btnCancel.setEnabled(false);
            this.beanEditor.cancel();
        } else {
            this.beanEditor.cancel();
            this.beanEditor.clearFields();
            this.beanEditor.setBean(null);
            this.beanEditor.setFieldsEnable(false);
            this.btnNew.setEnabled(true);
            this.btnEdit.setEnabled(false);
            this.btnSave.setEnabled(false);
            this.btnDelete.setEnabled(false);
            this.btnCancel.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        BeanTableModel beanTableModel = (BeanTableModel)this.browserTable.getModel();
        int n = this.browserTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        if ((n = this.browserTable.convertRowIndexToModel(n)) < 0) {
            return;
        }
        Object m = beanTableModel.getRow(n);
        this.beanEditor.setBean(m);
        this.btnNew.setEnabled(true);
        this.btnEdit.setEnabled(true);
        this.btnSave.setEnabled(false);
        this.btnDelete.setEnabled(true);
        this.btnCancel.setEnabled(false);
        this.beanEditor.setFieldsEnable(false);
    }

    public void setModels(List<E> list) {
        BeanTableModel beanTableModel = (BeanTableModel)this.browserTable.getModel();
        beanTableModel.removeAll();
        beanTableModel.addRows(list);
    }

    public BeanEditor<E> getBeanEditor() {
        return this.beanEditor;
    }

    public SearchPanel<E> getSearchPanel() {
        return this.searchPanel;
    }

    public void refreshButtonPanel() {
        this.beanEditor.clearFields();
        this.btnNew.setEnabled(true);
        this.btnEdit.setEnabled(false);
        this.btnSave.setEnabled(false);
        this.btnDelete.setEnabled(false);
        this.btnCancel.setEnabled(false);
    }
}

