/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.BeanTableExplorerView;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.ui.model.SalesAreaEntryForm;
import javax.swing.table.DefaultTableCellRenderer;

public class SalesAreaExplorer
extends BeanTableExplorerView<SalesArea> {
    public SalesAreaExplorer() {
        super(SalesArea.class);
        this.setColumnWidth(150, 100);
    }

    @Override
    public void initTableModel(BeanTableModel<SalesArea> beanTableModel) {
        beanTableModel.addColumn("NAME", SalesArea.PROP_NAME);
        beanTableModel.addColumn(Messages.getString("SalesAreaExplorer.1"), "department");
    }

    @Override
    public void initData() {
        this.setRows(SalesAreaDAO.getInstance().findAll());
    }

    @Override
    public DefaultTableCellRenderer geTableCellRenderer() {
        return new CustomCellRenderer();
    }

    @Override
    public SalesArea createNew() {
        return this.openNewForm(new SalesAreaEntryForm(new SalesArea()));
    }

    @Override
    public SalesArea editSelectedRow(SalesArea salesArea) {
        salesArea = SalesAreaDAO.getInstance().find(salesArea);
        super.checkDataValidation(salesArea.isDeleted(), salesArea.getName());
        return this.openEditForm(new SalesAreaEntryForm(salesArea));
    }

    @Override
    public boolean delete(SalesArea salesArea) {
        SalesAreaDAO.getInstance().refresh(salesArea);
        super.checkDataValidation(salesArea.isDeleted(), salesArea.getName());
        SalesAreaDAO.getInstance().delete(salesArea);
        return true;
    }
}

