/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.config.ui.PeripheralConfigurationView;
import com.floreantpos.config.ui.PrintServiceComboRenderer;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.DrawerUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class DrawerConfigurationView
extends JPanel
implements ItemListener {
    private JCheckBox a;
    private JPanel b;
    private JPanel c;
    private JRadioButton d;
    private JRadioButton e;
    private JTextField f = new JTextField(10);
    private JTextField g = new JTextField(15);
    private JLabel h;
    private JComboBox i;
    private JLabel j;
    private JComboBox k;
    private List<PrinterModel> l;
    private JTextField m = new JTextField(15);
    private JPanel n;

    public DrawerConfigurationView() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 3", "", ""));
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("PeripheralConfigurationView.4")));
        this.a = new JCheckBox(Messages.getString("TerminalConfigurationView.15"));
        this.add((Component)this.a, "span 5, wrap");
        this.n = new JPanel((LayoutManager)new MigLayout("hidemode 3", "", ""));
        JLabel jLabel = new JLabel(Messages.getString("PeripheralConfigurationView.2"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.e = new JRadioButton(KickDrawerType.Printer.getDisplayString());
        this.d = new JRadioButton(KickDrawerType.Drawer_Trigger.getDisplayString());
        this.e.addItemListener(this);
        this.d.addItemListener(this);
        buttonGroup.add(this.e);
        buttonGroup.add(this.d);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("", "0[]8[]", ""));
        jPanel.add(jLabel);
        jPanel.add(this.e);
        jPanel.add(this.d);
        this.n.add((Component)jPanel, "span 5, wrap");
        this.b = new JPanel((LayoutManager)new MigLayout("", "0[][][]", ""));
        this.b.add(new JLabel(Messages.getString("TerminalConfigurationView.25")));
        this.b.add((Component)this.f, "");
        this.b.add((Component)new JLabel(Messages.getString("TerminalConfigurationView.27")), "newline");
        this.b.add((Component)this.g, "");
        JButton jButton = new JButton(Messages.getString("TerminalConfigurationView.11"));
        jButton.addActionListener(actionEvent -> this.b());
        this.b.add(jButton);
        JButton jButton2 = new JButton(Messages.getString("TerminalConfigurationView.32"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrawerConfigurationView.this.f.setText("COM1");
                DrawerConfigurationView.this.g.setText(TerminalConfig.getDefaultDrawerControlCodes());
            }
        });
        this.b.add(jButton2);
        this.n.add(this.b);
        this.c = new JPanel((LayoutManager)new MigLayout("", "0[][][]", ""));
        this.h = new JLabel(Messages.getString("AddPrinterDialog.9"));
        this.i = new JComboBox();
        ArrayList<PrintService> arrayList = new ArrayList<PrintService>();
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        arrayList.add(null);
        for (int i = 0; i < printServiceArray.length; ++i) {
            arrayList.add(printServiceArray[i]);
        }
        this.i.setModel(new ComboBoxModel(arrayList));
        this.i.setRenderer(new PrintServiceComboRenderer());
        this.c.add((Component)this.h, "alignx trailing");
        this.c.add((Component)this.i, "growx,split 2");
        this.j = new JLabel(Messages.getString("PeripheralConfigurationView.1"));
        this.k = new JComboBox();
        this.k.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                PrinterModel printerModel = (PrinterModel)jComboBox.getSelectedItem();
                DrawerConfigurationView.this.m.setText(printerModel.drawerCode);
            }
        });
        this.c.add((Component)this.j, "newline,alignx trailing");
        this.c.add((Component)this.k, "growx,split 2");
        this.c.add(new JLabel(Messages.getString("TerminalConfigurationView.27")));
        this.c.add((Component)this.m, "");
        JButton jButton3 = new JButton(Messages.getString("TerminalConfigurationView.11"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrintService printService = (PrintService)DrawerConfigurationView.this.i.getSelectedItem();
                String string = DrawerConfigurationView.this.m.getText();
                if (printService == null) {
                    POSMessageDialog.showError(Messages.getString("DrawerConfigurationView.6"));
                    return;
                }
                if (StringUtils.isBlank((String)string)) {
                    POSMessageDialog.showError(Messages.getString("DrawerConfigurationView.7"));
                    return;
                }
                try {
                    DrawerUtil.kickDrawerUsingDevicePrinter(printService.getName(), string);
                }
                catch (Exception exception) {
                    PosLog.error(PeripheralConfigurationView.class, exception);
                    POSMessageDialog.showError(POSConstants.ERROR_MESSAGE);
                }
            }
        });
        this.c.add(jButton3);
        this.n.add(this.c);
        this.add(this.n);
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DrawerConfigurationView.this.n.setVisible(DrawerConfigurationView.this.a.isSelected());
            }
        });
    }

    public void initialize() throws Exception {
        Object object3;
        Object object22;
        this.a();
        this.k.setModel(new ComboBoxModel(this.l));
        Terminal terminal = Application.getInstance().refreshAndGetTerminal();
        this.a.setSelected(terminal.isHasCashDrawer());
        this.f.setText(TerminalConfig.getDrawerPortName());
        String string = TerminalConfig.getDrawerControlCodes();
        if (StringUtils.isNotEmpty((String)string)) {
            string = string.replaceAll("_", ",");
        }
        this.g.setText(string);
        String string2 = terminal.getProperty("cashdrawer.deviceName");
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.i.getModel();
        List list = comboBoxModel.getDataList();
        for (Object object22 : list) {
            if (object22 == null || !object22.getName().equals(string2)) continue;
            this.i.setSelectedItem(object22);
            break;
        }
        String string3 = terminal.getProperty("cashdrawer.deviceModel");
        object22 = (ComboBoxModel)this.k.getModel();
        List list2 = ((ComboBoxModel)object22).getDataList();
        for (Object object3 : list2) {
            if (!((PrinterModel)object3).model.equals(string3)) continue;
            this.k.setSelectedItem(object3);
            break;
        }
        String string4 = terminal.getProperty("cashdrawer.controlCode", "27,112,0,50,250");
        this.m.setText(string4);
        object3 = terminal.getProperty("cashdrawer.kickType");
        if (StringUtils.isNotBlank((String)object3)) {
            if (((String)object3).equals(KickDrawerType.Drawer_Trigger.name())) {
                this.d.setSelected(true);
            } else if (((String)object3).equals(KickDrawerType.Printer.name())) {
                this.e.setSelected(true);
            }
        } else {
            this.e.setSelected(true);
        }
        this.n.setVisible(terminal.isHasCashDrawer());
    }

    public boolean save(Terminal terminal) throws Exception {
        String string = null;
        if (this.a.isSelected()) {
            if (this.e.isSelected()) {
                string = KickDrawerType.Printer.name();
                PrintService printService = (PrintService)this.i.getSelectedItem();
                PrinterModel printerModel = (PrinterModel)this.k.getSelectedItem();
                String string2 = this.m.getText();
                if (printService == null) {
                    POSMessageDialog.showError(Messages.getString("DrawerConfigurationView.6"));
                    return false;
                }
                if (StringUtils.isBlank((String)string2)) {
                    POSMessageDialog.showError(Messages.getString("DrawerConfigurationView.7"));
                    return false;
                }
                terminal.addProperty("cashdrawer.deviceName", printService.getName());
                terminal.addProperty("cashdrawer.deviceModel", printerModel.model);
                terminal.addProperty("cashdrawer.controlCode", string2);
            } else if (this.d.isSelected()) {
                string = KickDrawerType.Drawer_Trigger.name();
                String string3 = this.f.getText();
                String string4 = this.g.getText();
                if (StringUtils.isBlank((String)string3)) {
                    POSMessageDialog.showError(Messages.getString("DrawerConfigurationView.8"));
                    return false;
                }
                if (StringUtils.isBlank((String)string4)) {
                    POSMessageDialog.showError(Messages.getString("DrawerConfigurationView.9"));
                    return false;
                }
                TerminalConfig.setDrawerPortName(string3);
                if (StringUtils.isNotEmpty((String)string4)) {
                    string4 = string4.replaceAll(",", "_");
                }
                TerminalConfig.setDrawerControlCodes(string4);
            }
            terminal.addProperty("cashdrawer.kickType", string);
        }
        terminal.setHasCashDrawer(this.a.isSelected());
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.d) {
            if (this.d.isSelected()) {
                this.b.setVisible(true);
                this.c.setVisible(false);
            }
        } else if (itemEvent.getSource() == this.e && this.e.isSelected()) {
            this.c.setVisible(true);
            this.b.setVisible(false);
        }
    }

    private void a() {
        this.l = new ArrayList<PrinterModel>();
        PrinterModel printerModel = new PrinterModel();
        printerModel.model = "";
        printerModel.drawerCode = "";
        this.l.add(printerModel);
        printerModel = new PrinterModel();
        printerModel.model = "Generic";
        printerModel.drawerCode = "27,112,0,50,250";
        this.l.add(printerModel);
        String string = "/util/drawer-codes.txt";
        try (InputStream inputStream = this.getClass().getResourceAsStream(string);){
            if (inputStream == null) {
                POSMessageDialog.showError("Unable to find drawer codes file " + string, new Exception("Unable to find drawer codes file " + string));
                return;
            }
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    String[] stringArray = string2.split("=");
                    PrinterModel printerModel2 = new PrinterModel();
                    printerModel2.model = stringArray[0];
                    printerModel2.drawerCode = stringArray[1];
                    this.l.add(printerModel2);
                }
            }
            catch (IOException iOException) {
                POSMessageDialog.showError("Error reading file " + string, iOException);
            }
        }
        catch (IOException iOException) {
            POSMessageDialog.showError("Unable to find drawer codes file " + string, iOException);
        }
    }

    private void b() {
        String string = this.g.getText();
        if (StringUtils.isEmpty((String)string)) {
            string = TerminalConfig.getDefaultDrawerControlCodes();
        }
        String[] stringArray = string.split(",");
        char[] cArray = new char[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                cArray[i] = (char)Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                cArray[i] = 48;
            }
        }
        DrawerUtil.kickDrawerUsingSerialPort(this.f.getText(), cArray);
    }

    public static enum KickDrawerType {
        Printer("Printer"),
        Drawer_Trigger("Drawer trigger");

        private String a;

        private KickDrawerType(String string2) {
            this.a = string2;
        }

        public String toString() {
            return this.a;
        }

        public String getDisplayString() {
            return this.a;
        }
    }

    private class PrinterModel {
        public String model;
        public String drawerCode;

        private PrinterModel() {
        }

        public String toString() {
            return this.model;
        }
    }
}

