/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.ui.ConfigurationSubEditor;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.main.PosWindow;
import com.floreantpos.main.update.UpdateManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orocube.common.util.ProductInfo;
import com.orocube.common.util.TerminalUtil;
import com.orocube.licensemanager.InvalidLicenseException;
import com.orocube.licensemanager.LicenseMode;
import com.orocube.licensemanager.LicenseNotFoundException;
import com.orocube.licensemanager.LicenseUtil;
import com.orocube.licensemanager.OroLicense;
import com.orocube.licensemanager.ui.InvalidPluginDialog;
import com.orocube.licensemanager.ui.LicenseSelectionListener;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractFloreantPlugin
implements FloreantPlugin,
ProductInfo,
LicenseSelectionListener {
    private OroLicense a;

    @Override
    public boolean requireLicense() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initLicense() {
        String string = this.getProductName();
        String string2 = this.getProductVersion();
        String string3 = TerminalUtil.getSystemUID();
        try {
            this.a = LicenseUtil.loadAndValidate((String)string, (String)string2, (String)string3);
        }
        catch (LicenseNotFoundException licenseNotFoundException) {
            this.a(string, string2, string3);
        }
        catch (InvalidLicenseException invalidLicenseException) {
            this.a();
        }
        catch (Exception exception) {
            LogFactory.getLog(this.getClass()).error((Object)exception);
        }
        finally {
            if (this.a == null) {
                this.b(string, string2);
            }
        }
    }

    private void a(String string, String string2, String string3) {
        String string4 = string + ".activation.do_not_prompt";
        boolean bl = AppConfig.getBoolean(string4, false);
        if (bl) {
            this.a(string, string2);
        } else {
            String string5 = "License for " + string + " not found. Please select a license to activate " + string + ".";
            String string6 = "Plugin license not found";
            Window window = POSUtil.getFocusedWindow();
            InvalidPluginDialog invalidPluginDialog = new InvalidPluginDialog((LicenseSelectionListener)this, (Component)window, string5, string6, string, string2, string3);
            invalidPluginDialog.setVisible(true);
            if (invalidPluginDialog.isCanceled() && invalidPluginDialog.isDoNotPromptAgain()) {
                AppConfig.put(string4, true);
                this.a(string, string2);
            }
        }
    }

    private void b(String string, String string2, String string3) {
        String string4 = string + ".invalid.license.do_not_prompt";
        boolean bl = AppConfig.getBoolean(string4, false);
        if (bl) {
            this.b(string, string2);
        } else {
            String string5 = "License for " + string + " is invalid. Please select a valid license to activate " + string + ".";
            String string6 = "Invalid license";
            Window window = POSUtil.getFocusedWindow();
            InvalidPluginDialog invalidPluginDialog = new InvalidPluginDialog((LicenseSelectionListener)this, (Component)window, string5, string6, string, string2, string3);
            invalidPluginDialog.setVisible(true);
            if (invalidPluginDialog.isCanceled() && invalidPluginDialog.isDoNotPromptAgain()) {
                AppConfig.put(string4, true);
                this.b(string, string2);
            }
        }
    }

    private void a(String string, String string2) {
        if (this.isEmbedded()) {
            this.a = new OroLicense();
            this.a.setProductName(string);
            this.a.setProductVersion(string2);
            this.a.setLicenseMode(LicenseMode.UNINILIZED);
            this.a.setValid(true);
        }
    }

    private void b(String string, String string2) {
        if (this.isEmbedded()) {
            this.a = new OroLicense();
            this.a.setProductName(string);
            this.a.setProductVersion(string2);
            this.a.setLicenseMode(LicenseMode.UNINILIZED);
            this.a.setValid(false);
        }
    }

    private void a() {
        String string = this.getProductName();
        String string2 = this.getProductVersion();
        String string3 = TerminalUtil.getOldSystemUID();
        try {
            this.a = LicenseUtil.loadAndValidate((String)string, (String)string2, (String)string3);
        }
        catch (LicenseNotFoundException licenseNotFoundException) {
            this.a(string, string2, string3);
        }
        catch (InvalidLicenseException invalidLicenseException) {
            this.b(string, string2, string3);
        }
        catch (Exception exception) {
            LogFactory.getLog(this.getClass()).error((Object)exception);
        }
    }

    public void checkForUpdate() {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        if (!this.isUpdateAvailable()) {
            POSMessageDialog.showMessage(backOfficeWindow, Messages.getString("AbstractFloreantPlugin.2"));
            return;
        }
        String string = this.getProductName();
        String string2 = this.getProductVersion();
        Integer n = this.getProductNumericVersion();
        if (n == null) {
            return;
        }
        String string3 = this.getUpdateServerURL();
        UpdateManager updateManager = new UpdateManager();
        updateManager.setParentWindow(backOfficeWindow == null ? Application.getPosWindow() : backOfficeWindow);
        updateManager.checkForPluginUpdate(string3, string, string2, n);
    }

    public boolean isUpdateAvailable() {
        String string = this.getProductName();
        String string2 = this.getProductVersion();
        Integer n = this.getProductNumericVersion();
        if (n == null) {
            return false;
        }
        String string3 = this.getUpdateServerURL();
        UpdateManager updateManager = new UpdateManager();
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        updateManager.setParentWindow(backOfficeWindow == null ? Application.getPosWindow() : backOfficeWindow);
        return updateManager.isUpdateAvailable(string3, string, string2, n);
    }

    @Override
    public abstract String getId();

    @Override
    public abstract String getProductName();

    public abstract String getProductVersion();

    public abstract Integer getProductNumericVersion();

    public abstract Component getParent();

    public abstract String getUpdateServerURL();

    @Override
    public void licenseFileSelected(File file) throws Exception {
        try {
            OroLicense oroLicense = LicenseUtil.loadAndValidate((File)file, (String)this.getProductName(), (String)this.getProductVersion(), (String)TerminalUtil.getSystemUID());
            LicenseUtil.copyLicenseFile((File)file, (String)this.getProductName());
            this.setLicense(oroLicense);
        }
        catch (Exception exception) {
            LogFactory.getLog(this.getClass()).error((Object)exception);
            throw exception;
        }
    }

    @Override
    public boolean hasValidLicense() {
        if (this.a != null) {
            if (this.a.isDemoLicense()) {
                return this.a.isValid() && this.a.isPinVarified();
            }
            return this.a.isValid();
        }
        return false;
    }

    @Override
    public OroLicense getLicense() {
        return this.a;
    }

    @Override
    public void setLicense(OroLicense oroLicense) {
        this.a = oroLicense;
    }

    @Override
    public boolean isActivated() {
        return this.getLicense() != null && this.getLicense().getLicenseMode() != LicenseMode.UNINILIZED;
    }

    @Override
    public void initBackoffice(BackOfficeWindow backOfficeWindow) {
    }

    @Override
    public void initConfigurationView(JDialog jDialog) {
    }

    @Override
    public List<AbstractAction> getSpecialFunctionActions() {
        return null;
    }

    @Override
    public List<ConfigurationSubEditor> getSubEditors() {
        return null;
    }

    @Override
    public void initUI(PosWindow posWindow) {
    }

    @Override
    public void restartPOS(boolean bl) {
    }
}

