/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension.cronjob;

import com.floreantpos.PosLog;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.extension.cronjob.CronJobPlugin;
import com.floreantpos.extension.cronjob.StoreCloseJob;
import com.floreantpos.licensing.LicenseCheckerJob;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.CronJobDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.util.DataProvider;
import java.util.List;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;

public class OroCronJobManager {
    private static OroCronJobManager a;
    private Scheduler b;
    private boolean c;

    private OroCronJobManager() {
        try {
            StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
            this.b = stdSchedulerFactory.getScheduler();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public static OroCronJobManager getInstance() {
        return a == null ? (a = new OroCronJobManager()) : a;
    }

    private CronTrigger a(CronJob cronJob, TriggerBuilder triggerBuilder) {
        if (triggerBuilder == null) {
            triggerBuilder = TriggerBuilder.newTrigger().withIdentity(cronJob.getId(), cronJob.getJobId());
        }
        if (cronJob.getFrequency().equalsIgnoreCase("DAILY")) {
            triggerBuilder = triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.dailyAtHourAndMinute((int)Integer.parseInt(cronJob.getExecutionTime().split(":")[0]), (int)Integer.parseInt(cronJob.getExecutionTime().split(":")[1])));
        } else if (cronJob.getFrequency().equalsIgnoreCase("WEEKLY")) {
            triggerBuilder = triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.weeklyOnDayAndHourAndMinute((int)1, (int)Integer.parseInt(cronJob.getExecutionTime().split(":")[0]), (int)Integer.parseInt(cronJob.getExecutionTime().split(":")[1])));
        } else if (cronJob.getFrequency().equalsIgnoreCase("MONTHLY")) {
            triggerBuilder = triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.monthlyOnDayAndHourAndMinute((int)1, (int)Integer.parseInt(cronJob.getExecutionTime().split(":")[0]), (int)Integer.parseInt(cronJob.getExecutionTime().split(":")[1])));
        } else if (cronJob.getFrequency().equalsIgnoreCase("EVERY")) {
            if (Integer.parseInt(cronJob.getExecutionTime().split(":")[0]) == -1) {
                triggerBuilder = triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)("0 0/" + Integer.parseInt(cronJob.getExecutionTime().split(":")[1]) + " * * * ?")));
            } else if (Integer.parseInt(cronJob.getExecutionTime().split(":")[1]) == -1) {
                triggerBuilder = triggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)("0 0 0/" + Integer.parseInt(cronJob.getExecutionTime().split(":")[0]) + " * * ?")));
            }
        }
        return (CronTrigger)triggerBuilder.build();
    }

    public boolean scheduleJob(CronJob cronJob) {
        boolean bl = false;
        try {
            if (!this.c) {
                this.startScheduler();
            }
            if (cronJob.isActive().booleanValue() && cronJob.isExecutionTimeValid()) {
                this.b.scheduleJob(JobBuilder.newJob(cronJob.getClass()).withIdentity(cronJob.getId(), cronJob.getJobId()).build(), (Trigger)this.a(cronJob, (TriggerBuilder)null));
            }
            CronJobDAO.getInstance().saveOrUpdate(cronJob);
            bl = true;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        return bl;
    }

    public boolean reScheduleJob(CronJob cronJob) {
        boolean bl = false;
        try {
            if (!this.c) {
                this.startScheduler();
            }
            TriggerKey triggerKey = TriggerKey.triggerKey((String)cronJob.getId(), (String)cronJob.getJobId());
            if (cronJob.isActive().booleanValue()) {
                if (this.b.getTrigger(triggerKey) == null) {
                    this.b.scheduleJob(JobBuilder.newJob(cronJob.getClass()).withIdentity(cronJob.getId(), cronJob.getJobId()).build(), (Trigger)this.a(cronJob, (TriggerBuilder)null));
                } else {
                    this.b.rescheduleJob(triggerKey, (Trigger)this.a(cronJob, this.b.getTrigger(triggerKey).getTriggerBuilder().withIdentity(cronJob.getId(), cronJob.getJobId())));
                }
            } else if (this.b.getTrigger(triggerKey) != null) {
                this.b.deleteJob(JobKey.jobKey((String)cronJob.getId(), (String)cronJob.getJobId()));
            }
            CronJobDAO.getInstance().saveOrUpdate(cronJob);
            bl = true;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        return bl;
    }

    public boolean deleteJob(CronJob cronJob) {
        boolean bl = false;
        try {
            if (!this.c) {
                this.startScheduler();
            }
            this.b.deleteJob(JobKey.jobKey((String)cronJob.getId(), (String)cronJob.getJobId()));
            CronJobDAO.getInstance().delete(cronJob.getId());
            bl = true;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        return bl;
    }

    private void a() {
        try {
            List<CronJob> list = CronJobDAO.getInstance().findAllActive();
            List<FloreantPlugin> list2 = ExtensionManager.getPlugins(CronJobPlugin.class);
            if (list != null && list.size() > 0) {
                list.forEach(cronJob -> list2.forEach(floreantPlugin -> {
                    if (cronJob.getJobId().trim().equals(((CronJobPlugin)floreantPlugin).getId().trim())) {
                        try {
                            ((CronJobPlugin)floreantPlugin).setCronJob((CronJob)cronJob);
                            CronJob cronJob2 = ((CronJobPlugin)floreantPlugin).convertToActualCronJob();
                            if (cronJob2.isActive().booleanValue() && cronJob2.isExecutionTimeValid()) {
                                JobDetail jobDetail = JobBuilder.newJob(cronJob2.getClass()).withIdentity(cronJob2.getId(), cronJob2.getJobId()).build();
                                this.b.scheduleJob(jobDetail, (Trigger)this.a(cronJob2, (TriggerBuilder)null));
                            }
                        }
                        catch (Exception exception) {
                            PosLog.error(this.getClass(), exception);
                        }
                    }
                }));
                PosLog.info(OroCronJobManager.class, "All jobs are started successfully.");
            } else {
                PosLog.info(OroCronJobManager.class, "There have no scheduled job to start.");
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public void startScheduler() {
        if (this.c) {
            return;
        }
        try {
            this.b.start();
            PosLog.info(OroCronJobManager.class, "Cron Job Manager Started Successfully.");
            this.a();
            this.c = true;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public void shutdownScheduler() {
        try {
            if (!this.c) {
                return;
            }
            this.b.shutdown();
            PosLog.info(OroCronJobManager.class, "Cron Job Manager Shutted Down Successfully.");
            this.c = false;
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public void startLicenseCheckingJob() throws SchedulerException {
        JobBuilder jobBuilder = JobBuilder.newJob(LicenseCheckerJob.class);
        CronTrigger cronTrigger = this.a((CronJob)new LicenseCheckerJob(), (TriggerBuilder)null);
        StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
        stdSchedulerFactory.getScheduler().scheduleJob(jobBuilder.build(), (Trigger)cronTrigger);
    }

    public void startStoreCloseJob() throws SchedulerException {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        if (!terminal.isMasterTerminal().booleanValue()) {
            return;
        }
        Outlet outlet = DataProvider.get().getOutlet();
        OutletDAO.getInstance().refresh(outlet);
        Boolean bl = outlet.isAutoCloseStore();
        if (bl.booleanValue()) {
            String string = outlet.getAutoCloseStoreTime();
            JobBuilder jobBuilder = JobBuilder.newJob(StoreCloseJob.class);
            CronTrigger cronTrigger = this.a((CronJob)new StoreCloseJob(string), (TriggerBuilder)null);
            this.b.scheduleJob(jobBuilder.build(), (Trigger)cronTrigger);
        }
    }

    public static void rescheduleJob(CronJob cronJob) throws SchedulerException {
        Scheduler scheduler = OroCronJobManager.getInstance().b;
        CronTrigger cronTrigger = OroCronJobManager.getInstance().a(cronJob, (TriggerBuilder)null);
        if (scheduler.checkExists(cronTrigger.getKey())) {
            scheduler.rescheduleJob(cronTrigger.getKey(), (Trigger)cronTrigger);
        } else {
            JobBuilder jobBuilder = JobBuilder.newJob(cronJob.getClass());
            scheduler.scheduleJob(jobBuilder.build(), (Trigger)cronTrigger);
        }
    }
}

