/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.licensing;

import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.licensing.ProductLicenseInfo;
import com.floreantpos.main.Application;
import com.floreantpos.model.CronJob;
import com.orocube.licensemanager.OroLicense;
import java.util.List;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class LicenseCheckerJob
extends CronJob {
    public LicenseCheckerJob() {
        this.setId("license-validation-checker");
        this.setFrequency("Every");
        this.setExecutionTime("-1:1");
    }

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        OroLicense oroLicense = Application.getInstance().getLicense();
        ProductLicenseInfo productLicenseInfo = new ProductLicenseInfo(oroLicense);
        if (productLicenseInfo.willExpireInSevenDays() || productLicenseInfo.isExpired()) {
            Application.getPosWindow().updateVissabityOfLicenceInfo(true);
            return;
        }
        List<FloreantPlugin> list = ExtensionManager.getPlugins();
        for (FloreantPlugin floreantPlugin : list) {
            ProductLicenseInfo productLicenseInfo2;
            OroLicense oroLicense2;
            if (!floreantPlugin.requireLicense() || !floreantPlugin.hasValidLicense() || (oroLicense2 = floreantPlugin.getLicense()) == null || !(productLicenseInfo2 = new ProductLicenseInfo(oroLicense2)).willExpireInSevenDays()) continue;
            Application.getPosWindow().updateVissabityOfLicenceInfo(true);
            return;
        }
        Application.getPosWindow().updateVissabityOfLicenceInfo(false);
    }
}

