/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.floreantpos.config.CardConfig;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.Department;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.ReversalTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.VoidTransaction;
import com.floreantpos.model.base.BasePosTransaction;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

@XmlSeeAlso(value={CashTransaction.class, CustomPaymentTransaction.class, GiftCertificateTransaction.class, CreditCardTransaction.class, DebitCardTransaction.class, CashDropTransaction.class, RefundTransaction.class, PayOutTransaction.class, VoidTransaction.class, CustomerAccountTransaction.class, ReversalTransaction.class})
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true, value={"ticketItems", "terminal", "properties", "cashDrawer"})
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="classType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=CashTransaction.class), @JsonSubTypes.Type(value=CustomPaymentTransaction.class), @JsonSubTypes.Type(value=GiftCertificateTransaction.class), @JsonSubTypes.Type(value=CreditCardTransaction.class), @JsonSubTypes.Type(value=DebitCardTransaction.class), @JsonSubTypes.Type(value=CashDropTransaction.class), @JsonSubTypes.Type(value=RefundTransaction.class), @JsonSubTypes.Type(value=PayOutTransaction.class), @JsonSubTypes.Type(value=VoidTransaction.class), @JsonSubTypes.Type(value=CustomerAccountTransaction.class), @JsonSubTypes.Type(value=ReversalTransaction.class)})
public class PosTransaction
extends BasePosTransaction {
    public static final String JSON_PROP_GIFT_CARD_GIFT_CARD_BALANCE_ADD_INFO = "gift_card_balance_add_info";
    public static final String JSON_PROP_GIFT_CARD_ADDED_AMOUNT = "addedAmount";
    public static final String JSON_PROP_GIFT_CARD_GIFT_CARD_NO = "giftCardNo";
    public static final String JSON_PROP_GIFT_CARD_TICKET_ITEM_ID = "ticketItemId";
    private static final long serialVersionUID = 1L;
    private transient boolean refunded = false;
    private transient boolean syncEdited;
    private CashDrawer cashDrawer;
    private transient JsonObject propertiesContainer;
    private String cardTrack;
    private String cardNo;
    private String cardExpYear;
    private String cardExpMonth;
    private String cardCVV;
    public static final String CASH = "CASH";
    public static final String GIFT_CERT = "GIFT_CERT";
    public static final String CREDIT_CARD = "CREDIT_CARD";
    public static final String DEBIT_CARD = "DEBIT_CARD";
    public static final String CASH_DROP = "CASH_DROP";
    public static final String REFUND = "REFUND";
    public static final String PAY_OUT = "PAY_OUT";
    public static final String VOID_TRANS = "VOID_TRANS";
    public static final String GIFT_CARD_BALANCE_ADD = "GIFT_CARD_BALANCE_ADD";
    public static final String PROP_CASH_BACK_POSTFIX = "_CASH_BACK";
    public static final String PROP_TENDERED_POSTFIX = "_TENDERED";
    public static final String JSON_PROP_REFUNDED_AMOUNT = "REFUNDED_AMOUNT";
    public static final String TRANSACTION_FEE = "transactionFee";
    private static final String JSON_PROP_GIFT_CARD_NUMBER = "gift_card_number";
    private static final String JSON_PROP_GIFT_CARD_BALANCE_AMOUNT = "gift_card_balance_amount";
    private transient String ticketId;
    private String classType;

    public PosTransaction() {
    }

    public PosTransaction(String string) {
        super(string);
    }

    public PosTransaction(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    @Override
    public String getTransactionType() {
        String string = super.getTransactionType();
        if (StringUtils.isEmpty((String)string)) {
            return TransactionType.CREDIT.name();
        }
        return string;
    }

    public void updateTerminalBalance() {
        Terminal terminal = this.getTerminal();
        if (terminal == null) {
            return;
        }
        Double d = this.getAmount();
        if (d == null || d == 0.0) {
            return;
        }
    }

    public boolean isCard() {
        return this instanceof CreditCardTransaction || this instanceof DebitCardTransaction;
    }

    public void addProperty(String string, String string2) {
        this.addExtraProperty(string, string2);
    }

    public boolean hasProperty(String string) {
        return this.getExtraProperty(string) != null;
    }

    public String getProperty(String string) {
        return this.getExtraProperty(string);
    }

    public String getProperty(String string, String string2) {
        if (this.getExtraProperties() == null) {
            return string2;
        }
        String string3 = this.getExtraProperty(string);
        if (StringUtils.isEmpty((String)string3)) {
            return string2;
        }
        return string3;
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getExtraProperty(string);
        return POSUtil.getBoolean(string2);
    }

    public void removeProperty(String string) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(string);
        }
    }

    public Double calculateTotalAmount() {
        return this.getAmount() + this.getTipsAmount();
    }

    public Double calculateAuthorizeAmount() {
        double d = CardConfig.getAdvanceTipsPercentage();
        return this.getTenderAmount() + this.getTenderAmount() * (d / 100.0);
    }

    @XmlTransient
    public String getCardTrack() {
        return this.cardTrack;
    }

    public void setCardTrack(String string) {
        this.cardTrack = string;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public void setCardNo(String string) {
        this.cardNo = string;
    }

    public String getCardExpYear() {
        return this.cardExpYear;
    }

    public void setCardExpYear(String string) {
        this.cardExpYear = string;
    }

    public String getCardExpMonth() {
        return this.cardExpMonth;
    }

    public void setCardExpMonth(String string) {
        this.cardExpMonth = string;
    }

    public String getCardCVV() {
        return this.cardCVV;
    }

    public void setCardCVV(String string) {
        this.cardCVV = string;
    }

    public String getGlobalId() {
        return super.getId();
    }

    public String getTicketId() {
        if (StringUtils.isNotEmpty((String)this.ticketId)) {
            return this.ticketId;
        }
        Ticket ticket = this.getTicket();
        if (ticket == null) {
            return "";
        }
        return ticket.getId();
    }

    public void setTicketId(String string) {
        this.ticketId = string;
    }

    public void calculateTaxAmount() {
        if (this.getAmount() <= 0.0) {
            return;
        }
        Ticket ticket = this.getTicket();
        if (ticket == null || ticket.getTotalAmount() <= 0.0 || this.isVoided().booleanValue() || this instanceof RefundTransaction) {
            return;
        }
        this.setTaxAmount(NumberUtil.roundToTwoDigit((this.getAmountWithTolerance() - this.getTipsAmount()) * ticket.getTaxAmount() / ticket.getTotalAmount()));
    }

    public void calculateServiceChargeAmount() {
        if (this.getAmount() <= 0.0) {
            return;
        }
        Ticket ticket = this.getTicket();
        if (ticket == null || ticket.getServiceCharge() <= 0.0 || this.isVoided().booleanValue() || this instanceof RefundTransaction) {
            return;
        }
        this.setServiceChargeAmount(NumberUtil.roundToTwoDigit((this.getAmountWithTolerance() - this.getTipsAmount()) * ticket.getServiceCharge() / ticket.getTotalAmount()));
    }

    public boolean isRefunded() {
        return this.refunded;
    }

    public void setRefunded(boolean bl) {
        this.refunded = bl;
    }

    @XmlTransient
    public Department getDepartment() {
        return DataProvider.get().getDepartmentById(this.getDepartmentId());
    }

    public void setDepartment(Department department) {
        String string = null;
        if (department != null) {
            string = department.getId();
        }
        super.setDepartmentId(string);
    }

    @XmlTransient
    public Terminal getTerminal() {
        return DataProvider.get().getTerminalById(this.getTerminalId());
    }

    public void setTerminal(Terminal terminal) {
        Integer n = null;
        if (terminal != null) {
            n = terminal.getId();
        }
        super.setTerminalId(n);
    }

    @XmlTransient
    public User getUser() {
        return DataProvider.get().getUserById(this.getUserId());
    }

    public void setUser(User user) {
        String string = null;
        if (user != null) {
            string = user.getId();
        }
        super.setUserId(string);
    }

    public void setServer(User user) {
        if (user == null) {
            this.setServerId(null);
        } else {
            this.setServerId(user.getId());
        }
    }

    public void setCashDrawer(CashDrawer cashDrawer) {
        this.cashDrawer = cashDrawer;
        if (cashDrawer != null) {
            super.setCashDrawerId(cashDrawer.getId());
        }
    }

    @XmlTransient
    public CashDrawer getCashDrawer() {
        if (this.cashDrawer != null) {
            return this.cashDrawer;
        }
        return CashDrawerDAO.getInstance().get(this.getCashDrawerId());
    }

    public boolean isSyncEdited() {
        return this.syncEdited;
    }

    public void setSyncEdited(boolean bl) {
        this.syncEdited = bl;
    }

    public void setPaymentType(PaymentType paymentType) {
        if (paymentType != null) {
            this.setPaymentTypeString(paymentType.name());
        } else {
            this.setPaymentTypeString(null);
        }
    }

    @XmlTransient
    public PaymentType getPaymentType() {
        String string = super.getPaymentTypeString();
        if (string == null) {
            return null;
        }
        try {
            return PaymentType.valueOf(string);
        }
        catch (Exception exception) {
            return PaymentType.fromDisplayString(string);
        }
    }

    public double getAmountWithTolerance() {
        return super.getAmount() - super.getToleranceAmount();
    }

    @Override
    public String getExtraProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getExtraProperties();
        if (StringUtils.isBlank((String)string)) {
            this.propertiesContainer = new JsonObject();
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setExtraProperties(String string) {
        super.setExtraProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    public void addExtraProperty(String string, String string2) {
        if (StringUtils.isEmpty((String)string2)) {
            return;
        }
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        this.propertiesContainer.addProperty(string, string2);
    }

    public String getExtraProperty(String string) {
        JsonElement jsonElement;
        if (this.propertiesContainer == null) {
            this.getExtraProperties();
        }
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    @Override
    @XmlTransient
    public Map<String, String> getProperties() {
        return super.getProperties();
    }

    public String getClassType() {
        return this.classType;
    }

    public void setClassType(String string) {
        this.classType = string;
    }

    public double getGiftCardBalanceId() {
        return POSUtil.getDoubleAmount(this.getProperty(JSON_PROP_GIFT_CARD_NUMBER));
    }

    public void setGiftCardBalanceNumber(String string) {
        this.addProperty(JSON_PROP_GIFT_CARD_NUMBER, String.valueOf(string));
    }

    public double getGiftCardBalanceAmount() {
        return POSUtil.parseDouble(this.getProperty(JSON_PROP_GIFT_CARD_BALANCE_AMOUNT));
    }

    public void setGiftCardBalanceAmount(double d) {
        this.addProperty(JSON_PROP_GIFT_CARD_BALANCE_AMOUNT, String.valueOf(d));
    }

    public void addGiftCardBalanceAddInfo(String string, String string2, double d) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(JSON_PROP_GIFT_CARD_TICKET_ITEM_ID, (Object)string);
        jSONObject.put(JSON_PROP_GIFT_CARD_GIFT_CARD_NO, (Object)string2);
        jSONObject.put(JSON_PROP_GIFT_CARD_ADDED_AMOUNT, d);
        String string3 = this.getGiftCardBalanceAddInfo();
        if (StringUtils.isBlank((String)string3)) {
            JSONArray jSONArray = new JSONArray();
            jSONArray.put((Object)jSONObject);
            this.addProperty(JSON_PROP_GIFT_CARD_GIFT_CARD_BALANCE_ADD_INFO, jSONArray.toString());
        } else {
            JSONArray jSONArray = new JSONArray(string3);
            jSONArray.put((Object)jSONObject);
            this.addProperty(JSON_PROP_GIFT_CARD_GIFT_CARD_BALANCE_ADD_INFO, jSONArray.toString());
        }
    }

    public String getGiftCardBalanceAddInfo() {
        return this.getProperty(JSON_PROP_GIFT_CARD_GIFT_CARD_BALANCE_ADD_INFO);
    }

    public Double getRefundedAmount() {
        String string = this.getProperty(JSON_PROP_REFUNDED_AMOUNT);
        if (StringUtils.isNotEmpty((String)string)) {
            try {
                return NumberUtil.parseDouble(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0.0;
    }

    public Double getRefundableAmount() {
        return this.getAmount() - this.getRefundedAmount();
    }
}

