/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseVoidItem;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@JsonIgnoreProperties(ignoreUnknown=true, value={"voidedModifiers", "printerGroup", "voidByUser"})
@XmlRootElement
public class VoidItem
extends BaseVoidItem
implements TimedModel {
    private static final long serialVersionUID = 1L;
    private String itemId;
    private boolean cooked;
    private Double taxAmount;
    private List<VoidItem> voidedModifiers;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public VoidItem() {
    }

    public VoidItem(String string) {
        super(string);
    }

    public VoidItem(String string, boolean bl, double d) {
        this.setVoidReason(string);
        this.setItemWasted(bl);
        this.setQuantity(d);
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String string) {
        this.itemId = string;
    }

    public boolean isCooked() {
        return this.cooked;
    }

    public void setCooked(boolean bl) {
        this.cooked = bl;
    }

    public Double getTaxAmount() {
        return this.taxAmount == null ? new Double(0.0) : this.taxAmount;
    }

    public void setTaxAmount(Double d) {
        this.taxAmount = d;
    }

    @Override
    public void setTotalPrice(Double d) {
        super.setTotalPrice(NumberUtil.roundToTwoDigit(d));
    }

    public void setVoidModifiers(List<VoidItem> list) {
        this.voidedModifiers = list;
    }

    @XmlTransient
    public List<VoidItem> getVoidedModifiers() {
        return this.voidedModifiers;
    }

    @XmlTransient
    public PrinterGroup getPrinterGroup() {
        if (super.getPrinterGroupId() == null) {
            return null;
        }
        return DataProvider.get().getPrinterGroupById(this.getPrinterGroupId());
    }

    public void setPrinterGroup(PrinterGroup printerGroup) {
        this.setPrinterGroupId(printerGroup == null ? null : printerGroup.getId());
    }

    public void setTerminal(Terminal terminal) {
        this.setTerminalId(terminal == null ? null : terminal.getId());
    }

    @XmlTransient
    public User getVoidByUser() {
        if (this.getVoidByUserId() == null) {
            return null;
        }
        return DataProvider.get().getUserById(this.getVoidByUserId());
    }

    public void setVoidByUser(User user) {
        this.setVoidByUserId(user == null ? null : user.getId());
    }
}

