/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.dao.BasePriceTableDAO;
import com.floreantpos.model.dao.PriceRuleDAO;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;

public class PriceTableDAO
extends BasePriceTableDAO {
    private static final String EMPTY_STRING = "";
    private static final String EMPTY_NEWLINE_STRING = "\n";
    private static final String EMPTY_DOT_STRING = ".";
    private static final String EMPTY_SPACE_STRING = " ";

    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        if (object instanceof PriceTable) {
            PriceTable priceTable = (PriceTable)object;
            this.checkForeignRelation(priceTable, session);
            priceTable.setDeleted(Boolean.TRUE);
            super.update(priceTable, session);
        } else {
            super.delete(object, session);
        }
    }

    private void checkForeignRelation(PriceTable priceTable, Session session) {
        List<PriceRule> list = PriceRuleDAO.getInstance().getPriceRulesByPriceTable(priceTable, session);
        if (list != null && !list.isEmpty()) {
            String string = priceTable.getName() + EMPTY_SPACE_STRING + Messages.getString("PriceTableDAO.4");
            String string2 = this.constructExceptionDetailsByMenuItems(priceTable, list);
            throw new PosException(string, string2);
        }
    }

    private String constructExceptionDetailsByMenuItems(PriceTable priceTable, List<PriceRule> list) {
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(priceTable.getName() + EMPTY_SPACE_STRING + Messages.getString("PriceTableDAO.5"));
            for (int i = 0; i < list.size(); ++i) {
                String string = i + 1 + EMPTY_DOT_STRING + EMPTY_SPACE_STRING + list.get(i).getName();
                stringBuilder.append(EMPTY_NEWLINE_STRING).append(string);
            }
            return stringBuilder.toString();
        }
        return EMPTY_STRING;
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    public List<PriceTable> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    @Deprecated
    public void releaseParentAndDelete(PriceTable priceTable) {
        this.delete(priceTable);
    }
}

