/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.TerminalPrinters;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.dao.BaseVirtualPrinterDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class VirtualPrinterDAO
extends BaseVirtualPrinterDAO {
    private static final String EMPTY_STRING = "";
    private static final String EMPTY_DOT_STRING = ".";
    private static final String EMPTY_NEWLINE_STRING = "\n";
    private static final String EMPTY_SPACE_STRING = " ";

    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        if (object instanceof VirtualPrinter) {
            VirtualPrinter virtualPrinter = (VirtualPrinter)object;
            List<PrinterGroup> list = PrinterGroupDAO.getInstance().getPrinterGroupsByVirtualPrinter(virtualPrinter, session);
            if (list != null && !list.isEmpty()) {
                String string = virtualPrinter.getName() + EMPTY_SPACE_STRING + Messages.getString("VirtualPrinterDAO.0");
                String string2 = this.constructExceptionDetailsByPrinterGroups(virtualPrinter, list);
                throw new PosException(string, string2);
            }
            virtualPrinter.setDeleted(Boolean.TRUE);
            super.update(virtualPrinter, session);
            this.deleteTerminalPrinters(virtualPrinter, session);
        } else {
            super.delete(object, session);
        }
    }

    private void deleteTerminalPrinters(VirtualPrinter virtualPrinter, Session session) {
        String string = "DELETE FROM %s TP WHERE TP.%s = :printer";
        string = String.format(string, TerminalPrinters.REF, TerminalPrinters.PROP_VIRTUAL_PRINTER);
        Query query = session.createQuery(string);
        query.setParameter("printer", (Object)virtualPrinter);
        query.executeUpdate();
    }

    private String constructExceptionDetailsByPrinterGroups(VirtualPrinter virtualPrinter, List<PrinterGroup> list) {
        if (list != null && !list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(virtualPrinter.getName() + EMPTY_SPACE_STRING + Messages.getString("VirtualPrinterDAO.3"));
            for (int i = 0; i < list.size(); ++i) {
                String string = i + 1 + EMPTY_DOT_STRING + EMPTY_SPACE_STRING + list.get(i).getName();
                stringBuilder.append(EMPTY_NEWLINE_STRING).append(string);
            }
            return stringBuilder.toString();
        }
        return EMPTY_STRING;
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    public List<VirtualPrinter> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    public void saveOrUpdateVirtualPrinter(List<VirtualPrinter> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (VirtualPrinter virtualPrinter : list) {
                VirtualPrinter virtualPrinter2 = this.get(virtualPrinter.getId());
                if (virtualPrinter2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(virtualPrinter.getLastUpdateTime(), virtualPrinter2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), virtualPrinter.getName() + " already updated");
                        continue;
                    }
                    long l = virtualPrinter2.getVersion();
                    PropertyUtils.copyProperties((Object)virtualPrinter2, (Object)virtualPrinter);
                    virtualPrinter2.setVersion(l);
                    virtualPrinter2.setUpdateLastUpdateTime(bl);
                    virtualPrinter2.setUpdateSyncTime(bl2);
                    this.update(virtualPrinter2);
                    continue;
                }
                virtualPrinter.setVersion(0L);
                virtualPrinter.setUpdateLastUpdateTime(bl);
                virtualPrinter.setUpdateSyncTime(bl2);
                this.save(virtualPrinter);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
    }

    public VirtualPrinter findPrinterByName(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)VirtualPrinter.PROP_NAME, (Object)string));
            VirtualPrinter virtualPrinter = (VirtualPrinter)criteria.uniqueResult();
            return virtualPrinter;
        }
    }

    public List<VirtualPrinter> findKitchenPrinters() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)VirtualPrinter.PROP_TYPE, (Object)2));
            List list = criteria.list();
            return list;
        }
    }

    public VirtualPrinter findAReceiptPrinter() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)VirtualPrinter.PROP_TYPE, (Object)1));
            List list = criteria.list();
            if (list.size() > 0) {
                VirtualPrinter virtualPrinter = (VirtualPrinter)list.get(0);
                return virtualPrinter;
            }
            VirtualPrinter virtualPrinter = null;
            return virtualPrinter;
        }
    }
}

