/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.DrawerPullVoidEntry;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.dao.BaseVoidItemDAO;
import com.floreantpos.model.dao.KitchenTicketDAO;
import com.floreantpos.model.dao.KitchenTicketItemDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.util.CopyUtil;
import com.floreantpos.util.NumberUtil;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.ResultTransformer;

public class VoidItemDAO
extends BaseVoidItemDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    public void saveOrUpdateVoidItem(List<VoidItem> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (VoidItem voidItem : list) {
                VoidItem voidItem2 = this.get(voidItem.getId());
                if (voidItem2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(voidItem.getLastUpdateTime(), voidItem2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), voidItem.getMenuItemName() + " already updated");
                        continue;
                    }
                    long l = voidItem2.getVersion();
                    PropertyUtils.copyProperties((Object)voidItem2, (Object)voidItem);
                    voidItem2.setVersion(l);
                    voidItem2.setUpdateLastUpdateTime(bl);
                    voidItem2.setUpdateSyncTime(bl2);
                    this.update(voidItem2);
                    continue;
                }
                voidItem.setVersion(0L);
                voidItem.setUpdateLastUpdateTime(bl);
                voidItem.setUpdateSyncTime(bl2);
                this.save(voidItem);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveVoidItems(List<VoidItem> list, Ticket ticket) {
        Transaction transaction = null;
        try (Session session = null;){
            CashDrawer cashDrawer = Application.getCurrentUser().getActiveDrawerPullReport();
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (VoidItem voidItem : list) {
                List<KitchenTicketItem> list2;
                Double d = Math.abs(voidItem.getTotalPrice());
                ticket.setVoidAmount(ticket.getVoidAmount() + d);
                voidItem.setTicketId(ticket.getId());
                voidItem.setCashDrawerId(cashDrawer.getId());
                if (voidItem.getItemId() != null && (list2 = KitchenTicketItemDAO.getInstance().find(voidItem.getItemId(), voidItem.isModifier(), session)) != null) {
                    for (KitchenTicketItem kitchenTicketItem : list2) {
                        KitchenTicket kitchenTicket = kitchenTicketItem.getKitchenTicket();
                        if (voidItem.getQuantity() < kitchenTicketItem.getQuantity()) {
                            KitchenTicketItem kitchenTicketItem2 = (KitchenTicketItem)CopyUtil.deepCopy(kitchenTicketItem);
                            kitchenTicketItem2.setId(null);
                            kitchenTicketItem2.setQuantity(kitchenTicketItem.getQuantity() - voidItem.getQuantity());
                            kitchenTicket.addToticketItems(kitchenTicketItem2);
                            session.save((Object)kitchenTicketItem2);
                        }
                        if (kitchenTicketItem.getStatus().equalsIgnoreCase(KitchenStatus.BUMP.name())) {
                            voidItem.setCooked(true);
                        }
                        kitchenTicketItem.setVoided(true);
                        session.update((Object)kitchenTicketItem);
                    }
                }
                session.saveOrUpdate((Object)voidItem);
            }
            TicketDAO.getInstance().updateStock(ticket, session);
            session.saveOrUpdate((Object)ticket);
            transaction.commit();
        }
    }

    public void saveVoidItems(List<VoidItem> list, Session session) {
        for (VoidItem voidItem : list) {
            session.saveOrUpdate((Object)voidItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VoidItem> findByDate(Date date, Date date2, Terminal terminal) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)VoidItem.PROP_VOID_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)VoidItem.PROP_VOID_DATE, (Object)date2));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)VoidItem.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<DrawerPullVoidEntry> getVoidEntries(CashDrawer cashDrawer) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(cashDrawer.getId());
        return this.getVoidEntries(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DrawerPullVoidEntry> getVoidEntries(List<String> list) {
        if (list.isEmpty()) {
            return new ArrayList<DrawerPullVoidEntry>();
        }
        Session session = null;
        Criteria criteria = null;
        try {
            Object object;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.countDistinct((String)VoidItem.PROP_TICKET_ID));
            projectionList.add((Projection)Projections.sum((String)VoidItem.PROP_QUANTITY));
            projectionList.add((Projection)Projections.sum((String)VoidItem.PROP_TOTAL_PRICE));
            projectionList.add((Projection)Projections.groupProperty((String)VoidItem.PROP_ITEM_WASTED));
            if (list.size() == 1) {
                criteria.add((Criterion)Restrictions.eq((String)VoidItem.PROP_CASH_DRAWER_ID, (Object)list.get(0)));
            } else {
                object = Restrictions.disjunction();
                for (String string : list) {
                    object.add((Criterion)Restrictions.eq((String)VoidItem.PROP_CASH_DRAWER_ID, (Object)string));
                }
                criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.isNotNull((String)VoidItem.PROP_CASH_DRAWER_ID), (Criterion)object));
            }
            object = new ResultTransformer(){

                public Object transformTuple(Object[] objectArray, String[] stringArray) {
                    DrawerPullVoidEntry drawerPullVoidEntry = new DrawerPullVoidEntry();
                    drawerPullVoidEntry.setCheckCount(Double.valueOf("" + objectArray[0]));
                    drawerPullVoidEntry.setQuantity(Double.valueOf("" + objectArray[1]));
                    drawerPullVoidEntry.setAmount(Double.valueOf("" + objectArray[2]));
                    drawerPullVoidEntry.setReason((Boolean.valueOf("" + objectArray[3]) == true ? Messages.getString("TOTAL_WASTE") : Messages.getString("TOTAL_VOID")) + (drawerPullVoidEntry.getCheckCount() > 0.0 ? " (" + NumberUtil.trimDecilamIfNotNeeded(drawerPullVoidEntry.getCheckCount()) + ")" : ""));
                    return drawerPullVoidEntry;
                }

                public List transformList(List list) {
                    return list;
                }
            };
            criteria.setProjection((Projection)projectionList).setResultTransformer((ResultTransformer)object);
            List list2 = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VoidItem> getVoidItems(String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)VoidItem.PROP_TICKET_ID, (Object)string));
            List list = criteria.list();
            if (list.isEmpty()) {
                List<VoidItem> list2 = null;
                return list2;
            }
            List list3 = list;
            return list3;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveAndSentToKitchenIfNeeded(VoidItem voidItem, boolean bl, Ticket ticket, Session session) {
        Double d = Math.abs(voidItem.getTotalPrice());
        ticket.setVoidAmount(ticket.getVoidAmount() + d);
        voidItem.setTicketId(ticket.getId());
        if (voidItem.getItemId() != null) {
            this.saveAndSentToKitchenIfNeeded(voidItem, session);
        }
        this.saveOrUpdate(voidItem, session);
    }

    public void saveAndSentToKitchenIfNeeded(VoidItem voidItem, Session session) {
        List<KitchenTicketItem> list = KitchenTicketItemDAO.getInstance().find(voidItem.getItemId(), voidItem.isModifier(), session);
        if (list != null) {
            HashSet<KitchenTicket> hashSet = new HashSet<KitchenTicket>();
            for (KitchenTicketItem comparable : list) {
                KitchenTicket kitchenTicket = comparable.getKitchenTicket();
                hashSet.add(kitchenTicket);
                if (voidItem.getQuantity() < comparable.getQuantity()) {
                    try {
                        KitchenTicketItem kitchenTicketItem = (KitchenTicketItem)CopyUtil.deepCopy(comparable);
                        kitchenTicketItem.setId(null);
                        kitchenTicketItem.setQuantity(comparable.getQuantity() - voidItem.getQuantity());
                        kitchenTicket.addToticketItems(kitchenTicketItem);
                    }
                    catch (Exception exception) {
                        PosLog.error(this.getClass(), exception);
                    }
                }
                if (comparable.getStatus().equalsIgnoreCase(KitchenStatus.BUMP.name())) {
                    voidItem.setCooked(true);
                }
                comparable.setVoided(true);
            }
            for (KitchenTicket kitchenTicket : hashSet) {
                KitchenTicketDAO.getInstance().update(kitchenTicket, session);
            }
        }
    }

    public void deleteAndSentToKitchenIfNeeded(VoidItem voidItem, boolean bl, Ticket ticket, Session session) {
        voidItem.setTicketId(ticket.getId());
        if (voidItem.getItemId() != null) {
            this.saveAndSentToKitchenIfNeeded(voidItem, session);
        }
        this.delete(voidItem, session);
    }
}

