/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services.report;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.CashInTransaction;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class StoreSessionSummaryReportService {
    private StoreSession a;
    private Session b;
    private CashDrawer c = new CashDrawer();

    public StoreSessionSummaryReportService(StoreSession storeSession) {
        this.a = storeSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CashDrawer populateStoreSessionSummaryReport() {
        GenericDAO genericDAO = new GenericDAO();
        try {
            this.b = genericDAO.createNewSession();
            this.j();
            this.a();
            this.b();
            this.c();
            double d = this.c.getCashTips() + this.c.getChargedTips();
            double d2 = this.c.getNetSales() - this.c.getTotalDiscountAmount() + this.c.getSalesTax() + this.c.getServiceCharge();
            this.c.setTotalRevenue(POSUtil.getRoundedDouble(d2));
            this.c.setGrossReceipts(POSUtil.getRoundedDouble(this.c.getTotalRevenue() + d));
            this.d();
            this.e();
            this.f();
            this.r();
            this.g();
            this.h();
            this.i();
            this.k();
            this.n();
            this.o();
            this.q();
            this.p();
            this.v();
            double d3 = this.c.getCashReceiptAmount() + this.c.getCreditCardReceiptAmount() + this.c.getDebitCardReceiptAmount() + this.c.getCustomerPaymentAmount() + this.c.getCustomPaymentAmount() + this.c.getPromotionAmount() + this.c.getGiftCertChangeAmount() - this.c.getRefundAmount() - this.c.getToleranceAmount();
            this.c.setReceiptDifferential(POSUtil.getRoundedDouble(this.c.getGrossReceipts() - d3));
            this.c.setAssignedUser(this.a.getOpenedBy());
            this.c.setStartTime(this.a.getOpenTime());
            this.c.setAssignedBy(this.a.getOpenedBy());
            this.c.setReportTime(this.a.getCloseTime());
            this.c.setClosedBy(this.a.getClosedBy());
            this.c.setStoreOperationData(this.a);
            this.t();
            this.u();
            this.l();
            this.m();
            this.s();
            CashDrawer cashDrawer = this.c;
            return cashDrawer;
        }
        finally {
            if (this.b != null) {
                this.b.close();
            }
        }
    }

    private Criteria a(Class clazz) {
        Criteria criteria = this.b.createCriteria(clazz);
        if (clazz.equals(RefundTransaction.class)) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
        } else if (clazz.equals(PayOutTransaction.class) || clazz.equals(CashDropTransaction.class)) {
            LogicalExpression logicalExpression = Restrictions.or((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()), (Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.OUT.name()));
            criteria.add((Criterion)logicalExpression);
        } else if (clazz.equals(CashInTransaction.class)) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.IN.name()));
        } else {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        }
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        return criteria;
    }

    private void a() {
        Criteria criteria = this.b.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.ne((String)Ticket.PROP_VOIDED, (Object)Boolean.TRUE));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_SUBTOTAL_AMOUNT));
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_TAX_AMOUNT));
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_SERVICE_CHARGE));
        projectionList.add((Projection)Projections.sum((String)Ticket.PROP_DISCOUNT_AMOUNT));
        criteria.setProjection((Projection)projectionList);
        List list = criteria.list();
        for (Object[] objectArray : list) {
            double d = objectArray[0] != null ? ((Number)objectArray[0]).doubleValue() : 0.0;
            double d2 = objectArray[1] != null ? ((Number)objectArray[1]).doubleValue() : 0.0;
            double d3 = objectArray[2] != null ? ((Number)objectArray[2]).doubleValue() : 0.0;
            double d4 = objectArray[3] != null ? ((Number)objectArray[3]).doubleValue() : 0.0;
            this.c.setNetSales(NumberUtil.round(d));
            this.c.setSalesTax(NumberUtil.round(d2));
            this.c.setServiceCharge(NumberUtil.round(d3));
            this.c.setTotalDiscountAmount(NumberUtil.round(d4));
        }
    }

    private void b() {
        Criteria criteria = this.a(CashTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        this.c.setCashTips(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void c() {
        Criteria criteria = this.a(PosTransaction.class);
        criteria.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        this.c.setChargedTips(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void d() {
        Criteria criteria = this.a(CashTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        this.c.setCashReceiptAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void e() {
        Criteria criteria = this.a(CreditCardTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        this.c.setCreditCardReceiptAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void f() {
        Criteria criteria = this.a(DebitCardTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        this.c.setDebitCardReceiptAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void g() {
        Criteria criteria = this.a(CustomPaymentTransaction.class);
        criteria.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.PROMOTION.name()));
        criteria.setProjection((Projection)Projections.sum((String)CustomPaymentTransaction.PROP_AMOUNT));
        this.c.setCustomPaymentAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void h() {
        Criteria criteria = this.a(CustomPaymentTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.PROMOTION.name()));
        criteria.setProjection((Projection)Projections.sum((String)CustomPaymentTransaction.PROP_AMOUNT));
        this.c.setPromotionAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void i() {
        Criteria criteria = this.a(GiftCertificateTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_AMOUNT));
        this.c.setGiftCertChangeAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void j() {
        Criteria criteria = this.a(RefundTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        this.c.setRefundAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void k() {
        Criteria criteria = this.b.createCriteria(PosTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.TRUE));
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        this.c.setCardVoidAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void l() {
        Criteria criteria = this.b.createCriteria(CashDrawer.class);
        criteria.add((Criterion)Restrictions.eq((String)CashDrawer.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.setProjection((Projection)Projections.sum((String)CashDrawer.PROP_BEGIN_CASH));
        this.c.setBeginCash(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void m() {
        Criteria criteria = this.a(CashInTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)CashInTransaction.PROP_AMOUNT));
        this.c.setCashInAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void n() {
        Criteria criteria = this.b.createCriteria(GratuityPaymentHistory.class);
        criteria.add((Criterion)Restrictions.eq((String)GratuityPaymentHistory.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.setProjection((Projection)Projections.sum((String)GratuityPaymentHistory.PROP_AMOUNT));
        this.c.setTipsPaid(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void o() {
        Criteria criteria = this.a(PayOutTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PayOutTransaction.PROP_AMOUNT));
        this.c.setPayOutAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void p() {
        Criteria criteria = this.a(CashDropTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)CashDropTransaction.PROP_AMOUNT));
        this.c.setDrawerBleedAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void q() {
        Criteria criteria = this.a(RefundTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        this.c.setCashBack(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void r() {
        Criteria criteria = this.a(CustomerAccountTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.MEMBER_ACCOUNT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        this.c.setCustomerPaymentAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void s() {
        double d = this.c.getCashReceiptAmount() - this.c.getTipsPaid() - this.c.getPayOutAmount() - this.c.getCashBack() + this.c.getBeginCash() + this.c.getCashInAmount() - this.c.getDrawerBleedAmount();
        this.c.setDrawerAccountable(POSUtil.getRoundedDouble(d));
    }

    private void t() {
        double d = this.c.getCashTips() + this.c.getChargedTips() - this.c.getTipsPaid();
        this.c.setTipsDifferential(POSUtil.getRoundedDouble(d));
    }

    private void u() {
        Criteria criteria = this.b.createCriteria(DeclaredTips.class);
        criteria.add((Criterion)Restrictions.eq((String)DeclaredTips.PROP_SESSION_ID, (Object)this.a.getId()));
        criteria.setProjection((Projection)Projections.sum((String)CashDropTransaction.PROP_AMOUNT));
        this.c.setDeclaredTips(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void v() {
        Criteria criteria = this.a(CashTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TOLERANCE_AMOUNT));
        this.c.setToleranceAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    public static CashDrawer createSessionSummaryReport(StoreSession storeSession) throws Exception {
        StoreSessionSummaryReportService storeSessionSummaryReportService = new StoreSessionSummaryReportService(storeSession);
        CashDrawer cashDrawer = storeSessionSummaryReportService.populateStoreSessionSummaryReport();
        return cashDrawer;
    }
}

