/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.ITicketList;
import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosBlinkButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.GlobalInputDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicScrollBarUI;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class CustomerTicketListView
extends JPanel
implements ITicketList,
DataChangeListener {
    private JXTable a = new JXTable();
    private PosButton b;
    private PosButton c;
    private PosBlinkButton d;
    private BeanTableModel<Ticket> e;
    private JScrollBar f;
    private String g;

    public CustomerTicketListView(String string) {
        this.g = string;
        this.setLayout(new BorderLayout());
        this.a();
    }

    private void a() {
        this.a.setSortable(true);
        this.a.setSelectionMode(0);
        this.a.setColumnControlVisible(true);
        this.e = new BeanTableModel(Ticket.class);
        this.e.addColumn(POSConstants.ID, Ticket.PROP_ID);
        this.e.addColumn(POSConstants.SERVER, "owner");
        this.e.addColumn(POSConstants.CREATED, Ticket.PROP_CREATE_DATE, 10, BeanTableModel.DataType.DATE);
        this.e.addColumn(POSConstants.CUSTOMER, "customer");
        this.e.addColumn(POSConstants.TOTAL, Ticket.PROP_TOTAL_AMOUNT, 4, BeanTableModel.DataType.MONEY);
        this.a.setModel(this.e);
        this.e.setPageSize(50);
        this.a.setAutoResizeMode(3);
        this.a.setGridColor(Color.LIGHT_GRAY);
        this.a.getTableHeader().setPreferredSize(new Dimension(100, PosUIManager.getSize(40)));
        this.e.initTableRenderer((JTable)this.a);
        this.a.setRowHeight(PosUIManager.getSize(60));
        this.b();
    }

    private void b() {
        this.d = new PosBlinkButton(IconFactory.getIcon("/ui_icons/", "refresh-16.png"));
        this.b = new PosButton(IconFactory.getIcon("/ui_icons/", "previous-24.png"));
        this.c = new PosButton(IconFactory.getIcon("/ui_icons/", "next-24.png"));
        this.createActionHandlers();
        PosScrollPane posScrollPane = new PosScrollPane((Component)this.a, 20, 31);
        posScrollPane.getVerticalScrollBar().setUI(new CustomScrollbarUI());
        int n = PosUIManager.getSize(40);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "grow", ""));
        jPanel.add((Component)this.d, "h " + n + "!, grow, wrap");
        jPanel.add((Component)this.b, "h " + n + "!, grow, wrap");
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("ins 0", "grow", ""));
        jPanel2.add((Component)this.c, "h " + n + "!, grow,gaptop 5, wrap");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        jPanel3.setPreferredSize(PosUIManager.getSize(48, 0));
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel2, "South");
        this.f = posScrollPane.getVerticalScrollBar();
        posScrollPane.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CustomerTicketListView.this.f.repaint();
            }
        });
        jPanel3.add(this.f);
        this.add(posScrollPane);
        this.add((Component)jPanel3, "East");
    }

    public void createActionHandlers() {
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomerTicketListView.this.e.hasPrevious()) {
                    CustomerTicketListView.this.e.setCurrentRowIndex(CustomerTicketListView.this.e.getPreviousRowIndex());
                    CustomerTicketListView.this.updateTicketList();
                }
                CustomerTicketListView.this.updateButtonStatus();
            }
        });
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomerTicketListView.this.e.hasNext()) {
                    CustomerTicketListView.this.e.setCurrentRowIndex(CustomerTicketListView.this.e.getNextRowIndex());
                    CustomerTicketListView.this.updateTicketList();
                }
                CustomerTicketListView.this.updateButtonStatus();
            }
        });
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomerTicketListView.this.e.setCurrentRowIndex(0);
                CustomerTicketListView.this.updateTicketList();
            }
        });
    }

    public void updateButtonStatus() {
        this.c.setEnabled(this.e.hasNext());
        this.b.setEnabled(this.e.hasPrevious());
    }

    @Override
    public synchronized void updateTicketList() {
        try {
            List<Ticket> list = TicketDAO.getInstance().findCustomerTickets(this.g, this.e);
            this.e.setRows(list);
            this.d.setBlinking(false);
            this.updateButtonStatus();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, Messages.getString("SwitchboardView.19"), exception);
        }
    }

    @Override
    public Ticket getSelectedTicket() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            return null;
        }
        return this.e.getRow(this.a.convertRowIndexToModel(n));
    }

    public List<Ticket> getSelectedTickets() {
        ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
        Ticket ticket = this.getSelectedTicket();
        if (ticket == null) {
            return null;
        }
        arrayList.add(ticket);
        return arrayList;
    }

    public Ticket getFirstSelectedTicket() {
        List<Ticket> list = this.getSelectedTickets();
        if (list == null || list.size() == 0) {
            return null;
        }
        Ticket ticket = list.get(0);
        return ticket;
    }

    public String getFirstSelectedTicketId() {
        Ticket ticket = this.getFirstSelectedTicket();
        if (ticket == null) {
            return null;
        }
        return ticket.getId();
    }

    public JXTable getTable() {
        return this.a;
    }

    public void setCurrentRowIndexZero() {
        this.e.setCurrentRowIndex(0);
    }

    @Override
    public Object getSelectedData() {
        Ticket ticket = this.getSelectedTicket();
        if (ticket == null) {
            GlobalInputDialog globalInputDialog = new GlobalInputDialog(Application.getPosWindow());
            globalInputDialog.setCaption(Messages.getString("TicketListView.20"));
            globalInputDialog.open();
            if (globalInputDialog.isCanceled()) {
                return null;
            }
            String string = globalInputDialog.getInput();
            ticket = TicketService.getTicket(string);
        }
        return ticket;
    }

    @Override
    public void dataSetUpdated() {
        this.updateTicketList();
    }

    @Override
    public void dataChangeCanceled(Object object) {
        if (object == null) {
            return;
        }
        Ticket ticket = (Ticket)object;
        if (ticket.getId() == null) {
            return;
        }
        ticket = TicketDAO.getInstance().get(ticket.getId());
        this.dataChanged(ticket);
    }

    @Override
    public void dataAdded(Object object) {
    }

    @Override
    public void dataChanged(Object object) {
    }

    @Override
    public void dataRemoved(Object object) {
    }

    class CustomScrollbarUI
    extends BasicScrollBarUI {
        private ImageIcon b;
        private ImageIcon c = IconFactory.getIcon("/ui_icons/", "up.png");

        public CustomScrollbarUI() {
            this.b = IconFactory.getIcon("/ui_icons/", "down.png");
        }

        @Override
        protected JButton createDecreaseButton(int n) {
            PosButton posButton = new PosButton(this.a(n)){

                @Override
                public Dimension getPreferredSize() {
                    return PosUIManager.getSize(40, 40);
                }

                @Override
                public boolean isVisible() {
                    this.setEnabled(CustomScrollbarUI.this.thumbRect.getY() > 0.0);
                    return super.isVisible();
                }
            };
            return posButton;
        }

        @Override
        protected JButton createIncreaseButton(int n) {
            PosButton posButton = new PosButton(this.a(n)){

                @Override
                public Dimension getPreferredSize() {
                    return PosUIManager.getSize(40, 40);
                }

                @Override
                public boolean isVisible() {
                    this.setEnabled(CustomScrollbarUI.this.thumbRect.getY() > 0.0);
                    return super.isVisible();
                }
            };
            return posButton;
        }

        private ImageIcon a(int n) {
            switch (n) {
                case 5: {
                    return this.b;
                }
                case 1: {
                    return this.c;
                }
            }
            return this.c;
        }
    }
}

