/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.actions.CacheDataUpdateAction;
import com.floreantpos.actions.ClockInOutAction;
import com.floreantpos.actions.HomeScreenViewAction;
import com.floreantpos.actions.LogoutAction;
import com.floreantpos.actions.ShowBackofficeAction;
import com.floreantpos.actions.ShowGiftCardAction;
import com.floreantpos.actions.ShowQuickSettingsAction;
import com.floreantpos.actions.ShowSpecialFunctionsAction;
import com.floreantpos.actions.ShutDownAction;
import com.floreantpos.actions.SwithboardViewAction;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosBlinkButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.util.OrgJsonUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.JSONObject;

public class HeaderPanel
extends JPanel
implements IMqttMessageListener {
    private PosButton a;
    private PosBlinkButton b;
    private PosButton c;
    private PosButton d;
    private PosButton e;
    private PosButton f;
    private PosButton g;
    private PosButton h;
    private PosButton i;
    private JPanel j;
    private int k;
    private JLabel l;
    private PosButton m;

    public HeaderPanel() {
        super(new BorderLayout(0, 0));
        this.a();
    }

    private void a() {
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.l = new JLabel();
        this.l.setOpaque(false);
        this.l.setFont(this.l.getFont().deriveFont(1, PosUIManager.getFontSize(16)));
        this.l.setHorizontalAlignment(0);
        this.l.setVerticalAlignment(0);
        this.j = new JPanel((LayoutManager)new MigLayout("hidemode 3, aligny center, alignx right", "sg,fill", ""));
        this.j.setBackground(Color.white);
        JLabel jLabel = new JLabel(IconFactory.getIcon("/icons/", "header_logo.png"));
        this.add((Component)jLabel, "West");
        this.k = PosUIManager.getSize(50);
        this.i = new PosButton(new ShowQuickSettingsAction(false, true));
        this.i.setToolTipText(Messages.getString("HeaderPanel.9"));
        this.j.add((Component)this.i, "w " + this.k + "!, h " + this.k + "!");
        this.a = new PosButton(new HomeScreenViewAction(false, true));
        this.a.setToolTipText(Messages.getString("HeaderPanel.2"));
        this.j.add((Component)this.a, "w " + this.k + "!, h " + this.k + "!");
        this.b = new PosBlinkButton();
        this.b.setAction(new CacheDataUpdateAction(false, true));
        this.b.setToolTipText(Messages.getString("HeaderPanel.3"));
        this.j.add((Component)this.b, "w " + this.k + "!, h " + this.k + "!");
        this.m = new PosButton(new ShowGiftCardAction(true));
        this.m.setToolTipText(Messages.getString("HeaderPanel.8"));
        this.j.add((Component)this.m, "w " + this.k + "!, h " + this.k + "!");
        this.e = new PosButton(new SwithboardViewAction(false, true));
        this.e.setToolTipText(Messages.getString("HeaderPanel.4"));
        this.j.add((Component)this.e, "w " + this.k + "!, h " + this.k + "!");
        this.d = new PosButton(new ShowSpecialFunctionsAction(false, true));
        this.d.setToolTipText(Messages.getString("HeaderPanel.5"));
        this.j.add((Component)this.d, "w " + this.k + "!, h " + this.k + "!");
        this.c = new PosButton(new ShowBackofficeAction(false, true));
        this.c.setToolTipText(Messages.getString("HeaderPanel.6"));
        this.j.add((Component)this.c, "w " + this.k + "!, h " + this.k + "!");
        this.g = new PosButton(new ClockInOutAction(false, true));
        this.g.setToolTipText(Messages.getString("HeaderPanel.7"));
        this.j.add((Component)this.g, "w " + this.k + "!, h " + this.k + "!");
        this.f = new PosButton(new LogoutAction(false, true));
        this.f.setToolTipText(Messages.getString("Logout"));
        this.j.add((Component)this.f, "w " + this.k + "!, h " + this.k + "!");
        this.h = new PosButton(new ShutDownAction(false, true));
        this.h.setIcon(IconFactory.getIcon("/ui_icons/", "shutdown.png"));
        this.h.setToolTipText(Messages.getString("Shutdown"));
        this.j.add((Component)this.h, "w " + this.k + "!, h " + this.k + "!");
        this.add((Component)this.j, "East");
        this.add((Component)this.l, "Center");
        this.add((Component)new JSeparator(0), "South");
        this.setPreferredSize(PosUIManager.getSize(100, 62));
    }

    public void subscribeToNotificationService() {
        try {
            OroMqttClient.getInstance().subscribeToStore("MQTT-COMMAND-REFRESH-CACHE", 0, this);
            OroMqttClient.getInstance().subscribeToStore("MQTT-COMMAND-STORE-CLOSED", 0, this);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageArrived(String string, MqttMessage mqttMessage) throws Exception {
        if (string.endsWith("MQTT-COMMAND-REFRESH-CACHE")) {
            if (Application.getPosWindow().isVisible()) {
                this.b.setBlinking(true);
            }
            if (POSUtil.getBackOfficeWindow() != null && BackOfficeWindow.getInstance().isVisible()) {
                BackOfficeWindow.getInstance().blinkCacheRefreshButton();
            }
        } else if (string.endsWith("MQTT-COMMAND-STORE-CLOSED")) {
            try {
                if (!Application.getPosWindow().isShowing()) {
                    return;
                }
                Application.getPosWindow().setGlassPaneVisible(true);
                JSONObject jSONObject = new JSONObject(mqttMessage.toString());
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("HeaderPanel.10") + " " + OrgJsonUtil.getString(jSONObject, "terminalName"));
                new LogoutAction(true, false).execute();
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
            finally {
                Application.getPosWindow().setGlassPaneVisible(false);
            }
        }
    }

    public void updateOthersFunctionsView(boolean bl) {
        this.j.removeAll();
        this.j.add((Component)this.a, "w " + this.k + "!, h " + this.k + "!");
        this.j.add((Component)this.b, "w " + this.k + "!, h " + this.k + "!");
        this.j.add((Component)this.m, "w " + this.k + "!, h " + this.k + "!");
        this.j.add((Component)this.d, "w " + this.k + "!, h " + this.k + "!");
        this.j.add((Component)this.e, "w " + this.k + "!, h " + this.k + "!");
        this.j.add((Component)this.c, "w " + this.k + "!, h " + this.k + "!");
        this.j.add((Component)this.g, "w " + this.k + "!, h " + this.k + "!");
        this.j.add((Component)this.f, "w " + this.k + "!, h " + this.k + "!");
        this.j.add((Component)this.h, "w " + this.k + "!, h " + this.k + "!");
        this.d.setVisible(bl);
        this.m.setVisible(TerminalConfig.isShouldShowShowGiftCardOnHeader());
        this.initRestaurantName();
    }

    public void updateSwitchBoardView(boolean bl) {
        this.j.removeAll();
        this.j.add((Component)this.i, "w " + this.k + "!, h " + this.k + "!");
        this.j.add((Component)this.a, "w " + this.k + "!, h " + this.k + "!");
        this.j.add((Component)this.b, "w " + this.k + "!, h " + this.k + "!");
        this.j.add((Component)this.m, "w " + this.k + "!, h " + this.k + "!");
        this.j.add((Component)this.d, "w " + this.k + "!, h " + this.k + "!");
        this.j.add((Component)this.e, "w " + this.k + "!, h " + this.k + "!");
        this.j.add((Component)this.c, "w " + this.k + "!, h " + this.k + "!");
        this.j.add((Component)this.g, "w " + this.k + "!, h " + this.k + "!");
        this.j.add((Component)this.f, "w " + this.k + "!, h " + this.k + "!");
        this.j.add((Component)this.h, "w " + this.k + "!, h " + this.k + "!");
        this.e.setVisible(bl);
        this.m.setVisible(TerminalConfig.isShouldShowShowGiftCardOnHeader());
        this.initRestaurantName();
    }

    public void updateHomeView(boolean bl) {
        this.a.setVisible(bl);
        this.initRestaurantName();
    }

    public void setSelected_86(boolean bl) {
        OrderView.getInstance().set_86Mode(bl);
    }

    public void initRestaurantName() {
        Store store = DataProvider.get().getStore();
        if (store != null && StringUtils.isNotEmpty((String)store.getName())) {
            this.l.setText(store.getName());
        }
    }
}

