/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.swing.POSFileChooser;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.ImageUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;

public class ImageUploaderDialog
extends POSDialog {
    public static String LAST_USED_FOLDER = "";
    private ImageResource.IMAGE_CATEGORY b = ImageResource.IMAGE_CATEGORY.PRODUCTS;
    private JLabel c;
    private JLabel d;
    private ImageResource e;
    private POSTextField f;
    private POSToggleButton g;
    private POSToggleButton h;
    private POSToggleButton i;
    private POSToggleButton j;
    private JPanel k;
    private ArrayList<byte[]> l;
    private boolean m;
    private JProgressBar n;
    private JLabel o;
    private PosButton p;
    private POSFileChooser q = null;
    boolean a = false;

    public ImageUploaderDialog(ImageResource imageResource, ImageResource.IMAGE_CATEGORY iMAGE_CATEGORY) {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.b = iMAGE_CATEGORY;
        this.e = imageResource;
        this.a();
        this.d();
    }

    public ImageUploaderDialog(ImageResource imageResource) {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.e = imageResource;
        this.a();
        this.d();
    }

    public ImageUploaderDialog(ImageResource.IMAGE_CATEGORY iMAGE_CATEGORY) {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.b = iMAGE_CATEGORY;
        this.a();
        this.d();
        this.m = true;
    }

    public ImageUploaderDialog() {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.a();
        this.d();
        this.m = true;
    }

    private void a() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("ImageUploaderDialog.1"));
        this.add((Component)titlePanel, "North");
        JPanel jPanel = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.g = new POSToggleButton(Messages.getString("ImageUploaderDialog.2"));
        this.h = new POSToggleButton(Messages.getString("ImageUploaderDialog.3"));
        this.i = new POSToggleButton(Messages.getString("ImageUploaderDialog.4"));
        this.j = new POSToggleButton(Messages.getString("ImageUploaderDialog.5"));
        buttonGroup.add(this.g);
        buttonGroup.add(this.h);
        buttonGroup.add(this.i);
        buttonGroup.add(this.j);
        jPanel.add(this.g);
        jPanel.add(this.h);
        jPanel.add(this.i);
        jPanel.add(this.j);
        this.i.setEnabled(true);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.setBorder(new EmptyBorder(20, 5, 20, 5));
        jPanel2.add((Component)jPanel, "North");
        this.c = new JLabel();
        this.d = new JLabel(Messages.getString("ImageUploaderDialog.6"));
        this.f = new POSTextField(50);
        this.k = new JPanel(new FlowLayout());
        this.k.add((Component)this.c, "center");
        JScrollPane jScrollPane = new JScrollPane(this.k, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(350, 220));
        jScrollPane.setVisible(true);
        jPanel2.add(jScrollPane);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        jPanel3.setLayout(new BorderLayout(5, 0));
        jPanel3.add((Component)this.d, "West");
        jPanel3.add((Component)this.f, "Center");
        jPanel2.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("fillx, hidemode 3", "[grow][grow][grow]", ""));
        this.n = new JProgressBar();
        this.n.setBounds(40, 40, 160, 30);
        this.n.setValue(0);
        this.n.setMinimum(0);
        this.n.setStringPainted(true);
        this.n.setVisible(false);
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 20));
        this.p = new PosButton(Messages.getString("ImageUploaderDialog.11"));
        this.p.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (!ImageUploaderDialog.this.m) {
                        ImageUploaderDialog.this.selectImage();
                    } else {
                        ImageUploaderDialog.this.selectBulkImage();
                    }
                }
                catch (PosException posException) {
                    POSMessageDialog.showError(posException.getMessage());
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(exception.getMessage(), exception);
                }
            }
        });
        PosButton posButton = new PosButton(Messages.getString("ImageUploaderDialog.15"));
        posButton.setPreferredSize(PosUIManager.getSize(100, 0));
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageUploaderDialog.this.doOk();
                ImageUploaderDialog.this.setCanceled(false);
            }
        });
        PosButton posButton2 = new PosButton(Messages.getString("ImageUploaderDialog.16"));
        posButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageUploaderDialog.this.setCanceled(true);
                ImageUploaderDialog.this.dispose();
            }
        });
        this.o = new JLabel(Messages.getString("ImageUploaderDialog.17"));
        this.o.setVisible(false);
        jPanel4.add((Component)this.p, "");
        jPanel4.add((Component)this.o, "left,split 2");
        jPanel4.add((Component)this.n, "");
        jPanel4.add((Component)posButton, "growy,right,skip 2, split 2");
        jPanel4.add((Component)posButton2, "");
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel4, "South");
    }

    public void doOk() {
        if (!this.m) {
            this.b();
            ImageResourceDAO.getInstance().saveOrUpdate(this.e);
            OroMqttClient.getInstance().notifyDataUpdated(ImageResource.class);
        } else {
            this.doSaveMultipleImage();
        }
        this.dispose();
    }

    private void b() {
        try {
            byte[] byArray;
            if (this.e == null) {
                this.e = new ImageResource();
            }
            if ((byArray = (byte[])this.c.getClientProperty("image")) != null) {
                this.e.setImageBytes(byArray);
            }
            this.e.setDescription(this.f.getText());
            if (this.g.isSelected()) {
                this.e.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.UNLISTED.getType());
                this.b = ImageResource.IMAGE_CATEGORY.UNLISTED;
            } else if (this.h.isSelected()) {
                this.e.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType());
                this.b = ImageResource.IMAGE_CATEGORY.FLOORPLAN;
            } else if (this.j.isSelected()) {
                this.e.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PEOPLE.getType());
                this.b = ImageResource.IMAGE_CATEGORY.PEOPLE;
            } else if (this.i.isSelected()) {
                this.e.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PRODUCTS.getType());
                this.b = ImageResource.IMAGE_CATEGORY.PRODUCTS;
            } else {
                this.e.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PRODUCTS.getType());
                this.b = ImageResource.IMAGE_CATEGORY.PRODUCTS;
            }
        }
        catch (Exception exception) {
            PosLog.error(ImageUploaderDialog.class, exception.getMessage(), exception);
        }
    }

    public void doSaveMultipleImage() {
        try {
            ArrayList<ImageResource> arrayList = new ArrayList<ImageResource>();
            for (byte[] byArray : this.l) {
                this.e = new ImageResource();
                if (byArray != null) {
                    this.e.setImageBytes(byArray);
                }
                if (this.g.isSelected()) {
                    this.e.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.UNLISTED.getType());
                    this.b = ImageResource.IMAGE_CATEGORY.UNLISTED;
                } else if (this.h.isSelected()) {
                    this.e.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType());
                    this.b = ImageResource.IMAGE_CATEGORY.FLOORPLAN;
                } else if (this.j.isSelected()) {
                    this.e.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PEOPLE.getType());
                    this.b = ImageResource.IMAGE_CATEGORY.PEOPLE;
                } else if (this.i.isSelected()) {
                    this.e.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PRODUCTS.getType());
                    this.b = ImageResource.IMAGE_CATEGORY.PRODUCTS;
                } else {
                    this.e.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PRODUCTS.getType());
                    this.b = ImageResource.IMAGE_CATEGORY.PRODUCTS;
                }
                arrayList.add(this.e);
            }
            ImageResourceDAO.getInstance().saveOrUpdate(arrayList);
            OroMqttClient.getInstance().notifyDataUpdated(ImageResource.class);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public void selectBulkImage() throws Exception {
        Preferences preferences = Preferences.userRoot().node(this.getClass().getName());
        this.q = LAST_USED_FOLDER != null ? new POSFileChooser(preferences.get(LAST_USED_FOLDER, new File(".").getAbsolutePath())) : new POSFileChooser();
        this.q.setMultiSelectionEnabled(true);
        this.q.setFileSelectionMode(2);
        this.q.setAcceptAllFileFilterUsed(false);
        int n = this.q.showOpenDialog(POSUtil.getFocusedWindow());
        this.l = new ArrayList();
        if (n == 0) {
            File[] fileArray;
            for (File file : fileArray = this.q.getSelectedFiles()) {
                if (file.isDirectory()) {
                    File[] fileArray2 = file.listFiles();
                    for (int i = 0; i < fileArray2.length; ++i) {
                        if (fileArray2[i].isDirectory()) {
                            this.a(fileArray2[i]);
                            continue;
                        }
                        this.a(fileArray2[i]);
                    }
                    continue;
                }
                this.a(file);
            }
        } else {
            return;
        }
        this.setCanceled(false);
    }

    public void showImages() {
        if (!this.m) {
            this.n.setVisible(false);
            return;
        }
        this.n.setVisible(true);
        this.p.setVisible(false);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ImageUploaderDialog.this.a) {
                        return;
                    }
                    int n = 1;
                    ImageUploaderDialog.this.n.setMaximum(ImageUploaderDialog.this.l.size());
                    ImageUploaderDialog.this.o.setVisible(true);
                    for (byte[] byArray : ImageUploaderDialog.this.l) {
                        JLabel jLabel = new JLabel();
                        jLabel.putClientProperty("image", byArray);
                        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
                            BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
                            ImageIcon imageIcon = new ImageIcon(ImageUtil.doScaleImageWithRatio(bufferedImage, false, bufferedImage.getWidth(), bufferedImage.getHeight()));
                            jLabel.setIcon(imageIcon);
                            ImageUploaderDialog.this.k.add(jLabel);
                            ImageUploaderDialog.this.k.revalidate();
                            ImageUploaderDialog.this.k.repaint();
                        }
                        Thread.sleep(500L);
                        ImageUploaderDialog.this.n.setValue(n);
                        ++n;
                    }
                }
                catch (Exception exception) {
                    PosLog.error(this.getClass(), exception);
                }
            }
        });
    }

    private void a(File file) throws Exception {
        String string = this.a(file.toString());
        if (this.c().contains(string.trim().toLowerCase())) {
            int n;
            BufferedImage bufferedImage = ImageIO.read(file);
            byte[] byArray = ImageUtil.convertImageToByteArray(bufferedImage);
            if (byArray != null && (n = byArray.length / 1024) > 1000) {
                bufferedImage = ImageUtil.doScaleImageWithRatio(bufferedImage, false, bufferedImage.getWidth(), bufferedImage.getHeight());
                byArray = ImageUtil.convertImageToByteArray(bufferedImage);
            }
            this.l.add(byArray);
        }
    }

    private String a(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        int n2 = string2.indexOf(46, n = string2.lastIndexOf(92) + 1);
        return n2 == -1 ? "" : string2.substring(n2 + 1);
    }

    private List<String> c() {
        return Arrays.asList("jpg", "jpeg", "png", "gif");
    }

    public void selectImage() throws Exception {
        Preferences preferences = Preferences.userRoot().node(this.getClass().getName());
        this.q = LAST_USED_FOLDER != null ? new POSFileChooser(preferences.get(LAST_USED_FOLDER, new File(".").getAbsolutePath())) : new POSFileChooser();
        this.q.setMultiSelectionEnabled(false);
        this.q.setFileSelectionMode(0);
        int n = this.q.showOpenDialog(POSUtil.getFocusedWindow());
        if (n == 0) {
            File file = this.q.getSelectedFile();
            preferences.put(LAST_USED_FOLDER, file.getPath());
            BufferedImage bufferedImage = ImageIO.read(file);
            bufferedImage = ImageUtil.doScaleImageWithRatio(bufferedImage, false, bufferedImage.getWidth(), bufferedImage.getHeight());
            this.c.setIcon(new ImageIcon(bufferedImage));
            byte[] byArray = ImageUtil.convertImageToByteArray(bufferedImage);
            this.c.putClientProperty("image", byArray);
            this.c.setText("");
            this.setCanceled(false);
        } else if (n == 1) {
            this.setCanceled(true);
        }
    }

    private void d() {
        if (this.e != null && this.e.getImageCategory() != null) {
            this.b = this.e.getImageCategory();
        }
        if (this.b == ImageResource.IMAGE_CATEGORY.UNLISTED) {
            this.g.setSelected(true);
        } else if (this.b == ImageResource.IMAGE_CATEGORY.FLOORPLAN) {
            this.h.setSelected(true);
        } else if (this.b == ImageResource.IMAGE_CATEGORY.PRODUCTS) {
            this.i.setSelected(true);
        } else if (this.b == ImageResource.IMAGE_CATEGORY.PEOPLE) {
            this.j.setSelected(true);
        } else {
            this.i.setSelected(true);
        }
        if (this.e == null) {
            return;
        }
        ImageIcon imageIcon = this.e.getImageIcon();
        if (imageIcon == null) {
            return;
        }
        this.c.setText("");
        this.c.setIcon(imageIcon);
        if (this.e.getDescription() != null) {
            this.f.setText(this.e.getDescription());
        }
    }

    public ImageResource getSelectedImageResourse() {
        return this.e;
    }

    @Override
    public void open() {
        this.showImages();
        super.open();
    }

    public void setDescriptionVisible(boolean bl) {
        this.d.setVisible(bl);
        this.f.setVisible(bl);
    }
}

