/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.PayoutReason;
import com.floreantpos.model.PayoutRecepient;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.PayOutTransactionDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.PayOutView;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Dialog;
import java.awt.Frame;
import org.apache.commons.lang.StringUtils;

public class PayoutDialog
extends OkCancelOptionDialog {
    private PayOutView a;
    private User b;
    private Terminal c;

    public PayoutDialog(Dialog dialog, User user, Terminal terminal) {
        super(dialog, true);
        this.b = user;
        this.c = terminal;
        this.setTitle(POSConstants.PAYOUT_BUTTON_TEXT);
        this.a();
        this.a.initialize();
    }

    public PayoutDialog(Frame frame, User user, Terminal terminal) {
        super(frame, true);
        this.b = user;
        this.c = terminal;
        this.setTitle(Application.getTitle() + POSConstants.PAYOUT_BUTTON_TEXT);
        this.a();
        this.a.initialize();
    }

    private void a() {
        this.setCaption(POSConstants.PAYOUT_BUTTON_TEXT);
        this.setOkButtonText(POSConstants.FINISH);
        this.a = new PayOutView();
        this.setDefaultCloseOperation(2);
        this.getContentPanel().add(this.a);
        this.pack();
    }

    @Override
    public void doOk() {
        try {
            if (StringUtils.isBlank((String)this.a.getPayoutAmountText())) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PayoutDialog.0"));
                return;
            }
            double d = this.a.getPayoutAmount();
            if (d == 0.0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PayoutDialog.1"));
                return;
            }
            if (d < 0.0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.NEGATIVE_AMOUNT_NOT_ALLOWED);
                return;
            }
            PayoutReason payoutReason = this.a.getReason();
            PayoutRecepient payoutRecepient = this.a.getRecepient();
            String string = this.a.getNote();
            PayOutTransactionDAO.getInstance().createPayoutTransaction(payoutReason, payoutRecepient, string, d, this.b, this.c);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("PayoutDialog.3"));
            this.a(d);
            this.setCanceled(false);
            this.dispose();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void a(double d) {
        try {
            Terminal terminal = DataProvider.get().getCurrentTerminal();
            CashDrawer cashDrawer = terminal.getCurrentCashDrawer();
            String string = String.format("Terminal id : %s, Cash drawer id : %s, Total : %s", terminal.getId(), cashDrawer.getId(), NumberUtil.formatNumber(d));
            ActionHistoryDAO.saveHistory(this.b, "Pay out", string);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }
}

