/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.modifierdesigner.ModifierSelectionDialog;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.hibernate.Hibernate;
import org.hibernate.StaleStateException;

public class ModifierGroupForm
extends BeanEditor
implements RefreshableView {
    private JLabel a;
    private FixedLengthTextField b;
    private FixedLengthTextField c;
    private JList d;
    private ComboBoxModel e;
    private Boolean f;

    public ModifierGroupForm() throws Exception {
        this(new ModifierGroup());
    }

    public ModifierGroupForm(ModifierGroup modifierGroup) throws Exception {
        this(modifierGroup, (Boolean)false);
    }

    public ModifierGroupForm(ModifierGroup modifierGroup, Boolean bl) throws Exception {
        this.a();
        this.setBean(modifierGroup);
        this.f = bl;
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("", "[45px][369px,grow]", "[19px][]"));
        this.a = new JLabel();
        this.b = new FixedLengthTextField();
        this.b.setLength(60);
        this.a.setText(POSConstants.NAME);
        jPanel.add((Component)this.a, "cell 0 0,alignx left,aligny center");
        jPanel.add((Component)this.b, "cell 1 0,growx,aligny top");
        JLabel jLabel = new JLabel(POSConstants.TRANSLATED_NAME);
        jPanel.add((Component)jLabel, "cell 0 1,alignx trailing");
        this.c = new FixedLengthTextField();
        this.c.setLength(60);
        jPanel.add((Component)this.c, "cell 1 1,growx");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fill"));
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("fill"));
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout());
        Border border = BorderFactory.createEtchedBorder(1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "Modifier List");
        titledBorder.setTitleJustification(1);
        JButton jButton = new JButton(Messages.getString("ModifierGroupForm.2"));
        jButton.addActionListener(actionEvent -> this.c());
        JButton jButton2 = new JButton(Messages.getString("ModifierGroupForm.3"));
        jButton2.addActionListener(actionEvent -> this.b());
        this.d = new JList();
        JScrollPane jScrollPane = new JScrollPane(this.d);
        jPanel3.setBorder(titledBorder);
        jPanel3.add((Component)jScrollPane, "grow");
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        jPanel2.add((Component)jPanel3, "grow");
        jPanel2.add((Component)jPanel4, "South");
        this.add(jPanel2);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            ModifierGroup modifierGroup = (ModifierGroup)this.getBean();
            ModifierGroupDAO modifierGroupDAO = new ModifierGroupDAO();
            modifierGroupDAO.saveOrUpdate(modifierGroup);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
            return false;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        Object object;
        ModifierGroup modifierGroup = (ModifierGroup)this.getBean();
        if (modifierGroup.getId() != null && !Hibernate.isInitialized(modifierGroup.getModifiers())) {
            object = MenuModifierDAO.getInstance().getSession();
            modifierGroup = (ModifierGroup)object.merge((Object)modifierGroup);
            Hibernate.initialize(modifierGroup.getModifiers());
            object.close();
        }
        this.b.setText(modifierGroup.getName());
        this.c.setText(modifierGroup.getTranslatedName());
        this.e = new ComboBoxModel();
        object = new ArrayList();
        if (modifierGroup.getModifiers() != null && modifierGroup.getModifiers().size() > 0) {
            object.addAll(modifierGroup.getModifiers());
        }
        this.e.setDataList((List)object);
        this.d.setModel(this.e);
    }

    @Override
    protected boolean updateModel() {
        ModifierGroup modifierGroup = (ModifierGroup)this.getBean();
        String string = this.b.getText();
        if (POSUtil.isBlankOrNull(string)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.NAME_REQUIRED);
            return false;
        }
        modifierGroup.setName(string);
        modifierGroup.setTranslatedName(this.c.getText());
        List<MenuModifier> list = modifierGroup.getModifiers();
        if (list == null) {
            list = new ArrayList<MenuModifier>();
            modifierGroup.setModifiers(list);
        } else {
            list.clear();
        }
        list.addAll(this.e.getDataList());
        modifierGroup.setPizzaModifierGroup(this.f);
        return true;
    }

    @Override
    public String getDisplayText() {
        ModifierGroup modifierGroup = (ModifierGroup)this.getBean();
        if (modifierGroup.getId() == null) {
            return POSConstants.NEW_MODIFIER_GROUP;
        }
        return POSConstants.EDIT_MODIFIER_GROUP;
    }

    private void b() {
        MenuModifier menuModifier = (MenuModifier)this.d.getSelectedValue();
        if (menuModifier == null) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToRemove"));
            return;
        }
        this.e.removeElement(menuModifier);
    }

    private void c() {
        ModifierSelectionDialog modifierSelectionDialog = new ModifierSelectionDialog(this.e.getDataList(), (boolean)this.f);
        modifierSelectionDialog.setSize(PosUIManager.getSize(800, 600));
        modifierSelectionDialog.open();
        if (modifierSelectionDialog.isCanceled()) {
            return;
        }
        List<MenuModifier> list = modifierSelectionDialog.getSelectedMenuModifierList();
        this.e.removeAllElements();
        for (MenuModifier menuModifier : list) {
            this.e.addElement(menuModifier);
        }
    }

    @Override
    public void refresh() {
        ModifierGroup modifierGroup = (ModifierGroup)this.getBean();
        ModifierGroup modifierGroup2 = ModifierGroupDAO.getInstance().get(modifierGroup.getId());
        this.setBean(modifierGroup2);
    }
}

