/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.ticket;

import com.floreantpos.Messages;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemModifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class TodoTicketViewerTableModel
extends AbstractTableModel {
    private JTable a;
    protected Ticket ticket;
    private List<ITicketItem> b = new ArrayList<ITicketItem>();
    protected String[] columnNames = new String[]{Messages.getString("TodoTicketViewerTableModel.0"), Messages.getString("TodoTicketViewerTableModel.1"), Messages.getString("TodoTicketViewerTableModel.2"), Messages.getString("TodoTicketViewerTableModel.3"), Messages.getString("TodoTicketViewerTableModel.4")};
    private boolean c;
    private boolean d;

    public TodoTicketViewerTableModel() {
    }

    public TodoTicketViewerTableModel(Ticket ticket) {
        this.setTicket(ticket);
    }

    public int getItemCount() {
        return this.b.size();
    }

    @Override
    public int getRowCount() {
        return this.b.size();
    }

    public int getActualRowCount() {
        return this.b.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ITicketItem iTicketItem = this.b.get(n);
        if (iTicketItem == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                return iTicketItem.getNameDisplay();
            }
            case 1: {
                return iTicketItem.getUnitPriceDisplay();
            }
            case 2: {
                return iTicketItem.getItemQuantityDisplay();
            }
            case 3: {
                return iTicketItem.getTaxAmountWithoutModifiersDisplay();
            }
            case 4: {
                return iTicketItem.getTotalAmountWithoutModifiersDisplay();
            }
        }
        return null;
    }

    private void a() {
        this.b.clear();
        if (this.ticket == null || this.ticket.getTicketItems() == null) {
            return;
        }
        List<TicketItem> list = this.ticket.getTicketItems();
        for (TicketItem ticketItem : list) {
            List<Comparable> list2;
            this.b.add(ticketItem);
            if (ticketItem.getTicketItemModifiers() != null && (list2 = ticketItem.getTicketItemModifiers()) != null) {
                for (TicketItemModifier ticketItemModifier : list2) {
                    this.b.add(ticketItemModifier);
                }
            }
            if ((list2 = ticketItem.getCookingInstructions()) == null) continue;
            for (TicketItemCookingInstruction ticketItemCookingInstruction : list2) {
                this.b.add(ticketItemCookingInstruction);
            }
        }
    }

    public int addTicketItem(TicketItem ticketItem) {
        if (ticketItem.isHasModifiers().booleanValue()) {
            return this.a(ticketItem);
        }
        for (int i = 0; i < this.b.size(); ++i) {
            ITicketItem iTicketItem = this.b.get(i);
            if (!(iTicketItem instanceof TicketItem)) continue;
            TicketItem ticketItem2 = (TicketItem)iTicketItem;
            if (!ticketItem.getName().equals(ticketItem2.getName()) || ticketItem2.isPrintedToKitchen().booleanValue()) continue;
            ticketItem2.setQuantity(ticketItem2.getQuantity() + 1.0);
            this.a.repaint();
            return i;
        }
        return this.a(ticketItem);
    }

    private int a(TicketItem ticketItem) {
        this.ticket.addToticketItems(ticketItem);
        this.a();
        this.fireTableDataChanged();
        return this.b.size() - 1;
    }

    public void addAllTicketItem(TicketItem ticketItem) {
        if (ticketItem.isHasModifiers().booleanValue()) {
            List<TicketItem> list = this.ticket.getTicketItems();
            list.add(ticketItem);
            this.a();
            this.fireTableDataChanged();
        } else {
            List<TicketItem> list = this.ticket.getTicketItems();
            boolean bl = false;
            for (TicketItem ticketItem2 : list) {
                if (!ticketItem2.getName().equals(ticketItem.getName())) continue;
                double d = ticketItem2.getQuantity();
                ticketItem2.setQuantity(d += ticketItem.getQuantity().doubleValue());
                bl = true;
                this.a.repaint();
                return;
            }
            if (!bl) {
                this.ticket.addToticketItems(ticketItem);
                this.a();
                this.fireTableDataChanged();
            }
        }
    }

    public boolean containsTicketItem(TicketItem ticketItem) {
        if (ticketItem.isHasModifiers().booleanValue()) {
            return false;
        }
        List<TicketItem> list = this.ticket.getTicketItems();
        for (TicketItem ticketItem2 : list) {
            if (!ticketItem2.getName().equals(ticketItem.getName())) continue;
            return true;
        }
        return false;
    }

    public void removeModifier(TicketItem ticketItem, TicketItemModifier ticketItemModifier) {
        List<TicketItemModifier> list = ticketItem.getTicketItemModifiers();
        Iterator<TicketItemModifier> iterator = list.iterator();
        while (iterator.hasNext()) {
            TicketItemModifier ticketItemModifier2 = iterator.next();
            if (ticketItemModifier2.getItemId() != ticketItemModifier.getItemId()) continue;
            iterator.remove();
            if (ticketItemModifier2.isPrintedToKitchen().booleanValue()) {
                this.ticket.addDeletedItems(ticketItemModifier2);
            }
            this.a();
            this.fireTableDataChanged();
            return;
        }
    }

    public Object delete(int n) {
        TicketItemModifier ticketItemModifier;
        TicketItem ticketItem;
        List<TicketItemModifier> list;
        if (n < 0 || n >= this.b.size()) {
            return null;
        }
        ITicketItem iTicketItem = this.b.get(n);
        if (iTicketItem instanceof TicketItem) {
            TicketItem ticketItem2 = (TicketItem)iTicketItem;
            int n2 = ticketItem2.getTableRowNum();
            List<TicketItem> list2 = this.ticket.getTicketItems();
            Iterator<TicketItem> iterator = list2.iterator();
            while (iterator.hasNext()) {
                TicketItem ticketItem3 = iterator.next();
                if (ticketItem3.getTableRowNum() != n2) continue;
                iterator.remove();
                if (!ticketItem3.isPrintedToKitchen().booleanValue() && !ticketItem3.isInventoryAdjusted()) break;
                this.ticket.addDeletedItems(ticketItem3);
                break;
            }
        } else if (iTicketItem instanceof TicketItemModifier && (list = (ticketItem = (ticketItemModifier = (TicketItemModifier)iTicketItem).getTicketItem()).getTicketItemModifiers()) != null) {
            Iterator<TicketItemModifier> iterator = list.iterator();
            while (iterator.hasNext()) {
                TicketItemModifier ticketItemModifier2 = iterator.next();
                if (ticketItemModifier.getTableRowNum() != ticketItemModifier2.getTableRowNum()) continue;
                iterator.remove();
                if (!ticketItemModifier2.isPrintedToKitchen().booleanValue()) continue;
                this.ticket.addDeletedItems(ticketItemModifier2);
            }
        }
        this.a();
        this.fireTableDataChanged();
        return iTicketItem;
    }

    public Object get(int n) {
        return null;
    }

    public JTable getTable() {
        return this.a;
    }

    public void setTable(JTable jTable) {
        this.a = jTable;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
        this.update();
    }

    public void update() {
        this.a();
        this.fireTableDataChanged();
    }

    public boolean isForReciptPrint() {
        return this.c;
    }

    public void setForReciptPrint(boolean bl) {
        this.c = bl;
    }

    public boolean isPrintCookingInstructions() {
        return this.d;
    }

    public void setPrintCookingInstructions(boolean bl) {
        this.d = bl;
    }
}

