/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.PrintException;
import com.floreantpos.actions.EmailSendAction;
import com.floreantpos.actions.TicketReorderAction;
import com.floreantpos.actions.TicketTransferAction;
import com.floreantpos.bo.actions.TicketPrintAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import javax.swing.JPanel;

public class OrderInfoDialog
extends POSDialog {
    private OrderInfoView a;
    private boolean b = false;
    private PosButton c;
    private PosButton d;
    private PosButton e;
    private PosButton f;
    private PosButton g;
    private JPanel h;
    private boolean i;

    public OrderInfoDialog(OrderInfoView orderInfoView) {
        this(orderInfoView, (boolean)Boolean.TRUE);
    }

    public OrderInfoDialog(OrderInfoView orderInfoView, boolean bl) {
        this.a = orderInfoView;
        this.i = bl;
        this.setTitle(Messages.getString("OrderInfoDialog.0"));
        this.createUI();
        this.a();
    }

    public void createUI() {
        this.add(this.a);
        this.h = new JPanel();
        this.getContentPane().add((Component)this.h, "South");
        this.c = new PosButton(Messages.getString("OrderInfoDialog.5"));
        this.c.setVisible(this.i);
        this.c.addActionListener(actionEvent -> this.d());
        this.g = new PosButton();
        this.g.setAction(new EmailSendAction(){

            @Override
            public Ticket getTicket() {
                return OrderInfoDialog.this.a.getTickets().get(0);
            }
        });
        this.h.add(this.g);
        this.h.add(this.c);
        this.d = new PosButton();
        this.d.setVisible(this.i);
        this.d.setText(Messages.getString("OrderInfoDialog.3"));
        this.d.addActionListener(actionEvent -> this.c());
        this.h.add(this.d);
        this.e = new PosButton();
        this.e.addActionListener(new TicketPrintAction(this.a, null, this.a.getTickets()));
        this.e.setText(Messages.getString("OrderInfoDialog.1"));
        this.h.add(this.e);
        this.f = new PosButton();
        this.f.addActionListener(actionEvent -> this.b());
        this.f.setText(Messages.getString("OrderInfoDialog.2"));
        this.f.setVisible(false);
        this.h.add(this.f);
        PosButton posButton = new PosButton();
        posButton.addActionListener(actionEvent -> this.dispose());
        posButton.setText(Messages.getString("Close"));
        this.h.add(posButton);
    }

    private void a() {
        try {
            Store store = DataProvider.get().getStore();
            boolean bl = POSUtil.getBoolean(store.getProperty("hide_print_button.in_order_info_view"));
            if (bl) {
                this.e.setVisible(Boolean.FALSE);
            } else {
                this.e.setVisible(Boolean.TRUE);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    private void b() {
        try {
            if (ReceiptPrintService.hasNoReceiptPrinters()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NoPrinterIsConfigured"));
                return;
            }
            this.a.printCopy("Driver Copy");
        }
        catch (PrintException printException) {
            POSMessageDialog.showError(Application.getPosWindow(), printException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage());
        }
    }

    public void updateView() {
        this.d.setVisible(false);
        this.c.setVisible(false);
        this.f.setVisible(true);
        this.e.setText("Print (Customer Copy)");
    }

    public void setReorder(boolean bl) {
        this.b = bl;
    }

    public boolean isReorder() {
        return this.b;
    }

    public void showOnlyPrintButton() {
        this.d.setVisible(false);
        this.c.setVisible(false);
        this.f.setVisible(false);
    }

    public OrderInfoView getOrderInfoView() {
        return this.a;
    }

    public JPanel getButtonPanel() {
        return this.h;
    }

    private void c() {
        try {
            TicketTransferAction ticketTransferAction = new TicketTransferAction(this.a.getTickets().get(0), Application.getCurrentUser());
            ticketTransferAction.execute();
            if (!ticketTransferAction.isTransfered()) {
                return;
            }
            this.a.getReportPanel().removeAll();
            this.a.createReport();
            this.a.revalidate();
            this.a.repaint();
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Messages.getString("MessageDialog.0"));
            PosLog.error(this.getClass(), exception);
        }
    }

    private void d() {
        try {
            TicketReorderAction ticketReorderAction = new TicketReorderAction(this.a.getTickets().get(0), UserPermission.CREATE_TICKET);
            ticketReorderAction.execute();
            if (!ticketReorderAction.isReorder()) {
                return;
            }
            this.b = true;
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }
}

