/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.Messages;
import com.floreantpos.StoreAlreadyOpenException;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.StoreSessionControlDAO;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.POSUtil;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.hibernate.Session;

public class StoreUtil {
    public static StoreSession getCurrentStoreSession() {
        StoreSessionControl storeSessionControl = StoreUtil.getCurrentStoreOperation();
        if (storeSessionControl == null) {
            return null;
        }
        return storeSessionControl.getCurrentData();
    }

    public static StoreSessionControl getCurrentStoreOperation() {
        return StoreSessionControlDAO.getInstance().getCurrent();
    }

    public static boolean isStoreOpen() {
        return StoreUtil.getCurrentStoreOperation().getCurrentData() != null;
    }

    public static void openStore(User user) {
        Outlet outlet = DataProvider.get().getOutlet();
        StoreUtil.openStore(user, outlet == null ? null : outlet.getId());
    }

    public static void openStore(User user, String string) {
        StoreSessionControl storeSessionControl = StoreUtil.getCurrentStoreOperation();
        if (storeSessionControl.getCurrentData() != null) {
            throw new StoreAlreadyOpenException(Messages.getString("StoreUtil.0"));
        }
        StoreSession storeSession = new StoreSession();
        storeSession.setId(StoreUtil.a(0));
        storeSession.setOpenedBy(user);
        storeSession.setOpenTime(new Date());
        storeSession.setOutletId(string);
        storeSessionControl.setCurrentData(storeSession);
        SequenceNumber sequenceNumber = SequenceNumberDAO.getInstance().get("TICKET_TOKEN_NUMBER");
        if (sequenceNumber == null) {
            sequenceNumber = new SequenceNumber("TICKET_TOKEN_NUMBER");
        }
        Store store = DataProvider.get().getStore();
        boolean bl = store.getBooleanProperty("reset.token", true);
        String string2 = store.getProperty("token_no.start");
        Integer n = POSUtil.parseInteger(string2);
        if (bl) {
            if (n > 0) {
                sequenceNumber.setNextSequenceNumber(n);
            } else {
                sequenceNumber.setNextSequenceNumber(1);
            }
        }
        StoreSessionDAO.getInstance().save(storeSession);
        TerminalDAO.getInstance().performBatchSave(storeSessionControl, sequenceNumber);
        DataProvider.get().setStoreSession(storeSession);
    }

    private static String a(Integer n) {
        String string = new DecimalFormat("000").format(n);
        String string2 = new SimpleDateFormat("ddMMyyyy").format(new Date()) + string;
        if (StoreSessionDAO.getInstance().get(string2) == null) {
            return string2;
        }
        return StoreUtil.a(n + 1);
    }

    public static void closeStore(User user) throws Exception {
        StoreDAO.getInstance().closeStore(user);
        DataProvider.get().setStoreSession(null);
    }

    public static void closeStore(Session session, User user) throws Exception {
        StoreDAO.getInstance().closeStore(session, user);
        DataProvider.get().setStoreSession(null);
    }
}

