/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.swing.POSPasswordField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.POSUtil;
import com.floreantpos.webservice.CloudSyncListener;
import com.floreantpos.webservice.PosWebService;
import com.orocube.rest.service.PosResponse;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class CloudRegistrationPanel
extends JPanel {
    private static final String a = "registered";
    public static final String VIEW_NAME = "register";
    private POSTextField b;
    private POSTextField c;
    private POSPasswordField d;
    private JLabel e;
    private JProgressBar f;
    private JPanel g;
    private PosButton h;
    private JButton i;
    private JButton j;
    private CloudSyncListener k;

    public CloudRegistrationPanel(CloudSyncListener cloudSyncListener) {
        this.k = cloudSyncListener;
        this.initComponents();
        this.a();
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.e = new JLabel();
        this.e.setFont(new Font("Arial", 1, 16));
        this.e.setText(Messages.getString("CloudRegistrationPanel.1"));
        this.e.setVisible(false);
        this.f = new JProgressBar();
        this.f.setIndeterminate(true);
        this.f.setStringPainted(false);
        this.f.setPreferredSize(new Dimension(0, 30));
        this.f.setVisible(false);
        this.f.setBorder(BorderFactory.createEmptyBorder(0, -5, 5, -5));
        this.g = new JPanel();
        this.g.setLayout((LayoutManager)new MigLayout("fillx,ins 20 20 20 20", "[][fill, grow]", ""));
        this.b = new POSTextField();
        this.c = new POSTextField();
        this.d = new POSPasswordField();
        if (Application.getInstance().isDevelopmentMode()) {
            this.g.add(new JLabel(Messages.getString("ServerAddress") + ":"));
            this.g.add((Component)this.b, "grow, wrap");
        }
        this.g.add(new JLabel(Messages.getString("CloudLoginPanel.2") + ":"));
        this.g.add((Component)this.c, "grow, wrap");
        this.g.add(new JLabel(Messages.getString("PASSWORD") + ":"));
        this.g.add((Component)this.d, "grow, wrap");
        this.j = new JButton(Messages.getString("CloudRegistrationPanel.9"));
        this.j.setActionCommand("login");
        this.j.addActionListener(actionEvent -> this.k.loginButtonClicked());
        JLabel jLabel = new JLabel(Messages.getString("CloudRegistrationPanel.11"));
        jLabel.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        this.g.add((Component)jLabel, "newline,span 2,right");
        this.g.add((Component)this.j, "newline,span 2,right");
        this.add(this.g);
        JSeparator jSeparator = new JSeparator();
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setLayout(new FlowLayout());
        this.h = new PosButton();
        this.i = new PosButton();
        TransparentPanel transparentPanel2 = new TransparentPanel();
        transparentPanel2.setLayout(new BorderLayout());
        transparentPanel.setLayout(new FlowLayout());
        this.h.setText(Messages.getString("CloudRegistrationPanel.15"));
        this.h.addActionListener(actionEvent -> this.doCloudRegistration());
        this.i.setText(POSConstants.CANCEL);
        this.i.addActionListener(actionEvent -> this.a(true));
        transparentPanel.add(this.h);
        transparentPanel.add(this.i);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        jPanel.add((Component)this.e, "split 2");
        jPanel.add((Component)this.f, "gapleft 15,grow,gapafter 20");
        transparentPanel2.add((Component)jPanel, "North");
        transparentPanel2.add((Component)jSeparator, "Center");
        transparentPanel2.add((Component)transparentPanel, "South");
        this.add(this.g);
        this.add((Component)transparentPanel2, "South");
    }

    private void a(boolean bl) {
        Window window = SwingUtilities.getWindowAncestor(this.g);
        if (window instanceof POSDialog) {
            ((POSDialog)window).setCanceled(bl);
            window.dispose();
        }
    }

    private void a() {
        Store store = StoreDAO.getRestaurant();
        String string = store.getProperty("web.service.url");
        this.b.setText(StringUtils.isEmpty((String)string) ? "https://siiopa.com/console" : string);
        this.c.setText(store.getProperty("web.service.username"));
        String string2 = store.getProperty("web.service.password");
        try {
            this.d.setText(AESencrp.decrypt(string2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void b() throws Exception {
        String string;
        String string2;
        Store store;
        String string3 = this.b.getText();
        String string4 = StoreDAO.getRestaurant().getName();
        String string5 = this.c.getText();
        String string6 = new String(this.d.getPassword());
        PosResponse posResponse = PosWebService.get().register(string3, string4, string5, string6);
        if (posResponse != null && posResponse.getResponseCode() == 200) {
            store = StoreDAO.getRestaurant();
            string2 = posResponse.getCustomerId();
            store.addProperty("web.service.url", string3);
            String string7 = store.getUuid();
            string = posResponse.getStoreId();
            if (StringUtils.isNotBlank((String)string7) && StringUtils.isNotBlank((String)string) && !string7.equals(string)) {
                StoreDAO.getInstance().removeLastUpdateTime(store);
            }
        } else {
            throw new Exception(posResponse.getMsg());
        }
        store.addProperty("web.service.schema", string);
        store.addProperty("web.service.username", string5);
        store.addProperty("web.service.password", AESencrp.encrypt(string6));
        store.addProperty("web.service.customer.id", string2);
        store.setUuid(string);
        StoreDAO.getInstance().saveOrUpdate(store);
        Application.getInstance().refreshStore();
        OroMqttClient.getInstance().notifyDataUpdated(Store.class);
    }

    public void doCloudRegistration() {
        this.e.setVisible(true);
        this.f.setVisible(true);
        this.b(false);
        SwingWorker<String, Object> swingWorker = new SwingWorker<String, Object>(){

            @Override
            protected String doInBackground() throws Exception {
                try {
                    CloudRegistrationPanel.this.b();
                    return CloudRegistrationPanel.a;
                }
                catch (Exception exception) {
                    return exception.getMessage();
                }
            }

            @Override
            protected void done() {
                super.done();
                CloudRegistrationPanel.this.e.setVisible(false);
                CloudRegistrationPanel.this.f.setVisible(false);
                CloudRegistrationPanel.this.b(true);
                try {
                    String string = (String)this.get();
                    if (string != null && string.equals(CloudRegistrationPanel.a)) {
                        CloudRegistrationPanel.this.k.registrationComplete();
                    } else {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CloudRegistrationPanel.20") + string);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        };
        swingWorker.execute();
    }

    private void b(boolean bl) {
        this.b.setEnabled(bl);
        this.d.setEnabled(bl);
        this.c.setEnabled(bl);
        this.h.setEnabled(bl);
        this.i.setEnabled(bl);
        this.j.setEnabled(bl);
    }
}

