/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.Department;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.ReversalTransaction;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.User;
import com.floreantpos.model.VoidTransaction;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.orocube.rest.service.JsonBeanFieldExcluder;
import com.orocube.rest.service.PosResponse;
import com.orocube.rest.service.mqtt.MqttSender;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class ServiceUtils {
    public static String convertToJson(Object object) throws Exception {
        if (object == null) {
            return "";
        }
        String string = "";
        try {
            System.setProperty("javax.xml.bind.context.factory", "org.eclipse.persistence.jaxb.JAXBContextFactory");
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller marshaller = jAXBContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            marshaller.setProperty("eclipselink.json.include-root", (Object)true);
            StringWriter stringWriter = new StringWriter();
            marshaller.marshal(object, (Writer)stringWriter);
            string = stringWriter.toString();
            return string;
        }
        catch (Exception exception) {
            PosLog.error(ServiceUtils.class, exception);
            return "";
        }
    }

    public static String getAsJsonString(PosResponse posResponse) throws Exception {
        return ServiceUtils.getAsJsonString(posResponse, StoreSession.class, MenuShift.class, TicketItemCookingInstruction.class, Department.class);
    }

    public static String getAsJsonString(PosResponse posResponse, boolean bl) throws Exception {
        if (bl) {
            return ServiceUtils.getAsJsonString(posResponse, CashDrawer.class, StoreSession.class, MenuShift.class, TicketItemCookingInstruction.class, Department.class);
        }
        return ServiceUtils.getAsJsonString(posResponse, StoreSession.class, MenuShift.class, TicketItemCookingInstruction.class, Department.class);
    }

    public static String getAsJsonString(PosResponse posResponse, Class ... classArray) throws Exception {
        if (posResponse == null) {
            return "";
        }
        try {
            Gson gson = BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(classArray)}).create();
            String string = gson.toJson((Object)posResponse);
            return string;
        }
        catch (Exception exception) {
            PosLog.error(ServiceUtils.class, exception);
            return "";
        }
    }

    public static String convertKitTicketsToJsonString(List<KitchenTicket> list) throws Exception {
        Object object;
        ArrayList<KitchenTicket> arrayList = new ArrayList<KitchenTicket>();
        for (KitchenTicket kitchenTicket : list) {
            if (kitchenTicket.getId() == null) continue;
            kitchenTicket.setParentTicket(null);
            kitchenTicket.setPrinter(null);
            object = kitchenTicket.getTicketItems();
            if (object == null) continue;
            Iterator<KitchenTicketItem> iterator = object.iterator();
            while (iterator.hasNext()) {
                KitchenTicketItem kitchenTicketItem = iterator.next();
                kitchenTicketItem.setKitchenTicket(null);
            }
            arrayList.add(kitchenTicket);
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("deviceId", (Object)String.valueOf(DataProvider.get().getCurrentTerminal().getId()));
        jSONObject.put("storeId", (Object)DataProvider.get().getStore().getId());
        jSONObject.put("outletId", (Object)Application.getInstance().getCurrentTerminalOutletId());
        jSONObject.put("request", (Object)"Kitchen Ticket Notification");
        jSONObject.put("responseCode", 1);
        try {
            KitchenTicket kitchenTicket;
            kitchenTicket = BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(User.class, StoreSession.class, Terminal.class, MenuShift.class, TicketItemCookingInstruction.class, Department.class, MenuItem.class, Attribute.class)}).create();
            object = kitchenTicket.toJson(arrayList);
            jSONObject.put("data", (Object)"%data");
            return jSONObject.toString().replace("\"%data\"", (CharSequence)object);
        }
        catch (Exception exception) {
            PosLog.error(ServiceUtils.class, exception);
            return null;
        }
    }

    public static String convertTicketsToJson(Object object) throws Exception {
        if (object == null) {
            return "";
        }
        try {
            Gson gson = BaseDataServiceDao.getGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(User.class, Outlet.class, StoreSession.class, Terminal.class, MenuShift.class, TicketItemCookingInstruction.class, Department.class)}).create();
            String string = gson.toJson(object);
            return string;
        }
        catch (Exception exception) {
            PosLog.error(ServiceUtils.class, exception);
            return "";
        }
    }

    public static Ticket convertToObject(String string) throws Exception {
        if (string == null) {
            return null;
        }
        try {
            System.setProperty("javax.xml.bind.context.factory", "org.eclipse.persistence.jaxb.JAXBContextFactory");
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{string.getClass()});
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            StringReader stringReader = new StringReader(string);
            Ticket ticket = (Ticket)unmarshaller.unmarshal((Reader)stringReader);
            return ticket;
        }
        catch (Exception exception) {
            PosLog.error(ServiceUtils.class, exception);
            return null;
        }
    }

    public static String convertImageIconToString(ImageIcon imageIcon) {
        String string = "";
        if (imageIcon != null) {
            try {
                Image image = imageIcon.getImage();
                BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage(image, 0, 0, null);
                graphics2D.dispose();
                File file = new File("saved.png");
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                byteArrayOutputStream.flush();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                byte[] byArray2 = Base64.encodeBase64((byte[])byArray);
                string = new String(byArray2);
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
        }
        return string;
    }

    public static List<Integer> convertJsonToIntList(String string, String string2) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            String string3 = String.valueOf(jSONObject.get(string2));
            return ServiceUtils.convertStringArrayToList(string3);
        }
        catch (Exception exception) {
            PosLog.error(ServiceUtils.class, exception);
            return null;
        }
    }

    public static List<ShopTableStatus> convertJsonToShopTableStatusList(String string) {
        try {
            if (string == null) {
                return null;
            }
            ArrayList<ShopTableStatus> arrayList = new ArrayList<ShopTableStatus>();
            JSONArray jSONArray = new JSONArray(string);
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                ShopTableStatus shopTableStatus = (ShopTableStatus)new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class, null)}).create().fromJson(jSONObject.toString(), ShopTableStatus.class);
                if (shopTableStatus == null) continue;
                arrayList.add(shopTableStatus);
            }
            return arrayList;
        }
        catch (Exception exception) {
            PosLog.error(ServiceUtils.class, exception);
            return null;
        }
    }

    public static List<CashDrawer> convertJsonToCashDrawerList(String string) {
        try {
            if (string == null) {
                return null;
            }
            ArrayList<CashDrawer> arrayList = new ArrayList<CashDrawer>();
            JSONArray jSONArray = new JSONArray(string);
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                CashDrawer cashDrawer = (CashDrawer)new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class, null)}).create().fromJson(jSONObject.toString(), CashDrawer.class);
                if (cashDrawer == null) continue;
                arrayList.add(cashDrawer);
            }
            return arrayList;
        }
        catch (Exception exception) {
            PosLog.error(ServiceUtils.class, exception);
            return null;
        }
    }

    public static List<Integer> convertStringArrayToList(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (string != null) {
            string = string.replace("[", "").replace("]", "").replaceAll("\"", Matcher.quoteReplacement(""));
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                Integer n = Integer.valueOf(stringArray[i]);
                arrayList.add(n);
            }
        }
        return arrayList;
    }

    public static String createPosResponseAsString(List<Ticket> list) throws Exception {
        return ServiceUtils.createPosResponseAsString(list, Application.getInstance().getMqttDeviceId());
    }

    public static String createPosResponseAsString(List<Ticket> list, String string) throws Exception {
        PosResponse posResponse = ServiceUtils.createPosResponse(list, string, MqttSender.OROPOS);
        String string2 = ServiceUtils.convertTicketsToJson(posResponse);
        return string2;
    }

    public static String createPosResponseAsString(List<Ticket> list, String string, boolean bl, MqttSender mqttSender) throws Exception {
        Object object;
        PosResponse posResponse = ServiceUtils.createPosResponse(list, string, mqttSender);
        if (bl) {
            object = TerminalDAO.getInstance().getMasterTerminalId();
            posResponse.setBlockTerminalId((Integer)object);
        }
        object = ServiceUtils.convertTicketsToJson(posResponse);
        return object;
    }

    public static PosResponse createPosResponse(List<Ticket> list, String string, MqttSender mqttSender) throws Exception {
        PosResponse posResponse = new PosResponse();
        posResponse.setResponseCode(1);
        posResponse.setSource(mqttSender.name());
        posResponse.setRequest("Ticket Notification");
        posResponse.setMsg((list.size() == 1 ? Messages.getString("ServiceUtils.30") : list.size() + Messages.getString("ServiceUtils.31")) + Messages.getString("ServiceUtils.32"));
        posResponse.setDeviceId(string);
        Terminal terminal = Application.getInstance().getTerminal();
        String string2 = terminal == null ? null : terminal.getOutletId();
        posResponse.setOutletId(StringUtils.isEmpty((String)string2) ? DataProvider.get().getStore().getDefaultOutletId() : string2);
        posResponse.setData(list);
        for (Ticket ticket : list) {
            Terminal terminal2;
            Set<PosTransaction> set;
            TicketDAO.getInstance().loadFullTicket(ticket);
            if (ticket.getTerminalId() == 0 && terminal != null) {
                ticket.setTerminalId(terminal.getId());
            }
            if ((set = ticket.getTransactions()) != null && set.size() > 0) {
                for (PosTransaction posTransaction : set) {
                    ServiceUtils.updatePosTransactionUsingClassType(posTransaction);
                    posTransaction.setTicket(null);
                    posTransaction.setTicketId(ticket.getId());
                }
            }
            OrderType orderType = ticket.getOrderType();
            orderType.setDepartments(null);
            orderType.setCategories(null);
            orderType.setTerminalTypes(null);
            Outlet comparable2 = ticket.getOutlet();
            if (comparable2 != null) {
                comparable2.setDepartments(null);
            }
            if ((terminal2 = ticket.getTerminal()) != null) {
                terminal2.setOutlet(null);
                terminal2.setCurrentCashDrawer(null);
                terminal2.setTerminalType(null);
            }
            for (TicketItem ticketItem : ticket.getTicketItems()) {
                ServiceUtils.doRemoveTicketItemsLink(ticketItem);
            }
        }
        return posResponse;
    }

    private static void doRemoveTicketItemsLink(TicketItem ticketItem) {
        List<TicketItem> list;
        Object object;
        List<TicketItemModifier> list2;
        ticketItem.setTicket(null);
        String string = ticketItem.getMenuItemId();
        ticketItem.setMenuItem(null);
        ticketItem.setMenuItemId(string);
        TicketItemModifier ticketItemModifier = ticketItem.getSizeModifier();
        if (ticketItemModifier != null) {
            ticketItemModifier.setTicketItem(null);
        }
        if ((list2 = ticketItem.getTicketItemModifiers()) != null) {
            object = list2.iterator();
            while (object.hasNext()) {
                list = (TicketItemModifier)object.next();
                ((BaseTicketItemModifier)((Object)list)).setTicketItem(null);
            }
        }
        if ((object = ticketItem.getDiscounts()) != null && object.size() > 0) {
            list = object.iterator();
            while (list.hasNext()) {
                TicketItemDiscount ticketItemDiscount = (TicketItemDiscount)list.next();
                ticketItemDiscount.setTicketItem(null);
            }
        }
        if (ticketItem.isComboItem().booleanValue() && (list = ticketItem.getComboItems()) != null) {
            for (TicketItem ticketItem2 : list) {
                ServiceUtils.doRemoveTicketItemsLink(ticketItem2);
            }
        }
    }

    public static void updatePosTransactionUsingClassType(PosTransaction posTransaction) throws Exception {
        if (posTransaction instanceof CashTransaction) {
            posTransaction.setClassType("CASH");
        } else if (posTransaction instanceof CustomPaymentTransaction) {
            posTransaction.setClassType("CUSTOM_PAYMENT");
        } else if (posTransaction instanceof GiftCertificateTransaction) {
            posTransaction.setClassType("GIFT_CERT");
        } else if (posTransaction instanceof CreditCardTransaction) {
            posTransaction.setClassType("CREDIT_CARD");
        } else if (posTransaction instanceof DebitCardTransaction) {
            posTransaction.setClassType("DEBIT_CARD");
        } else if (posTransaction instanceof CashDropTransaction) {
            posTransaction.setClassType("CASH_DROP");
        } else if (posTransaction instanceof RefundTransaction) {
            posTransaction.setClassType("REFUND");
        } else if (posTransaction instanceof PayOutTransaction) {
            posTransaction.setClassType("PAY_OUT");
        } else if (posTransaction instanceof VoidTransaction) {
            posTransaction.setClassType("VOID_TRANS");
        } else if (posTransaction instanceof CustomerAccountTransaction) {
            posTransaction.setClassType("CUSTOMER_ACCOUNT");
        } else if (posTransaction instanceof ReversalTransaction) {
            posTransaction.setClassType("REVERSAL");
        }
    }

    public static PosTransaction convertPosTransactionUsingClassType(PosTransaction posTransaction) throws Exception {
        String string = posTransaction.getClassType();
        PosTransaction posTransaction2 = null;
        switch (string) {
            case "CASH": {
                posTransaction2 = new CashTransaction();
                break;
            }
            case "CUSTOM_PAYMENT": {
                posTransaction2 = new CustomPaymentTransaction();
                break;
            }
            case "GIFT_CERT": {
                posTransaction2 = new GiftCertificateTransaction();
                break;
            }
            case "CREDIT_CARD": {
                posTransaction2 = new CreditCardTransaction();
                break;
            }
            case "DEBIT_CARD": {
                posTransaction2 = new DebitCardTransaction();
                break;
            }
            case "CASH_DROP": {
                posTransaction2 = new CashDropTransaction();
                break;
            }
            case "REFUND": {
                posTransaction2 = new RefundTransaction();
                break;
            }
            case "PAY_OUT": {
                posTransaction2 = new PayOutTransaction();
                break;
            }
            case "VOID_TRANS": {
                posTransaction2 = new VoidTransaction();
                break;
            }
            case "CUSTOMER_ACCOUNT": {
                posTransaction2 = new CustomerAccountTransaction();
                break;
            }
            case "REVERSAL": {
                posTransaction2 = new ReversalTransaction();
                break;
            }
        }
        try {
            PropertyUtils.copyProperties((Object)posTransaction2, (Object)posTransaction);
        }
        catch (Exception exception) {
            posTransaction2 = (PosTransaction)ServiceUtils.copy(posTransaction, posTransaction2.getClass());
        }
        posTransaction2.setVoided(posTransaction.isVoided());
        posTransaction2.setAuthorizable(posTransaction.isAuthorizable());
        posTransaction2.setCaptured(posTransaction.isCaptured());
        posTransaction2.setMarkedCaptured(posTransaction.isMarkedCaptured());
        return posTransaction2;
    }

    private static Object copy(Object object, Class clazz) {
        try {
            Gson gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new JsonBeanFieldExcluder(MenuShift.class, null)}).create();
            return gson.fromJson(gson.toJson(object), clazz);
        }
        catch (Exception exception) {
            PosLog.error(ServiceUtils.class, exception);
            return object;
        }
    }

    public static byte[] convertImageResourceToByteArray(ImageResource imageResource) {
        return Base64.encodeBase64((byte[])imageResource.getImageBytes());
    }
}

