/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service.mqtt;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.POSUtil;
import com.orocube.common.util.TerminalUtil;
import com.orocube.rest.service.mqtt.OroMqttMessageReceiver;
import java.util.UUID;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.json.JSONObject;

public class OroMqttClient
extends OroMqttMessageReceiver {
    private static final String MQTT_SERVER_URL = "tcp://siiopa.com:1883";
    private MqttClient oroMqttClient;
    private int qos = 0;
    private static OroMqttClient instance;
    private String deviceId;

    private OroMqttClient() {
    }

    public static OroMqttClient getInstance() {
        if (instance == null) {
            instance = new OroMqttClient();
        }
        return instance;
    }

    public MqttClient getMqttClient() {
        return OroMqttClient.getInstance().oroMqttClient;
    }

    public boolean isConnectedToServer() {
        if (this.oroMqttClient == null) {
            return false;
        }
        return this.oroMqttClient.isConnected();
    }

    public void initMqttClient(String string) throws Exception {
        if (Application.getInstance().isDevelopmentMode()) {
            this.initMqttClient(string, new DebugCallbackHandler());
        } else {
            this.initMqttClient(string, null);
        }
    }

    public void initMqttClient(String string, MqttCallback mqttCallback) throws Exception {
        this.deviceId = string;
        String string2 = MQTT_SERVER_URL;
        this.oroMqttClient = new MqttClient(string2, this.deviceId, (MqttClientPersistence)new MemoryPersistence());
        MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
        mqttConnectOptions.setCleanSession(true);
        mqttConnectOptions.setConnectionTimeout(2000);
        mqttConnectOptions.setAutomaticReconnect(true);
        mqttConnectOptions.setKeepAliveInterval(120);
        this.oroMqttClient.setCallback(mqttCallback);
        this.oroMqttClient.connect(mqttConnectOptions);
        this.subscribe();
    }

    public void initCloudClient(String string) throws Exception {
        this.deviceId = string;
        String string2 = MQTT_SERVER_URL;
        this.oroMqttClient = new MqttClient(string2, this.deviceId, (MqttClientPersistence)new MemoryPersistence());
        MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
        mqttConnectOptions.setCleanSession(true);
        mqttConnectOptions.setConnectionTimeout(2000);
        mqttConnectOptions.setAutomaticReconnect(true);
        mqttConnectOptions.setKeepAliveInterval(120);
        this.oroMqttClient.connect(mqttConnectOptions);
    }

    public void subscribe() throws Exception {
        this.subscribe(this.getStoreUuid() + "public", this.qos, this);
    }

    public void subscribeToStore(String string, int n, IMqttMessageListener iMqttMessageListener) throws Exception {
        this.subscribe(this.getStoreUuid() + string, n, iMqttMessageListener);
    }

    public void subscribe(String string, int n, IMqttMessageListener iMqttMessageListener) throws Exception {
        if (this.oroMqttClient == null) {
            return;
        }
        if (!this.oroMqttClient.isConnected()) {
            throw new PosException(Messages.getString("OroMqttClient.4"));
        }
        this.oroMqttClient.subscribe(string, n, iMqttMessageListener);
        PosLog.debug(this.getClass(), "subscribed to topic: " + string);
    }

    public void unsubscribe(String string) throws Exception {
        if (this.oroMqttClient == null) {
            return;
        }
        if (this.oroMqttClient != null && !this.oroMqttClient.isConnected()) {
            throw new PosException(Messages.getString("OroMqttClient.4"));
        }
        this.oroMqttClient.unsubscribe(this.getStoreUuid() + string);
        PosLog.debug(this.getClass(), "unsubscribed to topic: " + string);
    }

    protected void showMqttNotification(String string) {
        PosLog.info(this.getClass(), string);
    }

    public void publishOnThread(String string, String string2) {
        this.publishData(string, string2);
    }

    public void publishData(String string, String string2) {
        this.publishData(string, string2, false);
    }

    public void publishData(String string, String string2, boolean bl) {
        try {
            if (this.oroMqttClient == null) {
                return;
            }
            if (!this.isConnectedToServer()) {
                return;
            }
            PosLog.debug(this.getClass(), "publishing to topic: " + this.getStoreUuid() + string);
            this.oroMqttClient.publish(this.getStoreUuid() + string, bl ? POSUtil.compress(string2) : string2.getBytes(), this.qos, false);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), "Notification service error. " + exception.getMessage());
        }
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    private String getStoreUuid() {
        Store store = DataProvider.get().getStore();
        if (store != null) {
            return store.getUuid() + "/";
        }
        return UUID.randomUUID().toString() + "/";
    }

    public void notifyDataUpdated(Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        if (DataProvider.get().isCaching(clazz)) {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("terminalKey", (Object)TerminalUtil.getSystemUID());
                OroMqttClient.getInstance().publishData("MQTT-COMMAND-REFRESH-CACHE", jSONObject.toString());
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
    }

    public void notifyStoreClosed() {
        try {
            JSONObject jSONObject = new JSONObject();
            Terminal terminal = DataProvider.get().getCurrentTerminal();
            jSONObject.put("terminalKey", (Object)TerminalUtil.getSystemUID());
            jSONObject.put("terminalName", (Object)terminal.getName());
            OroMqttClient.getInstance().publishData("MQTT-COMMAND-STORE-CLOSED", jSONObject.toString());
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    class DebugCallbackHandler
    implements MqttCallback {
        DebugCallbackHandler() {
        }

        public void connectionLost(Throwable throwable) {
        }

        public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
            PosLog.debug(this.getClass(), "mqtt delivery complete");
        }

        public void messageArrived(String string, MqttMessage mqttMessage) throws Exception {
            PosLog.debug(this.getClass(), "message arrived. topic: " + string + ", message: " + mqttMessage);
        }
    }
}

