/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.apache.commons.lang.StringUtils;

public abstract class PosAction
extends AbstractAction {
    private boolean a = true;
    protected UserPermission requiredPermission;
    protected ActionEvent event;
    protected User authorizedUser;
    protected DataChangeListener listener;
    protected boolean mandatoryPermission;

    public PosAction() {
    }

    public PosAction(String string) {
        super(string);
    }

    public PosAction(Icon icon) {
        super(null, icon);
    }

    public PosAction(String string, Icon icon) {
        super(string, icon);
    }

    public PosAction(String string, UserPermission userPermission) {
        super(string);
        this.requiredPermission = userPermission;
    }

    public PosAction(Icon icon, UserPermission userPermission) {
        super(null, icon);
        this.requiredPermission = userPermission;
    }

    public PosAction(String string, DataChangeListener dataChangeListener) {
        super(string);
        this.listener = dataChangeListener;
    }

    public PosAction(DataChangeListener dataChangeListener) {
        this.listener = dataChangeListener;
    }

    public void setDataChangedListener(DataChangeListener dataChangeListener) {
        this.listener = dataChangeListener;
    }

    public DataChangeListener getDataChangedListener() {
        return this.listener;
    }

    public Object getSelectedObject() {
        if (this.listener == null) {
            return null;
        }
        return this.listener.getSelectedData();
    }

    public UserPermission getRequiredPermission() {
        return this.requiredPermission;
    }

    public void setRequiredPermission(UserPermission userPermission) {
        this.requiredPermission = userPermission;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.event = actionEvent;
            User user = this.getCurrentUser();
            if (this.requiredPermission == null) {
                this.authorizedUser = user;
                this.execute();
                return;
            }
            if (user == null) {
                return;
            }
            this.authorizedUser = user;
            if (!this.hasPermission(user, this.requiredPermission)) {
                return;
            }
            this.execute();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    public boolean hasPermissionToAccessTicket(Ticket ticket) {
        User user = this.getCurrentUser();
        if (ticket != null && ticket.getOwner() != null && ticket.getOwner().getId().equals(user.getId())) {
            return true;
        }
        return this.hasPermission(user, UserPermission.EDIT_OTHER_USERS_TICKETS);
    }

    public boolean hasPermission(User user, UserPermission userPermission) {
        if (this.isMandatoryPermission() || !user.hasPermission(userPermission)) {
            String string = PasswordEntryDialog.show(POSUtil.getFocusedWindow(), userPermission.toString(), Messages.getString("PosAction.0"));
            if (StringUtils.isEmpty((String)string)) {
                return false;
            }
            User user2 = UserDAO.getInstance().findUserBySecretKey(string);
            if (user2 == null) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PosAction.1"));
                return false;
            }
            if (!user2.hasPermissionInAnyRole(userPermission)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PosAction.2"));
                return false;
            }
            this.authorizedUser = user2;
            return true;
        }
        return true;
    }

    public static boolean checkPermission(User user, UserPermission userPermission) {
        if (!user.hasPermission(userPermission)) {
            String string = PasswordEntryDialog.show(POSUtil.getFocusedWindow(), userPermission.toString(), Messages.getString("PosAction.0"));
            if (StringUtils.isEmpty((String)string)) {
                return false;
            }
            User user2 = UserDAO.getInstance().findUserBySecretKey(string);
            if (user2 == null) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PosAction.1"));
                return false;
            }
            if (!user2.hasPermissionInAnyRole(userPermission)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PosAction.2"));
                return false;
            }
            return true;
        }
        return true;
    }

    public abstract void execute() throws Exception;

    public ActionEvent getActionEvent() {
        return this.event;
    }

    public boolean isVisible() {
        return this.a;
    }

    public void setVisible(boolean bl) {
        this.a = bl;
    }

    public User getAuthorizedUser() {
        return this.authorizedUser;
    }

    public boolean isMandatoryPermission() {
        return this.mandatoryPermission;
    }

    public void setMandatoryPermission(boolean bl) {
        this.mandatoryPermission = bl;
    }

    protected User getCurrentUser() {
        return Application.getCurrentUser();
    }
}

