/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.ProgressDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.List;
import javax.swing.AbstractAction;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;

public class RecalculateTicketsAction
extends AbstractAction
implements Runnable {
    private ProgressDialog2 a;

    public RecalculateTicketsAction() {
        super("Recalculate Tickets");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = POSMessageDialog.showYesNoQuestionDialog("Are you sure to recalculate tickets?");
        if (n != 0) {
            return;
        }
        this.a = new ProgressDialog2(this);
        this.a.setTitle("Recalculating tickets");
        this.a.setStringPainted(true);
        this.a.setCancelable(false);
        this.a.pack();
        this.a.open();
    }

    @Override
    public void run() {
        Transaction transaction = null;
        try (Session session = null;){
            session = TicketDAO.getInstance().createNewSession();
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.setProjection((Projection)Projections.property((String)Ticket.PROP_ID));
            List list = criteria.list();
            this.a.setProgressMaximum(list.size());
            int n = 0;
            for (String string : list) {
                Ticket ticket = (Ticket)session.get(Ticket.class, (Serializable)((Object)string));
                ticket.calculatePrice();
                transaction = session.beginTransaction();
                session.update((Object)ticket);
                transaction.commit();
                this.a.progress(++n);
            }
            this.a.dispose();
            POSMessageDialog.showMessage("Done");
        }
    }
}

