/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.OrderInfoDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;

public class ShowOrderInfoAction
extends PosAction {
    private Ticket a;

    public ShowOrderInfoAction() {
        super(POSConstants.ORDER_INFO);
    }

    public ShowOrderInfoAction(Ticket ticket) {
        super(POSConstants.ORDER_INFO);
        this.a = ticket;
    }

    public ShowOrderInfoAction(DataChangeListener dataChangeListener) {
        super(POSConstants.ORDER_INFO_BUTTON_TEXT, dataChangeListener);
    }

    public void setTicket(Ticket ticket) {
        this.a = ticket;
    }

    public Ticket getTicket() {
        return this.a;
    }

    @Override
    public void execute() {
        try {
            Object object;
            if (this.listener != null) {
                object = this.getSelectedObject();
                if (object == null) {
                    return;
                }
                if (object instanceof Ticket) {
                    this.a = (Ticket)object;
                }
            }
            if (this.a == null) {
                return;
            }
            if (!this.hasPermissionToAccessTicket(this.a)) {
                return;
            }
            object = TicketDAO.getInstance().loadFullTicket(this.a.getId());
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            arrayList.add((Ticket)object);
            try {
                OrderInfoView orderInfoView = new OrderInfoView(arrayList);
                OrderInfoDialog orderInfoDialog = new OrderInfoDialog(orderInfoView);
                orderInfoDialog.setSize(600, 700);
                orderInfoDialog.setDefaultCloseOperation(2);
                orderInfoDialog.open();
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

