/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;

public class TicketCloseAction
extends PosAction {
    private Object a;

    public TicketCloseAction() {
        super(POSConstants.CLOSE_ORDER_BUTTON_TEXT);
        this.setRequiredPermission(UserPermission.PERFORM_MANAGER_TASK);
        this.setMandatoryPermission(true);
    }

    public TicketCloseAction(DataChangeListener dataChangeListener) {
        super(POSConstants.CLOSE_ORDER_BUTTON_TEXT, dataChangeListener);
        this.setRequiredPermission(UserPermission.PERFORM_MANAGER_TASK);
        this.setMandatoryPermission(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.a = this.getSelectedObject();
            if (this.a instanceof Ticket) {
                Ticket ticket = (Ticket)this.a;
                if (ticket.getDueAmount() != 0.0) {
                    super.actionPerformed(actionEvent);
                } else {
                    this.execute();
                }
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
    }

    @Override
    public void execute() {
        this.a();
    }

    private void a() {
        try {
            if (this.a != null) {
                this.a(this.a);
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void a(Object object) {
        Ticket ticket = null;
        ticket = object instanceof Ticket ? (Ticket)object : TicketService.getTicket((String)object);
        if (ticket == null) {
            return;
        }
        if (ticket.isVoided().booleanValue()) {
            POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
            return;
        }
        ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        int n = (int)POSUtil.getDouble(ticket.getDueAmount());
        if (!NumberUtil.isZero(n)) {
            POSMessageDialog.showError(Messages.getString("TicketCloseAction.3"));
            return;
        }
        String string = Messages.getString("SwitchboardView.6") + ticket.getId() + Messages.getString("SwitchboardView.7");
        int n2 = POSMessageDialog.showYesNoQuestionDialog(string, POSConstants.CONFIRM);
        if (n2 != 0) {
            return;
        }
        OrderController.closeOrder(ticket);
        ActionHistoryDAO.saveHistory(this.getCurrentUser(), ticket, "Close ticket", String.format("Server: %s, total: %s", ticket.getOwner().getFirstName(), ticket.getTotalAmount()));
        if (this.listener != null) {
            this.listener.dataChanged(ticket);
        }
    }
}

