/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.base.BaseMenuItemModifierSpec;
import com.floreantpos.model.base.BaseMenuItemSize;
import com.floreantpos.model.base.BaseShopTable;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.dao.MenuItemSizeDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.PizzaCrustDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.ReorderType;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.tableselection.TableSelectionView;
import com.floreantpos.ui.tableselection.TableSelectorDialog;
import com.floreantpos.ui.tableselection.TableSelectorFactory;
import com.floreantpos.ui.views.order.OrderTypeSelectionDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TicketReorderAction
extends PosAction {
    private Ticket a;
    private boolean b;

    public TicketReorderAction() {
        super(POSConstants.REORDER_TICKET_BUTTON_TEXT);
        this.setRequiredPermission(UserPermission.CREATE_TICKET);
    }

    public TicketReorderAction(Ticket ticket, UserPermission userPermission) {
        super(POSConstants.REORDER_TICKET_BUTTON_TEXT, userPermission);
        this.a = ticket;
    }

    public TicketReorderAction(DataChangeListener dataChangeListener) {
        super(POSConstants.REORDER_TICKET_BUTTON_TEXT, dataChangeListener);
        this.setRequiredPermission(UserPermission.CREATE_TICKET);
    }

    public void setTicket(Ticket ticket) {
        this.a = ticket;
    }

    public Ticket getTicket() {
        return this.a;
    }

    @Override
    public void execute() {
        try {
            if (!this.getCurrentUser().hasPermission(this.requiredPermission)) {
                POSMessageDialog.showError(Messages.getString("OrderTypeButton.1"));
                return;
            }
            if (this.listener != null) {
                Object object = this.getSelectedObject();
                if (object == null) {
                    return;
                }
                if (object instanceof Ticket) {
                    this.a = (Ticket)object;
                }
            }
            if (this.a == null) {
                return;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("TicketReorderAction.0"), Messages.getString("TicketReorderAction.1"));
            if (n != 0) {
                return;
            }
            Ticket ticket = DataProvider.get().getTicketToBeCreated();
            if (ticket != null) {
                ticket.setCustomer(this.a.getCustomer());
                this.a(this.a, ticket.getOrderType(), ticket);
            } else {
                OrderTypeSelectionDialog orderTypeSelectionDialog = new OrderTypeSelectionDialog();
                orderTypeSelectionDialog.open();
                if (orderTypeSelectionDialog.isCanceled()) {
                    return;
                }
                OrderType orderType = orderTypeSelectionDialog.getSelectedOrderType();
                this.a = TicketDAO.getInstance().loadFullTicket(this.a.getId());
                this.a(this.a, orderType, null);
            }
            this.b = true;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(Ticket ticket, OrderType orderType, Ticket ticket2) {
        Serializable serializable;
        Serializable serializable2;
        if (ticket == null) {
            throw new PosException(Messages.getString("TicketReorderAction.2"));
        }
        Ticket ticket3 = ticket2;
        if (ticket2 == null) {
            ticket3 = new Ticket(true);
            ticket3.setOrderType(orderType);
        }
        if (ticket2 == null && orderType.isShowTableSelection().booleanValue()) {
            serializable2 = TableSelectorFactory.createTableSelectorDialog(orderType);
            TableSelectionView tableSelectionView = ((TableSelectorDialog)serializable2).getTableSelector();
            tableSelectionView.setHomeViewMode(Boolean.FALSE);
            tableSelectionView.setShouldReorder(Boolean.TRUE);
            tableSelectionView.setReorderType(ReorderType.TICKET_REORDER);
            ((TableSelectorDialog)serializable2).setCreateNewTicket(false);
            ((TableSelectorDialog)serializable2).updateView(true);
            ((POSDialog)serializable2).openUndecoratedFullScreen();
            tableSelectionView.setReorderType(null);
            tableSelectionView.setShouldReorder(Boolean.FALSE);
            if (((POSDialog)serializable2).isCanceled()) {
                return;
            }
            List<ShopTable> object2 = ((TableSelectorDialog)serializable2).getSelectedTables();
            serializable = new ArrayList();
            for (List<TicketItemModifier> list : object2) {
                SalesArea salesArea = ((ShopTable)((Object)list)).getSalesArea();
                if (salesArea != null) {
                    ticket3.setSalesArea(salesArea);
                    ticket3.setSalesAreaId(salesArea.getId());
                }
                serializable.add(((BaseShopTable)((Object)list)).getId());
            }
            ticket3.setTableNumbers((List<Integer>)((Object)serializable));
        }
        serializable2 = new ArrayList();
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            List<TicketItemModifier> list;
            if (ticketItem.isVoided().booleanValue() || ticketItem.isItemReturned().booleanValue() || ticketItem.isTreatAsSeat().booleanValue()) continue;
            serializable = ticketItem.cloneAsNew();
            ((BaseTicketItem)serializable).setTicket(ticket3);
            MenuItem menuItem = ((TicketItem)serializable).getMenuItem();
            if (menuItem != null) {
                if (menuItem.isDeleted().booleanValue()) continue;
                if (!menuItem.isEditablePrice().booleanValue()) {
                    menuItem.setTicketItemUnitPriceAndCost((TicketItem)serializable, menuItem, DataProvider.get().getUnitByCode(((TicketItem)serializable).getUnitName()), ticket3);
                }
                if (((BaseTicketItem)serializable).isPizzaType().booleanValue()) {
                    this.a(menuItem, (TicketItem)serializable);
                }
                if (((BaseTicketItem)serializable).isComboItem().booleanValue()) {
                    ((TicketItem)serializable).doCalculateComboItemPrice(true);
                }
                MenuItem.setItemTaxes((TicketItem)serializable, menuItem.getTaxGroup(ticket3.getCustomer()), ticket3.getOrderType());
            }
            serializable2.add(serializable);
            list = ((TicketItem)serializable).getTicketItemModifiers();
            if (list == null) continue;
            list.forEach(arg_0 -> this.a((TicketItem)serializable, orderType, arg_0));
        }
        this.a((List<TicketItem>)((Object)serializable2));
        ticket3.getTicketItems().addAll((Collection<TicketItem>)((Object)serializable2));
        if (ticket3.getCustomer() == null) {
            ticket3.setCustomer(ticket.getCustomer());
        }
        OrderView.getInstance().setCurrentTicket(ticket3);
        RootView.getInstance().showView("ORDER_VIEW");
    }

    private void a(List<TicketItem> list) {
        for (TicketItem ticketItem : list) {
            List<TicketItemModifier> list2 = ticketItem.getTicketItemModifiers();
            if (list2 == null) continue;
            Iterator<TicketItemModifier> iterator = list2.iterator();
            while (iterator.hasNext()) {
                TicketItemModifier ticketItemModifier = iterator.next();
                if (!ticketItem.isPizzaType().booleanValue() || !ticketItemModifier.isInfoOnly().booleanValue() || iterator.hasNext()) continue;
                iterator.remove();
            }
        }
    }

    private void a(TicketItem ticketItem, TicketItemModifier ticketItemModifier, MenuModifier menuModifier) {
        Object object;
        String string = ticketItemModifier.getMultiplierName();
        List<Multiplier> list = DataProvider.get().getMultiplierList();
        Multiplier comparable2 = null;
        for (Multiplier comparable3 : list) {
            if (!comparable3.getId().equals(string)) continue;
            comparable2 = comparable3;
        }
        String string2 = ticketItemModifier.getSectionName();
        TicketItemModifier ticketItemModifier2 = ticketItem.getSizeModifier();
        MenuItemSize menuItemSize = null;
        if (ticketItemModifier2 != null) {
            Object object2;
            Object d2;
            object = ticketItemModifier2.getName().trim();
            String d = "";
            List<MenuItemSize> list2 = MenuItemSizeDAO.getInstance().findAll();
            if (list2 != null) {
                d2 = list2.iterator();
                while (d2.hasNext()) {
                    object2 = (MenuItemSize)d2.next();
                    if (!((String)object).contains(((BaseMenuItemSize)object2).getName()) || ((BaseMenuItemSize)object2).getName().length() <= d.length()) continue;
                    d = ((BaseMenuItemSize)object2).getName();
                }
            }
            if ((d2 = ticketItem.getMenuItem().getPizzaPriceList()) != null) {
                object2 = d2.iterator();
                while (object2.hasNext()) {
                    PizzaPrice d3 = (PizzaPrice)object2.next();
                    if (!d3.getSize().getName().equalsIgnoreCase(d)) continue;
                    menuItemSize = d3.getSize();
                    break;
                }
            }
        }
        MenuModifierDAO.getInstance().initialize(menuModifier);
        ticketItemModifier.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        object = menuModifier.getMenuItemModifierGroup();
        if (object != null) {
            ticketItemModifier.setGroupId(((BaseMenuItemModifierSpec)object).getId());
        }
        double d = menuModifier.getPriceForSizeAndMultiplier(menuItemSize, false, comparable2);
        double d2 = menuModifier.getCost() * (comparable2.getRate() / 100.0);
        ticketItemModifier.setUnitPrice(d);
        ticketItemModifier.setUnitCost(d2);
        if (!ticketItemModifier.isInfoOnly().booleanValue()) {
            double d3 = ticketItem.getMenuItem().getDefaultSellPortion().intValue();
            ticketItemModifier.setUnitPrice(ticketItemModifier.getUnitPrice() * d3 / 100.0);
        }
        ticketItemModifier.setShouldSectionWisePrice(menuModifier.isShouldSectionWisePrice());
        if (ticketItemModifier.isShouldSectionWisePrice().booleanValue()) {
            ticketItemModifier.setUnitPrice(this.a(string2, ticketItemModifier.getUnitPrice()));
        }
    }

    private Double a(String string, double d) {
        switch (string) {
            case "WHOLE": {
                return d * 1.0;
            }
            case "Quarter 1": {
                return d * 0.25;
            }
            case "Quarter 2": {
                return d * 0.25;
            }
            case "Quarter 3": {
                return d * 0.25;
            }
            case "Quarter 4": {
                return d * 0.25;
            }
            case "Half 1": {
                return d * 0.5;
            }
            case "Half 2": {
                return d * 0.5;
            }
        }
        return null;
    }

    private void a(MenuItem menuItem, TicketItem ticketItem) {
        List<MenuItemSize> list = MenuItemSizeDAO.getInstance().findAll();
        List<PizzaCrust> list2 = PizzaCrustDAO.getInstance().findAll();
        TicketItemModifier ticketItemModifier = ticketItem.getSizeModifier();
        if (ticketItemModifier != null) {
            String string = ticketItemModifier.getName().trim();
            String string2 = "";
            String string3 = "";
            for (MenuItemSize object : list) {
                if (!string.contains(object.getName()) || object.getName().length() <= string2.length()) continue;
                string2 = object.getName();
            }
            for (PizzaCrust pizzaCrust : list2) {
                if (!string.contains(pizzaCrust.getName()) || pizzaCrust.getName().length() <= string3.length()) continue;
                string3 = pizzaCrust.getName();
            }
            List<PizzaPrice> list3 = menuItem.getPizzaPriceList();
            if (list3 != null) {
                for (PizzaPrice pizzaPrice : list3) {
                    if (!pizzaPrice.getCrust().getName().equalsIgnoreCase(string3) || !pizzaPrice.getSize().getName().equalsIgnoreCase(string2)) continue;
                    ticketItem.setUnitPrice(pizzaPrice.getPrice(menuItem.getDefaultSellPortion()));
                    break;
                }
            }
        }
    }

    public boolean isReorder() {
        return this.b;
    }

    private /* synthetic */ void a(TicketItem ticketItem, OrderType orderType, TicketItemModifier ticketItemModifier) {
        MenuModifier menuModifier;
        String string = ticketItemModifier.getItemId();
        MenuModifier menuModifier2 = menuModifier = StringUtils.isBlank((String)string) ? null : MenuModifierDAO.getInstance().get(string);
        if (menuModifier != null) {
            if (ticketItem.isPizzaType().booleanValue()) {
                this.a(ticketItem, ticketItemModifier, menuModifier);
            } else {
                ticketItemModifier.setUnitPrice(menuModifier.getPrice());
            }
            List<TicketItemTax> list = menuModifier.getTaxByOrderType(orderType, ticketItem);
            if (list != null) {
                ticketItemModifier.getTaxes().clear();
                ticketItemModifier.getTaxes().addAll(list);
            }
        }
    }
}

