/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.CurrencyExplorer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class CurrencyExplorerAction
extends AbstractAction {
    public CurrencyExplorerAction() {
        super(POSConstants.CURRENCY_EXPLORER);
    }

    public CurrencyExplorerAction(String string) {
        super(string);
    }

    public CurrencyExplorerAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            CurrencyExplorer currencyExplorer = null;
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            int n = jTabbedPane.indexOfTab(POSConstants.CURRENCY_EXPLORER);
            if (n == -1) {
                currencyExplorer = new CurrencyExplorer();
                jTabbedPane.addTab(POSConstants.CURRENCY_EXPLORER, currencyExplorer);
            } else {
                currencyExplorer = (CurrencyExplorer)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(currencyExplorer);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

