/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.explorer.BeanTableExplorerView;
import com.floreantpos.model.CookingInstruction;
import com.floreantpos.model.dao.CookingInstructionDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import javax.swing.JOptionPane;

public class CookingInstructionExplorer
extends BeanTableExplorerView<CookingInstruction> {
    public CookingInstructionExplorer() {
        super(CookingInstruction.class);
    }

    @Override
    public void initTableModel(BeanTableModel<CookingInstruction> beanTableModel) {
        beanTableModel.addColumn(POSConstants.DESCRIPTION, CookingInstruction.PROP_DESCRIPTION);
    }

    @Override
    public void initData() {
        this.setRows(CookingInstructionDAO.getInstance().findAll());
    }

    @Override
    public CookingInstruction createNew() {
        String string = JOptionPane.showInputDialog(POSUtil.getBackOfficeWindow(), (Object)POSConstants.ENTER_INSTRUCTION_DESCRIPTION);
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).isEmpty()) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.INSTRUCTION_CANNOT_BE_EMPTY);
            return null;
        }
        if (string.length() > 60) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.LONG_INSTRUCTION_ERROR);
            return null;
        }
        CookingInstruction cookingInstruction = new CookingInstruction();
        cookingInstruction.setDescription(string);
        CookingInstructionDAO.getInstance().save(cookingInstruction);
        return cookingInstruction;
    }

    @Override
    public CookingInstruction editSelectedRow(CookingInstruction cookingInstruction) {
        String string = JOptionPane.showInputDialog(POSUtil.getBackOfficeWindow(), POSConstants.ENTER_INSTRUCTION_DESCRIPTION, cookingInstruction.getDescription());
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).isEmpty()) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.INSTRUCTION_CANNOT_BE_EMPTY);
            return null;
        }
        if (string.length() > 60) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.LONG_INSTRUCTION_ERROR);
            return null;
        }
        cookingInstruction.setDescription(string);
        CookingInstructionDAO.getInstance().saveOrUpdate(cookingInstruction);
        return cookingInstruction;
    }

    @Override
    public boolean delete(CookingInstruction cookingInstruction) {
        CookingInstructionDAO.getInstance().refresh(cookingInstruction);
        this.checkDataValidation(cookingInstruction.isDeleted(), cookingInstruction.getDescription());
        CookingInstructionDAO.getInstance().delete(cookingInstruction);
        return true;
    }
}

