/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.explorer.BeanTableExplorerView;
import com.floreantpos.model.Discount;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.model.CouponForm;
import javax.swing.table.DefaultTableCellRenderer;

public class CouponExplorer
extends BeanTableExplorerView<Discount> {
    public CouponExplorer() {
        super(Discount.class);
    }

    @Override
    public DefaultTableCellRenderer geTableCellRenderer() {
        return new PosTableRenderer();
    }

    @Override
    public void initTableModel(BeanTableModel<Discount> beanTableModel) {
        beanTableModel.addColumn(POSConstants.NAME, Discount.PROP_NAME);
        beanTableModel.addColumn(Messages.getString("CouponForm.9"), Discount.PROP_BARCODE);
        beanTableModel.addColumn(POSConstants.COUPON_TYPE, "typeName");
        beanTableModel.addColumn(Messages.getString("CouponExplorer.0"), "qualificationName");
        beanTableModel.addColumn(Messages.getString("CouponExplorer.1"), Discount.PROP_MINIMUM_BUY);
        beanTableModel.addColumn(Messages.getString("CouponExplorer.2"), Discount.PROP_MAXIMUM_OFF);
        beanTableModel.addColumn(POSConstants.COUPON_VALUE, Discount.PROP_VALUE);
        beanTableModel.addColumn(POSConstants.EXPIRY_DATE, Discount.PROP_EXPIRY_DATE);
        beanTableModel.addColumn(POSConstants.ENABLED, Discount.PROP_ENABLED);
        beanTableModel.addColumn(POSConstants.NEVER_EXPIRE, Discount.PROP_NEVER_EXPIRE);
    }

    @Override
    public void initData() {
        this.setRows(new DiscountDAO().findAll());
    }

    @Override
    public Discount createNew() {
        return this.openNewForm(new CouponForm(), 900, 500);
    }

    @Override
    public Discount editSelectedRow(Discount discount) {
        DiscountDAO.getInstance().refresh(discount);
        this.checkDataValidation(discount.isDeleted(), discount.getName());
        return this.openEditForm(new CouponForm(discount), 900, 500);
    }

    @Override
    public boolean delete(Discount discount) {
        DiscountDAO.getInstance().refresh(discount);
        this.checkDataValidation(discount.isDeleted(), discount.getName());
        DiscountDAO.getInstance().delete(discount);
        return true;
    }
}

