/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.bo.ui.explorer.MenuItemTreeTableModel;
import com.floreantpos.model.ActiveStatus;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.inv.InventoryStockInForm;
import com.floreantpos.ui.inv.InventoryTransactionEntryForm;
import com.floreantpos.ui.menuitem.variant.VariantForm;
import com.floreantpos.ui.model.MenuItemForm;
import com.floreantpos.ui.model.PizzaItemForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.hibernate.exception.ConstraintViolationException;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class MenuItemExplorer
extends TransparentPanel
implements ExplorerView {
    private MenuItemTreeTableModel a;
    private JXTreeTable b;
    private JComboBox c;
    private JComboBox d;
    private JTextField e;
    private JCheckBox f;
    private JButton g;
    private JButton h;
    private JButton i;
    private JButton j;
    private JLabel k;
    private JComboBox l;
    private JComboBox<ActiveStatus> m;
    private JPanel n;
    private JPanel o;
    protected JButton btnAdd;
    protected JButton btnDelete;
    protected JButton btnDuplicate;
    private JButton p;
    private JButton q;
    private JButton r;
    private JComboBox<MenuItemSortType> s;

    public MenuItemExplorer() {
        this.a();
        this.a(0);
        this.b.setAutoCreateColumnsFromModel(false);
        this.resizeColumnWidth(this.b);
    }

    private void a(int n) {
        int n2;
        MenuItem menuItem = new MenuItem();
        menuItem.setId("0");
        menuItem.setName("Root");
        DefaultMutableTreeTableNode defaultMutableTreeTableNode = new DefaultMutableTreeTableNode((Object)menuItem);
        defaultMutableTreeTableNode.setUserObject((Object)menuItem);
        if (this.a == null) {
            this.a = new MenuItemTreeTableModel(defaultMutableTreeTableNode);
            this.b.setTreeTableModel((TreeTableModel)this.a);
        } else {
            this.a.setRoot((TreeTableNode)defaultMutableTreeTableNode);
        }
        Object object = this.c.getSelectedItem();
        Object object2 = this.l.getSelectedItem();
        ActiveStatus activeStatus = (ActiveStatus)((Object)this.m.getSelectedItem());
        Object object3 = this.d.getSelectedItem();
        MenuItemSortType menuItemSortType = (MenuItemSortType)((Object)this.s.getSelectedItem());
        String string = this.e.getText();
        Boolean bl = this.f.isSelected();
        MenuGroup menuGroup = null;
        MenuCategory menuCategory = null;
        Boolean bl2 = null;
        Boolean bl3 = null;
        Boolean bl4 = false;
        if (object2 instanceof MenuGroup) {
            menuGroup = (MenuGroup)object2;
        }
        if (object instanceof MenuCategory) {
            menuCategory = (MenuCategory)object;
        }
        if (activeStatus == ActiveStatus.Active) {
            bl2 = true;
        } else if (activeStatus == ActiveStatus.Inactive) {
            bl2 = false;
        }
        if (object3 == MenuItemType.Combo) {
            bl3 = true;
        }
        if (object3 == MenuItemType.Variant) {
            bl4 = true;
        }
        MenuItemDAO.getInstance().loadMenuItemsTree(this.a, bl, menuGroup, string, menuCategory, bl4, false, bl2, bl3, menuItemSortType == null ? "" : menuItemSortType.getKey());
        List list = this.a.getRows();
        for (MenuItem menuItem2 : list) {
            DefaultMutableTreeTableNode defaultMutableTreeTableNode2 = new DefaultMutableTreeTableNode((Object)menuItem2);
            if (menuItem2.isHasVariant().booleanValue()) {
                List<MenuItem> list2 = menuItem2.getVariants();
                for (MenuItem menuItem3 : list2) {
                    if (menuItem3.isDeleted().booleanValue()) continue;
                    DefaultMutableTreeTableNode defaultMutableTreeTableNode3 = new DefaultMutableTreeTableNode((Object)menuItem3);
                    defaultMutableTreeTableNode2.add((MutableTreeTableNode)defaultMutableTreeTableNode3);
                }
            }
            defaultMutableTreeTableNode.add((MutableTreeTableNode)defaultMutableTreeTableNode2);
        }
        int n3 = this.a.getCurrentRowIndex() + 1;
        int n4 = this.a.getNextRowIndex();
        if (n4 > (n2 = this.a.getNumRows())) {
            n4 = n2;
        }
        this.k.setText(String.format(Messages.getString("UserExplorer.17"), n3, n4, n2));
        this.i.setEnabled(this.a.hasPrevious());
        this.j.setEnabled(this.a.hasNext());
    }

    private void a() {
        this.b = new JXTreeTable();
        this.b.setRootVisible(false);
        this.b.setShowGrid(true, true);
        this.b.setRowHeight(PosUIManager.getSize(45));
        this.b.setLeafIcon(null);
        this.b.setOpenIcon(null);
        this.b.setClosedIcon(null);
        this.b.setSelectionMode(0);
        this.b.getSelectionModel().addListSelectionListener(listSelectionEvent -> this.b());
        this.b.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        int n = PosUIManager.getSize(16);
        this.g = new JButton();
        this.g.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.SKIP_PREVIOUS, (float)n));
        this.i = new JButton();
        this.i.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_BEFORE, (float)n));
        this.j = new JButton();
        this.j.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.NAVIGATE_NEXT, (float)n));
        this.h = new JButton();
        this.h.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.SKIP_NEXT, (float)n));
        this.k = new JLabel();
        this.b.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MenuItemExplorer.this.f();
                }
            }
        });
        this.i.addActionListener(actionEvent -> this.b(this.a.getPreviousRowIndex()));
        this.j.addActionListener(actionEvent -> this.b(this.a.getNextRowIndex()));
        this.g.addActionListener(actionEvent -> this.b(0));
        this.h.addActionListener(actionEvent -> {
            int n = this.a.getNumRows() / this.a.getPageSize();
            this.b(n * this.a.getPageSize());
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.b));
        this.n = this.e();
        this.add((Component)this.n, "South");
        this.o = this.c();
        this.add((Component)this.o, "North");
    }

    private void b() {
        int n = this.b.getSelectedRow();
        if (n < 0) {
            return;
        }
        TreePath treePath = this.b.getPathForRow(n);
        DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
        MenuItem menuItem = (MenuItem)defaultMutableTreeTableNode.getUserObject();
        this.p.setEnabled(menuItem.isComboItem() == false && menuItem.isHasVariant() == false);
        this.q.setEnabled(menuItem.isComboItem() == false && menuItem.isHasVariant() == false);
        this.r.setEnabled(menuItem.isComboItem() == false && menuItem.isHasVariant() == false);
        this.btnDelete.setEnabled(menuItem.isVariant() == false);
    }

    private JPanel c() {
        JPanel jPanel = new JPanel();
        try {
            WrapLayout wrapLayout = new WrapLayout(0, 5, 0);
            jPanel.setLayout(wrapLayout);
            JLabel jLabel = new JLabel(Messages.getString("MenuItemExplorer.4"));
            this.c = new OverflowCombobox();
            this.c.addItemListener(itemEvent -> this.a(itemEvent));
            JLabel jLabel2 = new JLabel(Messages.getString("MenuItemExplorer.16"));
            this.d = new JComboBox<MenuItemType>(MenuItemType.values());
            JLabel jLabel3 = new JLabel(Messages.getString("MenuItemExplorer.0"));
            JLabel jLabel4 = new JLabel(Messages.getString("MenuItemExplorer.1"));
            this.l = new OverflowCombobox();
            String[] stringArray = new String[]{Messages.getString("MenuItemExplorer.32"), Messages.getString("ACTIVE"), Messages.getString("MenuItemExplorer.34")};
            JLabel jLabel5 = new JLabel(Messages.getString("MenuItemExplorer.35"));
            this.m = new JComboBox<ActiveStatus>(ActiveStatus.values());
            this.e = new JTextField(15);
            this.f = new JCheckBox(Messages.getString("MenuItemExplorer.13"));
            JButton jButton = new JButton(Messages.getString("Search"));
            JPanel jPanel2 = new JPanel();
            jPanel2.add(jLabel3);
            jPanel2.add(this.e);
            JPanel jPanel3 = new JPanel();
            jPanel3.add(jLabel);
            jPanel3.add(this.c);
            JPanel jPanel4 = new JPanel();
            jPanel4.add(jLabel2);
            jPanel4.add(this.d);
            JPanel jPanel5 = new JPanel();
            jPanel5.add(jLabel4);
            jPanel5.add(this.l);
            JPanel jPanel6 = new JPanel();
            jPanel6.add(jLabel5);
            jPanel6.add(this.m);
            JPanel jPanel7 = new JPanel();
            JLabel jLabel6 = new JLabel(Messages.getString("MenuItemExplorer.33"));
            this.s = new JComboBox<MenuItemSortType>(MenuItemSortType.values());
            this.s.setSelectedItem(null);
            this.s.addItemListener(itemEvent -> this.d());
            jPanel7.add(jLabel6);
            jPanel7.add(this.s);
            jPanel.add(jPanel2);
            jPanel.add(jPanel3);
            jPanel.add(jPanel4);
            jPanel.add(jPanel5);
            jPanel.add(jPanel6);
            jPanel.add(this.f);
            jPanel.add(jPanel7);
            jPanel.add(jButton);
            Border border = BorderFactory.createEtchedBorder(1);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, Messages.getString("Search"));
            titledBorder.setTitleJustification(1);
            jPanel.setBorder(titledBorder);
            jButton.addActionListener(actionEvent -> this.d());
            KeyListener keyListener = new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (MenuItemExplorer.this.e.getText().length() > 2) {
                        MenuItemExplorer.this.d();
                    }
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n == 10) {
                        MenuItemExplorer.this.d();
                    }
                }
            };
            this.e.addKeyListener(keyListener);
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
        return jPanel;
    }

    private void d() {
        this.b(0);
    }

    private void b(int n) {
        this.a.setCurrentRowIndex(n);
        this.a(n);
        this.b.expandAll();
        this.b.collapseAll();
    }

    private JPanel e() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        this.btnAdd = explorerButtonPanel.getAddButton();
        this.btnDelete = explorerButtonPanel.getDeleteButton();
        JButton jButton2 = new JButton();
        JButton jButton3 = new JButton();
        this.btnAdd.setText(Messages.getString("MenuItemExplorer.17"));
        jButton2.setText(Messages.getString("MenuItemExplorer.3"));
        jButton3.setText(Messages.getString("MenuItemExplorer.9"));
        jButton.setText(Messages.getString("MenuItemExplorer.18"));
        this.btnDelete.setText(Messages.getString("MenuItemExplorer.19"));
        jButton.addActionListener(actionEvent -> this.f());
        this.btnAdd.addActionListener(actionEvent -> this.a(Boolean.FALSE, (boolean)Boolean.FALSE));
        jButton2.addActionListener(actionEvent -> this.a(Boolean.TRUE, (boolean)Boolean.FALSE));
        jButton3.addActionListener(actionEvent -> this.a(Boolean.FALSE, (boolean)Boolean.TRUE));
        this.btnDelete.addActionListener(actionEvent -> this.g());
        this.btnDuplicate = new JButton(Messages.getString("MenuItemExplorer.41"));
        this.btnDuplicate.addActionListener(actionEvent -> {
            try {
                this.i();
            }
            catch (Throwable throwable) {
                BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
            }
        });
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][fill]"));
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(this.btnAdd);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        transparentPanel.add(jButton);
        transparentPanel.add(this.btnDelete);
        transparentPanel.add(this.btnDuplicate);
        this.a(transparentPanel);
        jPanel.add((Component)transparentPanel, "");
        JPanel jPanel2 = new JPanel(new FlowLayout(4));
        jPanel2.add(this.k);
        jPanel2.add(this.g);
        jPanel2.add(this.i);
        jPanel2.add(this.j);
        jPanel2.add(this.h);
        jPanel.add((Component)jPanel2, "grow");
        return jPanel;
    }

    private void a(JPanel jPanel) {
        this.p = new JButton(Messages.getString("MenuItemExplorer.46"));
        this.q = new JButton(Messages.getString("MenuItemExplorer.47"));
        this.r = new JButton(Messages.getString("MenuItemExplorer.48"));
        this.p.addActionListener(actionEvent -> this.a(InventoryTransactionType.IN));
        this.q.addActionListener(actionEvent -> this.a(InventoryTransactionType.OUT, false));
        this.r.addActionListener(actionEvent -> this.a(InventoryTransactionType.UNCHANGED, true));
        jPanel.add(this.p);
        jPanel.add(this.q);
        jPanel.add(this.r);
    }

    private boolean a(InventoryTransactionType inventoryTransactionType, boolean bl) {
        if (this.b.getRowCount() == 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuItemExplorer.49"));
            return false;
        }
        int n = this.b.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuItemExplorer.20"));
            return false;
        }
        TreePath treePath = this.b.getPathForRow(n = this.b.convertRowIndexToModel(n));
        DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
        MenuItem menuItem = (MenuItem)defaultMutableTreeTableNode.getUserObject();
        if (menuItem == null) {
            return false;
        }
        if (menuItem.getUnit() == null) {
            POSMessageDialog.showError(this, Messages.getString("MenuItemExplorer.50"));
            return false;
        }
        MenuItemDAO.getInstance().initialize(menuItem);
        InventoryTransaction inventoryTransaction = new InventoryTransaction();
        inventoryTransaction.setTransactionType(inventoryTransactionType);
        if (bl) {
            inventoryTransaction.setReason("TRANSFER");
        }
        inventoryTransaction.setMenuItem(menuItem);
        Double d = menuItem.getVariantCost();
        inventoryTransaction.setUnitCost(d);
        InventoryTransactionEntryForm inventoryTransactionEntryForm = new InventoryTransactionEntryForm(inventoryTransaction);
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog(inventoryTransactionEntryForm);
        beanEditorDialog.setPreferredSize(PosUIManager.getSize(500, 500));
        beanEditorDialog.open();
        if (beanEditorDialog.isCanceled()) {
            return false;
        }
        this.d();
        return true;
    }

    private boolean a(InventoryTransactionType inventoryTransactionType) {
        Serializable serializable;
        InventoryTransaction inventoryTransaction;
        int n = this.b.getSelectedRow();
        MenuItem menuItem = null;
        TreePath treePath = null;
        if (n >= 0) {
            n = this.b.convertRowIndexToModel(n);
            treePath = this.b.getPathForRow(n);
            inventoryTransaction = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            menuItem = (MenuItem)inventoryTransaction.getUserObject();
            MenuItemDAO.getInstance().initialize(menuItem);
        }
        inventoryTransaction = new InventoryTransaction();
        inventoryTransaction.setTransactionType(inventoryTransactionType);
        InventoryStockInForm inventoryStockInForm = null;
        if (menuItem == null) {
            inventoryStockInForm = new InventoryStockInForm(inventoryTransaction);
        } else {
            inventoryTransaction.setMenuItem(menuItem);
            serializable = menuItem.getUnit();
            if (serializable == null) {
                POSMessageDialog.showError(this, Messages.getString("MenuItemExplorer.50"));
                return false;
            }
            inventoryTransaction.setUnit(((InventoryUnit)serializable).getUniqueCode());
            Double d = menuItem.getReplenishLevel();
            inventoryTransaction.setQuantity(d);
            Double d2 = menuItem.getVariantCost();
            inventoryTransaction.setUnitCost(d2);
            inventoryTransaction.setTotal(d * d2);
            inventoryStockInForm = new InventoryStockInForm(inventoryTransaction);
        }
        serializable = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)inventoryStockInForm);
        ((BeanEditorDialog)serializable).openWithScale(830, 630);
        if (((BeanEditorDialog)serializable).isCanceled()) {
            return false;
        }
        this.d();
        return true;
    }

    public void resizeColumnWidth(JXTreeTable jXTreeTable) {
        jXTreeTable.setAutoResizeMode(0);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(250);
        arrayList.add(200);
        arrayList.add(150);
        arrayList.add(100);
        arrayList.add(100);
        arrayList.add(120);
        for (int i = 0; i < arrayList.size(); ++i) {
            jXTreeTable.getColumnExt(i).setPreferredWidth(((Integer)arrayList.get(i)).intValue());
        }
    }

    private void f() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToEdit"));
                return;
            }
            TreePath treePath = this.b.getPathForRow(n);
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            MenuItem menuItem = (MenuItem)defaultMutableTreeTableNode.getUserObject();
            menuItem = MenuItemDAO.getInstance().getInitialized(menuItem.getId());
            if (menuItem.isVariant().booleanValue()) {
                VariantForm variantForm = new VariantForm(menuItem);
                BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)variantForm, true);
                beanEditorDialog.setTitle(Messages.getString("MenuItemExplorer.31"));
                beanEditorDialog.openWithScale(1000, 700);
                if (beanEditorDialog.isCanceled()) {
                    return;
                }
            } else if (menuItem.isPizzaType().booleanValue()) {
                PizzaItemForm pizzaItemForm = new PizzaItemForm(menuItem);
                BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)pizzaItemForm, true);
                beanEditorDialog.openWithScale(1000, 700);
                if (beanEditorDialog.isCanceled()) {
                    return;
                }
            } else {
                MenuItemForm menuItemForm = new MenuItemForm(menuItem);
                BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuItemForm, true);
                beanEditorDialog.openWithScale(1000, 700);
                if (beanEditorDialog.isCanceled()) {
                    return;
                }
            }
            this.a.valueForPathChanged(treePath, menuItem);
        }
        catch (PosException posException) {
            BOMessageDialog.showError(this, posException.getMessage());
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(this, throwable.getMessage(), throwable);
        }
    }

    private void a(boolean bl, boolean bl2) {
        try {
            Serializable serializable;
            MenuItem menuItem = new MenuItem();
            menuItem.setComboItem(bl);
            menuItem.setHasVariant(bl2);
            Object object = this.c.getSelectedItem();
            if (object instanceof OrderType) {
                serializable = new ArrayList<Object>();
                serializable.add(object);
                menuItem.setOrderTypeList((List)((Object)serializable));
            }
            serializable = new MenuItemForm(menuItem);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)serializable, true);
            beanEditorDialog.openWithScale(1000, 700);
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.d();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void g() {
        try {
            if (this.b.getRowCount() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuItemExplorer.22"));
                return;
            }
            int n = this.b.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                return;
            }
            n = this.b.convertRowIndexToModel(n);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            TreePath treePath = this.b.getPathForRow(n);
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            MenuItem menuItem = (MenuItem)defaultMutableTreeTableNode.getUserObject();
            MenuItemDAO menuItemDAO = new MenuItemDAO();
            menuItemDAO.initialize(menuItem);
            menuItemDAO.delete(menuItem);
            this.d();
        }
        catch (ConstraintViolationException constraintViolationException) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuItemExplorer.57"));
        }
        catch (PosException posException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    @Override
    public void initData() {
        this.d();
        this.h();
    }

    private void h() {
        this.c.removeAllItems();
        this.c.addItem(Messages.getString("MenuItemExplorer.5"));
        List<MenuCategory> list = MenuCategoryDAO.getInstance().findAll();
        for (MenuCategory menuCategory : list) {
            this.c.addItem(menuCategory);
        }
        this.c.setSelectedIndex(0);
    }

    private void a(ItemEvent itemEvent) {
        try {
            Object object = itemEvent.getItem();
            this.l.removeAllItems();
            this.l.addItem(Messages.getString("MenuItemExplorer.5"));
            if (object instanceof MenuCategory) {
                MenuCategory menuCategory = (MenuCategory)object;
                List<MenuGroup> list = MenuGroupDAO.getInstance().findByParent(menuCategory);
                for (MenuGroup menuGroup : list) {
                    this.l.addItem(menuGroup);
                }
            } else {
                List<MenuGroup> list = MenuGroupDAO.getInstance().findAll();
                for (MenuGroup menuGroup : list) {
                    this.l.addItem(menuGroup);
                }
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void i() throws Exception {
        int n = this.b.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showError(this, Messages.getString("MenuItemExplorer.59"));
            return;
        }
        TreePath treePath = this.b.getPathForRow(n);
        DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
        MenuItem menuItem = (MenuItem)defaultMutableTreeTableNode.getUserObject();
        menuItem = MenuItemDAO.getInstance().getInitialized(menuItem.getId());
        MenuItem menuItem2 = menuItem.clone();
        MenuItemForm menuItemForm = new MenuItemForm(menuItem2);
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuItemForm);
        beanEditorDialog.openWithScale(1000, 700);
        if (beanEditorDialog.isCanceled()) {
            return;
        }
        this.d();
    }

    public void setInventoryButtonsVisible(boolean bl) {
        this.p.setVisible(bl);
        this.q.setVisible(bl);
        this.r.setVisible(bl);
    }

    static enum MenuItemSortType {
        EMPTY("", ""),
        NAME(MenuItem.PROP_NAME, POSConstants.NAME),
        TRANSLATED_NAME(MenuItem.PROP_TRANSLATED_NAME, POSConstants.TRANSLATED_NAME),
        BARCODE(MenuItem.PROP_BARCODE, POSConstants.BARCODE),
        VISIBLE(MenuItem.PROP_VISIBLE, Messages.getString("MenuItemExplorer.39")),
        COMBO_ITEM(MenuItem.PROP_COMBO_ITEM, Messages.getString("MenuItemExplorer.42")),
        HAS_MODIFIERS(MenuItem.PROP_HAS_MODIFIERS, Messages.getString("MenuItemExplorer.43")),
        PRICE(MenuItem.PROP_PRICE, POSConstants.PRICE);

        String a;
        String b;

        private MenuItemSortType(String string2, String string3) {
            this.a = string2;
            this.b = string3;
        }

        public String getKey() {
            return this.a;
        }

        public String getDisplayString() {
            return this.b;
        }

        public static MenuItemSortType fromKey(String string) {
            MenuItemSortType[] menuItemSortTypeArray;
            for (MenuItemSortType menuItemSortType : menuItemSortTypeArray = MenuItemSortType.values()) {
                if (!menuItemSortType.getKey().equals(string)) continue;
                return menuItemSortType;
            }
            return null;
        }

        public String toString() {
            return this.b;
        }
    }

    static enum MenuItemType {
        All(Messages.getString("MenuItemExplorer.24")),
        Combo(Messages.getString("MenuItemExplorer.28")),
        Variant(Messages.getString("MenuItemExplorer.30"));

        String a;

        private MenuItemType(String string2) {
            this.a = string2;
        }

        public String toString() {
            return this.a;
        }
    }
}

