/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.util.CurrencyUtil;
import java.util.List;
import org.jdesktop.swingx.tree.TreeModelSupport;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

class MenuItemTreeTableModel
extends DefaultTreeTableModel
implements PaginationSupport {
    private int a;
    private int b;
    private int c = 20;
    private List<?> d;
    private final String[] e = new String[]{POSConstants.NAME, POSConstants.TRANSLATED_NAME, Messages.getString("MenuItemExplorer.12"), Messages.getString("MenuItemExplorer.15"), Messages.getString("MenuItemExplorer.27"), POSConstants.PRICE + " (" + CurrencyUtil.getCurrencySymbol() + ")", Messages.getString("MenuItemExplorer.14"), Messages.getString("MenuItemExplorer.26"), POSConstants.ACTIVE, Messages.getString("MenuItemExplorer.29"), Messages.getString("MenuItemExplorer.21"), Messages.getString("MenuItemExplorer.23"), Messages.getString("MenuItemExplorer.25"), POSConstants.IMAGE};

    public MenuItemTreeTableModel(DefaultMutableTreeTableNode defaultMutableTreeTableNode) {
        super((TreeTableNode)defaultMutableTreeTableNode);
    }

    public Object getValueAt(Object object, int n) {
        if (object instanceof DefaultMutableTreeTableNode) {
            MenuItem menuItem = (MenuItem)((DefaultMutableTreeTableNode)object).getUserObject();
            if (menuItem == null) {
                return "";
            }
            switch (n) {
                case 0: {
                    return menuItem.getName();
                }
                case 1: {
                    return menuItem.getTranslatedName();
                }
                case 2: {
                    return menuItem.getBarcode();
                }
                case 3: {
                    return menuItem.getComboItem();
                }
                case 4: {
                    return menuItem.getHasModifiers();
                }
                case 5: {
                    Double d = menuItem.getPrice();
                    if (menuItem.isVariant().booleanValue()) {
                        d = menuItem.getParentMenuItem().getPrice() + menuItem.getPrice();
                    }
                    return d;
                }
                case 6: {
                    if (menuItem.isHasVariant().booleanValue()) {
                        return null;
                    }
                    return menuItem.getAvailableUnit();
                }
                case 7: {
                    if (menuItem.isHasVariant().booleanValue()) {
                        return null;
                    }
                    return menuItem.getUnitOnHand();
                }
                case 8: {
                    return menuItem.isVisible();
                }
                case 9: {
                    TaxGroup taxGroup = menuItem.getTaxGroup();
                    if (menuItem.isVariant().booleanValue() && taxGroup == null) {
                        return menuItem.getParentMenuItem().getTaxGroup();
                    }
                    return taxGroup;
                }
                case 10: {
                    return menuItem.getSortOrder();
                }
                case 11: {
                    return menuItem.getButtonColor();
                }
                case 12: {
                    return menuItem.getTextColor();
                }
                case 13: {
                    return menuItem.getImage();
                }
            }
        }
        return null;
    }

    public TreeModelSupport getModelSupport() {
        return this.modelSupport;
    }

    public int getColumnCount() {
        return this.e.length;
    }

    public String getColumnName(int n) {
        return this.e[n];
    }

    public boolean isCellEditable(Object object, int n) {
        return false;
    }

    @Override
    public int getNumRows() {
        return this.a;
    }

    @Override
    public void setNumRows(int n) {
        this.a = n;
    }

    @Override
    public int getCurrentRowIndex() {
        return this.b;
    }

    @Override
    public void setCurrentRowIndex(int n) {
        this.b = n;
    }

    @Override
    public int getPageSize() {
        return this.c;
    }

    @Override
    public void setPageSize(int n) {
        this.c = n;
    }

    @Override
    public boolean hasNext() {
        return this.b + this.c < this.a;
    }

    @Override
    public boolean hasPrevious() {
        return this.b > 0;
    }

    @Override
    public int getNextRowIndex() {
        if (this.a == 0) {
            return 0;
        }
        return this.getCurrentRowIndex() + this.getPageSize();
    }

    @Override
    public int getPreviousRowIndex() {
        int n = this.getCurrentRowIndex() - this.getPageSize();
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    @Override
    public void setRows(List list) {
        this.d = list;
    }

    public List getRows() {
        return this.d;
    }
}

