/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.BeanTableExplorerView;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MultiplierForm;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import net.miginfocom.swing.MigLayout;

public class MultiplierExplorer
extends BeanTableExplorerView<Multiplier> {
    public MultiplierExplorer() {
        super(Multiplier.class);
        this.getTable().getColumnModel().getColumn(6).setCellRenderer(new PosTableRenderer());
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Multiplier multiplier = (Multiplier)MultiplierExplorer.this.getSelectedRow();
                if (multiplier == null) {
                    return;
                }
                MultiplierExplorer.this.editButton.setEnabled(multiplier.isMain() == false);
                MultiplierExplorer.this.deleteButton.setEnabled(multiplier.isMain() == false);
            }
        });
        JButton jButton = new JButton(Messages.getString("MultiplierExplorer.2"));
        jButton.addActionListener(actionEvent -> this.a());
        JButton jButton2 = new JButton(Messages.getString("MultiplierExplorer.0"));
        jButton2.addActionListener(actionEvent -> this.b());
        TransparentPanel transparentPanel = this.getBottomActionPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
    }

    @Override
    public DefaultTableCellRenderer geTableCellRenderer() {
        return new CustomCellRenderer();
    }

    @Override
    public void initTableModel(BeanTableModel<Multiplier> beanTableModel) {
        beanTableModel.addColumn(POSConstants.NAME, Multiplier.PROP_ID);
        beanTableModel.addColumn(Messages.getString("MultiplierExplorer.4"), Multiplier.PROP_TICKET_PREFIX);
        beanTableModel.addColumn(POSConstants.RATE, Multiplier.PROP_RATE);
        beanTableModel.addColumn(POSConstants.SORT_ORDER, Multiplier.PROP_SORT_ORDER);
        beanTableModel.addColumn(POSConstants.BUTTON_COLOR, "buttonBackgroundColor");
        beanTableModel.addColumn(POSConstants.TEXT_COLOR, "buttonTextColor");
        beanTableModel.addColumn(Messages.getString("MultiplierExplorer.5"), Multiplier.PROP_DEFAULT_MULTIPLIER);
    }

    @Override
    public void initData() {
        this.setRows(MultiplierDAO.getInstance().findAll());
    }

    @Override
    public Multiplier createNew() {
        return this.openNewForm(new MultiplierForm());
    }

    @Override
    public Multiplier editSelectedRow(Multiplier multiplier) {
        MultiplierDAO.getInstance().refresh(multiplier);
        if (multiplier.isMain().booleanValue()) {
            return null;
        }
        this.checkDataValidation(multiplier.isDeleted(), multiplier.getId());
        return this.openEditForm(new MultiplierForm(multiplier));
    }

    @Override
    public boolean delete(Multiplier multiplier) {
        MultiplierDAO.getInstance().refresh(multiplier);
        this.checkDataValidation(multiplier.isDeleted(), multiplier.getId());
        MultiplierDAO.getInstance().delete(multiplier);
        return true;
    }

    private void a() {
        try {
            Multiplier multiplier = (Multiplier)this.getSelectedRow();
            if (multiplier == null) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MultiplierExplorer.3"));
                return;
            }
            for (Multiplier multiplier2 : this.getRows()) {
                if (multiplier.getId().equals(multiplier2.getId())) {
                    multiplier2.setDefaultMultiplier(true);
                    continue;
                }
                multiplier2.setDefaultMultiplier(false);
            }
            MultiplierDAO.getInstance().saveOrUpdateMultipliers(this.getRows());
            OroMqttClient.getInstance().notifyDataUpdated(Multiplier.class);
            this.getTable().repaint();
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void b() {
        MultiplierExplorerConfigurationDialog multiplierExplorerConfigurationDialog = new MultiplierExplorerConfigurationDialog(Messages.getString("MultiplierExplorer.1"));
        multiplierExplorerConfigurationDialog.pack();
        multiplierExplorerConfigurationDialog.open();
    }

    private class MultiplierExplorerConfigurationDialog
    extends OkCancelOptionDialog {
        private static final String b = " ";
        private JComboBox<Multiplier> c;
        private JComboBox<Multiplier> d;
        private JComboBox<Multiplier> e;
        private Store f;
        private Multiplier g;
        private Multiplier h;
        private Multiplier i;

        public MultiplierExplorerConfigurationDialog(String string) {
            super(POSUtil.getFocusedWindow(), string);
            this.f = DataProvider.get().getStore();
            this.a();
        }

        private void a() {
            this.setDefaultCloseOperation(2);
            this.setResizable(Boolean.FALSE);
            JPanel jPanel = new JPanel();
            MigLayout migLayout = new MigLayout("fill,inset 0", "sg, fill", "");
            jPanel.setLayout((LayoutManager)migLayout);
            JLabel jLabel = new JLabel(Messages.getString("MultiplierExplorer.8"));
            JLabel jLabel2 = new JLabel(Messages.getString("MultiplierExplorer.9"));
            JLabel jLabel3 = new JLabel(Messages.getString("MultiplierExplorer.10"));
            this.g = this.f.getExtraMultiplier();
            this.h = this.f.getHalfMultiplier();
            this.i = this.f.getQuarterMultiplier();
            ComboBoxModel comboBoxModel = new ComboBoxModel();
            comboBoxModel.getDataList().add(null);
            List list = MultiplierExplorer.this.getRows();
            if (list == null) {
                list = new ArrayList();
            }
            for (Multiplier multiplier : list) {
                comboBoxModel.getDataList().add(multiplier);
            }
            this.c = new JComboBox(comboBoxModel);
            this.c.setSelectedItem(this.g);
            comboBoxModel = new ComboBoxModel();
            comboBoxModel.getDataList().add(null);
            for (Multiplier multiplier : list) {
                comboBoxModel.getDataList().add(multiplier);
            }
            this.d = new JComboBox(comboBoxModel);
            this.d.setSelectedItem(this.h);
            comboBoxModel = new ComboBoxModel();
            comboBoxModel.getDataList().add(null);
            for (Multiplier multiplier : list) {
                comboBoxModel.getDataList().add(multiplier);
            }
            this.e = new JComboBox(comboBoxModel);
            this.e.setSelectedItem(this.i);
            jPanel.add((Component)jLabel, "grow");
            jPanel.add(this.c, "grow, wrap");
            jPanel.add((Component)jLabel2, "grow");
            jPanel.add(this.d, "grow, wrap");
            jPanel.add((Component)jLabel3, "grow");
            jPanel.add(this.e, "grow, wrap");
            this.c.addItemListener(itemEvent -> this.b());
            this.d.addItemListener(itemEvent -> this.c());
            this.e.addItemListener(itemEvent -> this.d());
            this.getContentPanel().add((Component)jPanel, "Center");
        }

        private void b() {
            try {
                Multiplier multiplier;
                this.g = multiplier = (Multiplier)this.c.getSelectedItem();
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }

        private void c() {
            try {
                Multiplier multiplier;
                this.h = multiplier = (Multiplier)this.d.getSelectedItem();
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }

        private void d() {
            try {
                Multiplier multiplier;
                this.i = multiplier = (Multiplier)this.e.getSelectedItem();
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }

        @Override
        public void doOk() {
            try {
                if (this.g != null && this.g.equals(this.h)) {
                    String string = Messages.getString("MultiplierExplorer.11") + b + Messages.getString("MultiplierExplorer.12");
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), string);
                    return;
                }
                if (this.g != null && this.g.equals(this.i)) {
                    String string = Messages.getString("MultiplierExplorer.13") + b + Messages.getString("MultiplierExplorer.12");
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), string);
                    return;
                }
                if (this.h != null && this.h.equals(this.i)) {
                    String string = Messages.getString("MultiplierExplorer.15") + b + Messages.getString("MultiplierExplorer.12");
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), string);
                    return;
                }
                StoreDAO.getInstance().saveOrUpdate(this.f.setExtraMultiplier(this.g).setHalfMultiplier(this.h).setQuarterMultiplier(this.i));
                OroMqttClient.getInstance().notifyDataUpdated(Store.class);
                this.setCanceled(false);
                this.dispose();
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
    }
}

