/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.BeanTableExplorerView;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.dao.PizzaCrustDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.PizzaCrustForm;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.table.DefaultTableCellRenderer;

public class PizzaCrustExplorer
extends BeanTableExplorerView<PizzaCrust> {
    public PizzaCrustExplorer() {
        super(PizzaCrust.class);
        JButton jButton = new JButton(Messages.getString("PizzaCrustExplorer.5"));
        jButton.addActionListener(actionEvent -> this.a());
        TransparentPanel transparentPanel = this.getBottomActionPanel();
        transparentPanel.add(jButton);
    }

    @Override
    public void initTableModel(BeanTableModel<PizzaCrust> beanTableModel) {
        beanTableModel.addColumn(POSConstants.NAME, PizzaCrust.PROP_NAME);
        beanTableModel.addColumn(Messages.getString("PizzaCrustExplorer.0"), PizzaCrust.PROP_TRANSLATED_NAME);
        beanTableModel.addColumn(Messages.getString("PizzaCrustExplorer.1"), PizzaCrust.PROP_DESCRIPTION);
        beanTableModel.addColumn(Messages.getString("PizzaCrustExplorer.2"), PizzaCrust.PROP_SORT_ORDER);
        beanTableModel.addColumn(Messages.getString("MultiplierExplorer.5"), PizzaCrust.PROP_DEFAULT_CRUST);
    }

    @Override
    public void initData() {
        this.setRows(PizzaCrustDAO.getInstance().findAll());
    }

    @Override
    public DefaultTableCellRenderer geTableCellRenderer() {
        return new PosTableRenderer();
    }

    @Override
    public PizzaCrust createNew() {
        return this.openNewForm(new PizzaCrustForm());
    }

    @Override
    public PizzaCrust editSelectedRow(PizzaCrust pizzaCrust) {
        PizzaCrustDAO.getInstance().refresh(pizzaCrust);
        this.checkDataValidation(pizzaCrust.isDeleted(), pizzaCrust.getName());
        return this.openEditForm(new PizzaCrustForm(pizzaCrust));
    }

    @Override
    public boolean delete(PizzaCrust pizzaCrust) {
        PizzaCrustDAO.getInstance().refresh(pizzaCrust);
        this.checkDataValidation(pizzaCrust.isDeleted(), pizzaCrust.getName());
        if (pizzaCrust.isDefaultCrust().booleanValue()) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PizzaCrustExplorer.3"));
            return false;
        }
        PizzaCrustDAO.getInstance().delete(pizzaCrust);
        return true;
    }

    private void a() {
        try {
            PizzaCrust pizzaCrust = (PizzaCrust)this.getSelectedRow();
            if (pizzaCrust == null) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SetDefault"));
                return;
            }
            PizzaCrustDAO.getInstance().refresh(pizzaCrust);
            ArrayList<PizzaCrust> arrayList = new ArrayList<PizzaCrust>();
            arrayList.add(pizzaCrust);
            for (PizzaCrust pizzaCrust2 : this.getRows()) {
                if (!pizzaCrust2.isDefaultCrust().booleanValue()) continue;
                pizzaCrust2.setDefaultCrust(false);
                arrayList.add(pizzaCrust2);
            }
            pizzaCrust.setDefaultCrust(true);
            PizzaCrustDAO pizzaCrustDAO = new PizzaCrustDAO();
            pizzaCrustDAO.saveOrUpdateList(arrayList);
            this.getTable().repaint();
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

